package com.cnooc.expert.controller.expert.model.response;

import lombok.Builder;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author: FuHongZhang
 * @date 2025-11-15 14:26
 */
@Data
@Builder
public class PeiXunPageResp {

    /**
     * courseGuid 课程Guid
     */
    private String courseGuid;

    /**
     * courseName 课程名称
     */
    private String courseName;

    /**
     * courseTypeName 课程类型名称
     */
    private String courseTypeName;

    /**
     * lessonCount 课节数量
     */
    private Integer lessonCount;

    /**
     * courseReleaseTimestamp 发布时间
     */
    private Long courseReleaseTimestamp;

    /**
     * 学习进度
     */
    private BigDecimal studyProgress;

    /**
     * 学习进度状态（10：未完成；20：已完成）
     */
    private Short progressStatus;

    /**
     * 培训课程详情
     */
    @Data
    @Builder
    public static class PeiXunKeChengInfo {
        /** 课程唯一标识（GUID） */
        private String courseGuid;

        /** 课程介绍 */
        private String courseIntroduction;

        /** 课程名称 */
        private String courseName;

        /** 课程发布状态（） */
        private Short courseReleaseStatus;

        /** 课程发布时间戳（毫秒） */
        private Long courseReleaseTimestamp;

        /** 课程类型唯一标识（GUID） */
        private String courseTypeGuid;

        /** 课程类型名称（如：日常培训、定期培训） */
        private String courseTypeName;

        /** 学习后是否需要考试（true=是，false=否） */
        private Boolean isTestAfterLearn;

        /** 课程包含的课节数量 */
        private Integer lessonCount;

        /** 关联的试卷唯一标识（GUID） */
        private String testPaperGuid;
    }

}
