package com.cnooc.expert.external.expert.service;

import com.cnooc.expert.external.expert.model.request.ExamQuestionXiaoTiListApiReq;
import com.cnooc.expert.controller.expert.model.request.ExpertInfoUpdateApiReq;
import com.cnooc.expert.external.expert.model.response.ExamQuestionXiaoTiListApiResp;
import com.cnooc.expert.external.common.AbstractRetrofitManager;
import com.cnooc.expert.external.common.model.response.ApiBasePageResp;
import com.cnooc.expert.external.common.model.response.ApiBaseResult;
import com.cnooc.expert.external.expert.api.ExpertServiceApi;
import com.cnooc.expert.external.expert.model.request.CityTreeApiReq;
import com.cnooc.expert.external.expert.model.request.CommonFuJianListApiReq;
import com.cnooc.expert.external.expert.model.request.CommonJiTuanErJiDanWeiListApiReq;
import com.cnooc.expert.external.expert.model.request.CommonNofilterEnumGetApiReq;
import com.cnooc.expert.external.expert.model.request.DictByParentListApiReq;
import com.cnooc.expert.external.expert.model.request.DongJieGetApiReq;
import com.cnooc.expert.external.expert.model.request.DongJieZhuanYePageApiReq;
import com.cnooc.expert.external.expert.model.request.ExamQuestionListApiReq;
import com.cnooc.expert.external.expert.model.request.ExamRecordSaveApiReq;
import com.cnooc.expert.external.expert.model.request.ExpertInfoGetApiReq;
import com.cnooc.expert.external.expert.model.request.GeRenXiuJiaApplyApiReq;
import com.cnooc.expert.external.expert.model.request.GeRenXiuJiaPageApiReq;
import com.cnooc.expert.external.expert.model.request.JinJiQingJiaApplyApiReq;
import com.cnooc.expert.external.expert.model.request.JinJiQingJiaPageApiReq;
import com.cnooc.expert.external.expert.model.request.TainLessonProgressUpdateApiReq;
import com.cnooc.expert.external.expert.model.request.TempExamPaperGetApiReq;
import com.cnooc.expert.external.expert.model.request.TrainCourseGetApiReq;
import com.cnooc.expert.external.expert.model.request.TrainCourseLessonGetApiReq;
import com.cnooc.expert.external.expert.model.request.TrainCourseLessonPageApiReq;
import com.cnooc.expert.external.expert.model.request.TrainExamPageApiReq;
import com.cnooc.expert.external.expert.model.request.ViolationExpertGetApiReq;
import com.cnooc.expert.external.expert.model.request.ViolationExpertPageApiReq;
import com.cnooc.expert.external.expert.model.request.XiangMuInfoByChouQuNumGetApiReq;
import com.cnooc.expert.external.expert.model.request.ZhuanJiaPingBiaoXiangMuRenWuPageApiReq;
import com.cnooc.expert.external.expert.model.response.CityTreeApiResp;
import com.cnooc.expert.external.expert.model.response.CommonFuJianListApiResp;
import com.cnooc.expert.external.expert.model.response.CommonJiTuanErJiDanWeiListApiResp;
import com.cnooc.expert.external.expert.model.response.CommonNofilterEnumGetApiResp;
import com.cnooc.expert.external.expert.model.response.DictByParentListApiResp;
import com.cnooc.expert.external.expert.model.response.DongJieGetApiResp;
import com.cnooc.expert.external.expert.model.response.DongJieZhuanYePageApiResp;
import com.cnooc.expert.external.expert.model.response.ExamQuestionListApiResp;
import com.cnooc.expert.external.expert.model.response.ExamRecordSaveApiResp;
import com.cnooc.expert.external.expert.model.response.ExpertInfoGetApiResp;
import com.cnooc.expert.external.expert.model.response.GeRenXiuJiaApplyApiResp;
import com.cnooc.expert.external.expert.model.response.GeRenXiuJiaPageApiResp;
import com.cnooc.expert.external.expert.model.response.JinJiQingJiaApplyApiResp;
import com.cnooc.expert.external.expert.model.response.JinJiQingJiaPageApiResp;
import com.cnooc.expert.external.expert.model.response.TainLessonProgressUpdateApiResp;
import com.cnooc.expert.external.expert.model.response.TempExamPaperGetApiResp;
import com.cnooc.expert.external.expert.model.response.TrainCourseGetApiResp;
import com.cnooc.expert.external.expert.model.response.TrainCourseLessonGetApiResp;
import com.cnooc.expert.external.expert.model.response.TrainCourseLessonPageApiResp;
import com.cnooc.expert.external.expert.model.response.TrainCoursePageApiReq;
import com.cnooc.expert.external.expert.model.response.TrainCoursePageApiResp;
import com.cnooc.expert.external.expert.model.response.TrainExamPageApiResp;
import com.cnooc.expert.external.expert.model.response.ViolationExpertGetApiResp;
import com.cnooc.expert.external.expert.model.response.ViolationExpertPageApiResp;
import com.cnooc.expert.external.expert.model.response.XiangMuInfoByChouQuNumGetApiResp;
import com.cnooc.expert.external.expert.model.response.ZhuanJiaPingBiaoXiangMuRenWuPageApiResp;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import retrofit2.Call;
import retrofit2.Retrofit;

import java.util.List;
import java.util.Map;

@Service
public class ExpertServiceClient extends AbstractRetrofitManager {

    private final ExpertServiceApi expertServiceApi;

    public ExpertServiceClient(@Qualifier("retrofitExpert") Retrofit retrofit) {
        this.expertServiceApi = retrofit.create(ExpertServiceApi.class);
    }

    // ****** 工作流配置 *****

    public ApiBaseResult<String> getBusinessId() {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<String>> call = expertServiceApi.getBusinessIdApi(headers);
        return this.getResponseBody(call, "getBusinessId");
    }

    // ****** 专家 ******

    public ApiBaseResult<ExpertInfoGetApiResp> getExpertInfo(ExpertInfoGetApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<ExpertInfoGetApiResp>> call = expertServiceApi.getExpertInfo(headers, req);
        return this.getResponseBody(call, "getExpertInfo");
    }

    public ApiBaseResult<ExpertInfoGetApiResp> updateExpertInfo(ExpertInfoUpdateApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<ExpertInfoGetApiResp>> call = expertServiceApi.updateExpertInfoApi(headers, req);
        return this.getResponseBody(call, "updateExpertInfo");
    }

    public ApiBaseResult<List<CommonNofilterEnumGetApiResp>> getCommonNofilterEnum(CommonNofilterEnumGetApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<List<CommonNofilterEnumGetApiResp>>> call = expertServiceApi.getCommonNofilterEnumApi(headers, req);
        return this.getResponseBody(call, "getCommonNofilterEnum");
    }

    public ApiBaseResult<Long> getCommonNofilterSystemTime() {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<Long>> call = expertServiceApi.getCommonNofilterSystemTimeApi(headers);
        return this.getResponseBody(call, "getCommonNofilterSystemTime");
    }

    public ApiBaseResult<List<CommonJiTuanErJiDanWeiListApiResp>> listCommonJiTuanErJiDanWei(CommonJiTuanErJiDanWeiListApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<List<CommonJiTuanErJiDanWeiListApiResp>>> call = expertServiceApi.listCommonJiTuanErJiDanWeiApi(headers, req);
        return this.getResponseBody(call, "listCommonJiTuanErJiDanWei");
    }

    public ApiBaseResult<List<DictByParentListApiResp>> listDictByParent(DictByParentListApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<List<DictByParentListApiResp>>> call = expertServiceApi.listDictByParentApi(headers, req);
        return this.getResponseBody(call, "listDictByParent");
    }

    public ApiBaseResult<List<DictByParentListApiResp>> listDictByParentGuid(DictByParentListApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<List<DictByParentListApiResp>>> call = expertServiceApi.listDictByParentGuidApi(headers, req);
        return this.getResponseBody(call, "listDictByParentGuid");
    }

    public ApiBaseResult<List<CityTreeApiResp>> treeCity(CityTreeApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<List<CityTreeApiResp>>> call = expertServiceApi.cityTreeApi(headers, req);
        return this.getResponseBody(call, "treeCity");
    }

    public ApiBaseResult<XiangMuInfoByChouQuNumGetApiResp> getXiangMuInfoByChouQuNum(XiangMuInfoByChouQuNumGetApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<XiangMuInfoByChouQuNumGetApiResp>> call = expertServiceApi.xiangMuInfoByChouQuNumGetApi(headers, req);
        return this.getResponseBody(call, "getXiangMuInfoByChouQuNum");
    }

    public ApiBaseResult<ApiBasePageResp<ZhuanJiaPingBiaoXiangMuRenWuPageApiResp>> pageZhuanJiaPingBiaoXiangMuRenWu(ZhuanJiaPingBiaoXiangMuRenWuPageApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<ApiBasePageResp<ZhuanJiaPingBiaoXiangMuRenWuPageApiResp>>> call = expertServiceApi.pageZhuanJiaPingBiaoXiangMuRenWuApi(headers, req);
        return this.getResponseBody(call, "pageZhuanJiaPingBiaoXiangMuRenWu");
    }

    /* 请假、休假 */

    // 紧急请假分页
    public ApiBaseResult<ApiBasePageResp<JinJiQingJiaPageApiResp>> pageJinJiQingJia(JinJiQingJiaPageApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<ApiBasePageResp<JinJiQingJiaPageApiResp>>> call = expertServiceApi.pageJinJiQingJiaApi(headers, req);
        return this.getResponseBody(call, "pageJinJiQingJia");
    }

    // 紧急请假申请
    public ApiBaseResult<JinJiQingJiaApplyApiResp> applyJinJiQingJia(JinJiQingJiaApplyApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<JinJiQingJiaApplyApiResp>> call = expertServiceApi.applyJinJiQingJiaApi(headers, req);
        return this.getResponseBody(call, "applyJinJiQingJia");
    }

    // 个人休假分页
    public ApiBaseResult<ApiBasePageResp<GeRenXiuJiaPageApiResp>> pageGeRenXiuJia(GeRenXiuJiaPageApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<ApiBasePageResp<GeRenXiuJiaPageApiResp>>> call = expertServiceApi.pageGeRenXiuJiaApi(headers, req);
        return this.getResponseBody(call, "pageGeRenXiuJia");
    }

    // 个人休假申请
    public ApiBaseResult<GeRenXiuJiaApplyApiResp> applyGeRenXiuJia(GeRenXiuJiaApplyApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<GeRenXiuJiaApplyApiResp>> call = expertServiceApi.applyGeRenXiuJiaApi(headers, req);
        return this.getResponseBody(call, "applyJinJiQingJia");
    }

    // *** 违规、冻结 ***

    // 专家冻结分页
    public ApiBaseResult<ApiBasePageResp<DongJieZhuanYePageApiResp>> pageDongJieZhuanYe(DongJieZhuanYePageApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<ApiBasePageResp<DongJieZhuanYePageApiResp>>> call = expertServiceApi.pageDongJieZhuanYeApi(headers, req);
        return this.getResponseBody(call, "pageDongJieZhuanYe");
    }

    // 专家冻结详情
    public ApiBaseResult<DongJieGetApiResp> getDongJieExpert(DongJieGetApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<DongJieGetApiResp>> call = expertServiceApi.getDongJieApi(headers, req);
        return this.getResponseBody(call, "getDongJie");
    }

    // 专家违规分页
    public ApiBaseResult<ApiBasePageResp<ViolationExpertPageApiResp>> pageViolationExpert(ViolationExpertPageApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<ApiBasePageResp<ViolationExpertPageApiResp>>> call = expertServiceApi.pageViolationExpertApi(headers, req);
        return this.getResponseBody(call, "pageViolationExpert");
    }

    // 专家违规详情
    public ApiBaseResult<ViolationExpertGetApiResp> getViolationExpert(ViolationExpertGetApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<ViolationExpertGetApiResp>> call = expertServiceApi.getViolationExpertApi(headers, req);
        return this.getResponseBody(call, "getViolationExpert");
    }

    // *** 培训、考试 ***

    // 培训课程分页
    public ApiBaseResult<ApiBasePageResp<TrainCoursePageApiResp>> pageTrainCourse(TrainCoursePageApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<ApiBasePageResp<TrainCoursePageApiResp>>> call = expertServiceApi.pageTrainCourseApi(headers, req);
        return this.getResponseBody(call, "pageTrainCourse");
    }

    // 培训课程详情
    public ApiBaseResult<TrainCourseGetApiResp> getTrainCourse(TrainCourseGetApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<TrainCourseGetApiResp>> call = expertServiceApi.getTrainCourseApi(headers, req);
        return this.getResponseBody(call, "getTrainCourse");
    }

    // 培训课程课节分页
    public ApiBaseResult<ApiBasePageResp<TrainCourseLessonPageApiResp>> pageTrainCourseLesson(TrainCourseLessonPageApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<ApiBasePageResp<TrainCourseLessonPageApiResp>>> call = expertServiceApi.pageTrainCourseLessonApi(headers, req);
        return this.getResponseBody(call, "pageTrainCourseLesson");
    }

    // 培训课程课节详情
    public ApiBaseResult<TrainCourseLessonGetApiResp> getTrainCourseLesson(TrainCourseLessonGetApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<TrainCourseLessonGetApiResp>> call = expertServiceApi.getTrainCourseLessonApi(headers, req);
        return this.getResponseBody(call, "getTrainCourseLesson");
    }

    // 培训课程课节详情
    public ApiBaseResult<List<CommonFuJianListApiResp>> listCommonFuJian(CommonFuJianListApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<List<CommonFuJianListApiResp>>> call = expertServiceApi.listCommonFuJianApi(headers, req);
        return this.getResponseBody(call, "listCommonFuJian");
    }

    // 更新培训课节学习进度
    public ApiBaseResult<TainLessonProgressUpdateApiResp> updateTainLessonProgress(TainLessonProgressUpdateApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<TainLessonProgressUpdateApiResp>> call = expertServiceApi.updateTainLessonProgressApi(headers, req);
        return this.getResponseBody(call, "updateTainLessonProgress");
    }

    // 培训考试分页
    public ApiBaseResult<ApiBasePageResp<TrainExamPageApiResp>> pageTrainExam(TrainExamPageApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<ApiBasePageResp<TrainExamPageApiResp>>> call = expertServiceApi.pageTrainExamApi(headers, req);
        return this.getResponseBody(call, "pageTrainExam");
    }

    // 考试试卷信息
    public ApiBaseResult<TempExamPaperGetApiResp> getTempExamPaper(TempExamPaperGetApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<TempExamPaperGetApiResp>> call = expertServiceApi.getTempExamPaperApi(headers, req);
        return this.getResponseBody(call, "getTempExamPaper");
    }

    // 保存考试记录
    public ApiBaseResult<ExamRecordSaveApiResp> saveExamRecord(ExamRecordSaveApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<ExamRecordSaveApiResp>> call = expertServiceApi.saveExamRecordApi(headers, req);
        return this.getResponseBody(call, "saveExamRecord");
    }

    // 题库试题列表
    public ApiBaseResult<List<ExamQuestionListApiResp>> listExamQuestion(ExamQuestionListApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<List<ExamQuestionListApiResp>>> call = expertServiceApi.listExamQuestionApi(headers, req);
        return this.getResponseBody(call, "listExamQuestion");
    }

    // 题库试题小题列表
    public ApiBaseResult<List<ExamQuestionXiaoTiListApiResp>> listExamQuestionXiaoTi(ExamQuestionXiaoTiListApiReq req) {
        Map<String, Object> headers = super.getHeaders();
        Call<ApiBaseResult<List<ExamQuestionXiaoTiListApiResp>>> call = expertServiceApi.listExamQuestionXiaoTiApi(headers, req);
        return this.getResponseBody(call, "listExamQuestionXiaoTi");
    }


}
