/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server.jni;

import com.wangyin.key.server.exception.AksExceptionEnum;
import com.wangyin.key.server.exception.KeyException;
import com.wangyin.key.server.model.AlgEnum;
import com.wangyin.key.server.model.CertCache;
import com.wangyin.key.server.model.DigestAlgEnum;
import com.wangyin.key.server.model.ModeEnum;
import com.wangyin.key.server.model.PaddingEnum;
import com.wangyin.key.server.model.RadixEnum;
import com.wangyin.key.server.util.AKSCertInfo;
import com.wangyin.key.server.util.ByteUtil;
import com.wangyin.key.server.util.CryptUtil;
import com.wangyin.key.server.util.DatatypeConverter;
import com.wangyin.key.server.util.EncryptUtil;
import com.wangyin.key.server.util.Preconditions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AKSNativeCryptoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AKSNativeCryptoService.class);
    public static boolean isLinuxSystem;
    private static boolean isJNIInit;

    private static String getAKSHomeDir() {
        File file;
        block7: {
            String aksHome = System.getProperty("aks.file.home");
            if (aksHome != null && aksHome.length() != 0) {
                boolean done;
                File file2;
                block6: {
                    String base = "aks";
                    file2 = new File(aksHome, base);
                    done = false;
                    while (file2.exists()) {
                        if (!file2.isDirectory()) {
                            base = "aks" + EncryptUtil.md5Hex(base.getBytes());
                            file2 = new File(aksHome, base);
                            continue;
                        }
                        break block6;
                    }
                    done = file2.mkdirs();
                }
                if (done) {
                    return file2.getAbsolutePath();
                }
            }
            String userHome = System.getProperty("user.home");
            String base = "aks";
            file = new File(userHome, base);
            while (file.exists()) {
                if (!file.isDirectory()) {
                    base = "aks" + EncryptUtil.md5Hex(base.getBytes());
                    file = new File(userHome, base);
                    continue;
                }
                break block7;
            }
            file.mkdirs();
        }
        return file.getAbsolutePath();
    }

    private static void mkdir(String path) {
        File tmp_file = null;
        if (!path.isEmpty() && !(tmp_file = new File(path)).exists()) {
            tmp_file.mkdirs();
        }
    }

    private static native int init(String var0);

    private static native byte[] parseCert(String var0);

    private static native byte[] encrypt(int var0, int var1, int var2, byte[] var3, byte[] var4, byte[] var5);

    private static native byte[] decrypt(int var0, int var1, int var2, byte[] var3, byte[] var4, byte[] var5);

    private static native int putKey(String var0, String var1, byte[] var2);

    private static native void deleteKey(String var0);

    private static native byte[] encryptUserPW(String var0, String var1, byte[] var2, byte[] var3, String var4, String var5);

    private static native byte[] encryptUserPasswordMD5(String var0, byte[] var1, byte[] var2, byte[] var3, String var4, String var5);

    private static native int checkUserPW(String var0, String var1, byte[] var2, String var3, String var4);

    public static native byte[][] handshakeToMobile(String var0, byte[] var1, byte[] var2, long var3, byte[] var5);

    public static native byte[][] decodeMoblieMessage(String var0, byte[] var1, byte[] var2, long var3, int var5, boolean var6, byte[] var7, byte[] var8);

    public static native byte[][] encodeServerMessage(String var0, byte[] var1, byte[] var2, byte[] var3);

    public static native byte[][] sessionExpiredToMobile();

    private static native byte[] decryptSignedEnvelop(byte[] var0, byte[] var1);

    private static native byte[] encryptSignedEnvelop(byte[] var0, byte[] var1, byte[] var2, int var3, byte[] var4, int var5);

    private static native byte[] private_key_decrypt(byte[] var0, byte[] var1);

    private static native byte[] private_key_encrypt(byte[] var0, byte[] var1);

    private static native byte[] public_key_decrypt(byte[] var0, byte[] var1, byte[] var2);

    private static native byte[] public_key_encrypt(byte[] var0, byte[] var1, byte[] var2);

    private static native byte[] getPublicKey(byte[] var0, boolean var1);

    private static native byte[] getPublicKeyN(byte[] var0);

    private static native byte[] encryptPassword(byte[] var0, byte[] var1, byte[] var2);

    private static native byte[] verifyPassword(byte[] var0, byte[] var1, byte[] var2, byte[] var3);

    private static native byte[] p7Sign(byte[] var0, boolean var1, byte[] var2, byte[] var3, boolean var4);

    private static native byte[] p7Verify(boolean var0, byte[] var1, byte[] var2);

    private static native byte[] cleanPassword(byte[] var0, byte[] var1, byte[] var2);

    private static native byte[] resetPasswordByMD5(byte[] var0, byte[] var1, byte[] var2);

    private static native byte[] resetPasswordByAKS(byte[] var0, byte[] var1, byte[] var2, byte[] var3);

    private static native byte[] checkPasswordByMD5(byte[] var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    private static native byte[] checkPasswordByAKS(byte[] var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5);

    private static native byte[] encryptEvpWithSymm(int var0, int var1, int var2, byte[] var3, int var4, byte[] var5, byte[] var6, int var7);

    private static native byte[] decryptEvpWithSymm(byte[] var0, int var1, int var2, int var3, byte[] var4, byte[] var5, byte[] var6);

    private static native byte[] encryptEnvelop(int var0, byte[] var1, byte[] var2, int var3);

    private static native byte[] decryptEnvelop(byte[] var0, byte[] var1);

    private static native byte[] decryptWithAsym(byte[] var0, byte[] var1, byte[] var2, byte[] var3, int var4, int var5, int var6, byte[] var7, byte[] var8);

    private static native byte[] decryptWithAsym_offline(byte[] var0, byte[] var1, int var2, int var3, int var4, byte[] var5, byte[] var6);

    private static native byte[] encryptByFF1(byte[] var0, int var1, byte[] var2, byte[] var3);

    private static native byte[] decryptByFF1(byte[] var0, int var1, byte[] var2, byte[] var3);

    private static native byte[] chkPayCode(byte[] var0, int var1, byte[] var2, byte[] var3, int var4, byte[] var5, byte[] var6, byte[] var7, byte[] var8, long var9);

    private static native byte[] getSeedByPayCode(byte[] var0, int var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5);

    private static native byte[] encrypt_ex(int var0, int var1, int var2, byte[] var3, byte[] var4, byte[] var5);

    private static native byte[] decrypt_ex(int var0, int var1, int var2, byte[] var3, byte[] var4, byte[] var5);

    private static native byte[] private_key_decrypt_ex(byte[] var0, byte[] var1);

    public static native byte[][] handshakeToMobile2(String var0, String var1, byte[] var2, byte[] var3, long var4, byte[] var6, int var7);

    public static native byte[][] decodeMoblieMessage2(String var0, String var1, byte[] var2, byte[] var3, long var4, int var6, boolean var7, byte[] var8, byte[] var9);

    private static native byte[] encryptPassword_ex(byte[] var0, byte[] var1, byte[] var2);

    private static native byte[] verifyPassword_ex(byte[] var0, byte[] var1, byte[] var2, byte[] var3);

    private static native byte[] resetPasswordByAKS_ex(byte[] var0, byte[] var1, byte[] var2, byte[] var3);

    private static native byte[] checkPasswordByAKS_ex(byte[] var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5);

    private static native byte[] checkPassword(boolean var0, String var1, String var2);

    private static native byte[] hmac(String var0, int var1, byte[] var2);

    private static native byte[] hash_handle(int var0, byte[] var1);

    private static native byte[] createIndex(String var0, int var1, byte[] var2);

    private static native byte[] symm_encrypt(byte[] var0, int var1, int var2, int var3, byte[] var4, byte[] var5, byte[] var6);

    private static native byte[] symm_decrypt(byte[] var0, int var1, int var2, int var3, byte[] var4, byte[] var5, byte[] var6);

    private static native int checkOTP(byte[] var0, byte[] var1);

    private static native byte[] p1Sign(byte[] var0, byte[] var1);

    private static native byte[] p1_Verify(String var0, String var1, byte[] var2);

    private static native int addRootCert(String var0);

    private static native boolean isSM2Evp(String var0);

    private static native String[] antiCheatForSdk(String var0);

    private static native byte[] login(String var0, String var1, String var2, int var3, int var4, List<String> var5);

    private static native byte[] getKeys(String var0, List<String> var1, List<CertCache> var2);

    private static native byte[] loginByHsmsys(String var0, String var1, int var2, List<String> var3);

    private static native byte[] getKeysByHsmsys(String var0, List<String> var1, List<CertCache> var2);

    private static native long addKey(String var0);

    private static native byte[] encryptIndex(long var0, byte[] var2, int var3);

    public static native byte[][] handshakeToMobile3(String var0, String var1, String var2, String var3, byte[] var4, byte[] var5, long var6, byte[] var8, int var9);

    public static native byte[][] decodeMoblieMessage3(String var0, String var1, String var2, String var3, byte[] var4, byte[] var5, long var6, int var8, boolean var9, byte[] var10, byte[] var11);

    public static native byte[][] encodeServerMessage3(String var0, String var1, byte[] var2, byte[] var3, byte[] var4);

    private static native byte[] getKeyAliasFromCiphertext(byte[] var0);

    private static native byte[] hmac2(String var0, int var1, byte[] var2);

    private static void checkEnv() throws KeyException {
        if (!isLinuxSystem) {
            throw new KeyException(AksExceptionEnum.AKS_99_99970.getCode(), AksExceptionEnum.AKS_99_99970.getDesc());
        }
        if (!isJNIInit) {
            throw new KeyException(AksExceptionEnum.AKS_99_99971.getCode(), AksExceptionEnum.AKS_99_99971.getDesc());
        }
    }

    public static byte[] crypto(boolean isEncrypt, String aliasName, ModeEnum mode, PaddingEnum padding, byte[] iv, byte[] Data) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(aliasName);
        Preconditions.validate(new byte[][]{Data});
        Preconditions.validate(aliasName, mode, padding, iv);
        if (!isEncrypt) {
            AlgEnum alg = CryptUtil.getAlgByAliasName(aliasName);
            Preconditions.checkEncryptedData(alg, Data);
        }
        byte[] result = isEncrypt ? AKSNativeCryptoService.encrypt(aliasName, mode, padding, iv, Data) : AKSNativeCryptoService.decrypt(aliasName, mode, padding, iv, Data);
        result = isEncrypt ? AKSNativeCryptoService.getResultBytesV2(aliasName, " \u52a0\u5bc6\u539f\u6587\u957f\u5ea6\u4e3a\uff1a", Data, result) : AKSNativeCryptoService.getResultBytes(aliasName, " \u89e3\u5bc6\u5bc6\u6587\u4e3a\uff1a", Data, result);
        return result;
    }

    public static String cryptoByFF1(boolean isEncrypt, String aliasName, RadixEnum radix, String tweak, String data) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(aliasName, data);
        byte[] tweakByte = null;
        if (tweak != null && !"".equals(tweak)) {
            tweakByte = DatatypeConverter.parseBase64Binary(tweak);
        }
        byte[] dataBytes = data.getBytes();
        byte[] result = isEncrypt ? AKSNativeCryptoService.encryptByFF1(aliasName.getBytes(), Integer.parseInt(radix.getCode()), tweakByte, dataBytes) : AKSNativeCryptoService.decryptByFF1(aliasName.getBytes(), Integer.parseInt(radix.getCode()), tweakByte, dataBytes);
        result = isEncrypt ? AKSNativeCryptoService.getResultBytesV2(aliasName, " \u52a0\u5bc6\u539f\u6587\u957f\u5ea6\u4e3a\uff1a", dataBytes, result) : AKSNativeCryptoService.getResultBytes(aliasName, " \u89e3\u5bc6\u5bc6\u6587\u4e3a\uff1a", data, result);
        return new String(result);
    }

    public static byte[] encryptSignedEnvelop(String aliasName, String recipCertB64, String signedCertB64, byte[] data, int envelopType) throws KeyException {
        return AKSNativeCryptoService.encryptSignedEnvelop(aliasName, recipCertB64, signedCertB64, AlgEnum.ALG_AES, data, envelopType);
    }

    public static List<byte[]> decryptSignedEnvelop(String aliasName, String DataB64) throws KeyException {
        return AKSNativeCryptoService.decryptSignedEnvelop(aliasName, DatatypeConverter.parseBase64Binary(DataB64));
    }

    public static List<byte[]> decryptSignedEnvelop(String aliasName, byte[] data) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(aliasName);
        Preconditions.validate(new byte[][]{data});
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        byte[] value = AKSNativeCryptoService.decryptSignedEnvelop(aliasName.getBytes(), data);
        value = AKSNativeCryptoService.getResultBytesV2(aliasName, " \u89e3\u5bc6\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u957f\u5ea6\u4e3a\uff1a", data, value);
        try {
            int src_len = 16;
            String msg = new String(value);
            int length = Integer.parseInt(msg.substring(0, src_len));
            String str1 = msg.substring(src_len, length + src_len);
            result.add(DatatypeConverter.parseBase64Binary(str1));
            String str2 = msg.substring(length + src_len, length + src_len + 4);
            int size = Integer.parseInt(str2);
            str1 = msg.substring(length + src_len + 4);
            for (int i = 0; i < size; ++i) {
                int length1 = Integer.parseInt(str1.substring(0, 4));
                String _value = str1.substring(4, 4 + length1);
                result.add(_value.getBytes());
                str1 = str1.substring(4 + length1);
            }
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.error("\u89e3\u5bc6\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u5931\u8d25\u8fd4\u56de\u7ed3\u679c\u8d8a\u754c\uff0c\u89e3\u5bc6\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u957f\u5ea6\u4e3a\uff1a{}", (Object)data.length);
            throw new KeyException(AksExceptionEnum.AKS_99_00028.getCode(), AksExceptionEnum.AKS_99_00028.getDesc());
        }
        return result;
    }

    public static byte[] privateKeyDecrypt(String aliasName, byte[] srcData) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(aliasName);
        Preconditions.validate(new byte[][]{srcData});
        byte[] result = AKSNativeCryptoService.private_key_decrypt(aliasName.getBytes(), srcData);
        result = AKSNativeCryptoService.getResultBytes(aliasName, " \u79c1\u94a5\u89e3\u5bc6\u5bc6\u6587\u4e3a\uff1a", srcData, result);
        return result;
    }

    public static byte[] privateKeyDecrypt(byte[] key, byte[] srcData) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(key, srcData);
        byte[] result = AKSNativeCryptoService.private_key_decrypt_ex(key, srcData);
        result = AKSNativeCryptoService.getResultBytes(null, " \u79c1\u94a5\u89e3\u5bc6\u5bc6\u6587\u4e3a\uff1a", srcData, result);
        return result;
    }

    public static byte[] privateKeyEncrypt(String aliasName, byte[] srcData) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(aliasName);
        Preconditions.validate(new byte[][]{srcData});
        byte[] result = AKSNativeCryptoService.private_key_encrypt(aliasName.getBytes(), srcData);
        result = AKSNativeCryptoService.getResultBytesV2(aliasName, " \u79c1\u94a5\u52a0\u5bc6\u5bc6\u6587\u957f\u5ea6\u4e3a\uff1a", srcData, result);
        return result;
    }

    public static byte[] publicKeyDecrypt(String aliasName, byte[] cert, byte[] srcData) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(aliasName);
        Preconditions.validate(new byte[][]{srcData});
        byte[] result = AKSNativeCryptoService.public_key_decrypt(aliasName.getBytes(), cert, srcData);
        result = AKSNativeCryptoService.getResultBytes(aliasName, " \u516c\u94a5\u89e3\u5bc6\u5bc6\u6587\u4e3a\uff1a", srcData, result);
        return result;
    }

    public static byte[] publicKeyEncrypt(String aliasName, byte[] cert, byte[] srcData) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(aliasName);
        Preconditions.validate(new byte[][]{srcData});
        byte[] result = AKSNativeCryptoService.public_key_encrypt(aliasName.getBytes(), cert, srcData);
        result = AKSNativeCryptoService.getResultBytesV2(aliasName, " \u516c\u94a5\u52a0\u5bc6\u5bc6\u6587\u957f\u5ea6\u4e3a\uff1a", srcData, result);
        return result;
    }

    public static byte[] p7Sign(String aliasName, boolean isAttach, String signedCertB64, byte[] Data, boolean isGMT0010) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(aliasName, signedCertB64);
        Preconditions.validate(new byte[][]{Data});
        byte[] result = AKSNativeCryptoService.p7Sign(aliasName.getBytes(), !isAttach, DatatypeConverter.parseBase64Binary(signedCertB64), Data, isGMT0010);
        result = AKSNativeCryptoService.getResultBytes(aliasName, " P7\u7b7e\u540d\u6570\u636e\u4e3a\uff1a", Data, result);
        return result;
    }

    public static List<byte[]> p7Verify(boolean isAttach, String signedDataB64, byte[] Data) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(signedDataB64);
        if (!isAttach) {
            Preconditions.validate(new byte[][]{Data});
        }
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        byte[] value = AKSNativeCryptoService.p7Verify(!isAttach, DatatypeConverter.parseBase64Binary(signedDataB64), Data);
        value = AKSNativeCryptoService.getResultBytes(null, " P7\u9a8c\u7b7e\u6570\u636e\u4e3a\uff1a", signedDataB64, value);
        try {
            int src_len = 16;
            String msg = new String(value);
            int length = Integer.parseInt(msg.substring(0, src_len));
            String str1 = msg.substring(src_len, length + src_len);
            result.add(DatatypeConverter.parseBase64Binary(str1));
            String str2 = msg.substring(length + src_len, length + src_len + 4);
            int size = Integer.parseInt(str2);
            str1 = msg.substring(length + src_len + 4);
            for (int i = 0; i < size; ++i) {
                int length1 = Integer.parseInt(str1.substring(0, 4));
                String _value = str1.substring(4, 4 + length1);
                result.add(_value.getBytes());
                str1 = str1.substring(4 + length1);
            }
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.error("P7\u9a8c\u7b7e\u5931\u8d25\u8fd4\u56de\u7ed3\u679c\u8d8a\u754c, P7\u9a8c\u7b7e\u6570\u636e\u4e3a\uff1a{}", (Object)DatatypeConverter.printBase64Binary(Data));
            throw new KeyException(AksExceptionEnum.AKS_99_00052.getCode(), AksExceptionEnum.AKS_99_00052.getDesc());
        }
        return result;
    }

    public static byte[] encryptEnvelop(String recipCertB64, byte[] Data, int envelopType) throws KeyException {
        return AKSNativeCryptoService.encryptEnvelop(AlgEnum.ALG_AES, recipCertB64, Data, envelopType);
    }

    public static byte[] decryptEnvelop(String aliasName, String evpDataB64) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(aliasName, evpDataB64);
        byte[] result = AKSNativeCryptoService.decryptEnvelop(aliasName.getBytes(), DatatypeConverter.parseBase64Binary(evpDataB64));
        result = AKSNativeCryptoService.getResultBytes(aliasName, " \u89e3\u5bc6\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u4e3a\uff1a", evpDataB64, result);
        return result;
    }

    private static byte[] getResultBytes(String alias, String text, byte[] data, byte[] result) {
        if (result != null && result.length >= 4) {
            byte[] b = ByteUtil.copy(result, 0, 4);
            int errorCode = ByteUtil.byteToInt(b);
            if (errorCode != 0) {
                byte[] errorMsg = ByteUtil.copy(result, 4, result.length - 4);
                String code = String.valueOf(errorCode);
                String msg = new String(errorMsg);
                LOGGER.error("{} {} {} {}", new Object[]{msg, text, alias, DatatypeConverter.printBase64Binary(data)});
                throw new KeyException("AKS99" + code, msg + (alias == null ? "" : " alias: " + alias));
            }
            result = ByteUtil.copy(result, 4, result.length - 4);
        }
        return result;
    }

    private static byte[] getResultBytes(String alias, String text, String data, byte[] result) {
        if (result != null && result.length >= 4) {
            byte[] b = ByteUtil.copy(result, 0, 4);
            int errorCode = ByteUtil.byteToInt(b);
            if (errorCode != 0) {
                byte[] errorMsg = ByteUtil.copy(result, 4, result.length - 4);
                String code = String.valueOf(errorCode);
                String msg = new String(errorMsg);
                LOGGER.error("{} {} {} {}", new Object[]{msg, text, alias, data});
                throw new KeyException("AKS99" + code, msg + (alias == null ? "" : " alias: " + alias));
            }
            result = ByteUtil.copy(result, 4, result.length - 4);
        }
        return result;
    }

    private static byte[] getResultBytesV2(String alias, String text, byte[] data, byte[] result) {
        if (result != null && result.length >= 4) {
            byte[] b = ByteUtil.copy(result, 0, 4);
            int errorCode = ByteUtil.byteToInt(b);
            if (errorCode != 0) {
                byte[] errorMsg = ByteUtil.copy(result, 4, result.length - 4);
                String code = String.valueOf(errorCode);
                String msg = new String(errorMsg);
                LOGGER.error("{} {} {} {}", new Object[]{msg, text, alias, data.length});
                throw new KeyException("AKS99" + code, msg + (alias == null ? "" : " alias: " + alias));
            }
            result = ByteUtil.copy(result, 4, result.length - 4);
        }
        return result;
    }

    private static byte[] decrypt(String aliasName, ModeEnum mode, PaddingEnum padding, byte[] iv, byte[] Data) {
        AlgEnum alg = CryptUtil.getAlgByAliasName(aliasName);
        return AKSNativeCryptoService.decrypt(CryptUtil.getAlg(alg), CryptUtil.getMode(mode), CryptUtil.getPadding(padding), aliasName.getBytes(), iv, Data);
    }

    private static byte[] encrypt(String aliasName, ModeEnum mode, PaddingEnum padding, byte[] iv, byte[] Data) {
        AlgEnum alg = CryptUtil.getAlgByAliasName(aliasName);
        return AKSNativeCryptoService.encrypt(CryptUtil.getAlg(alg), CryptUtil.getMode(mode), CryptUtil.getPadding(padding), aliasName.getBytes(), iv, Data);
    }

    private static byte[] decrypt(AlgEnum alg, byte[] key, ModeEnum mode, PaddingEnum padding, byte[] iv, byte[] Data) {
        return AKSNativeCryptoService.decrypt_ex(CryptUtil.getAlg(alg), CryptUtil.getMode(mode), CryptUtil.getPadding(padding), key, iv, Data);
    }

    private static byte[] encrypt(AlgEnum alg, byte[] key, ModeEnum mode, PaddingEnum padding, byte[] iv, byte[] Data) {
        return AKSNativeCryptoService.encrypt_ex(CryptUtil.getAlg(alg), CryptUtil.getMode(mode), CryptUtil.getPadding(padding), key, iv, Data);
    }

    public static int setKey(String token, String aliasName, byte[] value) throws KeyException {
        if (!isLinuxSystem) {
            return 0;
        }
        Preconditions.validate(aliasName);
        Preconditions.validate(new byte[][]{value});
        Preconditions.checkAliasName(aliasName);
        int code = AKSNativeCryptoService.putKey(token, aliasName, value);
        if (0 != code) {
            LOGGER.warn("WARNING: put key error. alias {}, code {} ", (Object)aliasName, (Object)code);
        }
        return code;
    }

    public static void removeKey(String aliasName) throws KeyException {
        Preconditions.validate(aliasName);
        Preconditions.checkAliasName(aliasName);
        if (isLinuxSystem) {
            AKSNativeCryptoService.deleteKey(aliasName);
        }
    }

    public static int put_token(String token_keyAlias, String token) throws KeyException {
        if (!isLinuxSystem) {
            return 0;
        }
        int errorCode = AKSNativeCryptoService.putKey("put_token", token_keyAlias, ByteUtil.hexStringToBytes(token));
        if (0 != errorCode) {
            LOGGER.error("set {} key error, errorCode is {}", (Object)token_keyAlias, (Object)errorCode);
        } else {
            LOGGER.info("set {} key ok", (Object)token_keyAlias);
        }
        return errorCode;
    }

    public static byte[] crypto(String token_keyAlias, ModeEnum mode, PaddingEnum padding, byte[] iv, byte[] Data) throws KeyException {
        if (!isLinuxSystem) {
            return null;
        }
        return AKSNativeCryptoService.crypto(false, token_keyAlias, mode, padding, iv, Data);
    }

    @Deprecated
    public static byte[] encryptUserPasswordWithMD5(String userID, byte[] MD5Value, byte[] salt16, byte[] salt32, String pwkeyAlias, String hashKeyAlias) {
        return AKSNativeCryptoService.encryptUserPasswordMD5(userID, MD5Value, salt16, salt32, pwkeyAlias, hashKeyAlias);
    }

    @Deprecated
    public static byte[] encryptUserPassword(String userID, String password, byte[] salt16, byte[] salt32, String pwkeyAlias, String hashKeyAlias) {
        return AKSNativeCryptoService.encryptUserPW(userID, password, salt16, salt32, pwkeyAlias, hashKeyAlias);
    }

    @Deprecated
    public static int checkUserPassword(String userID, String password, byte[] secureValue, String pwkeyAlias, String hashKeyAlias) {
        return AKSNativeCryptoService.checkUserPW(userID, password, secureValue, pwkeyAlias, hashKeyAlias);
    }

    public static String getPublicKey(String aliasName, boolean isSubjectPublicKeyInfoStructure) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(aliasName);
        Preconditions.checkAliasName(aliasName);
        byte[] result = AKSNativeCryptoService.getPublicKey(aliasName.getBytes(), isSubjectPublicKeyInfoStructure);
        result = AKSNativeCryptoService.getResultBytes(aliasName, " \u83b7\u53d6\u516c\u94a5\u5931\u8d25 aliasName\uff1a", aliasName, result);
        return new String(result);
    }

    public static String getPublicKeyN(String aliasName) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(aliasName);
        Preconditions.checkAliasName(aliasName);
        byte[] result = AKSNativeCryptoService.getPublicKeyN(aliasName.getBytes());
        result = AKSNativeCryptoService.getResultBytes(aliasName, " \u83b7\u53d6\u516c\u94a5N\u5931\u8d25 aliasName\uff1a", aliasName, result);
        return new String(result);
    }

    public static List<String> encryptPassword(String symmKeyAliasName, String asymKeyAliasName, String pubKeyEncryptedPasswordB64) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(symmKeyAliasName, asymKeyAliasName, pubKeyEncryptedPasswordB64);
        Preconditions.checkAliasName(symmKeyAliasName);
        Preconditions.checkAliasName(asymKeyAliasName);
        ArrayList<String> result_list = new ArrayList<String>();
        byte[] result = AKSNativeCryptoService.encryptPassword(symmKeyAliasName.getBytes(), asymKeyAliasName.getBytes(), DatatypeConverter.parseBase64Binary(pubKeyEncryptedPasswordB64));
        result = AKSNativeCryptoService.getResultBytes(asymKeyAliasName, " \u52a0\u5bc6\u5bc6\u7801\u5931\u8d25\uff1a", pubKeyEncryptedPasswordB64, result);
        String[] values = new String(result).split("[|]");
        if (2 == values.length) {
            result_list.add(values[0]);
            result_list.add(values[1]);
        }
        return result_list;
    }

    public static String verifyPassword(String symmKeyAliasName, String asymKeyAliasName, String pubKeyEncryptedPasswordB64, String encryptedSaltB64) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(symmKeyAliasName, asymKeyAliasName, pubKeyEncryptedPasswordB64, encryptedSaltB64);
        Preconditions.checkAliasName(symmKeyAliasName);
        Preconditions.checkAliasName(asymKeyAliasName);
        byte[] result = AKSNativeCryptoService.verifyPassword(symmKeyAliasName.getBytes(), asymKeyAliasName.getBytes(), DatatypeConverter.parseBase64Binary(pubKeyEncryptedPasswordB64), DatatypeConverter.parseBase64Binary(encryptedSaltB64));
        result = AKSNativeCryptoService.getResultBytes(asymKeyAliasName, " \u9a8c\u8bc1\u5bc6\u7801\u5931\u8d25\uff1a", pubKeyEncryptedPasswordB64, result);
        return new String(result);
    }

    public static List<String> encryptEvpWithSymm(String certB64, AlgEnum alg, ModeEnum mode, PaddingEnum padding, byte[] iv, byte[] data, int envelopType) {
        return AKSNativeCryptoService.encryptEvpWithSymm(AlgEnum.ALG_AES, certB64, alg, mode, padding, iv, data, envelopType);
    }

    public static byte[] decryptEvpWithSymm(String certAliasName, AlgEnum alg, ModeEnum mode, PaddingEnum padding, byte[] iv, byte[] evp, byte[] data) {
        AKSNativeCryptoService.checkEnv();
        String tmp_aliasName = String.format("eee_%02d_001", CryptUtil.getAlg(alg));
        Preconditions.validate(certAliasName);
        Preconditions.validate(evp, data);
        Preconditions.validate(tmp_aliasName, mode, padding, iv);
        Preconditions.checkAliasName(certAliasName);
        Preconditions.checkEncryptedData(alg, data);
        byte[] result = AKSNativeCryptoService.decryptEvpWithSymm(certAliasName.getBytes(), CryptUtil.getAlg(alg), CryptUtil.getMode(mode), CryptUtil.getPadding(padding), iv, evp, data);
        result = AKSNativeCryptoService.getResultBytes(certAliasName, " \u89e3\u5bc6\u5916\u5e26\u6570\u636e\u6570\u5b57\u4fe1\u5c01\u5bc6\u6587: ", data, result);
        return result;
    }

    public static List<String> cleanPW(String aliasName, String jdpin, String pwHex) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(aliasName, jdpin, pwHex);
        Preconditions.checkAliasName(aliasName);
        ArrayList<String> result_list = new ArrayList<String>();
        byte[] result = AKSNativeCryptoService.cleanPassword(aliasName.getBytes(), jdpin.getBytes(), pwHex.toUpperCase().getBytes());
        result = AKSNativeCryptoService.getResultBytes(aliasName, " \u5bc6\u7801\u6e05\u6d17\u5931\u8d25. pwHex: ", pwHex, result);
        String msg = new String(result);
        String[] values = msg.split("[|]");
        if (2 == values.length) {
            result_list.add(values[0]);
            result_list.add(values[1]);
        }
        return result_list;
    }

    public static List<String> resetPWAks(String symmKeyAliasName, String asymKeyAliasName, String jdpin, String pubKeyEncryptedPasswordHashB64) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(symmKeyAliasName, asymKeyAliasName, jdpin, pubKeyEncryptedPasswordHashB64);
        Preconditions.checkAliasName(symmKeyAliasName);
        Preconditions.checkAliasName(asymKeyAliasName);
        ArrayList<String> result_list = new ArrayList<String>();
        byte[] result = AKSNativeCryptoService.resetPasswordByAKS(symmKeyAliasName.getBytes(), asymKeyAliasName.getBytes(), jdpin.getBytes(), DatatypeConverter.parseBase64Binary(pubKeyEncryptedPasswordHashB64));
        result = AKSNativeCryptoService.getResultBytes(asymKeyAliasName, " \u7528\u6237\u5bc6\u7801\u91cd\u7f6e(AKS)\u5931\u8d25. pubKeyEncryptedPasswordHashB64: ", pubKeyEncryptedPasswordHashB64, result);
        String msg = new String(result);
        String[] values = msg.split("[|]");
        if (2 == values.length) {
            result_list.add(values[0]);
            result_list.add(values[1]);
        }
        return result_list;
    }

    public static String checkPWAks(String symmKeyAliasName, String asymKeyAliasName, String jdpin, String pubKeyEncryptedPasswordHashB64, String cryptSalt64, String cryptPasswordHashB64) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(symmKeyAliasName, asymKeyAliasName, jdpin, pubKeyEncryptedPasswordHashB64, cryptSalt64, cryptPasswordHashB64);
        Preconditions.checkAliasName(symmKeyAliasName);
        Preconditions.checkAliasName(asymKeyAliasName);
        byte[] result = AKSNativeCryptoService.checkPasswordByAKS(symmKeyAliasName.getBytes(), asymKeyAliasName.getBytes(), jdpin.getBytes(), DatatypeConverter.parseBase64Binary(pubKeyEncryptedPasswordHashB64), DatatypeConverter.parseBase64Binary(cryptSalt64), cryptPasswordHashB64.getBytes());
        result = AKSNativeCryptoService.getResultBytes(asymKeyAliasName, " \u7528\u6237\u5bc6\u7801\u9a8c\u8bc1(AKS)\u5931\u8d25. pubKeyEncryptedPasswordHashB64: ", pubKeyEncryptedPasswordHashB64, result);
        return new String(result);
    }

    public static List<String> resetPWMD5(String aliasName, String jdpin, String pwd_hash_hex) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(aliasName, jdpin, pwd_hash_hex);
        Preconditions.checkAliasName(aliasName);
        ArrayList<String> result_list = new ArrayList<String>();
        byte[] result = AKSNativeCryptoService.resetPasswordByMD5(aliasName.getBytes(), jdpin.getBytes(), pwd_hash_hex.getBytes());
        result = AKSNativeCryptoService.getResultBytes(aliasName, " \u7528\u6237\u5bc6\u7801\u91cd\u7f6e(MD5)\u5931\u8d25. pwd_hash_hex: ", pwd_hash_hex, result);
        String msg = new String(result);
        String[] values = msg.split("[|]");
        if (2 == values.length) {
            result_list.add(values[0]);
            result_list.add(values[1]);
        }
        return result_list;
    }

    public static String checkPWMD5(String aliasName, String jdpin, String pwd_hash_hex, String cryptSaltB64, String cryptPasswordHashB64) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(aliasName, jdpin, pwd_hash_hex, cryptSaltB64, cryptPasswordHashB64);
        Preconditions.checkAliasName(aliasName);
        byte[] result = AKSNativeCryptoService.checkPasswordByMD5(aliasName.getBytes(), jdpin.getBytes(), pwd_hash_hex.getBytes(), DatatypeConverter.parseBase64Binary(cryptSaltB64), cryptPasswordHashB64.getBytes());
        result = AKSNativeCryptoService.getResultBytes(aliasName, " \u7528\u6237\u5bc6\u7801\u9a8c\u8bc1(MD5)\u5931\u8d25. pwd_hash_hex: ", pwd_hash_hex, result);
        return new String(result);
    }

    public static byte[] decryptWithAsym(String symmKeyAliasName, String encryptedSessionKeyB64, String encryptedPrivateKeyB64, String publicKeyEncryptedSessionKeyB64, AlgEnum alg, ModeEnum mode, PaddingEnum padding, byte[] iv, String encryptedDataB64) {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(symmKeyAliasName, encryptedSessionKeyB64, encryptedPrivateKeyB64, publicKeyEncryptedSessionKeyB64, encryptedDataB64);
        String tmp_aliasName = String.format("eee_%02d_001", CryptUtil.getAlg(alg));
        byte[] encryptedPrivateKey = DatatypeConverter.parseBase64Binary(encryptedPrivateKeyB64);
        byte[] publicKeyEncryptedSessionKey = DatatypeConverter.parseBase64Binary(publicKeyEncryptedSessionKeyB64);
        byte[] encryptedData = DatatypeConverter.parseBase64Binary(encryptedDataB64);
        byte[] encryptedSessionKey = DatatypeConverter.parseBase64Binary(encryptedSessionKeyB64);
        Preconditions.validate(tmp_aliasName, mode, padding, iv);
        Preconditions.checkAliasName(symmKeyAliasName);
        Preconditions.checkEncryptedData(alg, encryptedData);
        Preconditions.checkEncryptedData(CryptUtil.getAlgByAliasName(symmKeyAliasName), encryptedSessionKey);
        byte[] result = AKSNativeCryptoService.decryptWithAsym(symmKeyAliasName.getBytes(), encryptedSessionKey, encryptedPrivateKey, publicKeyEncryptedSessionKey, CryptUtil.getAlg(alg), CryptUtil.getMode(mode), CryptUtil.getPadding(padding), iv, encryptedData);
        result = AKSNativeCryptoService.getResultBytes(symmKeyAliasName, " decryptWithAsym error. encryptedDataB64: ", encryptedDataB64, result);
        return result;
    }

    public static byte[] decryptWithAsym(String asymKeyAliasName, String publicKeyEncryptedSessionKeyB64, AlgEnum alg, ModeEnum mode, PaddingEnum padding, byte[] iv, String encryptedDataB64) {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(asymKeyAliasName, publicKeyEncryptedSessionKeyB64, encryptedDataB64);
        String tmp_aliasName = String.format("eee_%02d_001", CryptUtil.getAlg(alg));
        byte[] publicKeyEncryptedSessionKey = DatatypeConverter.parseBase64Binary(publicKeyEncryptedSessionKeyB64);
        byte[] encryptedData = DatatypeConverter.parseBase64Binary(encryptedDataB64);
        Preconditions.validate(tmp_aliasName, mode, padding, iv);
        Preconditions.checkAliasName(asymKeyAliasName);
        Preconditions.checkEncryptedData(alg, encryptedData);
        byte[] result = AKSNativeCryptoService.decryptWithAsym_offline(asymKeyAliasName.getBytes(), publicKeyEncryptedSessionKey, CryptUtil.getAlg(alg), CryptUtil.getMode(mode), CryptUtil.getPadding(padding), iv, encryptedData);
        result = AKSNativeCryptoService.getResultBytes(asymKeyAliasName, " decryptWithAsym error. encryptedDataB64: ", encryptedDataB64, result);
        return result;
    }

    public static byte[] checkPayCode(String aliasName, RadixEnum radix, String tweak_FK, byte[] paycode, int rate, byte[] verifyPin, byte[] sk, byte[] fk, byte[] tweak, long t) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(aliasName);
        Preconditions.validate(paycode, verifyPin, sk, fk);
        byte[] tweakByte = null;
        if (tweak_FK != null && !"".equals(tweak_FK)) {
            tweakByte = DatatypeConverter.parseBase64Binary(tweak_FK);
        }
        byte[] result = AKSNativeCryptoService.chkPayCode(aliasName.getBytes(), Integer.parseInt(radix.getCode()), tweakByte, paycode, rate, verifyPin, sk, fk, tweak, t);
        result = AKSNativeCryptoService.getResultBytes(aliasName, " checkPayCode error ", "", result);
        return result;
    }

    public static byte[] getSeedByPayCodeUnipay(String aliasName, RadixEnum radix, String tweak_FK, byte[] paycode, byte[] fk, byte[] tweak) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(aliasName);
        Preconditions.validate(paycode, fk);
        byte[] tweakByte = null;
        if (tweak_FK != null && !"".equals(tweak_FK)) {
            tweakByte = DatatypeConverter.parseBase64Binary(tweak_FK);
        }
        byte[] result = AKSNativeCryptoService.getSeedByPayCode(aliasName.getBytes(), Integer.parseInt(radix.getCode()), tweakByte, paycode, fk, tweak);
        result = AKSNativeCryptoService.getResultBytes(aliasName, " getSeedByPayCode error ", "", result);
        return result;
    }

    public static byte[] decryptPW(String key, String keypair, String pubKeyPW) throws KeyException {
        try {
            byte[] keyBytes = AKSNativeCryptoService.crypto(false, "rsa_04_001", ModeEnum.MODE_ECB, PaddingEnum.PADDING_NOPADDING, null, DatatypeConverter.parseBase64Binary(key));
            byte[] keypairBytes = AKSNativeCryptoService.crypto(false, AlgEnum.ALG_AES256, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, keyBytes, null, DatatypeConverter.parseBase64Binary(keypair));
            byte[] pw = AKSNativeCryptoService.privateKeyDecrypt(keypairBytes, DatatypeConverter.parseBase64Binary(pubKeyPW));
            return pw;
        }
        catch (KeyException e) {
            LOGGER.warn(" decryptPW error. Msg:{}", (Object)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.warn(" decryptPW error. Exception\uff1a" + e, (Throwable)e);
        }
        return null;
    }

    public static byte[] crypto(boolean isEncrypt, AlgEnum alg, ModeEnum mode, PaddingEnum padding, byte[] key, byte[] iv, byte[] Data) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        String aliasName = CryptUtil.getAliasNameByAlg(alg);
        Preconditions.validate(key, Data);
        Preconditions.validate(aliasName, mode, padding, iv);
        if (!isEncrypt) {
            Preconditions.checkEncryptedData(alg, Data);
        }
        byte[] result = isEncrypt ? AKSNativeCryptoService.encrypt(alg, key, mode, padding, iv, Data) : AKSNativeCryptoService.decrypt(alg, key, mode, padding, iv, Data);
        result = isEncrypt ? AKSNativeCryptoService.getResultBytesV2(null, " \u52a0\u5bc6\u539f\u6587\u957f\u5ea6\u4e3a\uff1a", Data, result) : AKSNativeCryptoService.getResultBytes(null, " \u89e3\u5bc6\u5bc6\u6587\u4e3a\uff1a", Data, result);
        return result;
    }

    public static List<String> encryptPassword_ex(String symmKeyAliasName, byte[] asymKey, String pubKeyEncryptedPasswordB64) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(symmKeyAliasName, pubKeyEncryptedPasswordB64);
        Preconditions.validate(new byte[][]{asymKey});
        Preconditions.checkAliasName(symmKeyAliasName);
        ArrayList<String> result_list = new ArrayList<String>();
        byte[] result = AKSNativeCryptoService.encryptPassword_ex(symmKeyAliasName.getBytes(), asymKey, DatatypeConverter.parseBase64Binary(pubKeyEncryptedPasswordB64));
        result = AKSNativeCryptoService.getResultBytes(null, " \u5bc6\u7801\u52a0\u5bc6\u5931\u8d25\uff0c\u5bc6\u6587\u4e3a\uff1a", pubKeyEncryptedPasswordB64, result);
        String msg = new String(result);
        String[] values = msg.split("[|]");
        if (2 == values.length) {
            result_list.add(values[0]);
            result_list.add(values[1]);
        }
        return result_list;
    }

    public static String verifyPassword_ex(String symmKeyAliasName, byte[] asymKey, String pubKeyEncryptedPasswordB64, String encryptedSaltB64) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(symmKeyAliasName, pubKeyEncryptedPasswordB64, encryptedSaltB64);
        Preconditions.validate(new byte[][]{asymKey});
        Preconditions.checkAliasName(symmKeyAliasName);
        byte[] result = AKSNativeCryptoService.verifyPassword_ex(symmKeyAliasName.getBytes(), asymKey, DatatypeConverter.parseBase64Binary(pubKeyEncryptedPasswordB64), DatatypeConverter.parseBase64Binary(encryptedSaltB64));
        result = AKSNativeCryptoService.getResultBytes(null, " \u5bc6\u7801\u9a8c\u8bc1\u5931\u8d25\uff0c\u5bc6\u6587\u4e3a\uff1a", pubKeyEncryptedPasswordB64, result);
        return new String(result);
    }

    public static List<String> resetPWAks_ex(String symmKeyAliasName, byte[] asymKey, String jdpin, String pubKeyEncryptedPasswordHashB64) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(symmKeyAliasName, jdpin, pubKeyEncryptedPasswordHashB64);
        Preconditions.validate(new byte[][]{asymKey});
        Preconditions.checkAliasName(symmKeyAliasName);
        ArrayList<String> result_list = new ArrayList<String>();
        byte[] result = AKSNativeCryptoService.resetPasswordByAKS_ex(symmKeyAliasName.getBytes(), asymKey, jdpin.getBytes(), DatatypeConverter.parseBase64Binary(pubKeyEncryptedPasswordHashB64));
        result = AKSNativeCryptoService.getResultBytes(null, " \u5bc6\u7801\u91cd\u7f6e\u5931\u8d25\uff0c\u5bc6\u6587\u4e3a\uff1a", pubKeyEncryptedPasswordHashB64, result);
        String msg = new String(result);
        String[] values = msg.split("[|]");
        if (2 == values.length) {
            result_list.add(values[0]);
            result_list.add(values[1]);
        }
        return result_list;
    }

    public static String checkPWAks_ex(String symmKeyAliasName, byte[] asymKey, String jdpin, String pubKeyEncryptedPasswordHashB64, String cryptSalt64, String cryptPasswordHashB64) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(symmKeyAliasName, jdpin, pubKeyEncryptedPasswordHashB64, cryptSalt64, cryptPasswordHashB64);
        Preconditions.validate(new byte[][]{asymKey});
        Preconditions.checkAliasName(symmKeyAliasName);
        byte[] result = AKSNativeCryptoService.checkPasswordByAKS_ex(symmKeyAliasName.getBytes(), asymKey, jdpin.getBytes(), DatatypeConverter.parseBase64Binary(pubKeyEncryptedPasswordHashB64), DatatypeConverter.parseBase64Binary(cryptSalt64), cryptPasswordHashB64.getBytes());
        result = AKSNativeCryptoService.getResultBytes(null, " \u5bc6\u7801\u89e3\u5bc6\u5931\u8d25\uff0c\u5bc6\u6587\u4e3a\uff1a", pubKeyEncryptedPasswordHashB64, result);
        return new String(result);
    }

    public static String checkPWDForKeyboard(boolean isCheckOTP, String aliasName, String evpB64) {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(aliasName, evpB64);
        byte[] result = AKSNativeCryptoService.checkPassword(isCheckOTP, aliasName, evpB64);
        result = AKSNativeCryptoService.getResultBytes(aliasName, " \u5b89\u5168\u952e\u76d8\u89e3\u5bc6\u5931\u8d25\uff0c\u5bc6\u6587\u4e3a\uff1a", evpB64, result);
        return ByteUtil.bytesToHexString(result);
    }

    public static String hMac(DigestAlgEnum hashAlg, String appid, byte[] in) {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(appid);
        Preconditions.validate(new byte[][]{in});
        int alg = 5;
        if (hashAlg.getCode().equals("SHA-256")) {
            alg = 3;
        }
        byte[] result = AKSNativeCryptoService.hmac(appid, alg, in);
        result = AKSNativeCryptoService.getResultBytes(appid, " HMAC " + hashAlg.getDesc() + " \u5931\u8d25\uff1a", in, result);
        return ByteUtil.bytesToHexString(result);
    }

    public static String hMac2(DigestAlgEnum hashAlg, String aliasName, byte[] in) {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(aliasName);
        Preconditions.validate(new byte[][]{in});
        int alg = 5;
        if (hashAlg.getCode().equals("MD5")) {
            alg = 1;
        } else if (hashAlg.getCode().equals("SHA1")) {
            alg = 2;
        } else if (hashAlg.getCode().equals("SHA-256")) {
            alg = 3;
        } else if (hashAlg.getCode().equals("SHA-512")) {
            alg = 4;
        } else if (hashAlg.getCode().equals("SM3")) {
            alg = 5;
        }
        byte[] result = AKSNativeCryptoService.hmac2(aliasName, alg, in);
        result = AKSNativeCryptoService.getResultBytes(aliasName, " HMAC " + hashAlg.getDesc() + " \u5931\u8d25\uff1a", in, result);
        return ByteUtil.bytesToHexString(result);
    }

    public static byte[] hash(DigestAlgEnum hashAlg, byte[] in) {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(new byte[][]{in});
        int alg = 5;
        if (hashAlg.getCode().equals("MD5")) {
            alg = 1;
        } else if (hashAlg.getCode().equals("SHA1")) {
            alg = 2;
        } else if (hashAlg.getCode().equals("SHA-256")) {
            alg = 3;
        } else if (hashAlg.getCode().equals("SHA-512")) {
            alg = 4;
        } else if (hashAlg.getCode().equals("SM3")) {
            alg = 5;
        }
        byte[] result = AKSNativeCryptoService.hash_handle(alg, in);
        return AKSNativeCryptoService.getResultBytes(null, " HASH " + hashAlg.getDesc() + " \u5931\u8d25\uff1a", in, result);
    }

    public static String createIndex(String appId, byte[] in) {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(appId);
        Preconditions.validate(new byte[][]{in});
        byte[] result = AKSNativeCryptoService.createIndex(appId, 3, in);
        result = AKSNativeCryptoService.getResultBytes(appId, " createIndex  \u5931\u8d25\uff1a", in, result);
        return DatatypeConverter.printBase64Binary(result);
    }

    public static byte[] symmEncryptByte(String aliasName, ModeEnum mode, PaddingEnum padding, byte[] Data) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(aliasName);
        Preconditions.validate(new byte[][]{Data});
        AlgEnum alg = CryptUtil.getAlgByAliasName(aliasName);
        byte[] result = AKSNativeCryptoService.symm_encrypt(aliasName.getBytes(), CryptUtil.getAlg(alg), CryptUtil.getMode(mode), CryptUtil.getPadding(padding), null, Data, null);
        result = AKSNativeCryptoService.getResultBytesV2(aliasName, " \u52a0\u5bc6\u539f\u6587\u957f\u5ea6\u4e3a\uff1a", Data, result);
        return result;
    }

    public static String symmEncrypt(String aliasName, ModeEnum mode, PaddingEnum padding, byte[] Data) throws KeyException {
        return DatatypeConverter.printBase64Binary(AKSNativeCryptoService.symmEncryptByte(aliasName, mode, padding, Data));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] symmDecrypt(String aliasName, ModeEnum mode, PaddingEnum padding, byte[] iv, String Data) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(aliasName);
        Preconditions.validate(Data);
        Preconditions.validate(aliasName, mode, padding, iv);
        AlgEnum alg = CryptUtil.getAlgByAliasName(aliasName);
        byte[] inData = DatatypeConverter.parseBase64Binary(Data);
        try {
            Preconditions.checkEncryptedDataByVersion(alg, inData);
        }
        catch (KeyException e) {
            Preconditions.checkEncryptedData(alg, inData);
        }
        byte[] result = AKSNativeCryptoService.symm_decrypt(aliasName.getBytes(), CryptUtil.getAlg(alg), CryptUtil.getMode(mode), CryptUtil.getPadding(padding), iv, inData, null);
        if (result == null) return result;
        if (result.length < 4) return result;
        byte[] b = ByteUtil.copy(result, 0, 4);
        int errorCode = ByteUtil.byteToInt(b);
        if (errorCode == 0) return ByteUtil.copy(result, 4, result.length - 4);
        byte[] errorMsg = ByteUtil.copy(result, 4, result.length - 4);
        String code = String.valueOf(errorCode);
        if ("20119".equals(code)) {
            return AKSNativeCryptoService.crypto(false, aliasName, mode, padding, iv, inData);
        }
        String msg = new String(errorMsg);
        LOGGER.error("{} \u89e3\u5bc6\u5bc6\u6587\u4e3a\uff1a{}", (Object)msg, (Object)ByteUtil.bytesToHexString(inData));
        throw new KeyException("AKS99" + code, msg);
    }

    public static byte[] symmEncryptForGCM(String aliasName, PaddingEnum padding, byte[] Data, byte[] nonce, byte[] iv) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(aliasName);
        Preconditions.validate(new byte[][]{Data});
        AlgEnum alg = CryptUtil.getAlgByAliasName(aliasName);
        byte[] result = AKSNativeCryptoService.symm_encrypt(aliasName.getBytes(), CryptUtil.getAlg(alg), 3, CryptUtil.getPadding(padding), iv, Data, nonce);
        result = AKSNativeCryptoService.getResultBytesV2(aliasName, " GCM\u52a0\u5bc6\u539f\u6587\u957f\u5ea6\u4e3a\uff1a", Data, result);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] symmDecryptForGCM(String aliasName, ModeEnum mode, PaddingEnum padding, byte[] inData, byte[] nonce, byte[] iv) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(aliasName);
        Preconditions.validate(new byte[][]{inData});
        AlgEnum alg = CryptUtil.getAlgByAliasName(aliasName);
        byte[] result = AKSNativeCryptoService.symm_decrypt(aliasName.getBytes(), CryptUtil.getAlg(alg), CryptUtil.getMode(mode), CryptUtil.getPadding(padding), iv, inData, nonce);
        if (result == null) return result;
        if (result.length < 4) return result;
        byte[] b = ByteUtil.copy(result, 0, 4);
        int errorCode = ByteUtil.byteToInt(b);
        if (errorCode == 0) return ByteUtil.copy(result, 4, result.length - 4);
        byte[] errorMsg = ByteUtil.copy(result, 4, result.length - 4);
        String code = String.valueOf(errorCode);
        if ("20119".equals(code)) {
            return AKSNativeCryptoService.crypto(false, aliasName, mode, padding, iv, inData);
        }
        String msg = new String(errorMsg);
        LOGGER.error("{} GCM\u89e3\u5bc6\u5bc6\u6587\u4e3a\uff1a{} alias: {}", new Object[]{msg, ByteUtil.bytesToHexString(inData), aliasName});
        throw new KeyException("AKS99" + code, msg + " alias: " + aliasName);
    }

    public static byte[] checkOTP(boolean isCheckOTP, byte[] otpData) {
        int check;
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(new byte[][]{otpData});
        if (otpData.length <= 8) {
            throw new KeyException(AksExceptionEnum.AKS_99_00071.getCode(), AksExceptionEnum.AKS_99_00071.getDesc() + "otpData.length <= 8");
        }
        byte[] otp = ByteUtil.copy(otpData, 0, 8);
        byte[] data = ByteUtil.copy(otpData, 8, otpData.length - 8);
        if (isCheckOTP && (check = AKSNativeCryptoService.checkOTP(otp, data)) != 0) {
            throw new KeyException(AksExceptionEnum.AKS_99_00072.getCode(), AksExceptionEnum.AKS_99_00072.getDesc());
        }
        return data;
    }

    public static byte[] encryptEnvelop(AlgEnum evp_symm_alg, String recipCertB64, byte[] Data, int envelopType) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(recipCertB64);
        Preconditions.validate(new byte[][]{Data});
        int alg = CryptUtil.getAlg(evp_symm_alg);
        byte[] result = AKSNativeCryptoService.encryptEnvelop(alg, DatatypeConverter.parseBase64Binary(recipCertB64), Data, envelopType);
        result = AKSNativeCryptoService.getResultBytesV2(null, " \u52a0\u5bc6\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u957f\u5ea6\u4e3a\uff1a", Data, result);
        return result;
    }

    public static byte[] encryptSignedEnvelop(String aliasName, String recipCertB64, String signedCertB64, AlgEnum evp_symm_alg, byte[] data, int envelopType) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(aliasName, recipCertB64, signedCertB64);
        Preconditions.validate(new byte[][]{data});
        int alg = CryptUtil.getAlg(evp_symm_alg);
        byte[] result = AKSNativeCryptoService.encryptSignedEnvelop(aliasName.getBytes(), DatatypeConverter.parseBase64Binary(recipCertB64), DatatypeConverter.parseBase64Binary(signedCertB64), alg, data, envelopType);
        result = AKSNativeCryptoService.getResultBytesV2(aliasName, " \u52a0\u5bc6\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e\u957f\u5ea6\u4e3a\uff1a", data, result);
        return result;
    }

    public static List<String> encryptEvpWithSymm(AlgEnum evp_symm_alg, String certB64, AlgEnum alg, ModeEnum mode, PaddingEnum padding, byte[] iv, byte[] data, int envelopType) {
        AKSNativeCryptoService.checkEnv();
        String tmp_aliasName = String.format("eee_%02d_001", CryptUtil.getAlg(alg));
        Preconditions.validate(certB64);
        Preconditions.validate(new byte[][]{data});
        Preconditions.validate(tmp_aliasName, mode, padding, iv);
        ArrayList<String> results = new ArrayList<String>();
        int symm_alg = CryptUtil.getAlg(evp_symm_alg);
        byte[] result = AKSNativeCryptoService.encryptEvpWithSymm(CryptUtil.getAlg(alg), CryptUtil.getMode(mode), CryptUtil.getPadding(padding), iv, symm_alg, DatatypeConverter.parseBase64Binary(certB64), data, envelopType);
        if (result != null && result.length >= 4) {
            byte[] b = ByteUtil.copy(result, 0, 4);
            int errorCode = ByteUtil.byteToInt(b);
            if (errorCode != 0) {
                byte[] errorMsg = ByteUtil.copy(result, 4, result.length - 4);
                String code = String.valueOf(errorCode);
                String msg = new String(errorMsg);
                LOGGER.error("{} \u52a0\u5bc6\u5916\u5e26\u6570\u636e\u6570\u5b57\u4fe1\u5c01\u539f\u6587\u957f\u5ea6\uff1a{} \n\u8bc1\u4e66: {}", new Object[]{msg, data.length, certB64});
                throw new KeyException("AKS99" + code, msg);
            }
            result = ByteUtil.copy(result, 4, result.length - 4);
            String tmp_value = new String(result);
            int length = Integer.parseInt(tmp_value.substring(0, 4));
            String value = tmp_value.substring(4, length + 4);
            results.add(value);
            tmp_value = tmp_value.substring(length + 4);
            length = Integer.parseInt(tmp_value.substring(0, 5));
            value = tmp_value.substring(5, length + 5);
            results.add(value);
        }
        return results;
    }

    public static byte[] p1Sign(String aliasName, byte[] Data) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(aliasName);
        Preconditions.validate(new byte[][]{Data});
        byte[] result = AKSNativeCryptoService.p1Sign(aliasName.getBytes(), Data);
        result = AKSNativeCryptoService.getResultBytesV2(aliasName, " P1\u7b7e\u540d\u6570\u636e\u957f\u5ea6\u4e3a\uff1a", Data, result);
        return result;
    }

    public static boolean p1Verify(String signedDataB64, String signedCertB64, byte[] Data) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(signedDataB64, signedCertB64);
        Preconditions.validate(new byte[][]{Data});
        byte[] result = AKSNativeCryptoService.p1_Verify(signedDataB64, signedCertB64, Data);
        result = AKSNativeCryptoService.getResultBytes(null, " P1\u9a8c\u7b7e\u6570\u636e\u4e3a\uff1a", signedDataB64 + " " + signedCertB64, result);
        return "0000".equals(new String(result));
    }

    public static int importRootCert(String certB64) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(certB64);
        return AKSNativeCryptoService.addRootCert(certB64);
    }

    public static boolean isSM2Envelope(String evpDataB64) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(evpDataB64);
        return AKSNativeCryptoService.isSM2Evp(evpDataB64);
    }

    public static Map<String, Boolean> antiCheatForSdkJni(String dataString) throws KeyException {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(dataString);
        String[] result = AKSNativeCryptoService.antiCheatForSdk(dataString);
        if (result == null || result.length == 0) {
            throw new KeyException(AksExceptionEnum.AKS_99_00066.getCode(), AksExceptionEnum.AKS_99_00066.getDesc() + "result is null");
        }
        try {
            Long.parseLong(result[0]);
        }
        catch (NumberFormatException e) {
            return null;
        }
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        if (result.length > 2) {
            map.put("isAndroid", !"iOS".equalsIgnoreCase(result[1]));
            for (int i = 2; i < result.length; ++i) {
                String[] splits = result[i].split(":");
                map.put(splits[0], "Y".equalsIgnoreCase(splits[1]));
            }
        }
        return map;
    }

    public static String loginChips(String appid, String address_list, String sysid, int timeoutMs, int family, List<String> keys) {
        AKSNativeCryptoService.checkEnv();
        byte[] result = AKSNativeCryptoService.login(appid, address_list, sysid, timeoutMs, family, keys);
        result = AKSNativeCryptoService.getResultBytes(null, " Hsmsys\u767b\u5f55\u5931\u8d25\uff1a", appid, result);
        String token = new String(result);
        if (token.isEmpty()) {
            keys.clear();
        }
        return token;
    }

    public static void getAndPutKeysByChips(String appid, List<String> keys, List<CertCache> certs) {
        AKSNativeCryptoService.checkEnv();
        byte[] result = AKSNativeCryptoService.getKeys(appid, keys, certs);
        AKSNativeCryptoService.getResultBytes(null, " Chips getAndPutKeys \u5931\u8d25\uff1a", appid, result);
    }

    public static String loginHsmsys(String appid, String address_list, int timeoutMs, List<String> keys) {
        AKSNativeCryptoService.checkEnv();
        byte[] result = AKSNativeCryptoService.loginByHsmsys(appid, address_list, timeoutMs, keys);
        result = AKSNativeCryptoService.getResultBytes(null, " Hsmsys\u767b\u5f55\u5931\u8d25\uff1a", appid, result);
        String token = new String(result);
        if (token.isEmpty()) {
            keys.clear();
        }
        return token;
    }

    public static void getAndPutKeysByHsmsys(String appid, List<String> keys, List<CertCache> certs) {
        AKSNativeCryptoService.checkEnv();
        byte[] result = AKSNativeCryptoService.getKeysByHsmsys(appid, keys, certs);
        AKSNativeCryptoService.getResultBytes(null, " Hsmsys getAndPutKeys \u5931\u8d25\uff1a", appid, result);
    }

    public static AKSCertInfo getCertInfo(String certB64) {
        AKSNativeCryptoService.checkEnv();
        AKSCertInfo certInfo = new AKSCertInfo();
        byte[] value = AKSNativeCryptoService.parseCert(certB64);
        try {
            value = AKSNativeCryptoService.getResultBytes(null, " \u89e3\u6790\u6570\u5b57\u8bc1\u4e66\u5931\u8d25\uff1a", certB64, value);
            certInfo.parseCert(new String(value));
            return certInfo;
        }
        catch (Exception e) {
            LOGGER.warn("\u83b7\u53d6\u8bc1\u4e66\u7684\u4fe1\u606f\u5931\u8d25, cert is {}", (Object)certB64);
            return null;
        }
    }

    public static long initKey(String appid) {
        if (!isLinuxSystem) {
            return 0L;
        }
        return AKSNativeCryptoService.addKey(appid);
    }

    public static byte[] ciphertextIndex(long handle, byte[] in_data, int nSegmentLength) {
        AKSNativeCryptoService.checkEnv();
        byte[] result = AKSNativeCryptoService.encryptIndex(handle, in_data, nSegmentLength);
        result = AKSNativeCryptoService.getResultBytes(null, " ciphertextIndex \u5931\u8d25\uff1a", in_data, result);
        return result;
    }

    public static String ciphertextKeyAlias(String encDataB64) {
        AKSNativeCryptoService.checkEnv();
        Preconditions.validate(encDataB64);
        byte[] encData = DatatypeConverter.parseBase64Binary(encDataB64);
        byte[] result = AKSNativeCryptoService.getKeyAliasFromCiphertext(encData);
        result = AKSNativeCryptoService.getResultBytesV3(result);
        return result == null ? null : new String(result);
    }

    private static byte[] getResultBytesV3(byte[] result) {
        byte[] b;
        int errorCode;
        if (result != null && result.length >= 4 && (errorCode = ByteUtil.byteToInt(b = ByteUtil.copy(result, 0, 4))) == 0) {
            return ByteUtil.copy(result, 4, result.length - 4);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        isJNIInit = false;
        Properties props = System.getProperties();
        String osName = props.getProperty("os.name");
        String arch = props.getProperty("os.arch");
        isLinuxSystem = "Linux".equalsIgnoreCase(osName);
        if (!isLinuxSystem) {
            LOGGER.info("os name is {}", (Object)osName);
            LOGGER.info("os arch is {}", (Object)arch);
        }
        if (isLinuxSystem) {
            String name = "/libCryptoJNI";
            if ("aarch64".equalsIgnoreCase(arch)) {
                name = name + "-arm";
            }
            InputStream in = null;
            FileOutputStream out = null;
            try {
                int i;
                String basePath = AKSNativeCryptoService.getAKSHomeDir();
                String p_name = ManagementFactory.getRuntimeMXBean().getName();
                String pid = p_name.split("@")[0];
                String url = AKSNativeCryptoService.class.getResource(name + ".so").getPath();
                String so_name = String.format("%s%s_%s.so", basePath, name, pid);
                File dll = new File(so_name);
                byte[] buf = new byte[1024];
                LOGGER.info("libCryptoJNI.so path is:{}", (Object)url);
                LOGGER.info("libCryptoJNI.so confing path is:{}", (Object)basePath);
                String log_config_path = basePath + "/";
                File log_conf = new File(basePath, "aks_front_api.conf");
                if (log_conf.exists()) {
                    log_conf.delete();
                }
                String log_config_str = "[global]\nrotate lock file = " + basePath + "/aks_log.lock\n" + "[formats]\n" + "aks_default_fmt = \"%d(%F.%T).%ms [%p-%T]\t%V\t%F\t- (%us) %L\t%m%n\"\n" + "[rules]\n" + "aks_log.* \"" + basePath + "/aks_front_api.log\", 100MB * 5 ~ \"" + basePath + "/aks_front_api.log.#r\"; aks_default_fmt\n";
                FileOutputStream log_config_out = new FileOutputStream(log_conf);
                log_config_out.write(log_config_str.getBytes(), 0, log_config_str.length());
                log_config_out.close();
                log_config_path = basePath + "/log";
                AKSNativeCryptoService.mkdir(log_config_path);
                log_config_path = basePath + "/conf";
                AKSNativeCryptoService.mkdir(log_config_path);
                log_conf = new File(log_config_path, "aksclient.conf");
                if (log_conf.exists()) {
                    log_conf.delete();
                }
                log_config_str = "[aks_client]\nlog_path=" + basePath + "/log\n";
                log_config_out = new FileOutputStream(log_conf);
                log_config_out.write(log_config_str.getBytes(), 0, log_config_str.length());
                log_config_out.close();
                in = AKSNativeCryptoService.class.getResource(name + ".so").openStream();
                out = new FileOutputStream(dll);
                while ((i = in.read(buf)) != -1) {
                    out.write(buf, 0, i);
                }
                dll.deleteOnExit();
                System.load(dll.toString());
                isJNIInit = 0 == AKSNativeCryptoService.init(log_config_path);
                LOGGER.info("JNI\u5e93\u521d\u59cb\u5316\u72b6\u6001 {}", (Object)(isJNIInit ? "\u6210\u529f" : "\u5931\u8d25"));
            }
            catch (Exception e) {
                LOGGER.error(AksExceptionEnum.AKS_99_00013.getDesc(), (Throwable)e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e1) {
                    LOGGER.error(AksExceptionEnum.AKS_99_00007.getDesc(), (Throwable)e1);
                }
            }
        }
    }
}

