/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server.pdf;

import com.itextpdf.text.pdf.PdfDate;
import com.itextpdf.text.pdf.PdfDeveloperExtension;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfSignature;
import com.itextpdf.text.pdf.PdfSignatureAppearance;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.security.CrlClient;
import com.itextpdf.text.pdf.security.DigestAlgorithms;
import com.itextpdf.text.pdf.security.ExternalDigest;
import com.itextpdf.text.pdf.security.MakeSignature;
import com.itextpdf.text.pdf.security.OcspClient;
import com.itextpdf.text.pdf.security.PdfPKCS7;
import com.itextpdf.text.pdf.security.TSAClient;
import com.wangyin.key.server.jni.AKSNativeCryptoService;
import com.wangyin.key.server.model.DigestAlgEnum;
import com.wangyin.key.server.util.AKSConstant;
import com.wangyin.key.server.util.ByteUtil;
import com.wangyin.key.server.util.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;

public class CAMakeSignature {
    public static void signDetached(String aliasName, PdfSignatureAppearance sap, ExternalDigest externalDigest, Certificate[] chain, Collection<CrlClient> crlList, OcspClient ocspClient, TSAClient tsaClient, int estimatedSize, MakeSignature.CryptoStandard sigtype) throws Exception {
        Collection crlBytes = null;
        int i = 0;
        while (crlBytes == null && i < chain.length) {
            crlBytes = MakeSignature.processCrl((Certificate)chain[i++], crlList);
        }
        if (estimatedSize == 0) {
            estimatedSize = 8192;
            if (crlBytes != null) {
                for (byte[] element : crlBytes) {
                    estimatedSize += element.length + 10;
                }
            }
            if (ocspClient != null) {
                estimatedSize += 4192;
            }
            if (tsaClient != null) {
                estimatedSize += 4192;
            }
        }
        sap.setCertificate(chain[0]);
        if (sigtype == MakeSignature.CryptoStandard.CADES) {
            sap.addDeveloperExtension(PdfDeveloperExtension.ESIC_1_7_EXTENSIONLEVEL2);
        }
        PdfSignature dic = new PdfSignature(PdfName.ADOBE_PPKLITE, sigtype == MakeSignature.CryptoStandard.CADES ? PdfName.ETSI_CADES_DETACHED : PdfName.ADBE_PKCS7_DETACHED);
        dic.setReason(sap.getReason());
        dic.setLocation(sap.getLocation());
        dic.setSignatureCreator(sap.getSignatureCreator());
        dic.setContact(sap.getContact());
        dic.setDate(new PdfDate(sap.getSignDate()));
        sap.setCryptoDictionary((PdfDictionary)dic);
        HashMap<PdfName, Integer> exc = new HashMap<PdfName, Integer>();
        exc.put(PdfName.CONTENTS, estimatedSize * 2 + 2);
        sap.preClose(exc);
        String hashAlgorithm = "SHA1";
        PdfPKCS7 sgn = new PdfPKCS7(null, chain, hashAlgorithm, null, externalDigest, false);
        InputStream data = sap.getRangeStream();
        byte[] hash = DigestAlgorithms.digest((InputStream)data, (MessageDigest)externalDigest.getMessageDigest(hashAlgorithm));
        byte[] ocsp = null;
        if (chain.length >= 2 && ocspClient != null) {
            ocsp = ocspClient.getEncoded((X509Certificate)chain[0], (X509Certificate)chain[1], null);
        }
        byte[] sh = sgn.getAuthenticatedAttributeBytes(hash, ocsp, crlBytes, sigtype);
        byte[] extSignature = CAMakeSignature.getExtSignature(aliasName, sh);
        sgn.setExternalDigest(extSignature, null, chain[0].getPublicKey().getAlgorithm());
        byte[] encodedSig = sgn.getEncodedPKCS7(hash, tsaClient, ocsp, crlBytes, sigtype);
        System.out.println("encodedSig len is " + encodedSig.length + " data is " + DatatypeConverter.printBase64Binary(encodedSig));
        if (estimatedSize < encodedSig.length) {
            throw new IOException("Not enough space");
        }
        byte[] paddedSig = new byte[estimatedSize];
        System.arraycopy(encodedSig, 0, paddedSig, 0, encodedSig.length);
        PdfDictionary dic2 = new PdfDictionary();
        dic2.put(PdfName.CONTENTS, (PdfObject)new PdfString(paddedSig).setHexWriting(true));
        sap.close(dic2);
    }

    private static byte[] getExtSignature(String aliasName, byte[] srcData) throws Exception {
        MessageDigest md = MessageDigest.getInstance(DigestAlgEnum.ALG_SHA1.getCode());
        byte[] shaData = md.digest(srcData);
        byte[] data = ByteUtil.joinBytes(AKSConstant.HASH_PREFIX_SHA1, shaData);
        data = AKSNativeCryptoService.privateKeyEncrypt(aliasName, data);
        return data;
    }
}

