/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class JSON {
    private static final Gson gson = new GsonBuilder().registerTypeAdapterFactory(JSONObjectTypeAdapter.FACTORY).create();

    public static <T> T parseObject(String src, Type type) {
        return (T)gson.fromJson(src, type);
    }

    public static <T> T parseObject(String src, Class<T> clazz) {
        return (T)gson.fromJson(src, clazz);
    }

    public static String toJSONString(Object obj) {
        return gson.toJson(obj);
    }

    public static String json(Object obj) {
        return gson.toJson(obj);
    }

    public static Object parse(String src) {
        return gson.fromJson(src, JSONObject.class);
    }

    public static final class JSONObjectTypeAdapter
    extends TypeAdapter<Object> {
        private static final Pattern numbers = Pattern.compile("\\d+");
        public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
                return type.getRawType() == JSONObject.class ? new JSONObjectTypeAdapter(gson) : null;
            }
        };
        private final Gson gson;

        JSONObjectTypeAdapter(Gson gson) {
            this.gson = gson;
        }

        public void write(JsonWriter out, Object value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                TypeAdapter typeAdapter = this.gson.getAdapter(value.getClass());
                if (typeAdapter instanceof JSONObjectTypeAdapter) {
                    TypeAdapter mapAdapter = this.gson.getAdapter(Map.class);
                    mapAdapter.write(out, value);
                } else {
                    typeAdapter.write(out, value);
                }
            }
        }

        public Object read(JsonReader in) throws IOException {
            JsonToken token = in.peek();
            switch (token) {
                case BEGIN_ARRAY: {
                    ArrayList<Object> list = new ArrayList<Object>();
                    in.beginArray();
                    while (in.hasNext()) {
                        list.add(this.read(in));
                    }
                    in.endArray();
                    return list;
                }
                case BEGIN_OBJECT: {
                    JSONObject map = new JSONObject();
                    in.beginObject();
                    while (in.hasNext()) {
                        map.put(in.nextName(), this.read(in));
                    }
                    in.endObject();
                    return map;
                }
                case STRING: {
                    return in.nextString();
                }
                case NUMBER: {
                    String sNum = in.nextString();
                    try {
                        return Integer.parseInt(sNum);
                    }
                    catch (NumberFormatException e1) {
                        try {
                            return Long.parseLong(sNum);
                        }
                        catch (NumberFormatException e2) {
                            if (numbers.matcher(sNum).matches()) {
                                return sNum;
                            }
                            return Double.parseDouble(sNum);
                        }
                    }
                }
                case BOOLEAN: {
                    return in.nextBoolean();
                }
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            throw new IllegalStateException();
        }
    }

    public static class JSONArray
    extends ArrayList<Object> {
    }

    public static class JSONObject
    extends HashMap<String, Object> {
        public String getString(String key) {
            Object tmp = this.get(key);
            return tmp == null ? null : tmp.toString();
        }
    }
}

