package com.cnooc.expert.controller.workflow.model.response;

import lombok.Builder;
import lombok.Data;

import java.util.List;

@Data
@Builder
public class InstCalculateResp {

    // 是否需要审批
    private Boolean needApprove;

    // 符合条件的流程定义列表
    private List<ApproveSettingVO> approveSettingVOList;

    // 是否跳过大采购原有提交流程
    private Boolean ifJumpProcess;

    // 当前业务是否已经配置了审批流程
    private Boolean ifApprovePathSetting;

    @Data
    @Builder
    public static class ApproveSettingVO {

        // id
        private String id;

        // 租户id
        private String tenantId;

        // 主体id
        private String subjectId;

        // 业务类型编码
        private String businessTypeCode;

        // 审批定义id
        private String procDefId;

        // 审批定义名称
        private String procDefName;

        // 是否需要审批
        private Boolean needApprove;

        // 匹配优先级
        private Integer priority;

        // 是否向上审批
        private Boolean needUpApproval;

        // 发起人是否可选无需向上审批
        private Boolean sponsorCanChooseUpApproval;

        // 配置来源
        private Integer engineType;
    }

}
