package com.cnooc.expert.external.expert.service;

import com.cnooc.expert.external.common.AbstractRetrofitManager;
import com.cnooc.expert.external.expert.api.LoginServiceApi;
import com.cnooc.expert.external.expert.model.request.ExpertInfoAppReq;
import com.cnooc.expert.external.expert.model.request.ExpertInfoReq;
import com.cnooc.expert.external.expert.model.response.ExpertInfoAppResp;
import com.cnooc.expert.external.expert.model.response.ExpertInfoResp;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import retrofit2.Call;
import retrofit2.Retrofit;

import java.util.Map;

@Service
public class LoginServicesClient  extends AbstractRetrofitManager {

    private final LoginServiceApi loginServiceApi;

    public LoginServicesClient(@Qualifier("retrofitExpert") Retrofit retrofit) {
        this.loginServiceApi = retrofit.create(LoginServiceApi.class);
    }

    public ExpertInfoResp querySingleByShengFenZhengOrMobile(String mobile,String shenfenzheng){
        Map<String, Object> headers = Maps.newHashMap();
        ExpertInfoReq expertInfoReq = new ExpertInfoReq();
        expertInfoReq.setMobile(mobile);
        expertInfoReq.setShengfenzheng(shenfenzheng);
        Call<ExpertInfoResp> call = loginServiceApi.querySingleByShengFenZhengOrMobile(headers,expertInfoReq);
        return this.getResponseBody(call, "querySingleByShengFenZhengOrMobile");
     /*   String jsonString = JsonUtils.toJsonString(zhuanJiaInfoVo);
        res = RestUtils.sendPostRequest2Expert("/zjfw/zggrxxgl/querySingleByShengFenZhengOrMobile",jsonString,null);
    */
    }
    public ExpertInfoAppResp getZhuanJiaInfoAppById(String baseGuid){
        ExpertInfoAppReq expertInfoAppReq = new ExpertInfoAppReq();
        Map<String, Object> headers = Maps.newHashMap();
        expertInfoAppReq.setBaseGuid(baseGuid);
        Call<ExpertInfoAppResp> call = loginServiceApi.getZhuanJiaInfoAppById(headers,expertInfoAppReq);
        return this.getResponseBody(call, "getZhuanJiaInfoAppById");
/*        String jsonString = JsonUtils.toJsonString(zhuanJiaInfoAppVo);
        res = RestUtils.sendPostRequest2Expert("/zjfw/zggrxxgl/getZhuanJiaInfoAppById",jsonString,null);*/
    }
    public ExpertInfoAppResp saveZhuanJiaInfoApp(String baseGuid,String password){
        ExpertInfoAppReq expertInfoAppReq = new ExpertInfoAppReq();
        Map<String, Object> headers = Maps.newHashMap();
        expertInfoAppReq.setBaseGuid(baseGuid);
        expertInfoAppReq.setPassword(password);
        Call<ExpertInfoAppResp> call = loginServiceApi.saveZhuanJiaInfoApp(headers,expertInfoAppReq);
        return this.getResponseBody(call, "saveZhuanJiaInfoApp");
/*        String jsonString = JsonUtils.toJsonString(zhuanJiaInfoAppVo);
        res = RestUtils.sendPostRequest2Expert("/zjfw/zggrxxgl/saveZhuanJiaInfoApp",jsonString,null);*/
    }
    public ExpertInfoAppResp updateZhuanJiaInfoApp(String baseGuid,String password){
        ExpertInfoAppReq expertInfoAppReq = new ExpertInfoAppReq();
        Map<String, Object> headers = Maps.newHashMap();
        expertInfoAppReq.setBaseGuid(baseGuid);
        expertInfoAppReq.setPassword(password);
        Call<ExpertInfoAppResp> call = loginServiceApi.updateZhuanJiaInfoApp(headers,expertInfoAppReq);
        return this.getResponseBody(call, "updateZhuanJiaInfoApp");
/*        String jsonString = JsonUtils.toJsonString(zhuanJiaInfoAppVo);
        res = RestUtils.sendPostRequest2Expert("/zjfw/zggrxxgl/updateZhuanJiaInfoApp",jsonString,null);*/
    }
}
