/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server.pdf;

import com.wangyin.key.server.exception.AksExceptionEnum;
import com.wangyin.key.server.exception.KeyException;
import com.wangyin.key.server.pdf.SignerKeystore;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignerKeystorePKCS12
implements SignerKeystore {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignerKeystorePKCS12.class);
    private static Provider provider;
    private KeyStore keystore;
    private String alias;
    private PrivateKey privateKey;
    private Certificate[] chain;
    private long expiredDate;

    private SignerKeystorePKCS12(byte[] pfxBytes, String pfxPwd) {
        try {
            if (provider == null) {
                provider = new BouncyCastleProvider();
                Security.addProvider(provider);
            }
            this.keystore = KeyStore.getInstance("pkcs12", provider);
            ByteArrayInputStream pfxIn = new ByteArrayInputStream(pfxBytes);
            this.keystore.load(pfxIn, pfxPwd.toCharArray());
            this.alias = this.keystore.aliases().nextElement();
            this.privateKey = (PrivateKey)this.keystore.getKey(this.alias, pfxPwd.toCharArray());
            this.chain = this.keystore.getCertificateChain(this.alias);
            X509Certificate cert = (X509Certificate)this.keystore.getCertificate(this.alias);
            this.expiredDate = cert.getNotAfter().getTime();
        }
        catch (Exception e) {
            LOGGER.error("SignerKeystorePKCS12() error.", (Throwable)e);
            throw new KeyException(AksExceptionEnum.AKS_99_00038.getCode(), AksExceptionEnum.AKS_99_00038.getDesc());
        }
    }

    public static SignerKeystore getInstance(byte[] pfxBytes, String pfxPwd) {
        return new SignerKeystorePKCS12(pfxBytes, pfxPwd);
    }

    @Override
    public Certificate[] getChain() {
        return this.chain;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public Provider getProvider() {
        return this.keystore.getProvider();
    }

    @Override
    public long getExpireDate() {
        return this.expiredDate;
    }

    @Override
    public boolean isExpired() {
        int compare = new Date().compareTo(new Date(this.expiredDate));
        return compare > 0;
    }
}

