/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server.thread;

import com.wangyin.key.server.IBaseCryptoService;
import com.wangyin.key.server.exception.AuthException;
import com.wangyin.key.server.jni.AKSNativeCryptoService;
import com.wangyin.key.server.model.Cache;
import com.wangyin.key.server.model.Key;
import com.wangyin.key.server.util.DateUtil;
import com.wangyin.key.server.util.StatusUtil;
import com.wangyin.key.server.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelExecutor.class);
    private Map<String, Thread> doLoginStatusThreadMap = new ConcurrentHashMap<String, Thread>();
    private Map<String, Thread> doOfflineStatusThreadMap = new ConcurrentHashMap<String, Thread>();

    private ChannelExecutor() {
    }

    public static ChannelExecutor getExecutor() {
        return SingletonHolder.instance;
    }

    public static boolean aks_sleep(String appId, long millis) {
        boolean isStop = false;
        try {
            long count = millis / 100L == 0L ? 1L : millis / 100L;
            long my_millis = millis / 100L == 0L ? millis : 100L;
            for (long i = 0L; i < count; ++i) {
                if (StatusUtil.getInstance().isLogout(appId)) {
                    isStop = true;
                    break;
                }
                Thread.sleep(my_millis);
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("The Thread.sleep has error!.", (Throwable)e);
        }
        return isStop;
    }

    public void startStatusMonitor(String appId, Cache cache, IBaseCryptoService cryptoDisService, String token_keyAlias, int intervaltime) {
        if (!this.check(appId, cache)) {
            return;
        }
        this.doLoginStatus(appId, cache, cryptoDisService);
        this.doOfflineStatus(appId, cache, cryptoDisService, token_keyAlias, intervaltime);
    }

    public void stopStatusMonitor(String appId) {
        StatusUtil.getInstance().setLogout(appId, true);
        try {
            Thread doLoginStatusThread;
            Thread doOfflineStatusThread = this.doOfflineStatusThreadMap.get(appId);
            if (doOfflineStatusThread != null) {
                doOfflineStatusThread.join();
            }
            if ((doLoginStatusThread = this.doLoginStatusThreadMap.get(appId)) != null) {
                doLoginStatusThread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean check(String appId, Cache cache) {
        if (cache.getToken() == null || "".equals(cache.getToken())) {
            LOGGER.error("token is null or empty,so can not do business.");
            return false;
        }
        if (appId == null || "".equals(appId)) {
            LOGGER.error("appId is null or empty,so can not do business.");
            return false;
        }
        if (!cache.getStatus()) {
            LOGGER.error("status is false,so can not do business.");
            return false;
        }
        return true;
    }

    private void doOfflineStatus(String appId, Cache cache, IBaseCryptoService cryptoDisService, String token_keyAlias, int intervaltime) {
        AcquireTask task = new AcquireTask(appId, cache, cryptoDisService, token_keyAlias, intervaltime);
        Thread thread = new Thread(task);
        thread.start();
        this.doOfflineStatusThreadMap.put(appId, thread);
    }

    private void doLoginStatus(String appId, Cache cache, IBaseCryptoService cryptoDisService) {
        UpdateTask task = new UpdateTask(appId, cache, cryptoDisService);
        Thread thread = new Thread(task);
        thread.start();
        this.doLoginStatusThreadMap.put(appId, thread);
    }

    private static class UpdateTask
    implements Runnable {
        private IBaseCryptoService cryptoDisService;
        private String token;
        private String status;
        private String appId;

        public UpdateTask(String appId, Cache cache, IBaseCryptoService cryptoDisService) {
            this.token = cache.getToken();
            this.status = cache.getStatus() ? "Y" : "N";
            this.cryptoDisService = cryptoDisService;
            this.appId = appId;
        }

        @Override
        public void run() {
            try {
                this.cryptoDisService.sendStatus(this.token, this.status + "|" + StringUtil.getPid() + "|" + StatusUtil.getApiVersion() + "|" + this.appId);
            }
            catch (Exception e) {
                LOGGER.info("UpdateTask error! {}", (Object)e.getMessage());
            }
        }
    }

    private static class AcquireTask
    implements Runnable {
        private IBaseCryptoService cryptoDisService;
        private String appId;
        private String token;
        private String token_keyAlias;
        private int intervaltime;

        public AcquireTask(String appId, Cache cache, IBaseCryptoService cryptoDisService, String token_keyAlias, int intervaltime) {
            this.cryptoDisService = cryptoDisService;
            this.appId = appId;
            this.token = cache.getToken();
            this.token_keyAlias = token_keyAlias;
            this.intervaltime = intervaltime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean isFirst = true;
            boolean isGetRootCert = false;
            int currentSleep = this.intervaltime;
            int offlineInterval = 1800;
            while (true) {
                try {
                    String policy = this.cryptoDisService.getServerPolicy(this.appId, this.token);
                    currentSleep = this.intervaltime;
                    if (policy != null && !"".equals(policy)) {
                        String[] policies = policy.split("\\|");
                        try {
                            offlineInterval = Integer.parseInt(policies[0]);
                        }
                        catch (Exception e) {
                            LOGGER.debug("\u7cfb\u7edf\u670d\u52a1\u5668\u4e0b\u53d1\u7b56\u7565offlineInterval:" + policy);
                            offlineInterval = 1800;
                        }
                        try {
                            boolean monitorSwitch = "Y".equalsIgnoreCase(policies[1]);
                            StatusUtil.getInstance().setMonitor(this.appId, monitorSwitch);
                        }
                        catch (Exception e) {
                            LOGGER.debug("\u7cfb\u7edf\u670d\u52a1\u5668\u4e0b\u53d1\u7b56\u7565monitorSwitch:" + policy);
                        }
                    }
                    if (!StatusUtil.getInstance().isInitiative(this.appId)) {
                        long lastTime = StatusUtil.getInstance().getLastTime(this.appId).getTime();
                        long now = new Date().getTime();
                        if (now - lastTime < (long)(offlineInterval * 1000)) continue;
                    }
                    String status = this.cryptoDisService.getOfflineStatus(this.appId, this.token);
                    boolean boolOfflineStatus = "Y".equalsIgnoreCase(status);
                    if (!isFirst && boolOfflineStatus && StatusUtil.getInstance().isOnLine(this.appId)) {
                        LOGGER.info("\u7cfb\u7edf\u8bbe\u7f6e\u5e94\u7528\u4e3aoffline\u6a21\u5f0f");
                    }
                    if (!(isFirst || boolOfflineStatus || StatusUtil.getInstance().isOnLine(this.appId))) {
                        LOGGER.info("\u7cfb\u7edf\u6062\u590d\u5e94\u7528\u4e3aonline\u6a21\u5f0f");
                    }
                    LOGGER.debug("\u4e3b\u52a8\u8bbe\u7f6e\u79bb\u7ebf\u72b6\u6001\uff1a" + boolOfflineStatus);
                    StatusUtil.getInstance().setStatusInitiative(this.appId, boolOfflineStatus);
                    if (!AKSNativeCryptoService.isLinuxSystem) continue;
                    if (!isFirst) {
                        List<Key> list = this.cryptoDisService.getAuthorizedKeys(this.token, this.appId);
                        ArrayList keys = new ArrayList();
                        for (Key key : list) {
                            int code = AKSNativeCryptoService.setKey(this.token, key.getAlias(), key.getValue());
                            if (code != 0) continue;
                            LOGGER.info("{} put key ok", (Object)key.getAlias());
                        }
                    }
                    boolean isUpdate = false;
                    String hour = DateUtil.getCurrentHour();
                    if (!"03".equals(hour)) {
                        isGetRootCert = false;
                    } else if (!isGetRootCert) {
                        isUpdate = true;
                    }
                    if (isFirst || isUpdate) {
                        try {
                            List<String> rootCerts = this.cryptoDisService.getRootCert(this.token, this.appId);
                            if (rootCerts != null && rootCerts.size() > 0) {
                                for (String rootCert : rootCerts) {
                                    AKSNativeCryptoService.importRootCert(rootCert);
                                }
                            }
                            LOGGER.info("\u66f4\u65b0\u8bbe\u7f6e\u6839\u8bc1\u4e66\u5b8c\u6210 @{}", (Object)DateUtil.getCurrentDateTime());
                            isGetRootCert = true;
                        }
                        catch (Exception e) {
                            LOGGER.info("getRootCert error! {}", (Object)e.getMessage());
                        }
                    }
                    isFirst = false;
                    continue;
                }
                catch (AuthException ae) {
                    if (!"AKS9914008".equalsIgnoreCase(ae.getCode())) continue;
                }
                catch (Throwable t) {
                    if (t.getClass().getName().endsWith("RpcException")) {
                        StatusUtil.getInstance().setStatusIsOffline(this.appId, true);
                        LOGGER.warn("Rpc connection timeout! turn to offLineCrypto.");
                        continue;
                    }
                    LOGGER.warn("Heartbeat has error.{}", (Object)t.getMessage());
                    continue;
                }
                finally {
                    if (ChannelExecutor.aks_sleep(this.appId, currentSleep * 1000) || (currentSleep *= 2) <= offlineInterval) continue;
                    currentSleep = offlineInterval;
                    continue;
                }
                break;
            }
        }
    }

    private static class SingletonHolder {
        public static final ChannelExecutor instance = new ChannelExecutor();

        private SingletonHolder() {
        }
    }
}

