package com.cnooc.expert.config;

import com.cnooc.expert.common.interceptor.WebAuthInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class TheWebMvcConfigurer implements WebMvcConfigurer {

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(webAuthInterceptor());
    }

    @Bean
    public WebAuthInterceptor webAuthInterceptor() {
        return new WebAuthInterceptor();
    }

}
