package com.cnooc.expert.service;

import com.cnooc.expert.external.expert.service.ExpertService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

@AllArgsConstructor
@Service
public class PersonService {

    private ObjectMapper objectMapper;

    private final ExpertService expertService;

    public String getExpertDetail(int id) throws JsonProcessingException {

        return objectMapper.writeValueAsString(expertService.getExpertInfo(id));
    }
}
