package com.cnooc.expert.external.file.model.request;

import lombok.Builder;
import lombok.Data;

@Data
@Builder
public class GeneratorUploadInfoApiReq {

    /**
     * 此次文件的id，为空则重新生成前缀。不为空，则获取id的路径作为前缀。
     */
    // 路径id
    private Long pathId;

    /**
     * 最大有效时间
     */
    // 路径有效时间，默认30分钟
    private Integer maxValidTimeMinute;

    /**
     * 文件类型
     * 分为：1:标书文件类型、2:普通文件类型、3：富文本文件类型
     */
    // 文件类型。1:标书文件类型、2:普通文件类型、3：富文本文件类型
    private Integer fileType;
    
}
