/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server;

import com.google.gson.JsonSyntaxException;
import com.wangyin.key.server.CryptoServiceBase;
import com.wangyin.key.server.exception.AksExceptionEnum;
import com.wangyin.key.server.exception.AuthException;
import com.wangyin.key.server.exception.KeyException;
import com.wangyin.key.server.hsm.ChipsDataHandler;
import com.wangyin.key.server.hsm.HsmDataHandler;
import com.wangyin.key.server.hsm.IDataHandler;
import com.wangyin.key.server.jni.AKSNativeCryptoService;
import com.wangyin.key.server.model.AksRet;
import com.wangyin.key.server.model.AlgEnum;
import com.wangyin.key.server.model.Cache;
import com.wangyin.key.server.model.CertCache;
import com.wangyin.key.server.model.CipherOptEnum;
import com.wangyin.key.server.model.DigestAlgEnum;
import com.wangyin.key.server.model.EncryptPWResponse;
import com.wangyin.key.server.model.Key;
import com.wangyin.key.server.model.ModeEnum;
import com.wangyin.key.server.model.PaddingEnum;
import com.wangyin.key.server.model.PayCode;
import com.wangyin.key.server.model.PayCodeEnum;
import com.wangyin.key.server.model.PayCodeTypeEnum;
import com.wangyin.key.server.model.Paymark;
import com.wangyin.key.server.model.RadixEnum;
import com.wangyin.key.server.model.SecureChannel;
import com.wangyin.key.server.model.Session;
import com.wangyin.key.server.model.SignPdfResponse;
import com.wangyin.key.server.model.Status;
import com.wangyin.key.server.monitor2.MonitorMessage;
import com.wangyin.key.server.pdf.FileTypeVerify;
import com.wangyin.key.server.pdf.PDFSigner;
import com.wangyin.key.server.thread.ChannelExecutor;
import com.wangyin.key.server.thread.CipherExecutorService;
import com.wangyin.key.server.util.AKSCertInfo;
import com.wangyin.key.server.util.AKSConstant;
import com.wangyin.key.server.util.AKSP7Object;
import com.wangyin.key.server.util.BCConvert;
import com.wangyin.key.server.util.ByteUtil;
import com.wangyin.key.server.util.CacheUtil;
import com.wangyin.key.server.util.CryptUtil;
import com.wangyin.key.server.util.DatatypeConverter;
import com.wangyin.key.server.util.EncryptUtil;
import com.wangyin.key.server.util.JSON;
import com.wangyin.key.server.util.KeyboardHelper;
import com.wangyin.key.server.util.PKIHelper;
import com.wangyin.key.server.util.Preconditions;
import com.wangyin.key.server.util.StatusUtil;
import com.wangyin.key.server.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceCryptoService
extends CryptoServiceBase {
    private static final String MY_NAME = "com.wangyin.key.server.DeviceCryptoService";
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceCryptoService.class);
    private final Set<String> aliasNameSet = new HashSet<String>();
    private final ExecutorService reportPool = new ThreadPoolExecutor(4, 4, 60L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(2048), Executors.defaultThreadFactory(), new ThreadPoolExecutor.DiscardPolicy());

    private boolean isRpcException(Throwable t) {
        for (Class<?> clazz = t.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (!clazz.getName().endsWith("RpcException")) continue;
            return true;
        }
        return false;
    }

    public Boolean init() {
        long startTime = System.nanoTime();
        ArrayList<CertCache> certs = new ArrayList<CertCache>();
        Session session = new Session();
        String offlineInit = "";
        if (this.cryptoDisService == null) {
            LOGGER.error("AKS init error... cryptoDisService is null ");
            this.initSuccess = false;
            if (!this.ignoreInitError) {
                throw new AuthException(AksExceptionEnum.AKS_99_99981.getCode(), AksExceptionEnum.AKS_99_99981.getDesc());
            }
        } else {
            block20: {
                try {
                    this.readProps();
                    session = this.cryptoDisService.init(this.appID + "|" + StringUtil.getPid() + "|" + StatusUtil.getApiVersion(), "");
                    String token = session.getToken();
                    this.token_keyAlias = this.createTokenKeyAlias(token);
                    this.getAndPutKeys(token, certs);
                }
                catch (AuthException auth) {
                    if (AKSConstant.errorcodes.contains(auth.getCode()) || AKSConstant.authCodes.contains(auth.getCode())) {
                        offlineInit = this.initOffline(session, certs, " AuthException: " + auth.getMessage());
                    } else {
                        this.initSuccess = false;
                        if (!this.ignoreInitError) {
                            throw new AuthException(AksExceptionEnum.AKS_99_00005.getCode(), AksExceptionEnum.AKS_99_00005.getDesc() + " ERROR: " + auth.getMessage());
                        }
                    }
                }
                catch (KeyException key) {
                    if (AKSConstant.errorcodes.contains(key.getCode()) || AKSConstant.authCodes.contains(key.getCode())) {
                        offlineInit = this.initOffline(session, certs, " KeyException: " + key.getMessage());
                    } else {
                        this.initSuccess = false;
                        if (!this.ignoreInitError) {
                            throw new AuthException(AksExceptionEnum.AKS_99_00005.getCode(), AksExceptionEnum.AKS_99_00005.getDesc() + " ERROR: " + key.getMessage());
                        }
                    }
                }
                catch (Throwable t) {
                    if (this.isRpcException(t)) {
                        offlineInit = this.initOffline(session, certs, "RpcException: " + t.getMessage());
                    }
                    LOGGER.error("AKS init error... Throwable: " + t, t);
                    this.initSuccess = false;
                    if (this.ignoreInitError) break block20;
                    throw new AuthException(AksExceptionEnum.AKS_99_00005.getCode(), AksExceptionEnum.AKS_99_00005.getDesc() + " ERROR: " + t);
                }
            }
            if (!"".equals(offlineInit)) {
                LOGGER.error("AKS init error... : {}", (Object)offlineInit);
                this.initSuccess = false;
                if (!this.ignoreInitError) {
                    throw new AuthException(AksExceptionEnum.AKS_99_00005.getCode(), AksExceptionEnum.AKS_99_00005.getDesc() + " ERROR: " + offlineInit);
                }
            }
            if (this.initSuccess) {
                this.checkKeys();
                if (this.initSuccess) {
                    Cache cache = new Cache();
                    cache.setCerts(certs);
                    cache.setServerVersion(session.getServerVersion());
                    cache.setApiVersion(StatusUtil.getApiVersion());
                    cache.setToken(session.getToken());
                    cache.setStatus(cache.isAuthPermission());
                    CacheUtil.getInstance().setCache(this.appID, cache);
                    boolean boolOfflineStatus = "Y".equalsIgnoreCase(session.getOfflineStatus());
                    if (boolOfflineStatus) {
                        LOGGER.info("AKS in offline mode.");
                    }
                    Status status = new Status();
                    status.setLastTime(new Date());
                    status.setOffLine(boolOfflineStatus);
                    status.setInitiative(true);
                    StatusUtil.getInstance().setStatus(this.appID, status);
                    long handle = AKSNativeCryptoService.initKey(this.appID);
                    this.indexHandle.put(this.appID, handle);
                    if (this.heartbeatInterval != 118 && this.heartbeatInterval != Integer.MAX_VALUE) {
                        ChannelExecutor.getExecutor().startStatusMonitor(this.appID, cache, this.cryptoDisService, this.token_keyAlias, this.heartbeatInterval);
                    }
                }
            }
        }
        long endTime = System.nanoTime();
        LOGGER.info("AKS init {} total time: {} \u5fae\u79d2", (Object)(this.initSuccess ? "success" : "fail"), (Object)((endTime - startTime) / 1000L));
        return this.initSuccess;
    }

    private void checkKeys() {
        if (this.aliasNames != null && !"".equals(this.aliasNames)) {
            StringBuilder sb = new StringBuilder();
            for (String alias : this.aliasNames.split("\\|")) {
                if (this.aliasNameSet.contains(alias)) continue;
                sb.append("|").append(alias);
            }
            if (sb.length() != 0) {
                LOGGER.error("AKS init error... checkKeys failure. errorAlias: {}", (Object)sb.substring(1));
                this.initSuccess = false;
                if (!this.ignoreInitError) {
                    throw new AuthException(AksExceptionEnum.AKS_99_00077.getCode(), AksExceptionEnum.AKS_99_00077.getDesc() + " ERROR: Check keys failure some alias not found, errorAlias: " + sb.substring(1));
                }
            }
        }
    }

    private String initOffline(Session session, List<CertCache> certs, String msg) {
        LOGGER.warn("AKS\u5f00\u59cb\u79bb\u7ebf\u521d\u59cb\u5316 ... appID: {}, token: {}, {}", new Object[]{this.appID, session.getToken(), msg});
        boolean result = false;
        StringBuilder resultMsg = new StringBuilder(msg + " \u4e14\u79bb\u7ebf\u521d\u59cb\u5316\u9519\u8bef\uff1a");
        try {
            IDataHandler dataHandler = "hsmsys".equals(this.initType) ? new HsmDataHandler(this.hsmZkAddress, this.hsmTimeout, this.appID) : new ChipsDataHandler(this.chipsZkAddress, this.chipsTimeout, this.appID, this.chipsSysId, this.chipsFamily);
            dataHandler.initSession(session);
            ArrayList<String> aliasList = new ArrayList<String>();
            for (int i = 0; i < session.getAliases().size(); ++i) {
                try {
                    this.aliasNameSet.add(session.getAliases().get(i).getAlias().split("-")[0]);
                }
                catch (RuntimeException e) {
                    LOGGER.warn("WARNING: Unexpected aliasName type: " + session.getAliases().get(i).getAlias(), (Throwable)e);
                    this.aliasNameSet.add(session.getAliases().get(i).getAlias());
                }
                aliasList.add(session.getAliases().get(i).getAlias());
            }
            dataHandler.getKeysR6(session, aliasList, certs);
            result = true;
        }
        catch (Exception e) {
            LOGGER.error("initOffline error. Exception: {}", (Object)e.getMessage());
            resultMsg.append(" : ").append(e.getMessage());
        }
        if (result) {
            return "";
        }
        return resultMsg.toString();
    }

    private void getAndPutKeys(String token, List<CertCache> certs) {
        String tokenAndVersion = token + "|" + StatusUtil.getApiVersion();
        List<Key> keys = this.cryptoDisService.getAuthorizedKeys(tokenAndVersion, this.appID);
        if (keys != null && keys.size() > 0) {
            AKSNativeCryptoService.put_token(this.token_keyAlias, token);
            for (Key k : keys) {
                k.setToken(token);
                try {
                    AlgEnum algEnum = CryptUtil.getAlgByAliasName(k.getAlias());
                    if (AlgEnum.ALG_3DES == algEnum || AlgEnum.ALG_AES == algEnum || AlgEnum.ALG_AES192 == algEnum || AlgEnum.ALG_AES256 == algEnum || AlgEnum.ALG_SM4 == algEnum || AlgEnum.ALG_RSA1024 == algEnum || AlgEnum.ALG_RSA2048 == algEnum || AlgEnum.ALG_SM2 == algEnum) {
                        try {
                            this.aliasNameSet.add(k.getAlias().split("-")[0]);
                        }
                        catch (RuntimeException e) {
                            LOGGER.warn("WARNING: Unexpected aliasName type: " + k.getAlias(), (Throwable)e);
                            this.aliasNameSet.add(k.getAlias());
                        }
                        int code = AKSNativeCryptoService.setKey(k.getToken(), k.getAlias(), k.getValue());
                        if (code == 0) {
                            LOGGER.info("{} put key ok", (Object)k.getAlias());
                        }
                    }
                    if (AlgEnum.ALG_RSA1024 != algEnum && AlgEnum.ALG_RSA2048 != algEnum && AlgEnum.ALG_SM2 != algEnum) continue;
                    try {
                        String cert = this.cryptoDisService.exportCert(tokenAndVersion, this.appID, k.getAlias());
                        certs.add(new CertCache(k.getAlias(), cert));
                    }
                    catch (Exception e) {
                        LOGGER.warn("{}\u8bc1\u4e66\u83b7\u53d6\u65f6\u5931\u8d25\u3002 Exception:{}", (Object)k.getAlias(), (Object)e.getMessage());
                    }
                }
                catch (KeyException e) {
                    if (AksExceptionEnum.AKS_99_00008.getCode().equals(e.getCode())) continue;
                    throw e;
                }
            }
        } else {
            LOGGER.warn("\u83b7\u53d6\u5bc6\u94a5\u5217\u8868\u4e3a\u7a7a\uff0cappId:{}", (Object)this.appID);
        }
        if (AKSNativeCryptoService.isLinuxSystem) {
            try {
                List<String> rootCerts = this.cryptoDisService.getRootCert(token, this.appID);
                if (rootCerts != null && rootCerts.size() > 0) {
                    for (String rootCert : rootCerts) {
                        AKSNativeCryptoService.importRootCert(rootCert);
                    }
                }
            }
            catch (KeyException e) {
                LOGGER.warn("\u66f4\u65b0\u8bbe\u7f6e\u6839\u8bc1\u4e66\u65f6\u5931\u8d25\u3002 Exception: {}", (Object)e.getMessage());
            }
        }
    }

    private void checkPermission() throws KeyException {
        if (!CacheUtil.getInstance().getStatus(this.appID)) {
            LOGGER.warn("\u8bbe\u5907\u6743\u9650\u672a\u8ba4\u8bc1\uff0cAKS\u91cd\u8bd5init\u521d\u59cb\u5316");
            this.initSuccess = true;
            if (!this.init().booleanValue()) {
                throw new KeyException(AksExceptionEnum.AKS_99_00012.getCode(), AksExceptionEnum.AKS_99_00012.getDesc());
            }
        }
    }

    private String getAndCheckCert(String alias) {
        CertCache cache = CacheUtil.getInstance().getCertCache(this.appID, alias);
        if (cache == null || cache.getCert() == null || PKIHelper.certIsExpire(DatatypeConverter.parseBase64Binary(cache.getCert()))) {
            try {
                String cert = this.cryptoDisService.exportCert(this.getTokenAndApiVersion(), this.appID, alias);
                if (cert == null || PKIHelper.certIsExpire(DatatypeConverter.parseBase64Binary(cert))) {
                    LOGGER.warn("{}\u8bc1\u4e66\u8fc7\u671f\uff0c\u91cd\u65b0\u83b7\u53d6\u8bc1\u4e66\u8fc7\u671f\u3002", (Object)alias);
                    return null;
                }
                CacheUtil.getInstance().updateCertCache(this.appID, alias, cert);
                return cert;
            }
            catch (Exception e) {
                LOGGER.warn("{}\u8bc1\u4e66\u8fc7\u671f\uff0c\u91cd\u65b0\u83b7\u53d6\u65f6\u5931\u8d25\u3002 Exception: {}", (Object)alias, (Object)e.getMessage());
                return null;
            }
        }
        return cache.getCert();
    }

    private String getCert(String alias) {
        CertCache cache = CacheUtil.getInstance().getCertCache(this.appID, alias);
        if (cache == null || cache.getCert() == null) {
            try {
                String cert = this.cryptoDisService.exportCert(this.getTokenAndApiVersion(), this.appID, alias);
                if (cert != null) {
                    CacheUtil.getInstance().updateCertCache(this.appID, alias, cert);
                }
                return cert;
            }
            catch (Exception e) {
                LOGGER.warn("{}\u91cd\u65b0\u83b7\u53d6\u8bc1\u4e66\u65f6\u5931\u8d25\u3002 Exception: {}", (Object)alias, (Object)e.getMessage());
                return null;
            }
        }
        return cache.getCert();
    }

    private int lengthOf(byte[] data) {
        return data == null ? 0 : data.length;
    }

    private int lengthOf(String data) {
        return data == null ? 0 : data.length();
    }

    private void report(final MonitorMessage message) {
        try {
            message.beforeSend();
            if (StatusUtil.getInstance().isMonitor(this.appID)) {
                this.reportPool.submit(new Runnable(){

                    @Override
                    public void run() {
                        String text = message.toJson();
                        DeviceCryptoService.this.cryptoDisService.report(text);
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String digest(DigestAlgEnum digestAlg, byte[] srcData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "digest", this.appID, "", this.lengthOf(srcData));
            monitorMessage.tail(200, null, null);
            String string = ByteUtil.bytesToHexString(this.digestByte(digestAlg, srcData));
            return string;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    private String digestPrivate(DigestAlgEnum digestAlg, byte[] srcData) throws KeyException {
        return ByteUtil.bytesToHexString(this.digestByte(digestAlg, srcData));
    }

    byte[] digestByte(DigestAlgEnum digestAlg, byte[] srcData) throws KeyException {
        Preconditions.validate(new byte[][]{srcData});
        try {
            if (this.isOnLine()) {
                return this.cryptoDisService.hash(this.getTokenAndApiVersion(), this.appID, digestAlg, srcData);
            }
        }
        catch (KeyException k) {
            if (!AKSConstant.errorcodes.contains(k.getCode())) {
                throw new KeyException(AksExceptionEnum.AKS_99_00086.getCode(), AksExceptionEnum.AKS_99_00086.getDesc() + "KeyException:" + k.getMessage());
            }
            LOGGER.warn("\u6458\u8981\u8fd0\u7b97 \u964d\u7ea7\u5904\u7406 ... KeyException:{}", (Object)k.getMessage());
            this.setOffLineStatus();
        }
        catch (Throwable t) {
            if (this.isRpcException(t)) {
                LOGGER.warn("\u6458\u8981\u8fd0\u7b97 \u964d\u7ea7\u5904\u7406. RpcException:{}", (Object)t.getMessage());
                this.setOffLineStatus();
            }
            LOGGER.error("An exception occured when digestByte failed.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_00086.getCode(), AksExceptionEnum.AKS_99_00086.getDesc() + t + t.getMessage());
        }
        return AKSNativeCryptoService.hash(digestAlg, srcData);
    }

    public byte[] encrypt(String aliasName, byte[] srcData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "encrypt", this.appID, aliasName, this.lengthOf(srcData));
            monitorMessage.tail(200, null, null);
            byte[] byArray = this.encryptBytes(aliasName, AKSConstant.DEFAULT_MODE, CryptUtil.getPaddingByAliasName(aliasName), null, srcData);
            return byArray;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public byte[] encrypt(String aliasName, ModeEnum mode, PaddingEnum padding, byte[] iv, byte[] srcData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "encrypt2", this.appID, aliasName, this.lengthOf(srcData));
            monitorMessage.tail(200, null, null);
            byte[] byArray = this.encryptBytes(aliasName, mode, padding, iv, srcData);
            return byArray;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    private byte[] encryptBytes(String aliasName, ModeEnum mode, PaddingEnum padding, byte[] iv, byte[] srcData) throws KeyException {
        Preconditions.validate(aliasName);
        Preconditions.validate(new byte[][]{srcData});
        Preconditions.validate(aliasName, mode, padding, iv);
        Preconditions.checkPlaintext(aliasName, padding, srcData);
        this.checkPermission();
        try {
            if (this.isOnLine() && srcData.length / 3 * 4 < 9984) {
                return this.cryptoDisService.encrypt(this.getTokenAndApiVersion(), this.appID, aliasName, mode, padding, iv, srcData);
            }
        }
        catch (KeyException k) {
            if (!AKSConstant.errorcodes.contains(k.getCode())) {
                throw k;
            }
            LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u5bf9\u79f0\u52a0\u5bc6. KeyException:{}", (Object)k.getMessage());
            this.setOffLineStatus();
        }
        catch (Throwable t) {
            if (this.isRpcException(t)) {
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u5bf9\u79f0\u52a0\u5bc6. RpcException:{}", (Object)t.getMessage());
                this.setOffLineStatus();
            }
            LOGGER.error("An exception occured when encrypt failed.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_00014.getCode(), AksExceptionEnum.AKS_99_00014.getDesc() + t + t.getMessage());
        }
        return AKSNativeCryptoService.crypto(true, aliasName, mode, padding, iv, srcData);
    }

    public byte[] decrypt(String aliasName, byte[] envData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "decrypt", this.appID, aliasName, this.lengthOf(envData));
            monitorMessage.tail(200, null, null);
            byte[] byArray = this.decryptBytes(aliasName, AKSConstant.DEFAULT_MODE, CryptUtil.getPaddingByAliasName(aliasName), null, envData);
            return byArray;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public byte[] decrypt(String aliasName, ModeEnum mode, PaddingEnum padding, byte[] iv, byte[] envData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "decrypt2", this.appID, aliasName, this.lengthOf(envData));
            monitorMessage.tail(200, null, null);
            byte[] byArray = this.decryptBytes(aliasName, mode, padding, iv, envData);
            return byArray;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public byte[] decryptBytes(String aliasName, ModeEnum mode, PaddingEnum padding, byte[] iv, byte[] envData) throws KeyException {
        Preconditions.validate(aliasName);
        Preconditions.validate(new byte[][]{envData});
        Preconditions.validate(aliasName, mode, padding, iv);
        Preconditions.checkEncryptedDataByVersion(CryptUtil.getAlgByAliasName(aliasName), envData);
        this.checkPermission();
        try {
            if (this.isOnLine() && envData.length / 3 * 4 < 9984) {
                return this.cryptoDisService.decrypt(this.getTokenAndApiVersion(), this.appID, aliasName, mode, padding, iv, envData);
            }
        }
        catch (KeyException k) {
            if (!AKSConstant.errorcodes.contains(k.getCode())) {
                throw k;
            }
            LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u5bf9\u79f0\u89e3\u5bc6. KeyException:{}", (Object)k.getMessage());
            this.setOffLineStatus();
        }
        catch (Throwable t) {
            if (this.isRpcException(t)) {
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u5bf9\u79f0\u52a0\u5bc6. RpcException:{}", (Object)t.getMessage());
                this.setOffLineStatus();
            }
            LOGGER.error("An exception occured when decrypt failed.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_00015.getCode(), AksExceptionEnum.AKS_99_00015.getDesc() + t + t.getMessage());
        }
        return AKSNativeCryptoService.crypto(false, aliasName, mode, padding, iv, envData);
    }

    public String encryptString(String aliasName, byte[] srcData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "encryptString", this.appID, aliasName, this.lengthOf(srcData));
            monitorMessage.tail(200, null, null);
            byte[] result = this.encryptBytes(aliasName, AKSConstant.DEFAULT_MODE, CryptUtil.getPaddingByAliasName(aliasName), null, srcData);
            String string = DatatypeConverter.printBase64Binary(result);
            return string;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public String encryptString(String aliasName, ModeEnum mode, PaddingEnum padding, byte[] iv, byte[] srcData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "encryptString2", this.appID, aliasName, this.lengthOf(srcData));
            monitorMessage.tail(200, null, null);
            byte[] result = this.encryptBytes(aliasName, mode, padding, iv, srcData);
            String string = DatatypeConverter.printBase64Binary(result);
            return string;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public byte[] decryptString(String aliasName, String envData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "decryptString", this.appID, aliasName, this.lengthOf(envData));
            monitorMessage.tail(200, null, null);
            Preconditions.validate(envData);
            Preconditions.checkIsBase64Data(envData);
            byte[] result = DatatypeConverter.parseBase64Binary(envData);
            byte[] byArray = this.decryptBytes(aliasName, AKSConstant.DEFAULT_MODE, CryptUtil.getPaddingByAliasName(aliasName), null, result);
            return byArray;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public byte[] decryptString(String aliasName, ModeEnum mode, PaddingEnum padding, byte[] iv, String envData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "decryptString2", this.appID, aliasName, this.lengthOf(envData));
            monitorMessage.tail(200, null, null);
            Preconditions.validate(envData);
            Preconditions.checkIsBase64Data(envData);
            byte[] result = DatatypeConverter.parseBase64Binary(envData);
            byte[] byArray = this.decryptBytes(aliasName, mode, padding, iv, result);
            return byArray;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public String encryptStringByVersion(String aliasName, byte[] srcData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "encryptStringByVersion", this.appID, aliasName, this.lengthOf(srcData));
            monitorMessage.tail(200, null, null);
            byte[] result = this.encryptBytesByVersion(aliasName, AKSConstant.DEFAULT_MODE_VERSION, CryptUtil.getPaddingByAliasName(aliasName), srcData);
            String string = DatatypeConverter.printBase64Binary(result);
            return string;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public String encryptStringByVersion(String aliasName, ModeEnum mode, PaddingEnum padding, byte[] srcData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "encryptStringByVersion2", this.appID, aliasName, this.lengthOf(srcData));
            monitorMessage.tail(200, null, null);
            byte[] result = this.encryptBytesByVersion(aliasName, mode, padding, srcData);
            String string = DatatypeConverter.printBase64Binary(result);
            return string;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public byte[] encryptByVersion(String aliasName, ModeEnum mode, PaddingEnum padding, byte[] srcData) {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "encryptByVersion", this.appID, aliasName, this.lengthOf(srcData));
            monitorMessage.tail(200, null, null);
            byte[] byArray = this.encryptBytesByVersion(aliasName, mode, padding, srcData);
            return byArray;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    private byte[] encryptBytesByVersion(String aliasName, ModeEnum mode, PaddingEnum padding, byte[] srcData) {
        Preconditions.validate(aliasName);
        Preconditions.validate(new byte[][]{srcData});
        Preconditions.validateForSysmVersion(aliasName, mode, padding);
        Preconditions.checkPlaintext(aliasName, padding, srcData);
        this.checkPermission();
        try {
            if (this.isOnLine() && srcData.length / 3 * 4 < 9984) {
                return this.cryptoDisService.encryptByVersion(this.getTokenAndApiVersion(), this.appID, aliasName, mode, padding, srcData);
            }
        }
        catch (KeyException k) {
            if (!AKSConstant.errorcodes.contains(k.getCode())) {
                throw k;
            }
            LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u5bf9\u79f0\u52a0\u5bc6(\u5e26\u5bc6\u94a5\u7248\u672c). KeyException:{}", (Object)k.getMessage());
            this.setOffLineStatus();
        }
        catch (Throwable t) {
            if (this.isRpcException(t)) {
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u5bf9\u79f0\u52a0\u5bc6(\u5e26\u5bc6\u94a5\u7248\u672c). RpcException:{}", (Object)t.getMessage());
                this.setOffLineStatus();
            }
            LOGGER.error("An exception occured when encrypt failed.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_00014.getCode(), AksExceptionEnum.AKS_99_00014.getDesc() + t + t.getMessage());
        }
        return AKSNativeCryptoService.symmEncryptByte(aliasName, mode, padding, srcData);
    }

    public byte[] decryptStringByVersion(String aliasName, String envData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "decryptStringByVersion", this.appID, aliasName, this.lengthOf(envData));
            monitorMessage.tail(200, null, null);
            Preconditions.validate(envData);
            Preconditions.checkIsBase64Data(envData);
            byte[] result = DatatypeConverter.parseBase64Binary(envData);
            byte[] byArray = this.decryptBytesByVersion(aliasName, result);
            return byArray;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public byte[] decryptStringByVersion(String aliasName, ModeEnum mode, PaddingEnum padding, byte[] iv, String envData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "decryptStringByVersion2", this.appID, aliasName, this.lengthOf(envData));
            monitorMessage.tail(200, null, null);
            Preconditions.validate(envData);
            Preconditions.checkIsBase64Data(envData);
            byte[] result = DatatypeConverter.parseBase64Binary(envData);
            byte[] byArray = this.decryptBytesByVersion(aliasName, mode, padding, iv, result);
            return byArray;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public byte[] decryptByVersion(String aliasName, ModeEnum mode, PaddingEnum padding, byte[] iv, byte[] envData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "decryptByVersion", this.appID, aliasName, this.lengthOf(envData));
            monitorMessage.tail(200, null, null);
            byte[] byArray = this.decryptBytesByVersion(aliasName, mode, padding, iv, envData);
            return byArray;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    private byte[] decryptBytesByVersion(String aliasName, byte[] envData) throws KeyException {
        return this.decryptBytesByVersion(aliasName, AKSConstant.DEFAULT_MODE, CryptUtil.getPaddingByAliasName(aliasName), null, envData);
    }

    private byte[] decryptBytesByVersion(String aliasName, ModeEnum mode, PaddingEnum padding, byte[] iv, byte[] envData) throws KeyException {
        Preconditions.validate(aliasName);
        Preconditions.validate(new byte[][]{envData});
        Preconditions.validate(aliasName, mode, padding, iv);
        Preconditions.checkEncryptedDataByVersion(CryptUtil.getAlgByAliasName(aliasName), envData);
        this.checkPermission();
        try {
            if (this.isOnLine() && envData.length / 3 * 4 < 9984) {
                return this.cryptoDisService.decryptByVersion(this.getTokenAndApiVersion(), this.appID, aliasName, mode, padding, iv, envData);
            }
        }
        catch (KeyException k) {
            if (!AKSConstant.errorcodes.contains(k.getCode())) {
                throw k;
            }
            LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u5bf9\u79f0\u89e3\u5bc6(\u5e26\u5bc6\u94a5\u7248\u672c). KeyException:{}", (Object)k.getMessage());
            this.setOffLineStatus();
        }
        catch (Throwable t) {
            if (this.isRpcException(t)) {
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u5bf9\u79f0\u52a0\u5bc6(\u5e26\u5bc6\u94a5\u7248\u672c). RpcException:{}", (Object)t.getMessage());
                this.setOffLineStatus();
            }
            LOGGER.error("An exception occured when decrypt failed.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_00015.getCode(), AksExceptionEnum.AKS_99_00015.getDesc() + t + t.getMessage());
        }
        return AKSNativeCryptoService.symmDecrypt(aliasName, mode, padding, iv, DatatypeConverter.printBase64Binary(envData));
    }

    public String encryptStringByGCM(String aliasName, byte[] srcData, byte[] nonce, byte[] iv) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "encryptStringByGCM", this.appID, aliasName, this.lengthOf(srcData));
            monitorMessage.tail(200, null, null);
            Preconditions.validate(aliasName);
            Preconditions.validate(srcData, nonce);
            this.checkPermission();
            byte[] result = AKSNativeCryptoService.symmEncryptForGCM(aliasName, PaddingEnum.PADDING_PKCS7, srcData, nonce, iv);
            String string = DatatypeConverter.printBase64Binary(result);
            return string;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public byte[] decryptStringByGCM(String aliasName, String envData, byte[] nonce, byte[] iv) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "decryptStringByGCM", this.appID, aliasName, this.lengthOf(envData));
            monitorMessage.tail(200, null, null);
            byte[] byArray = this.decryptBytesStringByGCM(aliasName, AKSConstant.DEFAULT_MODE, envData, nonce, iv);
            return byArray;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public byte[] decryptStringByGCM(String aliasName, ModeEnum mode, String envData, byte[] nonce, byte[] iv) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "decryptStringByGCM2", this.appID, aliasName, this.lengthOf(envData));
            monitorMessage.tail(200, null, null);
            byte[] byArray = this.decryptBytesStringByGCM(aliasName, mode, envData, nonce, iv);
            return byArray;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    private byte[] decryptBytesStringByGCM(String aliasName, ModeEnum mode, String envData, byte[] nonce, byte[] iv) throws KeyException {
        Preconditions.validate(aliasName, envData);
        Preconditions.checkIsBase64Data(envData);
        this.checkPermission();
        byte[] envDataBytes = DatatypeConverter.parseBase64Binary(envData);
        return AKSNativeCryptoService.symmDecryptForGCM(aliasName, mode, PaddingEnum.PADDING_PKCS7, envDataBytes, nonce, iv);
    }

    public String encryptByFF1(String aliasName, RadixEnum radix, String tweak, String srcData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "encryptByFF1", this.appID, aliasName, this.lengthOf(srcData));
            monitorMessage.tail(200, null, null);
            Preconditions.validate(aliasName, srcData);
            if (tweak != null && tweak.length() != 0) {
                Preconditions.checkIsBase64Data(tweak);
            }
            Preconditions.checkFF1DataType(radix, srcData);
            this.checkPermission();
            try {
                if (this.isOnLine() && srcData.length() < 9984) {
                    String string = this.cryptoDisService.encryptFF1(this.getTokenAndApiVersion(), this.appID, aliasName, radix, tweak, srcData);
                    return string;
                }
            }
            catch (KeyException k) {
                if (!AKSConstant.errorcodes.contains(k.getCode())) {
                    throw k;
                }
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... FF1\u4fdd\u578b\u52a0\u5bc6. KeyException:{}", (Object)k.getMessage());
                this.setOffLineStatus();
            }
            catch (Throwable t) {
                if (this.isRpcException(t)) {
                    LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... FF1\u4fdd\u578b\u52a0\u5bc6. RpcException:{}", (Object)t.getMessage());
                    this.setOffLineStatus();
                }
                LOGGER.error("An exception occured when encryptByFF1 failed.", t);
                throw new KeyException(AksExceptionEnum.AKS_99_00014.getCode(), AksExceptionEnum.AKS_99_00014.getDesc() + t + t.getMessage());
            }
            String t = AKSNativeCryptoService.cryptoByFF1(true, aliasName, radix, tweak, srcData);
            return t;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public String decryptByFF1(String aliasName, RadixEnum radix, String tweak, String enData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "decryptByFF1", this.appID, aliasName, this.lengthOf(enData));
            monitorMessage.tail(200, null, null);
            Preconditions.validate(aliasName, enData);
            if (tweak != null && tweak.length() != 0) {
                Preconditions.checkIsBase64Data(tweak);
            }
            Preconditions.checkFF1DataType(radix, enData);
            this.checkPermission();
            try {
                if (this.isOnLine() && enData.length() < 9984) {
                    String string = this.cryptoDisService.decryptFF1(this.getTokenAndApiVersion(), this.appID, aliasName, radix, tweak, enData);
                    return string;
                }
            }
            catch (KeyException k) {
                if (!AKSConstant.errorcodes.contains(k.getCode())) {
                    throw k;
                }
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... FF1\u4fdd\u578b\u89e3\u5bc6. KeyException:{}", (Object)k.getMessage());
                this.setOffLineStatus();
            }
            catch (Throwable t) {
                if (this.isRpcException(t)) {
                    LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... FF1\u4fdd\u578b\u89e3\u5bc6. RpcException:{}", (Object)t.getMessage());
                    this.setOffLineStatus();
                }
                LOGGER.error("An exception occured when decryptByFF1 failed.", t);
                throw new KeyException(AksExceptionEnum.AKS_99_00015.getCode(), AksExceptionEnum.AKS_99_00015.getDesc() + t + t.getMessage());
            }
            String t = AKSNativeCryptoService.cryptoByFF1(false, aliasName, radix, tweak, enData);
            return t;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public String indexing(byte[] srcData) {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "indexing", this.appID, null, this.lengthOf(srcData));
            monitorMessage.tail(200, null, null);
            String string = this.indexingWithAppIdPrivate(this.appID, srcData);
            return string;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public String indexingWithAppId(String appId, byte[] srcData) {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "indexingWithAppId", this.appID, appId, this.lengthOf(srcData));
            monitorMessage.tail(200, null, null);
            String string = this.indexingWithAppIdPrivate(appId, srcData);
            return string;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    private String indexingWithAppIdPrivate(String appId, byte[] srcData) {
        Preconditions.validate(new byte[][]{srcData});
        try {
            if (this.isOnLine() && srcData.length / 3 * 4 < 9984) {
                return this.cryptoDisService.indexing(this.getTokenAndApiVersion(), appId, srcData);
            }
        }
        catch (KeyException k) {
            if (!AKSConstant.errorcodes.contains(k.getCode())) {
                throw k;
            }
            LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u8ba1\u7b97\u7d22\u5f15. KeyException:{}", (Object)k.getMessage());
            this.setOffLineStatus();
        }
        catch (Throwable t) {
            if (this.isRpcException(t)) {
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u8ba1\u7b97\u7d22\u5f15. RpcException:{}", (Object)t.getMessage());
                this.setOffLineStatus();
            }
            LOGGER.error("An exception occured when indexing failed.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_00074.getCode(), AksExceptionEnum.AKS_99_00074.getDesc() + t + t.getMessage());
        }
        return AKSNativeCryptoService.createIndex(appId, srcData);
    }

    public AKSP7Object decryptSignedEnvelop(String certAliasName, String envelop) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "decryptSignedEnvelop", this.appID, certAliasName, this.lengthOf(envelop));
            monitorMessage.tail(200, null, null);
            AKSP7Object result = new AKSP7Object();
            List<byte[]> listResult = this.decryptSignedEnvelopPrivate(certAliasName, envelop);
            if (null != listResult && listResult.size() > 1) {
                ArrayList<AKSCertInfo> certInfos = new ArrayList<AKSCertInfo>();
                for (int i = 0; i < listResult.size(); ++i) {
                    if (i == 0) {
                        result.setDataB64(DatatypeConverter.printBase64Binary(listResult.get(i)));
                        continue;
                    }
                    AKSCertInfo certInfo = this.getCertInfo(listResult.get(i));
                    certInfos.add(certInfo);
                }
                result.setCertInfos(certInfos);
            }
            AKSP7Object aKSP7Object = result;
            return aKSP7Object;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public List<byte[]> deP7envelop(String certAliasName, String envelop) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "deP7envelop", this.appID, certAliasName, this.lengthOf(envelop));
            monitorMessage.tail(200, null, null);
            List<byte[]> list = this.decryptSignedEnvelopPrivate(certAliasName, envelop);
            return list;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    private List<byte[]> decryptSignedEnvelopPrivate(String certAliasName, String envelop) throws KeyException {
        Preconditions.validate(certAliasName, envelop);
        Preconditions.checkIsBase64Data(envelop);
        Preconditions.checkCertAliasName(certAliasName);
        this.checkPermission();
        try {
            if (this.isOnLine() && envelop.length() < 9984) {
                return this.cryptoDisService.deP7envelop(this.getTokenAndApiVersion(), this.appID, certAliasName, envelop);
            }
        }
        catch (KeyException k) {
            if (!AKSConstant.errorcodes.contains(k.getCode())) {
                throw k;
            }
            LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u89e3\u5bc6\u7b7e\u540d\u7684\u6570\u5b57\u4fe1\u5c01. KeyException:{}", (Object)k.getMessage());
            this.setOffLineStatus();
        }
        catch (Throwable t) {
            if (this.isRpcException(t)) {
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u89e3\u5bc6\u7b7e\u540d\u7684\u6570\u5b57\u4fe1\u5c01. RpcException:{}", (Object)t.getMessage());
                this.setOffLineStatus();
            }
            LOGGER.error("An exception occured when deP7envelop failed.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_00029.getCode(), AksExceptionEnum.AKS_99_00029.getDesc() + t + t.getMessage());
        }
        return AKSNativeCryptoService.decryptSignedEnvelop(certAliasName, envelop);
    }

    public String GMT_encryptSignedEnvelop(String certAliasName, byte[] cert, byte[] srcData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "GMT_encryptSignedEnvelop", this.appID, certAliasName, this.lengthOf(srcData));
            monitorMessage.tail(200, null, null);
            Preconditions.validate(certAliasName);
            Preconditions.validate(cert, srcData);
            Preconditions.checkCertAliasName(certAliasName);
            this.checkPermission();
            try {
                if (this.isOnLine() && srcData.length / 3 * 4 < 9984) {
                    String string = this.cryptoDisService.encryptSignedEnvelop(this.getTokenAndApiVersion(), this.appID, certAliasName + "|3", cert, srcData);
                    return string;
                }
            }
            catch (KeyException e) {
                if (!AKSConstant.errorcodes.contains(e.getCode())) {
                    throw e;
                }
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... GMT\u52a0\u5bc6\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01. KeyException:{}", (Object)e.getMessage());
                this.setOffLineStatus();
            }
            catch (Throwable t) {
                if (this.isRpcException(t)) {
                    LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... GMT\u52a0\u5bc6\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01. RpcException:{}", (Object)t.getMessage());
                    this.setOffLineStatus();
                }
                LOGGER.error("An exception occured when encryptSignedEnvelop failed.", t);
                throw new KeyException(AksExceptionEnum.AKS_99_00041.getCode(), AksExceptionEnum.AKS_99_00041.getDesc() + t + t.getMessage());
            }
            String recipCertB64 = this.getCertInfo(cert).getCertB64();
            String signedCertB64 = this.getAndCheckCert(certAliasName);
            if (signedCertB64 == null) {
                throw new KeyException(AksExceptionEnum.AKS_99_00043.getCode(), AksExceptionEnum.AKS_99_00043.getDesc());
            }
            byte[] signedEnvelopBytes = AKSNativeCryptoService.encryptSignedEnvelop(certAliasName, recipCertB64, signedCertB64, srcData, 3);
            String string = DatatypeConverter.printBase64Binary(signedEnvelopBytes);
            return string;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public String encryptSignedEnvelop(String certAliasName, byte[] cert, byte[] srcData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "encryptSignedEnvelop", this.appID, certAliasName, this.lengthOf(srcData));
            monitorMessage.tail(200, null, null);
            Preconditions.validate(certAliasName);
            Preconditions.validate(cert, srcData);
            Preconditions.checkCertAliasName(certAliasName);
            this.checkPermission();
            try {
                if (this.isOnLine() && srcData.length / 3 * 4 < 9984) {
                    String string = this.cryptoDisService.encryptSignedEnvelop(this.getTokenAndApiVersion(), this.appID, certAliasName, cert, srcData);
                    return string;
                }
            }
            catch (KeyException e) {
                if (!AKSConstant.errorcodes.contains(e.getCode())) {
                    throw e;
                }
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u52a0\u5bc6\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01. KeyException:{}", (Object)e.getMessage());
                this.setOffLineStatus();
            }
            catch (Throwable t) {
                if (this.isRpcException(t)) {
                    LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u52a0\u5bc6\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01. RpcException:{}", (Object)t.getMessage());
                    this.setOffLineStatus();
                }
                LOGGER.error("An exception occured when encryptSignedEnvelop failed.", t);
                throw new KeyException(AksExceptionEnum.AKS_99_00041.getCode(), AksExceptionEnum.AKS_99_00041.getDesc() + t + t.getMessage());
            }
            String recipCertB64 = this.getCertInfo(cert).getCertB64();
            String signedCertB64 = this.getAndCheckCert(certAliasName);
            if (signedCertB64 == null) {
                throw new KeyException(AksExceptionEnum.AKS_99_00043.getCode(), AksExceptionEnum.AKS_99_00043.getDesc());
            }
            byte[] signedEnvelopBytes = AKSNativeCryptoService.encryptSignedEnvelop(certAliasName, recipCertB64, signedCertB64, srcData, 1);
            String string = DatatypeConverter.printBase64Binary(signedEnvelopBytes);
            return string;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public byte[] private_decrypt(String certAliasName, byte[] envData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "private_decrypt", this.appID, certAliasName, this.lengthOf(envData));
            monitorMessage.tail(200, null, null);
            byte[] byArray = this.privateDecryptBytes(certAliasName, envData);
            return byArray;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    private byte[] privateDecryptBytes(String certAliasName, byte[] envData) throws KeyException {
        Preconditions.validate(certAliasName);
        Preconditions.validate(new byte[][]{envData});
        Preconditions.checkCertAliasName(certAliasName);
        AlgEnum alg = CryptUtil.getAlgByAliasName(certAliasName);
        Preconditions.checkEncryptedData(alg, envData);
        this.checkPermission();
        try {
            if (this.isOnLine()) {
                return this.cryptoDisService.private_decrypt(this.getTokenAndApiVersion(), this.appID, certAliasName, envData);
            }
        }
        catch (KeyException k) {
            if (!AKSConstant.errorcodes.contains(k.getCode())) {
                throw k;
            }
            LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u79c1\u94a5\u89e3\u5bc6. KeyException:{}", (Object)k.getMessage());
            this.setOffLineStatus();
        }
        catch (Throwable t) {
            if (this.isRpcException(t)) {
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u79c1\u94a5\u89e3\u5bc6. RpcException:{}", (Object)t.getMessage());
                this.setOffLineStatus();
            }
            LOGGER.error("An exception occured when private_decrypt failed.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_00016.getCode(), AksExceptionEnum.AKS_99_00016.getDesc() + t + t.getMessage());
        }
        return AKSNativeCryptoService.privateKeyDecrypt(certAliasName, envData);
    }

    public byte[] public_encrypt(String certAliasName, byte[] srcData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "public_encrypt", this.appID, certAliasName, this.lengthOf(srcData));
            monitorMessage.tail(200, null, null);
            byte[] byArray = this.publicEncryptPrivate(certAliasName, new byte[0], srcData);
            return byArray;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public byte[] public_encrypt(String certAliasName, byte[] publicKey_Cert, byte[] srcData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "public_encrypt2", this.appID, certAliasName, this.lengthOf(srcData));
            monitorMessage.tail(200, null, null);
            byte[] byArray = this.publicEncryptPrivate(certAliasName, publicKey_Cert, srcData);
            return byArray;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    private byte[] publicEncryptPrivate(String certAliasName, byte[] publicKey_Cert, byte[] srcData) throws KeyException {
        Preconditions.validate(certAliasName);
        Preconditions.validate(new byte[][]{srcData});
        Preconditions.checkCertAliasName(certAliasName);
        if (publicKey_Cert == null || publicKey_Cert.length == 0) {
            AlgEnum _alg = CryptUtil.getAlgByAliasName(certAliasName);
            Preconditions.checkPlaintextAsymm(_alg, srcData);
        }
        this.checkPermission();
        try {
            AKSCertInfo certInfo;
            if (null != publicKey_Cert && publicKey_Cert.length > 0 && null != (certInfo = this.getCertInfo(publicKey_Cert)) && certInfo.getCertResidualTime() < 0L) {
                LOGGER.error("cert has expired, {}", (Object)certInfo.getCertResidualTime());
                throw new KeyException(AksExceptionEnum.AKS_99_00031.getCode(), AksExceptionEnum.AKS_99_00031.getDesc());
            }
            if (this.isOnLine()) {
                return this.cryptoDisService.public_encrypt(this.getTokenAndApiVersion(), this.appID, certAliasName, publicKey_Cert, srcData);
            }
        }
        catch (KeyException k) {
            if (!AKSConstant.errorcodes.contains(k.getCode())) {
                throw k;
            }
            LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u516c\u94a5\u52a0\u5bc6. KeyException:{}", (Object)k.getMessage());
            this.setOffLineStatus();
        }
        catch (Throwable t) {
            if (this.isRpcException(t)) {
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u516c\u94a5\u52a0\u5bc6. RpcException:{}", (Object)t.getMessage());
                this.setOffLineStatus();
            }
            LOGGER.error("An exception occured when public_encrypt failed.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_00017.getCode(), AksExceptionEnum.AKS_99_00017.getDesc() + t + t.getMessage());
        }
        return AKSNativeCryptoService.publicKeyEncrypt(certAliasName, publicKey_Cert, srcData);
    }

    public byte[] p1_sign(String certAliasName, byte[] srcData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "p1_sign", this.appID, certAliasName, this.lengthOf(srcData));
            monitorMessage.tail(200, null, null);
            Preconditions.validate(certAliasName);
            Preconditions.validate(new byte[][]{srcData});
            Preconditions.checkCertAliasName(certAliasName);
            this.checkPermission();
            try {
                if (this.isOnLine() && srcData.length / 3 * 4 < 9984) {
                    byte[] byArray = this.cryptoDisService.p1Sign(this.getTokenAndApiVersion(), this.appID, certAliasName, srcData);
                    return byArray;
                }
            }
            catch (KeyException k) {
                if (!AKSConstant.errorcodes.contains(k.getCode())) {
                    throw k;
                }
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... P1\u7b7e\u540d. KeyException:{}", (Object)k.getMessage());
                this.setOffLineStatus();
            }
            catch (Throwable t) {
                if (this.isRpcException(t)) {
                    LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... P1\u7b7e\u540d. RpcException:{}", (Object)t.getMessage());
                    this.setOffLineStatus();
                }
                LOGGER.error("An exception occured when p1_sign failed.", t);
                throw new KeyException(AksExceptionEnum.AKS_99_00020.getCode(), AksExceptionEnum.AKS_99_00020.getDesc() + t + t.getMessage());
            }
            byte[] t = AKSNativeCryptoService.p1Sign(certAliasName, srcData);
            return t;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public boolean p1_verify(String certAliasName, byte[] srcData, byte[] p1Data) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "p1_verify", this.appID, certAliasName, this.lengthOf(srcData));
            monitorMessage.tail(200, null, null);
            boolean bl = this.p1VerifyPrivate(certAliasName, new byte[0], srcData, p1Data);
            return bl;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public boolean p1_verify(String certAliasName, byte[] publicKey_Cert, byte[] srcData, byte[] p1Data) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "p1_verify2", this.appID, certAliasName, this.lengthOf(srcData));
            monitorMessage.tail(200, null, null);
            boolean bl = this.p1VerifyPrivate(certAliasName, publicKey_Cert, srcData, p1Data);
            return bl;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    private boolean p1VerifyPrivate(String certAliasName, byte[] publicKey_Cert, byte[] srcData, byte[] p1Data) throws KeyException {
        String recipCertB64;
        Preconditions.validate(certAliasName);
        Preconditions.validate(srcData, p1Data);
        Preconditions.checkCertAliasName(certAliasName);
        if (publicKey_Cert == null || publicKey_Cert.length == 0) {
            AlgEnum _alg = CryptUtil.getAlgByAliasName(certAliasName);
            Preconditions.checkEncryptedData(_alg, p1Data);
        }
        if (128 != p1Data.length && 256 != p1Data.length && 512 != p1Data.length && 68 != p1Data.length && 69 != p1Data.length && 70 != p1Data.length && 71 != p1Data.length && 72 != p1Data.length) {
            LOGGER.error("p1_verify\u9a8c\u7b7e\u6570\u636e\u7684\u957f\u5ea6\u9519\u8bef {}", (Object)p1Data.length);
            throw new KeyException(AksExceptionEnum.AKS_99_00021.getCode(), AksExceptionEnum.AKS_99_00021.getDesc());
        }
        this.checkPermission();
        try {
            if (this.isOnLine()) {
                return this.cryptoDisService.p1Verify(this.getTokenAndApiVersion(), this.appID, certAliasName, publicKey_Cert, p1Data, srcData);
            }
        }
        catch (KeyException k) {
            if (!AKSConstant.errorcodes.contains(k.getCode())) {
                throw k;
            }
            LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... P1\u9a8c\u7b7e. KeyException:{}", (Object)k.getMessage());
            this.setOffLineStatus();
        }
        catch (Throwable t) {
            if (this.isRpcException(t)) {
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... P1\u9a8c\u7b7e. RpcException:{}", (Object)t.getMessage());
                this.setOffLineStatus();
            }
            LOGGER.error("An exception occured when p1_verify failed.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_00030.getCode(), AksExceptionEnum.AKS_99_00030.getDesc() + t + t.getMessage());
        }
        if (publicKey_Cert == null || publicKey_Cert.length == 0) {
            recipCertB64 = this.getCert(certAliasName);
            if (recipCertB64 == null) {
                throw new KeyException(AksExceptionEnum.AKS_99_00043.getCode(), AksExceptionEnum.AKS_99_00043.getDesc());
            }
        } else {
            recipCertB64 = this.getCertInfo(publicKey_Cert).getCertB64();
        }
        return AKSNativeCryptoService.p1Verify(DatatypeConverter.printBase64Binary(p1Data), recipCertB64, srcData);
    }

    public String GMT_p7Sign(String certAliasName, boolean attachFlag, byte[] srcData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "GMT_p7Sign", this.appID, certAliasName, this.lengthOf(srcData));
            monitorMessage.tail(200, null, null);
            Preconditions.validate(certAliasName);
            Preconditions.validate(new byte[][]{srcData});
            Preconditions.checkCertAliasName(certAliasName);
            this.checkPermission();
            try {
                if (this.isOnLine() && srcData.length / 3 * 4 < 7984) {
                    String string = this.cryptoDisService.p7Sign(this.getTokenAndApiVersion(), this.appID, certAliasName + "|3", attachFlag, srcData);
                    return string;
                }
            }
            catch (KeyException e) {
                if (!AKSConstant.errorcodes.contains(e.getCode())) {
                    throw e;
                }
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... GMT_p7Sign\u7b7e\u540d. KeyException:{}", (Object)e.getMessage());
                this.setOffLineStatus();
            }
            catch (Throwable t) {
                if (this.isRpcException(t)) {
                    LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... GMT_p7Sign\u7b7e\u540d. RpcException:{}", (Object)t.getMessage());
                    this.setOffLineStatus();
                }
                LOGGER.error("An exception occured when GMT_p7Sign failed.", t);
                throw new KeyException(AksExceptionEnum.AKS_99_00042.getCode(), AksExceptionEnum.AKS_99_00042.getDesc() + t + t.getMessage());
            }
            String signedCertB64 = this.getAndCheckCert(certAliasName);
            if (signedCertB64 == null) {
                throw new KeyException(AksExceptionEnum.AKS_99_00043.getCode(), AksExceptionEnum.AKS_99_00043.getDesc());
            }
            byte[] sign = AKSNativeCryptoService.p7Sign(certAliasName, attachFlag, signedCertB64, srcData, true);
            String string = DatatypeConverter.printBase64Binary(sign);
            return string;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public String p7_sign(String certAliasName, boolean attachFlag, byte[] srcData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "p7_sign", this.appID, certAliasName, this.lengthOf(srcData));
            monitorMessage.tail(200, null, null);
            Preconditions.validate(certAliasName);
            Preconditions.validate(new byte[][]{srcData});
            Preconditions.checkCertAliasName(certAliasName);
            this.checkPermission();
            try {
                if (this.isOnLine() && srcData.length / 3 * 4 < 7984) {
                    String string = this.cryptoDisService.p7Sign(this.getTokenAndApiVersion(), this.appID, certAliasName, attachFlag, srcData);
                    return string;
                }
            }
            catch (KeyException e) {
                if (!AKSConstant.errorcodes.contains(e.getCode())) {
                    throw e;
                }
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... P7\u7b7e\u540d. KeyException:{}", (Object)e.getMessage());
                this.setOffLineStatus();
            }
            catch (Throwable t) {
                if (this.isRpcException(t)) {
                    LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... P7\u7b7e\u540d. RpcException:{}", (Object)t.getMessage());
                    this.setOffLineStatus();
                }
                LOGGER.error("An exception occured when p7_sign failed.", t);
                throw new KeyException(AksExceptionEnum.AKS_99_00042.getCode(), AksExceptionEnum.AKS_99_00042.getDesc() + t + t.getMessage());
            }
            String signedCertB64 = this.getAndCheckCert(certAliasName);
            if (signedCertB64 == null) {
                throw new KeyException(AksExceptionEnum.AKS_99_00043.getCode(), AksExceptionEnum.AKS_99_00043.getDesc());
            }
            byte[] sign = AKSNativeCryptoService.p7Sign(certAliasName, attachFlag, signedCertB64, srcData, false);
            String string = DatatypeConverter.printBase64Binary(sign);
            return string;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public List<String> p7_verify(String certAliasName, boolean attachFlag, String signedDataB64, byte[] srcData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "p7_verify", this.appID, certAliasName, this.lengthOf(srcData));
            monitorMessage.tail(200, null, null);
            Preconditions.validate(certAliasName, signedDataB64);
            Preconditions.checkIsBase64Data(signedDataB64);
            Preconditions.checkCertAliasName(certAliasName);
            if (!attachFlag && null == srcData) {
                LOGGER.error("An exception occured when p7_verify() check argument failed");
                throw new KeyException(AksExceptionEnum.AKS_99_00001.getCode(), AksExceptionEnum.AKS_99_00001.getDesc());
            }
            this.checkPermission();
            if (!this.aliasNameSet.contains(certAliasName)) {
                LOGGER.error("An exception occured when p7_verify() check argument certAliasName permission");
                throw new KeyException(AksExceptionEnum.AKS_99_00076.getCode(), AksExceptionEnum.AKS_99_00076.getDesc() + "certAliasName = " + certAliasName);
            }
            try {
                if (this.isOnLine() && (null == srcData || srcData.length / 3 * 4 < 9984)) {
                    List<String> list = this.cryptoDisService.p7Verify(this.getTokenAndApiVersion(), this.appID, certAliasName, attachFlag, signedDataB64, srcData);
                    return list;
                }
            }
            catch (KeyException e) {
                if (!AKSConstant.errorcodes.contains(e.getCode())) {
                    throw e;
                }
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... P7\u9a8c\u7b7e. KeyException:{}", (Object)e.getMessage());
                this.setOffLineStatus();
            }
            catch (Throwable t) {
                if (this.isRpcException(t)) {
                    LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... P7\u9a8c\u7b7e. RpcException:{}", (Object)t.getMessage());
                    this.setOffLineStatus();
                }
                LOGGER.error("An exception occured when p7_verify failed.", t);
                throw new KeyException(AksExceptionEnum.AKS_99_00052.getCode(), AksExceptionEnum.AKS_99_00052.getDesc() + t + t.getMessage());
            }
            ArrayList<String> verifyRetsB64 = new ArrayList<String>();
            List<byte[]> verifyRets = AKSNativeCryptoService.p7Verify(attachFlag, signedDataB64, srcData);
            if (!verifyRets.isEmpty()) {
                boolean first = true;
                for (byte[] bs : verifyRets) {
                    if (first) {
                        verifyRetsB64.add(DatatypeConverter.printBase64Binary(bs));
                        first = false;
                        continue;
                    }
                    verifyRetsB64.add(new String(bs));
                }
            }
            ArrayList<String> arrayList = verifyRetsB64;
            return arrayList;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public String GMT_encryptEnvelop(String certAliasName, byte[] cert, byte[] srcData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            String recipCertB64;
            monitorMessage.head(MY_NAME, "GMT_encryptEnvelop", this.appID, certAliasName, this.lengthOf(srcData));
            monitorMessage.tail(200, null, null);
            Preconditions.validate(certAliasName);
            Preconditions.validate(new byte[][]{srcData});
            Preconditions.checkCertAliasName(certAliasName);
            this.checkPermission();
            if (!this.aliasNameSet.contains(certAliasName)) {
                LOGGER.error("An exception occured when encryptEnvelop() check argument certAliasName permission");
                throw new KeyException(AksExceptionEnum.AKS_99_00076.getCode(), AksExceptionEnum.AKS_99_00076.getDesc() + "certAliasName = " + certAliasName);
            }
            try {
                if (this.isOnLine() && srcData.length / 3 * 4 < 9984) {
                    String string = this.cryptoDisService.encryptEnvelop(this.getTokenAndApiVersion(), this.appID, certAliasName + "|3", cert, srcData);
                    return string;
                }
            }
            catch (KeyException e) {
                if (!AKSConstant.errorcodes.contains(e.getCode())) {
                    throw e;
                }
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... GMT\u52a0\u5bc6\u6570\u5b57\u4fe1\u5c01. KeyException:{}", (Object)e.getMessage());
                this.setOffLineStatus();
            }
            catch (Throwable t) {
                if (this.isRpcException(t)) {
                    LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... GMT\u52a0\u5bc6\u6570\u5b57\u4fe1\u5c01. RpcException:{}", (Object)t.getMessage());
                    this.setOffLineStatus();
                }
                LOGGER.error("An exception occured when GMT_encryptEnvelop failed.", t);
                throw new KeyException(AksExceptionEnum.AKS_99_00053.getCode(), AksExceptionEnum.AKS_99_00053.getDesc() + t + t.getMessage());
            }
            if (cert == null || cert.length == 0) {
                recipCertB64 = this.getCert(certAliasName);
                if (recipCertB64 == null) {
                    throw new KeyException(AksExceptionEnum.AKS_99_00043.getCode(), AksExceptionEnum.AKS_99_00043.getDesc());
                }
            } else {
                recipCertB64 = this.getCertInfo(cert).getCertB64();
            }
            byte[] envelop = AKSNativeCryptoService.encryptEnvelop(recipCertB64, srcData, 3);
            String string = DatatypeConverter.printBase64Binary(envelop);
            return string;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public String encryptEnvelop(String certAliasName, byte[] cert, byte[] srcData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            String recipCertB64;
            monitorMessage.head(MY_NAME, "encryptEnvelop", this.appID, certAliasName, this.lengthOf(srcData));
            monitorMessage.tail(200, null, null);
            Preconditions.validate(certAliasName);
            Preconditions.validate(new byte[][]{srcData});
            Preconditions.checkCertAliasName(certAliasName);
            this.checkPermission();
            if (!this.aliasNameSet.contains(certAliasName)) {
                LOGGER.error("An exception occured when encryptEnvelop() check argument certAliasName permission");
                throw new KeyException(AksExceptionEnum.AKS_99_00076.getCode(), AksExceptionEnum.AKS_99_00076.getDesc() + "certAliasName = " + certAliasName);
            }
            try {
                if (this.isOnLine() && srcData.length / 3 * 4 < 9984) {
                    String string = this.cryptoDisService.encryptEnvelop(this.getTokenAndApiVersion(), this.appID, certAliasName, cert, srcData);
                    return string;
                }
            }
            catch (KeyException e) {
                if (!AKSConstant.errorcodes.contains(e.getCode())) {
                    throw e;
                }
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u52a0\u5bc6\u6570\u5b57\u4fe1\u5c01. KeyException:{}", (Object)e.getMessage());
                this.setOffLineStatus();
            }
            catch (Throwable t) {
                if (this.isRpcException(t)) {
                    LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u52a0\u5bc6\u6570\u5b57\u4fe1\u5c01. RpcException:{}", (Object)t.getMessage());
                    this.setOffLineStatus();
                }
                LOGGER.error("An exception occured when encryptEnvelop failed.", t);
                throw new KeyException(AksExceptionEnum.AKS_99_00053.getCode(), AksExceptionEnum.AKS_99_00053.getDesc() + t + t.getMessage());
            }
            if (cert == null || cert.length == 0) {
                recipCertB64 = this.getCert(certAliasName);
                if (recipCertB64 == null) {
                    throw new KeyException(AksExceptionEnum.AKS_99_00043.getCode(), AksExceptionEnum.AKS_99_00043.getDesc());
                }
            } else {
                recipCertB64 = this.getCertInfo(cert).getCertB64();
            }
            byte[] envelop = AKSNativeCryptoService.encryptEnvelop(recipCertB64, srcData, 1);
            String string = DatatypeConverter.printBase64Binary(envelop);
            return string;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public String decryptEnvelop(String certAliasName, String envelopB64) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "encryptEnvelop", this.appID, certAliasName, this.lengthOf(envelopB64));
            monitorMessage.tail(200, null, null);
            Preconditions.validate(certAliasName, envelopB64);
            Preconditions.checkIsBase64Data(envelopB64);
            Preconditions.checkCertAliasName(certAliasName);
            this.checkPermission();
            try {
                if (this.isOnLine() && envelopB64.length() < 9984) {
                    String string = this.cryptoDisService.decryptEnvelop(this.getTokenAndApiVersion(), this.appID, certAliasName, envelopB64);
                    return string;
                }
            }
            catch (KeyException e) {
                if (!AKSConstant.errorcodes.contains(e.getCode())) {
                    throw e;
                }
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u89e3\u5bc6\u6570\u5b57\u4fe1\u5c01. KeyException:{}", (Object)e.getMessage());
                this.setOffLineStatus();
            }
            catch (Throwable t) {
                if (this.isRpcException(t)) {
                    LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u89e3\u5bc6\u6570\u5b57\u4fe1\u5c01. RpcException:{}", (Object)t.getMessage());
                    this.setOffLineStatus();
                }
                LOGGER.error("An exception occured when decryptEnvelop failed.", t);
                throw new KeyException(AksExceptionEnum.AKS_99_00054.getCode(), AksExceptionEnum.AKS_99_00054.getDesc() + t + t.getMessage());
            }
            byte[] srcData = AKSNativeCryptoService.decryptEnvelop(certAliasName, envelopB64);
            String string = DatatypeConverter.printBase64Binary(srcData);
            return string;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public List<AksRet> batchEncrypt(String aliasName, List<byte[]> srcDataList) throws KeyException {
        return this.batchEncrypt(aliasName, AKSConstant.DEFAULT_MODE, CryptUtil.getPaddingByAliasName(aliasName), null, srcDataList);
    }

    public List<AksRet> batchEncrypt(String aliasName, ModeEnum mode, PaddingEnum padding, byte[] iv, List<byte[]> srcDataList) throws KeyException {
        Preconditions.validate(aliasName);
        Preconditions.validate(aliasName, mode, padding, iv);
        CipherExecutorService executorService = CipherExecutorService.getInstance();
        return executorService.execute(this, CipherOptEnum.ENCRYPT, aliasName, mode, padding, iv, srcDataList);
    }

    public List<AksRet> batchDecrypt(String aliasName, List<byte[]> envDataList) throws KeyException {
        return this.batchDecrypt(aliasName, AKSConstant.DEFAULT_MODE, CryptUtil.getPaddingByAliasName(aliasName), null, envDataList);
    }

    public List<AksRet> batchDecrypt(String aliasName, ModeEnum mode, PaddingEnum padding, byte[] iv, List<byte[]> envDataList) throws KeyException {
        Preconditions.validate(aliasName);
        Preconditions.validate(aliasName, mode, padding, iv);
        CipherExecutorService executorService = CipherExecutorService.getInstance();
        return executorService.execute(this, CipherOptEnum.DECRYPT, aliasName, mode, padding, iv, envDataList);
    }

    public Map<String, byte[]> handshakeToMobile(byte[] mobilePublicKey) {
        return this.handshakeToMobile("SIG_04_001", mobilePublicKey);
    }

    public Map<String, byte[]> handshakeToMobile(String aksKeyAliasName, byte[] mobilePublicKey) {
        return this.handshakeToMobile(aksKeyAliasName, mobilePublicKey, 1800);
    }

    public Map<String, byte[]> handshakeToMobile(String aksKeyAliasName, byte[] mobilePublicKey, int expirationInterval) {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            SecureChannel sc = new SecureChannel();
            long currentTime = sc.getCurrentTime();
            monitorMessage.head(MY_NAME, "handshakeToMobile", this.appID, aksKeyAliasName, this.lengthOf(mobilePublicKey));
            monitorMessage.tail(200, null, null);
            Preconditions.validate(new byte[][]{mobilePublicKey});
            byte[][] message = AKSNativeCryptoService.handshakeToMobile3(aksKeyAliasName, "APB_12_001", "SIG_05_001", "APB_13_001", mobilePublicKey, null, currentTime, null, expirationInterval);
            Map<String, byte[]> map = sc.addParam(message);
            return map;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public Map<String, byte[]> decodeMobileMessage(byte[] mobileMessage, byte[] digestProtectKey, int sessionExpiredTime, boolean isCheckOTP, byte[] OTPSeed, byte[] OTPSeedKey) {
        return this.decodeMoblieMessage("SIG_04_001", mobileMessage, digestProtectKey, sessionExpiredTime, isCheckOTP, OTPSeed, OTPSeedKey);
    }

    public Map<String, byte[]> decodeMoblieMessage(String aksKeyAliasName, byte[] mobileMessage, byte[] digestProtectKey, int sessionExpiredTime, boolean isCheckOTP, byte[] OTPSeed, byte[] OTPSeedKey) {
        SecureChannel sc = new SecureChannel();
        long currentTime = sc.getCurrentTime();
        if (digestProtectKey != null && digestProtectKey.length == 0) {
            digestProtectKey = null;
        }
        if (OTPSeed != null && OTPSeed.length == 0) {
            OTPSeed = null;
        }
        if (OTPSeedKey != null && OTPSeedKey.length == 0) {
            OTPSeedKey = null;
        }
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "decodeMoblieMessage", this.appID, aksKeyAliasName, this.lengthOf(mobileMessage));
            monitorMessage.tail(200, null, null);
            Preconditions.validate(new byte[][]{mobileMessage});
            byte[][] messsage = AKSNativeCryptoService.decodeMoblieMessage3(aksKeyAliasName, "APB_12_001", "SIG_05_001", "APB_13_001", mobileMessage, digestProtectKey, currentTime, sessionExpiredTime, isCheckOTP, OTPSeed, OTPSeedKey);
            Map<String, byte[]> map = sc.addParam(messsage);
            return map;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public Map<String, byte[]> encodeServerMessage(byte[] sessionInfo, byte[] serverMessage, byte[] digestProtectKey) {
        return this.encodeServerMessage("SIG_04_001", sessionInfo, serverMessage, digestProtectKey);
    }

    public Map<String, byte[]> encodeServerMessage(String aksKeyAliasName, byte[] sessionInfo, byte[] serverMessage, byte[] digestProtectKey) {
        SecureChannel sc = new SecureChannel();
        if (digestProtectKey != null && digestProtectKey.length == 0) {
            digestProtectKey = null;
        }
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "encodeServerMessage", this.appID, aksKeyAliasName, this.lengthOf(serverMessage));
            monitorMessage.tail(200, null, null);
            Preconditions.validate(sessionInfo, serverMessage);
            byte[][] message = AKSNativeCryptoService.encodeServerMessage3(aksKeyAliasName, "SIG_05_001", sessionInfo, serverMessage, digestProtectKey);
            Map<String, byte[]> map = sc.addParam(message);
            return map;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public Map<String, byte[]> sessionExpiredToMobile() {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "sessionExpiredToMobile", this.appID, null, null);
            monitorMessage.tail(200, null, null);
            SecureChannel sc = new SecureChannel();
            byte[][] message = AKSNativeCryptoService.sessionExpiredToMobile();
            Map<String, byte[]> map = sc.addParam(message);
            return map;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public Boolean setNewBankZPK(String aliasName, String bankKeyAlias, String ZPK, String ZPKCRC) throws KeyException {
        Preconditions.validate(bankKeyAlias, ZPK, ZPKCRC);
        String[] alias = bankKeyAlias.split("\\|");
        if (alias.length < 5) {
            throw new KeyException(AksExceptionEnum.AKS_99_00008.getCode(), AksExceptionEnum.AKS_99_00008.getDesc() + "alias.length < 5");
        }
        return this.cryptoDisService.setNewBankZPK(this.getTokenAndApiVersion(), this.appID, aliasName, bankKeyAlias, ZPK, ZPKCRC);
    }

    public Boolean setNewBankZAK(String aliasName, String bankZAKAlias, String ZAK, String ZAKCRC) throws KeyException {
        Preconditions.validate(bankZAKAlias, ZAK, ZAKCRC);
        String[] alias = bankZAKAlias.split("\\|");
        if (alias.length < 5) {
            throw new KeyException(AksExceptionEnum.AKS_99_00008.getCode(), AksExceptionEnum.AKS_99_00008.getDesc() + "alias.length < 5");
        }
        return this.cryptoDisService.setNewBankZAK(this.getTokenAndApiVersion(), this.appID, aliasName, bankZAKAlias, ZAK, ZAKCRC);
    }

    public String calculateMAC(String aliasName, String bankZAKAlias, String dataToMAC) throws KeyException {
        Preconditions.validate(bankZAKAlias, dataToMAC);
        Preconditions.checkDataToMAC(dataToMAC);
        String[] alias = bankZAKAlias.split("\\|");
        if (alias.length < 5) {
            throw new KeyException(AksExceptionEnum.AKS_99_00008.getCode(), AksExceptionEnum.AKS_99_00008.getDesc() + "alias.length < 5");
        }
        return this.cryptoDisService.calculateMAC(this.getTokenAndApiVersion(), this.appID, aliasName, bankZAKAlias, dataToMAC);
    }

    public Boolean verifyMAC(String aliasName, String bankZAKAlias, String dataToMAC, String MAC) throws KeyException {
        Preconditions.validate(bankZAKAlias, dataToMAC, MAC);
        Preconditions.checkDataToMAC(dataToMAC);
        String[] alias = bankZAKAlias.split("\\|");
        if (alias.length < 5) {
            throw new KeyException(AksExceptionEnum.AKS_99_00008.getCode(), AksExceptionEnum.AKS_99_00008.getDesc() + "alias.length < 5");
        }
        return this.cryptoDisService.verifyMAC(this.getTokenAndApiVersion(), this.appID, aliasName, bankZAKAlias, dataToMAC, MAC);
    }

    public String decryptoPW(String aliasName, String bankKeyAlias, String pinBlock, String pan) throws KeyException {
        Preconditions.validate(bankKeyAlias, pinBlock, pan);
        String[] alias = bankKeyAlias.split("\\|");
        if (alias.length < 5) {
            throw new KeyException(AksExceptionEnum.AKS_99_00008.getCode(), AksExceptionEnum.AKS_99_00008.getDesc() + "alias.length < 5");
        }
        return this.cryptoDisService.decryptoPW(this.getTokenAndApiVersion(), this.appID, aliasName, bankKeyAlias, pinBlock, pan);
    }

    public AKSCertInfo getCertInfo(byte[] cert) {
        return PKIHelper.getCertInfo(cert);
    }

    public String getRSAPublicKeyNByAlias(String certAliasName) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "getRSAPublicKeyNByAlias", this.appID, certAliasName, null);
            monitorMessage.tail(200, null, null);
            Preconditions.checkCertAliasName(certAliasName);
            this.checkPermission();
            String string = AKSNativeCryptoService.getPublicKeyN(certAliasName);
            return string;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    @Deprecated
    public String transEncryptUserPwd(String certAliasName, String cryptoPwd, DigestAlgEnum alg) throws KeyException {
        if (alg == null) {
            LOGGER.error("Check argument failed. alg is null");
            throw new KeyException(AksExceptionEnum.AKS_99_00001.getCode(), AksExceptionEnum.AKS_99_00001.getDesc());
        }
        Preconditions.checkCertAliasName(certAliasName);
        this.checkPermission();
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "transEncryptUserPwd", this.appID, certAliasName, this.lengthOf(cryptoPwd));
            monitorMessage.tail(200, null, null);
            byte[] pwd = AKSNativeCryptoService.privateKeyDecrypt(certAliasName, DatatypeConverter.parseBase64Binary(cryptoPwd));
            if (pwd == null) {
                throw new KeyException(AksExceptionEnum.AKS_99_00016.getCode(), AksExceptionEnum.AKS_99_00016.getDesc());
            }
            try {
                MessageDigest md = MessageDigest.getInstance(alg.getCode());
                byte[] shaData = md.digest(pwd);
                String string = DatatypeConverter.printBase64Binary(shaData);
                return string;
            }
            catch (NoSuchAlgorithmException e) {
                try {
                    throw new KeyException(AksExceptionEnum.AKS_99_00026.getCode(), AksExceptionEnum.AKS_99_00026.getDesc(), e);
                }
                catch (RuntimeException e2) {
                    monitorMessage.tail(500, e2.getClass().getName(), e2.getMessage());
                    throw e2;
                }
            }
        }
        finally {
            this.report(monitorMessage);
        }
    }

    @Deprecated
    public String transEncryptUserPwdForKeyboard(String encPW, boolean isCheckOTP, DigestAlgEnum alg) throws KeyException {
        return this.transEncryptUserPwdForKeyboard("APB_12_001", "APB_13_001", encPW, isCheckOTP, alg);
    }

    private String transEncryptUserPwdForKeyboard(String certAliasName, String sm2AliasName, String encPW, boolean isCheckOTP, DigestAlgEnum alg) throws KeyException {
        if (alg == null) {
            LOGGER.error("\u5b89\u5168\u952e\u76d8\u52a0\u5bc6\u7528\u6237\u5bc6\u7801\u8f6c\u52a0\u5bc6\u4e3aHash\u6458\u8981\u5931\u8d25. alg is null");
            throw new KeyException(AksExceptionEnum.AKS_99_00001.getCode(), AksExceptionEnum.AKS_99_00001.getDesc());
        }
        Preconditions.validate(encPW);
        this.checkPermission();
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            if (encPW.length() <= 4) {
                LOGGER.error("\u5b89\u5168\u952e\u76d8\u52a0\u5bc6\u7528\u6237\u5bc6\u7801\u8f6c\u52a0\u5bc6\u4e3aHash\u6458\u8981\u5931\u8d25. encPW is: {}", (Object)encPW);
                throw new KeyException(AksExceptionEnum.AKS_99_00008.getCode(), AksExceptionEnum.AKS_99_00008.getDesc() + "encPW.length() <= 4");
            }
            String index = encPW.substring(0, 4);
            String content = encPW.substring(4);
            if (index.charAt(0) == '1') {
                String alias;
                if (index.charAt(1) == '1') {
                    alias = sm2AliasName;
                } else if (index.charAt(1) == '0') {
                    alias = certAliasName;
                } else {
                    LOGGER.error("\u5b89\u5168\u952e\u76d8\u52a0\u5bc6\u7528\u6237\u5bc6\u7801\u8f6c\u52a0\u5bc6\u4e3aHash\u6458\u8981\u5931\u8d25. encPW is: {}", (Object)encPW);
                    throw new KeyException(AksExceptionEnum.AKS_99_00008.getCode(), AksExceptionEnum.AKS_99_00008.getDesc() + "index = " + index);
                }
                monitorMessage.head(MY_NAME, "transEncryptUserPwdForKeyboard", this.appID, certAliasName + "|" + sm2AliasName, this.lengthOf(encPW));
                monitorMessage.tail(200, null, null);
                byte[] sourcePwd = this.digestByte(alg, ByteUtil.hexStringToBytes(AKSNativeCryptoService.checkPWDForKeyboard(isCheckOTP, alias, content)));
                if (DigestAlgEnum.ALG_MD5.equals((Object)alg)) {
                    String string = ByteUtil.bytesToHexString(sourcePwd);
                    return string;
                }
                String string = DatatypeConverter.printBase64Binary(sourcePwd);
                return string;
            }
            if (index.charAt(0) == '0') {
                byte[] sourcePwd = this.digestByte(alg, content.getBytes());
                if (DigestAlgEnum.ALG_MD5.equals((Object)alg)) {
                    String string = ByteUtil.bytesToHexString(sourcePwd);
                    return string;
                }
                String string = DatatypeConverter.printBase64Binary(sourcePwd);
                return string;
            }
            try {
                LOGGER.error("\u5b89\u5168\u952e\u76d8\u52a0\u5bc6\u7528\u6237\u5bc6\u7801\u8f6c\u52a0\u5bc6\u4e3aHash\u6458\u8981\u5931\u8d25. encPW is: {}", (Object)encPW);
                throw new KeyException(AksExceptionEnum.AKS_99_00008.getCode(), AksExceptionEnum.AKS_99_00008.getDesc() + "index = " + index);
            }
            catch (Throwable t) {
                monitorMessage.tail(500, t.getClass().getName(), t.getMessage());
                LOGGER.error("\u5b89\u5168\u952e\u76d8\u52a0\u5bc6\u7528\u6237\u5bc6\u7801\u8f6c\u52a0\u5bc6\u4e3aHash\u6458\u8981\u5931\u8d25.", t);
                throw new KeyException(AksExceptionEnum.AKS_99_99999.getCode(), AksExceptionEnum.AKS_99_99999.getDesc() + t + t.getMessage());
            }
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public String getRSAPublicKeyN(String certAliasName) throws KeyException {
        String pubKeyNJson;
        Preconditions.validate(certAliasName);
        Preconditions.checkCertAliasName(certAliasName);
        this.checkPermission();
        try {
            pubKeyNJson = this.isOnLine() ? this.cryptoDisService.getRSAPublicKeyN(this.getTokenAndApiVersion(), this.appID, "rsa_04_001") : this.aksNativeGetPublicKeyN(certAliasName);
        }
        catch (KeyException k) {
            if (AKSConstant.errorcodes.contains(k.getCode())) {
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u83b7\u53d6RSA\u516c\u94a5\u7684N\u503c. KeyException:{}", (Object)k.getMessage());
                pubKeyNJson = this.aksNativeGetPublicKeyN(certAliasName);
            }
            throw k;
        }
        catch (Throwable t) {
            if (this.isRpcException(t)) {
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u83b7\u53d6RSA\u516c\u94a5\u7684N\u503c. RpcException:{}", (Object)t.getMessage());
                pubKeyNJson = this.aksNativeGetPublicKeyN(certAliasName);
            }
            LOGGER.error("An exception occured when getRSAPublicKeyN failed.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_99999.getCode(), AksExceptionEnum.AKS_99_99999.getDesc() + t + t.getMessage());
        }
        return pubKeyNJson;
    }

    private String aksNativeGetPublicKeyN(String certAliasName) {
        this.setOffLineStatus();
        String pubKeyNJson = null;
        try {
            JSON.JSONObject jsonObject = this.aksNativeGetPublicKey(certAliasName);
            pubKeyNJson = JSON.json(jsonObject);
        }
        catch (Exception e) {
            LOGGER.error("aksNativeGetPublicKeyN error.", (Throwable)e);
        }
        return pubKeyNJson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSON.JSONObject aksNativeGetPublicKey(String certAliasName) {
        JSON.JSONObject jsonObject = new JSON.JSONObject();
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "aksNativeGetPublicKey", this.appID, certAliasName, null);
            monitorMessage.tail(200, null, null);
            String pubKeyN = AKSNativeCryptoService.getPublicKeyN(certAliasName);
            String shaKey = EncryptUtil.getSHA256(certAliasName);
            jsonObject.put("pubKey", pubKeyN);
            jsonObject.put("shaKey", shaKey);
        }
        catch (Exception e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            LOGGER.error("aksNativeGetPublicKey error.", (Throwable)e);
        }
        finally {
            this.report(monitorMessage);
        }
        return jsonObject;
    }

    @Deprecated
    public List<String> encryptUserPwd(String certAliasName, String cryptoPwdB64, String shaKeyB64, String shaUserPin, String ext) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "encryptUserPwd", this.appID, certAliasName, this.lengthOf(cryptoPwdB64));
            monitorMessage.tail(200, null, null);
            Preconditions.validate(certAliasName, cryptoPwdB64, shaUserPin);
            Preconditions.checkCertAliasName(certAliasName);
            if (cryptoPwdB64.startsWith("{")) {
                try {
                    JSON.JSONObject jsonobj = (JSON.JSONObject)JSON.parse(cryptoPwdB64);
                    cryptoPwdB64 = jsonobj.getString("data");
                    String version = jsonobj.getString("version");
                    if ("2".equals(version)) {
                        shaKeyB64 = jsonobj.getString("shakey");
                    }
                }
                catch (JsonSyntaxException e) {
                    LOGGER.error("An exception occured when encryptUserPwd failed.", (Throwable)e);
                }
            }
            Preconditions.validate(shaKeyB64);
            Preconditions.checkIsBase64Data(shaKeyB64);
            this.checkPermission();
            List<String> userPwdList = null;
            if (this.isRSAOffLine(certAliasName, shaKeyB64)) {
                userPwdList = AKSNativeCryptoService.encryptPassword("rsa_04_001", certAliasName, cryptoPwdB64);
                userPwdList.add(0, "success");
            } else {
                block20: {
                    try {
                        userPwdList = this.cryptoDisService.encryptUserPwd(this.getTokenAndApiVersion(), this.appID, "rsa_04_001", shaUserPin, cryptoPwdB64, shaKeyB64, ext);
                    }
                    catch (KeyException e) {
                        if (AKSConstant.errorcodes.contains(e.getCode())) {
                            LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u7528\u6237\u5bc6\u7801\u52a0\u5bc6. KeyException:{}", (Object)e.getMessage());
                            this.setOffLineStatus();
                            try {
                                List<String> privateKey = this.cryptoDisService.getRSAPrivateKey(this.getTokenAndApiVersion(), this.appID, "rsa_04_001", shaKeyB64);
                                if (privateKey != null && privateKey.size() == 2) {
                                    String sessionkey = privateKey.get(0);
                                    String keypair = privateKey.get(1);
                                    byte[] keyBytes = AKSNativeCryptoService.crypto(false, "rsa_04_001", ModeEnum.MODE_ECB, PaddingEnum.PADDING_NOPADDING, null, DatatypeConverter.parseBase64Binary(sessionkey));
                                    byte[] keypairBytes = AKSNativeCryptoService.crypto(false, AlgEnum.ALG_AES256, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, keyBytes, null, DatatypeConverter.parseBase64Binary(keypair));
                                    userPwdList = AKSNativeCryptoService.encryptPassword_ex("rsa_04_001", keypairBytes, cryptoPwdB64);
                                }
                            }
                            catch (Exception e2) {
                                LOGGER.warn("AKS\u8f6c\u964d\u7ea7\u79bb\u7ebf\u5904\u7406 ... \u7528\u6237\u5bc6\u7801\u52a0\u5bc6. Exception:{}", (Object)e2.getMessage());
                            }
                        }
                        throw e;
                    }
                    catch (Throwable t) {
                        if (!this.isRpcException(t)) break block20;
                        LOGGER.warn("AKS\u8f6c\u964d\u7ea7\u79bb\u7ebf\u5904\u7406 ... \u7528\u6237\u5bc6\u7801\u52a0\u5bc6. RpcException:{}", (Object)t.getMessage());
                    }
                }
                if (userPwdList == null || userPwdList.isEmpty()) {
                    String nativePubKey = this.aksNativeGetPublicKeyN(certAliasName);
                    userPwdList = new ArrayList<String>();
                    userPwdList.add("fail");
                    userPwdList.add(nativePubKey);
                    monitorMessage.setExceptionMessage("fail");
                } else {
                    userPwdList.add(0, "success");
                }
            }
            List<String> list = userPwdList;
            return list;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    @Deprecated
    public List<String> verifyUserPwd(String certAliasName, String cryptoPwdB64, String shaKeyB64, String salt, String shaUserPin, String ext) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "verifyUserPwd", this.appID, certAliasName, this.lengthOf(cryptoPwdB64));
            monitorMessage.tail(200, null, null);
            Preconditions.validate(certAliasName, cryptoPwdB64, salt, shaUserPin);
            Preconditions.checkCertAliasName(certAliasName);
            if (cryptoPwdB64.startsWith("{")) {
                try {
                    JSON.JSONObject jsonobj = (JSON.JSONObject)JSON.parse(cryptoPwdB64);
                    cryptoPwdB64 = jsonobj.getString("data");
                    String version = jsonobj.getString("version");
                    if ("2".equals(version)) {
                        shaKeyB64 = jsonobj.getString("shakey");
                    }
                }
                catch (JsonSyntaxException e) {
                    LOGGER.error("An exception occured when verifyUserPwd failed.", (Throwable)e);
                }
            }
            Preconditions.validate(shaKeyB64);
            Preconditions.checkIsBase64Data(shaKeyB64);
            this.checkPermission();
            ArrayList<String> userPwdList = new ArrayList<String>();
            String userPwd = null;
            if (this.isRSAOffLine(certAliasName, shaKeyB64)) {
                userPwd = AKSNativeCryptoService.verifyPassword("rsa_04_001", certAliasName, cryptoPwdB64, salt);
                userPwdList.add("success");
                userPwdList.add(userPwd);
            } else {
                block20: {
                    try {
                        userPwd = this.cryptoDisService.verifyUserPwd(this.getTokenAndApiVersion(), this.appID, "rsa_04_001", shaUserPin, cryptoPwdB64, shaKeyB64, salt, ext);
                    }
                    catch (KeyException e) {
                        if (AKSConstant.errorcodes.contains(e.getCode())) {
                            LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u7528\u6237\u5bc6\u7801\u9a8c\u8bc1. KeyException:{}", (Object)e.getMessage());
                            this.setOffLineStatus();
                            try {
                                List<String> privateKey = this.cryptoDisService.getRSAPrivateKey(this.getTokenAndApiVersion(), this.appID, "rsa_04_001", shaKeyB64);
                                if (privateKey != null && privateKey.size() == 2) {
                                    String sessionkey = privateKey.get(0);
                                    String keypair = privateKey.get(1);
                                    byte[] keyBytes = AKSNativeCryptoService.crypto(false, "rsa_04_001", ModeEnum.MODE_ECB, PaddingEnum.PADDING_NOPADDING, null, DatatypeConverter.parseBase64Binary(sessionkey));
                                    byte[] keypairBytes = AKSNativeCryptoService.crypto(false, AlgEnum.ALG_AES256, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, keyBytes, null, DatatypeConverter.parseBase64Binary(keypair));
                                    userPwd = AKSNativeCryptoService.verifyPassword_ex("rsa_04_001", keypairBytes, cryptoPwdB64, salt);
                                    userPwdList.add("success");
                                    userPwdList.add(userPwd);
                                }
                            }
                            catch (Exception e2) {
                                LOGGER.warn("AKS\u8f6c\u964d\u7ea7\u79bb\u7ebf\u5904\u7406 ... \u7528\u6237\u5bc6\u7801\u9a8c\u8bc1. Exception:{}", (Object)e2.getMessage());
                            }
                        }
                        throw e;
                    }
                    catch (Throwable t) {
                        if (!this.isRpcException(t)) break block20;
                        LOGGER.warn("AKS\u8f6c\u964d\u7ea7\u79bb\u7ebf\u5904\u7406 ... \u7528\u6237\u5bc6\u7801\u9a8c\u8bc1. RpcException:{}", (Object)t.getMessage());
                    }
                }
                if (userPwd == null || "".equals(userPwd)) {
                    String nativePubKey = this.aksNativeGetPublicKeyN(certAliasName);
                    userPwdList.add("fail");
                    userPwdList.add(nativePubKey);
                    monitorMessage.setExceptionMessage("fail");
                } else {
                    userPwdList.add("success");
                    userPwdList.add(userPwd);
                }
            }
            ArrayList<String> arrayList = userPwdList;
            return arrayList;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    private boolean isRSAOffLine(String certAliasName, String shaKey) {
        String shaCertAliasName = EncryptUtil.getSHA256(certAliasName);
        return shaCertAliasName.equals(shaKey);
    }

    public SignPdfResponse signPdf(String certAliasName, byte[] srcPdf, byte[] signPng, float x, float y, boolean isAllSign, int page) {
        return this.signPdf(certAliasName, srcPdf, signPng, x, y, isAllSign, page, true);
    }

    public SignPdfResponse signPdf(String certAliasName, byte[] srcPdf, byte[] signPng, float x, float y, boolean isAllSign, int page, boolean requiredTimestamp) {
        Preconditions.validate(certAliasName);
        Preconditions.validate(srcPdf, signPng);
        Preconditions.checkAliasName(certAliasName);
        this.checkPermission();
        if (!FileTypeVerify.isFileType(signPng, "png")) {
            throw new KeyException(AksExceptionEnum.AKS_99_00034.getCode(), AksExceptionEnum.AKS_99_00034.getDesc());
        }
        X509Certificate x509Certificate = null;
        String certB64 = this.getAndCheckCert(certAliasName);
        if (certB64 != null) {
            x509Certificate = PKIHelper.parseCert(DatatypeConverter.parseBase64Binary(certB64));
        }
        if (x509Certificate == null) {
            throw new KeyException(AksExceptionEnum.AKS_99_00043.getCode(), AksExceptionEnum.AKS_99_00043.getDesc());
        }
        byte[] signPdf = PDFSigner.signPDF(srcPdf, signPng, certAliasName, x509Certificate, x, y, page, isAllSign, requiredTimestamp, this.tsaUrl, this.appID);
        long expireDate = x509Certificate.getNotBefore().getTime();
        LOGGER.debug("signPdf done.");
        return new SignPdfResponse(signPdf, expireDate);
    }

    public SignPdfResponse signPdf(String certAliasName, byte[] srcPdf, byte[] signPng, String signKeyWord, boolean isAllSign, int page) throws KeyException {
        return this.signPdf(certAliasName, srcPdf, signPng, signKeyWord, isAllSign, page, true);
    }

    public SignPdfResponse signPdf(String certAliasName, byte[] srcPdf, byte[] signPng, String signKeyWord, boolean isAllSign, int page, boolean requiredTimestamp) throws KeyException {
        Preconditions.validate(certAliasName, signKeyWord);
        Preconditions.validate(srcPdf, signPng);
        Preconditions.checkAliasName(certAliasName);
        this.checkPermission();
        if (!FileTypeVerify.isFileType(signPng, "png")) {
            throw new KeyException(AksExceptionEnum.AKS_99_00034.getCode(), AksExceptionEnum.AKS_99_00034.getDesc());
        }
        X509Certificate x509Certificate = null;
        String certB64 = this.getAndCheckCert(certAliasName);
        if (certB64 != null) {
            x509Certificate = PKIHelper.parseCert(DatatypeConverter.parseBase64Binary(certB64));
        }
        if (x509Certificate == null) {
            LOGGER.warn("{} isn't found public key cert.", (Object)certAliasName);
            throw new KeyException(AksExceptionEnum.AKS_99_00043.getCode(), AksExceptionEnum.AKS_99_00043.getDesc());
        }
        byte[] signPdf = PDFSigner.signPDF(srcPdf, signPng, signKeyWord, certAliasName, x509Certificate, isAllSign, page, requiredTimestamp, this.tsaUrl, this.appID);
        long expireDate = x509Certificate.getNotBefore().getTime();
        LOGGER.debug("signPdf done.");
        return new SignPdfResponse(signPdf, expireDate);
    }

    public String exportCert(String certAliasName) throws KeyException {
        Preconditions.validate(certAliasName);
        Preconditions.checkAliasName(certAliasName);
        this.checkPermission();
        CertCache cache = CacheUtil.getInstance().getCertCache(this.appID, certAliasName);
        if (cache == null || cache.getCert() == null || PKIHelper.certIsExpire(DatatypeConverter.parseBase64Binary(cache.getCert()))) {
            try {
                String cert = this.cryptoDisService.exportCert(this.getTokenAndApiVersion(), this.appID, certAliasName);
                if (cert == null || PKIHelper.certIsExpire(DatatypeConverter.parseBase64Binary(cert))) {
                    LOGGER.warn("{}\u8bc1\u4e66\u8fc7\u671f\uff0c\u91cd\u65b0\u83b7\u53d6\u8bc1\u4e66\u8fc7\u671f\u3002", (Object)certAliasName);
                    return cache == null ? cert : (cache.getCert() == null ? cert : cache.getCert());
                }
                CacheUtil.getInstance().updateCertCache(this.appID, certAliasName, cert);
                return cert;
            }
            catch (Exception e) {
                LOGGER.warn("{}\u8bc1\u4e66\u8fc7\u671f\uff0c\u91cd\u65b0\u83b7\u53d6\u65f6\u5931\u8d25\u3002 Exception: {}", (Object)certAliasName, (Object)e.getMessage());
                return cache == null ? null : cache.getCert();
            }
        }
        return cache.getCert();
    }

    public List<String> encryptEvpWithSymmString(String certAliasName, String certB64, String dataB64) throws KeyException {
        return this.encryptEvpWithSymmString(certAliasName, certB64, AKSConstant.DEFAULT_ALG, dataB64);
    }

    public List<String> encryptEvpWithSymmString(String certAliasName, String certB64, AlgEnum alg, String dataB64) throws KeyException {
        return this.encryptEvpWithSymmString(certAliasName, certB64, alg, AKSConstant.DEFAULT_MODE, null, dataB64);
    }

    public List<String> encryptEvpWithSymmString(String certAliasName, String certB64, AlgEnum alg, ModeEnum mode, byte[] iv, String dataB64) throws KeyException {
        return this.encryptEvpWithSymmString(certAliasName, certB64, alg, mode, AKSConstant.DEFAULT_PADDING, iv, dataB64);
    }

    public List<String> encryptEvpWithSymmString(String certAliasName, String certB64, AlgEnum alg, ModeEnum mode, PaddingEnum padding, byte[] iv, String dataB64) throws KeyException {
        Preconditions.validate(dataB64);
        Preconditions.checkIsBase64Data(certB64);
        byte[] data = DatatypeConverter.parseBase64Binary(dataB64);
        return this.encryptEvpWithSymm(certAliasName, certB64, alg, mode, padding, iv, data);
    }

    public List<String> encryptEvpWithSymm(String certAliasName, String certB64, byte[] data) throws KeyException {
        return this.encryptEvpWithSymm(certAliasName, certB64, AKSConstant.DEFAULT_ALG, data);
    }

    public List<String> encryptEvpWithSymm(String certAliasName, String certB64, AlgEnum alg, byte[] data) throws KeyException {
        return this.encryptEvpWithSymm(certAliasName, certB64, alg, AKSConstant.DEFAULT_MODE, null, data);
    }

    public List<String> encryptEvpWithSymm(String certAliasName, String certB64, AlgEnum alg, ModeEnum mode, byte[] iv, byte[] data) throws KeyException {
        return this.encryptEvpWithSymm(certAliasName, certB64, alg, mode, AKSConstant.DEFAULT_PADDING, iv, data);
    }

    public List<String> encryptEvpWithSymm(String certAliasName, String certB64, AlgEnum alg, ModeEnum mode, PaddingEnum padding, byte[] iv, byte[] data) throws KeyException {
        List<String> result;
        String tmp_aliasName = String.format("eee_%02d_001", CryptUtil.getAlg(alg));
        Preconditions.validate(certAliasName, certB64);
        Preconditions.validate(new byte[][]{data});
        Preconditions.checkIsBase64Data(certB64);
        Preconditions.checkAliasName(certAliasName);
        Preconditions.validate(tmp_aliasName, mode, padding, iv);
        this.checkPermission();
        try {
            if (this.isOnLine() && data.length / 3 * 4 < 9984) {
                String ivB64 = "";
                if (ModeEnum.MODE_CBC == mode && null != iv) {
                    ivB64 = DatatypeConverter.printBase64Binary(iv);
                }
                result = this.cryptoDisService.encryptEvpWithSymm(this.getTokenAndApiVersion(), this.appID, certAliasName, certB64, alg, mode, padding, ivB64, data);
            } else {
                result = this.aksNativeEncryptEvpWithSymm(certB64, alg, mode, padding, iv, data, false);
            }
        }
        catch (KeyException k) {
            if (AKSConstant.errorcodes.contains(k.getCode())) {
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u52a0\u5bc6\u5916\u5e26\u6570\u636e\u6570\u5b57\u4fe1\u5c01. KeyException:{}", (Object)k.getMessage());
                result = this.aksNativeEncryptEvpWithSymm(certB64, alg, mode, padding, iv, data, true);
            }
            throw k;
        }
        catch (Throwable t) {
            if (this.isRpcException(t)) {
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u52a0\u5bc6\u5916\u5e26\u6570\u636e\u6570\u5b57\u4fe1\u5c01. RpcException:{}", (Object)t.getMessage());
                result = this.aksNativeEncryptEvpWithSymm(certB64, alg, mode, padding, iv, data, true);
            }
            LOGGER.error("An exception occured when encrypt failed.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_00045.getCode(), AksExceptionEnum.AKS_99_00045.getDesc() + t + t.getMessage());
        }
        return result;
    }

    private List<String> aksNativeEncryptEvpWithSymm(String certB64, AlgEnum alg, ModeEnum mode, PaddingEnum padding, byte[] iv, byte[] data, boolean isOffLineStatus) {
        if (isOffLineStatus) {
            this.setOffLineStatus();
        }
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "aksNativeEncryptEvpWithSymm", this.appID, null, data.length);
            monitorMessage.tail(200, null, null);
            List<String> list = AKSNativeCryptoService.encryptEvpWithSymm(certB64, alg, mode, padding, iv, data, 1);
            return list;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public byte[] decryptEvpWithSymmString(String certAliasName, String evpB64, String dataB64) throws KeyException {
        return this.decryptEvpWithSymmString(certAliasName, AKSConstant.DEFAULT_ALG, evpB64, dataB64);
    }

    public byte[] decryptEvpWithSymmString(String certAliasName, AlgEnum alg, String evpB64, String dataB64) throws KeyException {
        return this.decryptEvpWithSymmString(certAliasName, alg, AKSConstant.DEFAULT_MODE, null, evpB64, dataB64);
    }

    public byte[] decryptEvpWithSymmString(String certAliasName, AlgEnum alg, ModeEnum mode, byte[] iv, String evpB64, String dataB64) throws KeyException {
        return this.decryptEvpWithSymmString(certAliasName, alg, mode, AKSConstant.DEFAULT_PADDING, iv, evpB64, dataB64);
    }

    public byte[] decryptEvpWithSymmString(String certAliasName, AlgEnum alg, ModeEnum mode, PaddingEnum padding, byte[] iv, String evpB64, String dataB64) throws KeyException {
        Preconditions.validate(evpB64, dataB64);
        Preconditions.checkIsBase64Data(evpB64, dataB64);
        byte[] evp = DatatypeConverter.parseBase64Binary(evpB64);
        byte[] data = DatatypeConverter.parseBase64Binary(dataB64);
        return this.decryptEvpWithSymm(certAliasName, alg, mode, padding, iv, evp, data);
    }

    public byte[] decryptEvpWithSymm(String certAliasName, byte[] evp, byte[] data) throws KeyException {
        return this.decryptEvpWithSymm(certAliasName, AKSConstant.DEFAULT_ALG, evp, data);
    }

    public byte[] decryptEvpWithSymm(String certAliasName, AlgEnum alg, byte[] evp, byte[] data) throws KeyException {
        return this.decryptEvpWithSymm(certAliasName, alg, AKSConstant.DEFAULT_MODE, null, evp, data);
    }

    public byte[] decryptEvpWithSymm(String certAliasName, AlgEnum alg, ModeEnum mode, byte[] iv, byte[] evp, byte[] data) throws KeyException {
        return this.decryptEvpWithSymm(certAliasName, alg, mode, AKSConstant.DEFAULT_PADDING, iv, evp, data);
    }

    public byte[] decryptEvpWithSymm(String certAliasName, AlgEnum alg, ModeEnum mode, PaddingEnum padding, byte[] iv, byte[] evp, byte[] data) throws KeyException {
        byte[] result;
        String tmp_aliasName = String.format("eee_%02d_001", CryptUtil.getAlg(alg));
        Preconditions.validate(certAliasName);
        Preconditions.validate(evp, data);
        Preconditions.checkAliasName(certAliasName);
        Preconditions.validate(tmp_aliasName, mode, padding, iv);
        this.checkPermission();
        try {
            if (this.isOnLine() && data.length / 3 * 4 < 9984) {
                String ivB64 = "";
                if (ModeEnum.MODE_CBC == mode && null != iv) {
                    ivB64 = DatatypeConverter.printBase64Binary(iv);
                }
                result = this.cryptoDisService.decryptEvpWithSymm(this.getTokenAndApiVersion(), this.appID, certAliasName, alg, mode, padding, ivB64, evp, data);
            } else {
                result = this.aksNativeDecryptEvpWithSymm(certAliasName, alg, mode, padding, iv, evp, data, false);
            }
        }
        catch (KeyException k) {
            if (AKSConstant.errorcodes.contains(k.getCode())) {
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u89e3\u5bc6\u5916\u5e26\u6570\u636e\u6570\u5b57\u4fe1\u5c01. KeyException:{}", (Object)k.getMessage());
                result = this.aksNativeDecryptEvpWithSymm(certAliasName, alg, mode, padding, iv, evp, data, true);
            }
            throw k;
        }
        catch (Throwable t) {
            if (this.isRpcException(t)) {
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u89e3\u5bc6\u5916\u5e26\u6570\u636e\u6570\u5b57\u4fe1\u5c01. RpcException:{}", (Object)t.getMessage());
                result = this.aksNativeDecryptEvpWithSymm(certAliasName, alg, mode, padding, iv, evp, data, true);
            }
            LOGGER.error("An exception occured when encrypt failed.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_00046.getCode(), AksExceptionEnum.AKS_99_00046.getDesc() + t + t.getMessage());
        }
        return result;
    }

    private byte[] aksNativeDecryptEvpWithSymm(String certAliasName, AlgEnum alg, ModeEnum mode, PaddingEnum padding, byte[] iv, byte[] evp, byte[] data, boolean isOffLineStatus) {
        if (isOffLineStatus) {
            this.setOffLineStatus();
        }
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "aksNativeDecryptEvpWithSymm", this.appID, certAliasName, data.length);
            monitorMessage.tail(200, null, null);
            byte[] byArray = AKSNativeCryptoService.decryptEvpWithSymm(certAliasName, alg, mode, padding, iv, evp, data);
            return byArray;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    @Deprecated
    public EncryptPWResponse cleanPW(String bizPinUuid, String pwHex) throws KeyException {
        List<String> ret;
        Preconditions.validate(bizPinUuid, pwHex);
        this.checkPermission();
        try {
            ret = this.isOnLine() ? this.cryptoDisService.cleanPW(this.getTokenAndApiVersion(), this.appID, "rsa_04_001", bizPinUuid, pwHex) : this.aksNativeCleanPW(bizPinUuid, pwHex);
        }
        catch (KeyException e) {
            if (AKSConstant.errorcodes.contains(e.getCode())) {
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u5bc6\u7801\u6e05\u6d17. KeyException:{}", (Object)e.getMessage());
                ret = this.aksNativeCleanPW(bizPinUuid, pwHex);
            }
            throw e;
        }
        catch (Throwable t) {
            if (this.isRpcException(t)) {
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u5bc6\u7801\u6e05\u6d17. RpcException:{}", (Object)t.getMessage());
                ret = this.aksNativeCleanPW(bizPinUuid, pwHex);
            }
            LOGGER.error("An exception occured when cleanPW failed.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_99999.getCode(), AksExceptionEnum.AKS_99_99999.getDesc() + t + t.getMessage());
        }
        return this.resetPWResponse(ret);
    }

    private List<String> aksNativeCleanPW(String jdpin, String pwHex) {
        this.setOffLineStatus();
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "aksNativeCleanPW", this.appID, null, null);
            monitorMessage.tail(200, null, null);
            List<String> list = AKSNativeCryptoService.cleanPW("rsa_05_001", jdpin, pwHex);
            return list;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public boolean removePW(String bizPinUuid) {
        Preconditions.validate(bizPinUuid);
        return this.cryptoDisService.removePW(this.getTokenAndApiVersion(), this.appID, bizPinUuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EncryptPWResponse resetPWAks(String certAliasName, String bizPinUuid, String jdpin, String pubKeyPW, String shaKeyB64, String behavior) throws KeyException {
        EncryptPWResponse response;
        block12: {
            Preconditions.validate(certAliasName, bizPinUuid, jdpin, pubKeyPW, shaKeyB64);
            Preconditions.checkAliasName(certAliasName);
            this.checkPermission();
            jdpin = BCConvert.qj2bj(jdpin.toLowerCase()).trim();
            MonitorMessage monitorMessage = new MonitorMessage();
            try {
                monitorMessage.head(MY_NAME, "resetPWAks", this.appID, certAliasName, null);
                monitorMessage.tail(200, null, null);
                List<String> ret = this.isRSAOffLine(certAliasName, shaKeyB64) ? AKSNativeCryptoService.resetPWAks("rsa_04_001", certAliasName, jdpin, pubKeyPW) : this.cryptoDisService.resetPWAks(this.getTokenAndApiVersion(), this.appID, "rsa_04_001", bizPinUuid, jdpin, pubKeyPW, shaKeyB64, behavior);
                response = this.resetPWResponse(ret);
            }
            catch (KeyException e) {
                if (AKSConstant.errorcodes.contains(e.getCode())) {
                    LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... AKS\u652f\u4ed8\u5bc6\u7801\u91cd\u7f6e. KeyException:{}", (Object)e.getMessage());
                    this.setOffLineStatus();
                    try {
                        List<String> privateKey = this.cryptoDisService.getRSAPrivateKey(this.getTokenAndApiVersion(), this.appID, "rsa_04_001", shaKeyB64);
                        if (privateKey != null && privateKey.size() == 2) {
                            String sessionkey = privateKey.get(0);
                            String keypair = privateKey.get(1);
                            byte[] keyBytes = AKSNativeCryptoService.crypto(false, "rsa_04_001", ModeEnum.MODE_ECB, PaddingEnum.PADDING_NOPADDING, null, DatatypeConverter.parseBase64Binary(sessionkey));
                            byte[] keypairBytes = AKSNativeCryptoService.crypto(false, AlgEnum.ALG_AES256, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, keyBytes, null, DatatypeConverter.parseBase64Binary(keypair));
                            List<String> ret = AKSNativeCryptoService.resetPWAks_ex("rsa_04_001", keypairBytes, jdpin, pubKeyPW);
                            response = this.resetPWResponse(ret);
                            break block12;
                        }
                        LOGGER.warn("AKS\u8f6c\u964d\u7ea7\u79bb\u7ebf\u5904\u7406 ... AKS\u652f\u4ed8\u5bc6\u7801\u91cd\u7f6e. ");
                        response = this.pwDegradeHandle(certAliasName);
                    }
                    catch (Exception e2) {
                        LOGGER.warn("AKS\u8f6c\u964d\u7ea7\u79bb\u7ebf\u5904\u7406 ... AKS\u652f\u4ed8\u5bc6\u7801\u91cd\u7f6e. Exception:{}", (Object)e2.getMessage());
                        response = this.pwDegradeHandle(certAliasName);
                    }
                    break block12;
                }
                throw e;
            }
            catch (Throwable t) {
                if (this.isRpcException(t)) {
                    monitorMessage.tail(500, t.getClass().getName(), t.getMessage());
                    LOGGER.warn("AKS\u8f6c\u964d\u7ea7\u79bb\u7ebf\u5904\u7406 ... AKS\u652f\u4ed8\u5bc6\u7801\u91cd\u7f6e. RpcException:" + t.getMessage());
                    response = this.pwDegradeHandle(certAliasName);
                    break block12;
                }
                monitorMessage.tail(500, t.getClass().getName(), t.getMessage());
                LOGGER.error("An exception occured when resetPWAks failed.", t);
                throw new KeyException(AksExceptionEnum.AKS_99_99999.getCode(), AksExceptionEnum.AKS_99_99999.getDesc() + t + t.getMessage());
            }
            finally {
                this.report(monitorMessage);
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EncryptPWResponse resetPWAksForSM(String certAliasName, String bizPinUuid, String jdpin, String pubKeyPW, String shaKeyB64, String behavior) throws KeyException {
        EncryptPWResponse response;
        block15: {
            Preconditions.validate(certAliasName, bizPinUuid, jdpin, pubKeyPW);
            Preconditions.checkAliasName(certAliasName);
            boolean isSM = true;
            if (CryptUtil.getAlgByAliasName(certAliasName).equals((Object)AlgEnum.ALG_RSA1024)) {
                isSM = false;
                Preconditions.validate(shaKeyB64);
            }
            this.checkPermission();
            jdpin = BCConvert.qj2bj(jdpin.toLowerCase()).trim();
            MonitorMessage monitorMessage = new MonitorMessage();
            try {
                monitorMessage.head(MY_NAME, "resetPWAksForSM", this.appID, certAliasName, null);
                monitorMessage.tail(200, null, null);
                if (isSM) {
                    Preconditions.checkAliasName(certAliasName, AlgEnum.ALG_SM2);
                    Preconditions.checkIsBase64Data(pubKeyPW);
                    byte[][] data = PKIHelper.parseSMWebData(pubKeyPW);
                    byte[] key = this.privateDecryptBytes(certAliasName, data[3]);
                    byte[] plain = this.crypto(false, AlgEnum.ALG_SM4, ModeEnum.MODE_CBC, PaddingEnum.PADDING_PKCS5, key, data[1], data[2]);
                    String sourcePwd = this.digestPrivate(DigestAlgEnum.ALG_MD5, plain);
                    response = this._resetPWMD5(bizPinUuid, jdpin, sourcePwd, "rsa_05_001");
                } else {
                    List<String> ret = this.isRSAOffLine(certAliasName, shaKeyB64) ? AKSNativeCryptoService.resetPWAks("rsa_05_001", certAliasName, jdpin, pubKeyPW) : this.cryptoDisService.resetPWAks(this.getTokenAndApiVersion(), this.appID, "rsa_05_001", bizPinUuid, jdpin, pubKeyPW, shaKeyB64, behavior);
                    response = this.resetPWResponse(ret);
                }
            }
            catch (KeyException e) {
                if (!isSM && AKSConstant.errorcodes.contains(e.getCode())) {
                    LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... AKS\u652f\u4ed8\u5bc6\u7801\u91cd\u7f6e. KeyException:{}", (Object)e.getMessage());
                    this.setOffLineStatus();
                    try {
                        List<String> privateKey = this.cryptoDisService.getRSAPrivateKey(this.getTokenAndApiVersion(), this.appID, "rsa_05_001", shaKeyB64);
                        if (privateKey != null && privateKey.size() == 2) {
                            String sessionkey = privateKey.get(0);
                            String keypair = privateKey.get(1);
                            byte[] keyBytes = AKSNativeCryptoService.crypto(false, "rsa_04_001", ModeEnum.MODE_ECB, PaddingEnum.PADDING_NOPADDING, null, DatatypeConverter.parseBase64Binary(sessionkey));
                            byte[] keypairBytes = AKSNativeCryptoService.crypto(false, AlgEnum.ALG_AES256, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, keyBytes, null, DatatypeConverter.parseBase64Binary(keypair));
                            List<String> ret = AKSNativeCryptoService.resetPWAks_ex("rsa_05_001", keypairBytes, jdpin, pubKeyPW);
                            response = this.resetPWResponse(ret);
                            break block15;
                        }
                        LOGGER.warn("AKS\u8f6c\u964d\u7ea7\u79bb\u7ebf\u5904\u7406 ... AKS\u652f\u4ed8\u5bc6\u7801\u91cd\u7f6e. ");
                        response = this.pwDegradeHandle(certAliasName);
                    }
                    catch (Exception e2) {
                        LOGGER.warn("AKS\u8f6c\u964d\u7ea7\u79bb\u7ebf\u5904\u7406 ... AKS\u652f\u4ed8\u5bc6\u7801\u91cd\u7f6e. Exception:{}", (Object)e2.getMessage());
                        response = this.pwDegradeHandle(certAliasName);
                    }
                    break block15;
                }
                monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
                LOGGER.error("An KeyException occured when resetPWAksForSM failed.", (Throwable)e);
                throw e;
            }
            catch (Throwable t) {
                if (!isSM && this.isRpcException(t)) {
                    monitorMessage.tail(500, t.getClass().getName(), t.getMessage());
                    LOGGER.warn("AKS\u8f6c\u964d\u7ea7\u79bb\u7ebf\u5904\u7406 ... AKS\u652f\u4ed8\u5bc6\u7801\u91cd\u7f6e. RpcException:" + t.getMessage());
                    response = this.pwDegradeHandle(certAliasName);
                    break block15;
                }
                monitorMessage.tail(500, t.getClass().getName(), t.getMessage());
                LOGGER.error("An exception occured when resetPWAksForSM failed.", t);
                throw new KeyException(AksExceptionEnum.AKS_99_99999.getCode(), AksExceptionEnum.AKS_99_99999.getDesc() + t + t.getMessage());
            }
            finally {
                this.report(monitorMessage);
            }
        }
        return response;
    }

    @Deprecated
    public EncryptPWResponse resetPWForKeyboard(String bizPinUuid, String jdpin, String encPW, boolean isCheckOTP) throws KeyException {
        return this._resetPWForKeyboard(bizPinUuid, jdpin, encPW, isCheckOTP, "rsa_04_001");
    }

    @Deprecated
    public EncryptPWResponse resetPWForKeyboardSM(String bizPinUuid, String jdpin, String encPW, boolean isCheckOTP) throws KeyException {
        return this._resetPWForKeyboard(bizPinUuid, jdpin, encPW, isCheckOTP, "rsa_05_001");
    }

    private EncryptPWResponse _resetPWForKeyboard(String bizPinUuid, String jdpin, String encPW, boolean isCheckOTP, String webAliasName) throws KeyException {
        Preconditions.validate(bizPinUuid, jdpin, encPW);
        this.checkPermission();
        EncryptPWResponse response = new EncryptPWResponse();
        jdpin = BCConvert.qj2bj(jdpin.toLowerCase()).trim();
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            String[] data;
            monitorMessage.head(MY_NAME, "resetPWForKeyboard", this.appID, webAliasName, null);
            monitorMessage.tail(200, null, null);
            try {
                data = KeyboardHelper.parseForKeyboard(encPW);
            }
            catch (KeyException e) {
                LOGGER.warn("AKS\u79fb\u52a8\u7aef\u5b89\u5168\u952e\u76d8\u652f\u4ed8\u5bc6\u7801\u91cd\u7f6e\u5931\u8d25. ");
                response.setSuccess(false);
                EncryptPWResponse encryptPWResponse = response;
                this.report(monitorMessage);
                return encryptPWResponse;
            }
            String alias = data[0];
            String content = data[1];
            if (data[0] == null || data[0].length() == 0) {
                String sourcePwd = this.digestPrivate(DigestAlgEnum.ALG_MD5, content.getBytes());
                response = this._resetPWMD5(bizPinUuid, jdpin, sourcePwd, webAliasName);
            } else {
                Preconditions.checkIsBase64Data(content);
                String sourcePwd = this.digestPrivate(DigestAlgEnum.ALG_MD5, ByteUtil.hexStringToBytes(AKSNativeCryptoService.checkPWDForKeyboard(isCheckOTP, alias, content)));
                response = this._resetPWMD5(bizPinUuid, jdpin, sourcePwd, webAliasName);
            }
        }
        catch (KeyException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            LOGGER.warn("AKS\u79fb\u52a8\u7aef\u5b89\u5168\u952e\u76d8\u652f\u4ed8\u5bc6\u7801\u91cd\u7f6e\u5931\u8d25. Exception:{}", (Object)e.getMessage());
            if ("AKS9920219".equals(e.getCode()) || "AKS9932002".equals(e.getCode()) || "AKS9920353".equals(e.getCode())) {
                response.setSuccess(false);
                EncryptPWResponse encryptPWResponse = response;
                return encryptPWResponse;
            }
            throw e;
        }
        catch (Throwable t) {
            monitorMessage.tail(500, t.getClass().getName(), t.getMessage());
            LOGGER.error("AKS\u79fb\u52a8\u7aef\u5b89\u5168\u952e\u76d8\u652f\u4ed8\u5bc6\u7801\u91cd\u7f6e\u5931\u8d25.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_99999.getCode(), AksExceptionEnum.AKS_99_99999.getDesc() + t + t.getMessage());
        }
        finally {
            this.report(monitorMessage);
        }
        return response;
    }

    public EncryptPWResponse resetPWForGeneralKeyboard(String bizPinUuid, String jdpin, String encPW, boolean isCheckOTP) throws KeyException {
        return this._resetPWForGeneralKeyboard(bizPinUuid, jdpin, encPW, isCheckOTP, "rsa_04_001");
    }

    public EncryptPWResponse resetPWForGeneralKeyboardSM(String bizPinUuid, String jdpin, String encPW, boolean isCheckOTP) throws KeyException {
        return this._resetPWForGeneralKeyboard(bizPinUuid, jdpin, encPW, isCheckOTP, "rsa_05_001");
    }

    private EncryptPWResponse _resetPWForGeneralKeyboard(String bizPinUuid, String jdpin, String encPW, boolean isCheckOTP, String webAliasName) throws KeyException {
        Preconditions.validate(bizPinUuid, jdpin, encPW);
        this.checkPermission();
        EncryptPWResponse response = new EncryptPWResponse();
        jdpin = BCConvert.qj2bj(jdpin.toLowerCase()).trim();
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            String[] data;
            monitorMessage.head(MY_NAME, "resetPWForGeneralKeyboard", this.appID, webAliasName, null);
            monitorMessage.tail(200, null, null);
            try {
                data = KeyboardHelper.parseForGeneralKeyboard(encPW);
            }
            catch (KeyException e) {
                LOGGER.warn("AKS\u79fb\u52a8\u7aefH5\u5b89\u5168\u952e\u76d8(\u539f\u751f&H5)\u652f\u4ed8\u5bc6\u7801\u91cd\u7f6e\u5931\u8d25. ");
                response.setSuccess(false);
                EncryptPWResponse encryptPWResponse = response;
                this.report(monitorMessage);
                return encryptPWResponse;
            }
            if (data.length == 4) {
                String aliasName = data[0];
                String pwd = data[1];
                String encPin = data[2];
                byte[] zpk = AKSNativeCryptoService.crypto(false, aliasName, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null, DatatypeConverter.parseBase64Binary(pwd));
                byte[] pinByte = AKSNativeCryptoService.crypto(false, AlgEnum.ALG_SM4, ModeEnum.MODE_ECB, PaddingEnum.PADDING_NOPADDING, zpk, null, ByteUtil.hexStringToBytes(encPin));
                String pin = ByteUtil.binaryToHexString(pinByte).replaceAll("F", "");
                String sourcePwd = this.digestPrivate(DigestAlgEnum.ALG_MD5, pin.getBytes());
                response = this._resetPWMD5(bizPinUuid, jdpin, sourcePwd, webAliasName);
            } else {
                String alias = data[0];
                String content = data[1];
                if (data[0] == null || data[0].length() == 0) {
                    String sourcePwd = this.digestPrivate(DigestAlgEnum.ALG_MD5, content.getBytes());
                    response = this._resetPWMD5(bizPinUuid, jdpin, sourcePwd, webAliasName);
                } else {
                    Preconditions.checkIsBase64Data(content);
                    if ("JS".equals(data[2])) {
                        byte[] plain;
                        if ("APB_12_001".equals(alias)) {
                            byte[] envData = DatatypeConverter.parseBase64Binary(content);
                            byte[] encKey = ByteUtil.copy(envData, 0, 256);
                            byte[] encData = ByteUtil.copy(envData, 256, envData.length - 256);
                            byte[] aesKey = AKSNativeCryptoService.privateKeyDecrypt(alias, encKey);
                            plain = AKSNativeCryptoService.crypto(false, AlgEnum.ALG_AES256, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, aesKey, null, encData);
                        } else {
                            byte[][] keyData = PKIHelper.parseSMKeyboardData(content);
                            byte[] key = this.privateDecryptBytes(alias, keyData[2]);
                            plain = this.crypto(false, AlgEnum.ALG_SM4, ModeEnum.MODE_CBC, PaddingEnum.PADDING_PKCS5, key, keyData[0], keyData[1]);
                        }
                        String sourcePwd = this.digestPrivate(DigestAlgEnum.ALG_MD5, AKSNativeCryptoService.checkOTP(isCheckOTP, plain));
                        response = this._resetPWMD5(bizPinUuid, jdpin, sourcePwd, webAliasName);
                    } else {
                        String sourcePwd = this.digestPrivate(DigestAlgEnum.ALG_MD5, ByteUtil.hexStringToBytes(AKSNativeCryptoService.checkPWDForKeyboard(isCheckOTP, alias, content)));
                        response = this._resetPWMD5(bizPinUuid, jdpin, sourcePwd, webAliasName);
                    }
                }
            }
        }
        catch (KeyException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            LOGGER.warn("AKS\u79fb\u52a8\u7aef\u5b89\u5168\u952e\u76d8\u652f\u4ed8(\u539f\u751f&H5)\u5bc6\u7801\u91cd\u7f6e\u5931\u8d25. Exception:{}", (Object)e.getMessage());
            if ("AKS9920219".equals(e.getCode()) || "AKS9932002".equals(e.getCode()) || "AKS9920353".equals(e.getCode())) {
                response.setSuccess(false);
                EncryptPWResponse encryptPWResponse = response;
                return encryptPWResponse;
            }
            throw e;
        }
        catch (Throwable t) {
            monitorMessage.tail(500, t.getClass().getName(), t.getMessage());
            LOGGER.error("AKS\u79fb\u52a8\u7aef\u5b89\u5168\u952e\u76d8(\u539f\u751f&H5)\u652f\u4ed8\u5bc6\u7801\u91cd\u7f6e\u5931\u8d25.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_99999.getCode(), AksExceptionEnum.AKS_99_99999.getDesc() + t + t.getMessage());
        }
        finally {
            this.report(monitorMessage);
        }
        return response;
    }

    public Map<String, Boolean> resetCheckPayPW(String certAliasName, String bizPinUuid, String jdpin, String pubKeyPW, String dbPW, String shaKey, String cryptSalt, String behavior, Map<String, String> cond) throws KeyException {
        Preconditions.validate(certAliasName, bizPinUuid, jdpin, pubKeyPW);
        Preconditions.checkAliasName(certAliasName);
        boolean isSM = true;
        if (CryptUtil.getAlgByAliasName(certAliasName).equals((Object)AlgEnum.ALG_RSA1024)) {
            isSM = false;
            Preconditions.validate(shaKey);
        }
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "resetCheckPayPW", this.appID, certAliasName, null);
            monitorMessage.tail(200, null, null);
            jdpin = BCConvert.qj2bj(jdpin.toLowerCase()).trim();
            HashMap<String, Boolean> result = new HashMap<String, Boolean>();
            String string = null;
            try {
                if (isSM) {
                    Preconditions.checkAliasName(certAliasName, AlgEnum.ALG_SM2);
                    Preconditions.checkIsBase64Data(pubKeyPW);
                    byte[][] data = PKIHelper.parseSMWebData(pubKeyPW);
                    byte[] byArray = this.privateDecryptBytes(certAliasName, data[3]);
                    byte[] plain = this.crypto(false, AlgEnum.ALG_SM4, ModeEnum.MODE_CBC, PaddingEnum.PADDING_PKCS5, byArray, data[1], data[2]);
                    string = this.digestPrivate(DigestAlgEnum.ALG_MD5, plain);
                } else if (this.isRSAOffLine(certAliasName, shaKey)) {
                    string = new String(AKSNativeCryptoService.privateKeyDecrypt(certAliasName, DatatypeConverter.parseBase64Binary(pubKeyPW)));
                } else {
                    List<String> privateKey = this.cryptoDisService.getRSAPrivateKey(this.getTokenAndApiVersion(), this.appID, "rsa_05_001", shaKey);
                    if (privateKey != null && privateKey.size() == 2) {
                        String keypair;
                        String string2 = privateKey.get(0);
                        byte[] bytes = AKSNativeCryptoService.decryptPW(string2, keypair = privateKey.get(1), pubKeyPW);
                        string = new String(bytes == null ? new byte[]{} : bytes);
                    }
                }
            }
            catch (Exception e) {
                string = "";
            }
            for (String string3 : cond.keySet()) {
                if (string != null && !"".equals(string)) {
                    String value = cond.get(string3);
                    if (value != null && !"".equals(value)) {
                        String digest = this.digestPrivate(DigestAlgEnum.ALG_MD5, value.getBytes());
                        result.put(string3, digest.equalsIgnoreCase(string));
                        continue;
                    }
                    result.put(string3, false);
                    continue;
                }
                result.put(string3, false);
            }
            if (dbPW == null || "".equals(dbPW) || cryptSalt == null || "".equals(cryptSalt)) {
                result.put("history_pw", false);
            } else {
                try {
                    String cryptPW = AKSNativeCryptoService.checkPWMD5("rsa_05_001", jdpin, string, cryptSalt, dbPW);
                    result.put("history_pw", dbPW.equalsIgnoreCase(cryptPW));
                }
                catch (Exception e) {
                    result.put("history_pw", false);
                }
            }
            HashMap<String, Boolean> hashMap = result;
            return hashMap;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    @Deprecated
    public EncryptPWResponse checkPWForKeyboard(String bizPinUuid, String jdpin, String encPW, String dbPW, String cryptSalt, boolean isCheckOTP) throws KeyException {
        Preconditions.validate(bizPinUuid, jdpin, encPW, dbPW, cryptSalt);
        this.checkPermission();
        EncryptPWResponse response = new EncryptPWResponse();
        jdpin = BCConvert.qj2bj(jdpin.toLowerCase()).trim();
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            String[] data;
            monitorMessage.head(MY_NAME, "checkPWForKeyboard", this.appID, null, null);
            monitorMessage.tail(200, null, null);
            try {
                data = KeyboardHelper.parseForKeyboard(encPW);
            }
            catch (KeyException e) {
                LOGGER.warn("AKS\u79fb\u52a8\u7aef\u5b89\u5168\u952e\u76d8\u652f\u4ed8\u5bc6\u7801\u9a8c\u8bc1\u5931\u8d25. ");
                response.setSuccess(false);
                EncryptPWResponse encryptPWResponse = response;
                this.report(monitorMessage);
                return encryptPWResponse;
            }
            String alias = data[0];
            String content = data[1];
            if (data[0] == null || data[0].length() == 0) {
                String sourcePwd = this.digestPrivate(DigestAlgEnum.ALG_MD5, content.getBytes());
                String needCheckEncPassword = this.checkPWMD5ByAKS(bizPinUuid, jdpin, sourcePwd, dbPW, cryptSalt, "9");
                response = this.checkPWResponse(needCheckEncPassword, dbPW, null);
            } else {
                Preconditions.checkIsBase64Data(content);
                String sourcePwd = this.digestPrivate(DigestAlgEnum.ALG_MD5, ByteUtil.hexStringToBytes(AKSNativeCryptoService.checkPWDForKeyboard(isCheckOTP, alias, content)));
                String needCheckEncPassword = this.checkPWMD5ByAKS(bizPinUuid, jdpin, sourcePwd, dbPW, cryptSalt, "9");
                response = this.checkPWResponse(needCheckEncPassword, dbPW, null);
            }
        }
        catch (KeyException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            LOGGER.warn("AKS\u79fb\u52a8\u7aef\u5b89\u5168\u952e\u76d8\u652f\u4ed8\u5bc6\u7801\u9a8c\u8bc1\u5931\u8d25. Exception:{}", (Object)e.getMessage());
            if ("AKS9920219".equals(e.getCode()) || "AKS9932002".equals(e.getCode()) || "AKS9920353".equals(e.getCode())) {
                response.setSuccess(true);
                response.setLogin(false);
                EncryptPWResponse encryptPWResponse = response;
                return encryptPWResponse;
            }
            throw e;
        }
        catch (Throwable t) {
            monitorMessage.tail(500, t.getClass().getName(), t.getMessage());
            LOGGER.error("AKS\u79fb\u52a8\u7aef\u5b89\u5168\u952e\u76d8\u652f\u4ed8\u5bc6\u7801\u9a8c\u8bc1\u5931\u8d25.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_99999.getCode(), AksExceptionEnum.AKS_99_99999.getDesc() + t + t.getMessage());
        }
        finally {
            this.report(monitorMessage);
        }
        return response;
    }

    public EncryptPWResponse checkPWForGeneralKeyboard(String bizPinUuid, String jdpin, String encPW, String dbPW, String cryptSalt, boolean isCheckOTP) throws KeyException {
        Preconditions.validate(bizPinUuid, jdpin, encPW, dbPW, cryptSalt);
        this.checkPermission();
        EncryptPWResponse response = new EncryptPWResponse();
        jdpin = BCConvert.qj2bj(jdpin.toLowerCase()).trim();
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            String[] data;
            monitorMessage.head(MY_NAME, "checkPWForGeneralKeyboard", this.appID, null, null);
            monitorMessage.tail(200, null, null);
            try {
                data = KeyboardHelper.parseForGeneralKeyboard(encPW);
            }
            catch (KeyException e) {
                LOGGER.warn("AKS\u79fb\u52a8\u7aef\u5b89\u5168\u952e\u76d8(\u539f\u751f&H5)\u652f\u4ed8\u5bc6\u7801\u9a8c\u8bc1\u5931\u8d25. ");
                response.setSuccess(false);
                EncryptPWResponse encryptPWResponse = response;
                this.report(monitorMessage);
                return encryptPWResponse;
            }
            if (data.length == 4) {
                String aliasName = data[0];
                String pwd = data[1];
                String encPin = data[2];
                byte[] zpk = AKSNativeCryptoService.crypto(false, aliasName, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null, DatatypeConverter.parseBase64Binary(pwd));
                byte[] pinByte = AKSNativeCryptoService.crypto(false, AlgEnum.ALG_SM4, ModeEnum.MODE_ECB, PaddingEnum.PADDING_NOPADDING, zpk, null, ByteUtil.hexStringToBytes(encPin));
                String pin = ByteUtil.binaryToHexString(pinByte).replaceAll("F", "");
                String sourcePwd = this.digestPrivate(DigestAlgEnum.ALG_MD5, pin.getBytes());
                String needCheckEncPassword = this.checkPWMD5ByAKS(bizPinUuid, jdpin, sourcePwd, dbPW, cryptSalt, "10");
                response = this.checkPWResponse(needCheckEncPassword, dbPW, null);
            } else {
                String alias = data[0];
                String content = data[1];
                if (data[0] == null || data[0].length() == 0) {
                    String sourcePwd = this.digestPrivate(DigestAlgEnum.ALG_MD5, content.getBytes());
                    String needCheckEncPassword = this.checkPWMD5ByAKS(bizPinUuid, jdpin, sourcePwd, dbPW, cryptSalt, "9");
                    response = this.checkPWResponse(needCheckEncPassword, dbPW, null);
                } else {
                    Preconditions.checkIsBase64Data(content);
                    if ("JS".equals(data[2])) {
                        byte[] plain;
                        if ("APB_12_001".equals(alias)) {
                            byte[] envData = DatatypeConverter.parseBase64Binary(content);
                            byte[] encKey = ByteUtil.copy(envData, 0, 256);
                            byte[] encData = ByteUtil.copy(envData, 256, envData.length - 256);
                            byte[] aesKey = AKSNativeCryptoService.privateKeyDecrypt(alias, encKey);
                            plain = AKSNativeCryptoService.crypto(false, AlgEnum.ALG_AES256, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, aesKey, null, encData);
                        } else {
                            byte[][] keyData = PKIHelper.parseSMKeyboardData(content);
                            byte[] key = this.privateDecryptBytes(alias, keyData[2]);
                            plain = this.crypto(false, AlgEnum.ALG_SM4, ModeEnum.MODE_CBC, PaddingEnum.PADDING_PKCS5, key, keyData[0], keyData[1]);
                        }
                        String sourcePwd = this.digestPrivate(DigestAlgEnum.ALG_MD5, AKSNativeCryptoService.checkOTP(isCheckOTP, plain));
                        String needCheckEncPassword = this.checkPWMD5ByAKS(bizPinUuid, jdpin, sourcePwd, dbPW, cryptSalt, "9");
                        response = this.checkPWResponse(needCheckEncPassword, dbPW, null);
                    } else {
                        String sourcePwd = this.digestPrivate(DigestAlgEnum.ALG_MD5, ByteUtil.hexStringToBytes(AKSNativeCryptoService.checkPWDForKeyboard(isCheckOTP, alias, content)));
                        String needCheckEncPassword = this.checkPWMD5ByAKS(bizPinUuid, jdpin, sourcePwd, dbPW, cryptSalt, "9");
                        response = this.checkPWResponse(needCheckEncPassword, dbPW, null);
                    }
                }
            }
        }
        catch (KeyException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            LOGGER.warn("AKS\u79fb\u52a8\u7aef\u5b89\u5168\u952e\u76d8(\u539f\u751f&H5)\u652f\u4ed8\u5bc6\u7801\u9a8c\u8bc1\u5931\u8d25. Exception:{}", (Object)e.getMessage());
            if ("AKS9920219".equals(e.getCode()) || "AKS9932002".equals(e.getCode()) || "AKS9920353".equals(e.getCode())) {
                response.setSuccess(true);
                response.setLogin(false);
                EncryptPWResponse encryptPWResponse = response;
                return encryptPWResponse;
            }
            throw e;
        }
        catch (Throwable t) {
            monitorMessage.tail(500, t.getClass().getName(), t.getMessage());
            LOGGER.error("AKS\u79fb\u52a8\u7aef\u5b89\u5168\u952e\u76d8(\u539f\u751f&H5)\u652f\u4ed8\u5bc6\u7801\u9a8c\u8bc1\u5931\u8d25.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_99999.getCode(), AksExceptionEnum.AKS_99_99999.getDesc() + t + t.getMessage());
        }
        finally {
            this.report(monitorMessage);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EncryptPWResponse checkPWAks(String certAliasName, String bizPinUuid, String jdpin, String pubKeyPW, String dbPW, String shaKeyB64, String cryptSalt, String behavior) throws KeyException {
        EncryptPWResponse response;
        block19: {
            Preconditions.validate(certAliasName, bizPinUuid, jdpin, pubKeyPW, dbPW, cryptSalt);
            Preconditions.checkAliasName(certAliasName);
            boolean isSM = true;
            if (CryptUtil.getAlgByAliasName(certAliasName).equals((Object)AlgEnum.ALG_RSA1024)) {
                isSM = false;
                Preconditions.validate(shaKeyB64);
            }
            this.checkPermission();
            jdpin = BCConvert.qj2bj(jdpin.toLowerCase()).trim();
            MonitorMessage monitorMessage = new MonitorMessage();
            try {
                monitorMessage.head(MY_NAME, "checkPWAks", this.appID, certAliasName, null);
                monitorMessage.tail(200, null, null);
                if (isSM) {
                    Preconditions.checkAliasName(certAliasName, AlgEnum.ALG_SM2);
                    Preconditions.checkIsBase64Data(pubKeyPW);
                    byte[][] data = PKIHelper.parseSMWebData(pubKeyPW);
                    byte[] key = this.privateDecryptBytes(certAliasName, data[3]);
                    byte[] plain = this.crypto(false, AlgEnum.ALG_SM4, ModeEnum.MODE_CBC, PaddingEnum.PADDING_PKCS5, key, data[1], data[2]);
                    String sourcePwd = this.digestPrivate(DigestAlgEnum.ALG_MD5, plain);
                    String needCheckEncPassword = this.checkPWMD5ByAKS(bizPinUuid, jdpin, sourcePwd, dbPW, cryptSalt, "8");
                    response = this.checkPWResponse(needCheckEncPassword, dbPW, null);
                } else if (this.isRSAOffLine(certAliasName, shaKeyB64)) {
                    String encryptedPWB64 = AKSNativeCryptoService.checkPWAks("rsa_05_001", certAliasName, jdpin, pubKeyPW, cryptSalt, dbPW);
                    response = this.checkPWResponse(encryptedPWB64, dbPW, null);
                } else {
                    List<String> ret = this.cryptoDisService.checkPWAks(this.getTokenAndApiVersion(), this.appID, "rsa_05_001", bizPinUuid, jdpin, pubKeyPW, dbPW, shaKeyB64, cryptSalt, behavior);
                    if (ret != null && ret.size() == 2) {
                        response = this.checkPWResponse(ret.get(0), dbPW, ret.get(1));
                    } else {
                        LOGGER.warn("AKS\u8f6c\u964d\u7ea7\u79bb\u7ebf\u5904\u7406 ... AKS\u652f\u4ed8\u5bc6\u7801\u9a8c\u8bc1.");
                        response = this.pwDegradeHandle(certAliasName);
                    }
                }
            }
            catch (KeyException e) {
                if (!isSM && AKSConstant.errorcodes.contains(e.getCode())) {
                    LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... AKS\u652f\u4ed8\u5bc6\u7801\u9a8c\u8bc1. KeyException:{}", (Object)e.getMessage());
                    this.setOffLineStatus();
                    try {
                        List<String> privateKey = this.cryptoDisService.getRSAPrivateKey(this.getTokenAndApiVersion(), this.appID, "rsa_05_001", shaKeyB64);
                        if (privateKey != null && privateKey.size() == 2) {
                            String sessionkey = privateKey.get(0);
                            String keypair = privateKey.get(1);
                            byte[] keyBytes = AKSNativeCryptoService.crypto(false, "rsa_04_001", ModeEnum.MODE_ECB, PaddingEnum.PADDING_NOPADDING, null, DatatypeConverter.parseBase64Binary(sessionkey));
                            byte[] keypairBytes = AKSNativeCryptoService.crypto(false, AlgEnum.ALG_AES256, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, keyBytes, null, DatatypeConverter.parseBase64Binary(keypair));
                            String encryptedPWB64 = AKSNativeCryptoService.checkPWAks_ex("rsa_05_001", keypairBytes, jdpin, pubKeyPW, cryptSalt, dbPW);
                            response = this.checkPWResponse(encryptedPWB64, dbPW, null);
                            break block19;
                        }
                        LOGGER.warn("AKS\u8f6c\u964d\u7ea7\u79bb\u7ebf\u5904\u7406 ... AKS\u652f\u4ed8\u5bc6\u7801\u9a8c\u8bc1.");
                        response = this.pwDegradeHandle(certAliasName);
                    }
                    catch (Exception e2) {
                        monitorMessage.tail(500, e2.getClass().getName(), e2.getMessage());
                        LOGGER.warn("AKS\u8f6c\u964d\u7ea7\u79bb\u7ebf\u5904\u7406 ... AKS\u652f\u4ed8\u5bc6\u7801\u9a8c\u8bc1. Exception:{}", (Object)e2.getMessage());
                        response = this.pwDegradeHandle(certAliasName);
                    }
                    break block19;
                }
                monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
                LOGGER.error("An KeyException occured when checkPWAks failed.", (Throwable)e);
                throw e;
            }
            catch (Throwable t) {
                if (!isSM && this.isRpcException(t)) {
                    monitorMessage.tail(500, t.getClass().getName(), t.getMessage());
                    LOGGER.warn("AKS\u8f6c\u964d\u7ea7\u79bb\u7ebf\u5904\u7406 ... AKS\u652f\u4ed8\u5bc6\u7801\u9a8c\u8bc1. RpcException:{}", (Object)t.getMessage());
                    response = this.pwDegradeHandle(certAliasName);
                    break block19;
                }
                monitorMessage.tail(500, t.getClass().getName(), t.getMessage());
                LOGGER.error("An exception occured when checkPWAks failed.", t);
                throw new KeyException(AksExceptionEnum.AKS_99_99999.getCode(), AksExceptionEnum.AKS_99_99999.getDesc() + t + t.getMessage());
            }
            finally {
                this.report(monitorMessage);
            }
        }
        return response;
    }

    private EncryptPWResponse pwDegradeHandle(String certAliasName) {
        this.setOffLineStatus();
        EncryptPWResponse response = new EncryptPWResponse();
        JSON.JSONObject jsonObj = this.aksNativeGetPublicKey(certAliasName);
        response.setSuccess(false);
        response.setPubKey(jsonObj.getString("pubKey"));
        response.setShaKey(jsonObj.getString("shaKey"));
        return response;
    }

    public EncryptPWResponse resetPWMD5(String bizPinUuid, String jdpin, String pwHex) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "resetPWMD5", this.appID, "", this.lengthOf(pwHex));
            monitorMessage.tail(200, null, null);
            EncryptPWResponse encryptPWResponse = this._resetPWMD5(bizPinUuid, jdpin, pwHex, "rsa_04_001");
            return encryptPWResponse;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public EncryptPWResponse resetPWMD5ForSM(String bizPinUuid, String jdpin, String pwHex) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "resetPWMD5ForSM", this.appID, "", this.lengthOf(pwHex));
            monitorMessage.tail(200, null, null);
            EncryptPWResponse encryptPWResponse = this._resetPWMD5(bizPinUuid, jdpin, pwHex, "rsa_05_001");
            return encryptPWResponse;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    private EncryptPWResponse _resetPWMD5(String bizPinUuid, String jdpin, String pwHex, String aliasName) throws KeyException {
        Preconditions.validate(bizPinUuid, jdpin, pwHex);
        this.checkPermission();
        jdpin = BCConvert.qj2bj(jdpin.toLowerCase()).trim();
        try {
            if (this.isOnLine()) {
                List<String> ret = this.cryptoDisService.resetPWMD5(this.getTokenAndApiVersion(), this.appID, aliasName, bizPinUuid, jdpin, pwHex);
                return this.resetPWResponse(ret);
            }
        }
        catch (KeyException e) {
            if (AKSConstant.errorcodes.contains(e.getCode())) {
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... MD5\u5bc6\u7801\u91cd\u7f6e. KeyException:{}", (Object)e.getMessage());
                this.setOffLineStatus();
            }
            throw e;
        }
        catch (Throwable t) {
            if (this.isRpcException(t)) {
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... MD5\u5bc6\u7801\u91cd\u7f6e. RpcException:{}", (Object)t.getMessage());
                this.setOffLineStatus();
            }
            LOGGER.error("An exception occured when resetPWMD5 failed.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_99999.getCode(), AksExceptionEnum.AKS_99_99999.getDesc() + t + t.getMessage());
        }
        List<String> ret = AKSNativeCryptoService.resetPWMD5(aliasName, jdpin, pwHex);
        return this.resetPWResponse(ret);
    }

    public EncryptPWResponse checkPWMD5(String bizPinUuid, String jdpin, String pwHex, String dbPW, String cryptSalt) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "checkPWMD5", this.appID, "", this.lengthOf(pwHex));
            monitorMessage.tail(200, null, null);
            Preconditions.validate(bizPinUuid, jdpin, pwHex, dbPW, cryptSalt);
            this.checkPermission();
            jdpin = BCConvert.qj2bj(jdpin.toLowerCase()).trim();
            if (bizPinUuid.startsWith("1_1_2_")) {
                EncryptPWResponse encryptPWResponse = this.checkMD5Des(pwHex, dbPW, bizPinUuid, jdpin, cryptSalt);
                return encryptPWResponse;
            }
            Pattern pattern = Pattern.compile("[0-9A-Fa-f]*");
            Matcher isHex = pattern.matcher(pwHex);
            if (!dbPW.startsWith("@") && !isHex.matches()) {
                EncryptPWResponse encryptPWResponse = this.checkPWResponse("", dbPW, null);
                return encryptPWResponse;
            }
            String result = this.checkPWMD5ByAKS(bizPinUuid, jdpin, pwHex, dbPW, cryptSalt, "7");
            EncryptPWResponse encryptPWResponse = this.checkPWResponse(result, dbPW, null);
            return encryptPWResponse;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public String encInputPassword(String needEncPassword, String dbPassword, String bizPinUuid, String jdpin, String cryptSalt, String pwType) {
        String result;
        try {
            String desPwd = CryptUtil.decodePwdDesType(needEncPassword);
            String md5SourcePwd = EncryptUtil.md5Hex(desPwd);
            result = this.checkPWMD5ByAKS(bizPinUuid, jdpin, md5SourcePwd, dbPassword, cryptSalt, pwType);
        }
        catch (Exception e) {
            String md5SourcePwd = needEncPassword;
            result = this.checkPWMD5ByAKS(bizPinUuid, jdpin, md5SourcePwd, dbPassword, cryptSalt, "2");
        }
        return result;
    }

    private String encInputPasswordMd5(String needEncPassword, String dbPassword, String bizPinUuid, String jdpin, String cryptSalt, String pwType) {
        return this.checkPWMD5ByAKS(bizPinUuid, jdpin, needEncPassword, dbPassword, cryptSalt, pwType);
    }

    private String encInputPasswordMagic(String needEncPassword, String dbPassword, String bizPinUuid, String jdpin, String cryptSalt, String pwType) {
        String md5SourcePwd;
        try {
            String desPwd = CryptUtil.decodePwdDesType(needEncPassword);
            md5SourcePwd = EncryptUtil.md5Hex(desPwd);
            String magicPwd = CryptUtil.decodePwdDesType(md5SourcePwd);
            md5SourcePwd = EncryptUtil.md5Hex(magicPwd);
        }
        catch (Exception e) {
            md5SourcePwd = needEncPassword;
        }
        return this.checkPWMD5ByAKS(bizPinUuid, jdpin, md5SourcePwd, dbPassword, cryptSalt, pwType);
    }

    private EncryptPWResponse checkMD5Des(String needCheckPassword, String dbPassword, String bizPinUuid, String jdpin, String cryptSalt) {
        try {
            String needCheckEncPassword = this.encInputPassword(needCheckPassword, dbPassword, bizPinUuid, jdpin, cryptSalt, "1");
            boolean checkRes = needCheckEncPassword.equalsIgnoreCase(dbPassword);
            if (checkRes) {
                return this.checkPWResponse(needCheckEncPassword, dbPassword, null);
            }
            String needCheckEncPasswordMd5 = this.encInputPasswordMd5(needCheckPassword, dbPassword, bizPinUuid, jdpin, cryptSalt, "2");
            checkRes = needCheckEncPasswordMd5.equalsIgnoreCase(dbPassword);
            if (checkRes) {
                return this.checkPWResponse(needCheckEncPasswordMd5, dbPassword, null);
            }
            String needCheckEncPasswordMagic = this.encInputPasswordMagic(needCheckPassword, dbPassword, bizPinUuid, jdpin, cryptSalt, "3");
            checkRes = needCheckEncPasswordMagic.equalsIgnoreCase(dbPassword);
            if (checkRes) {
                return this.checkPWResponse(needCheckEncPasswordMagic, dbPassword, null);
            }
            return this.checkUpLow(needCheckPassword, dbPassword, bizPinUuid, jdpin, cryptSalt);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private EncryptPWResponse checkUpLow(String needCheckPassword, String dbPassword, String bizPinUuid, String jdpin, String cryptSalt) {
        try {
            if (needCheckPassword != null && needCheckPassword.length() == 32) {
                needCheckPassword = needCheckPassword.matches("[A-Z0-9]+") ? needCheckPassword.toLowerCase() : needCheckPassword.toUpperCase();
            } else {
                return this.checkPWResponse("", dbPassword, null);
            }
            String needCheckEncPassword = this.encInputPassword(needCheckPassword, dbPassword, bizPinUuid, jdpin, cryptSalt, "4");
            boolean checkRes = needCheckEncPassword.equalsIgnoreCase(dbPassword);
            if (checkRes) {
                return this.checkPWResponse(needCheckEncPassword, dbPassword, null);
            }
            String needCheckEncPasswordMd5 = this.encInputPasswordMd5(needCheckPassword, dbPassword, bizPinUuid, jdpin, cryptSalt, "5");
            checkRes = needCheckEncPasswordMd5.equalsIgnoreCase(dbPassword);
            if (checkRes) {
                return this.checkPWResponse(needCheckEncPasswordMd5, dbPassword, null);
            }
            String needCheckEncPasswordMagic = this.encInputPasswordMagic(needCheckPassword, dbPassword, bizPinUuid, jdpin, cryptSalt, "6");
            checkRes = needCheckEncPasswordMagic.equalsIgnoreCase(dbPassword);
            if (checkRes) {
                return this.checkPWResponse(needCheckEncPasswordMagic, dbPassword, null);
            }
            return this.checkPWResponse("", dbPassword, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String checkPWMD5ByAKS(String bizPinUuid, String jdpin, String pwHex, String dbPW, String cryptSalt, String pwType) throws KeyException {
        try {
            if (this.isOnLine()) {
                return this.cryptoDisService.checkPWMD5(this.getTokenAndApiVersion(), this.appID, "rsa_05_001", bizPinUuid, jdpin, pwHex, dbPW, cryptSalt, pwType);
            }
        }
        catch (KeyException e) {
            if (AKSConstant.errorcodes.contains(e.getCode())) {
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... MD5\u5bc6\u7801\u9a8c\u8bc1. KeyException:{}", (Object)e.getMessage());
                this.setOffLineStatus();
            }
            throw e;
        }
        catch (Throwable t) {
            if (this.isRpcException(t)) {
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... MD5\u5bc6\u7801\u9a8c\u8bc1. RpcException:{}", (Object)t.getMessage());
                this.setOffLineStatus();
            }
            LOGGER.error("An exception occured when checkPWMD5 failed.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_99999.getCode(), AksExceptionEnum.AKS_99_99999.getDesc() + t + t.getMessage());
        }
        return AKSNativeCryptoService.checkPWMD5("rsa_05_001", jdpin, pwHex, cryptSalt, dbPW);
    }

    private EncryptPWResponse resetPWResponse(List<String> ret) {
        if (ret == null || ret.isEmpty()) {
            return null;
        }
        EncryptPWResponse response = new EncryptPWResponse();
        response.setSuccess(true);
        response.setCryptPW(ret.get(0));
        response.setCryptSalt(ret.get(1));
        if (ret.size() == 3) {
            response.setSecurityLevel(ret.get(2));
        }
        return response;
    }

    private EncryptPWResponse checkPWResponse(String cryptPW, String dbPW, String securityLevel) {
        EncryptPWResponse response = new EncryptPWResponse();
        response.setSuccess(true);
        response.setCryptPW(cryptPW);
        response.setLogin(dbPW.equalsIgnoreCase(cryptPW));
        if (securityLevel != null && !"".equals(securityLevel)) {
            response.setSecurityLevel(securityLevel);
        }
        return response;
    }

    public String convertEncrypt(String srcAliasName, String destAliasName, String cryptDataB64) throws KeyException {
        return this.convertEncrypt(srcAliasName, srcAliasName, destAliasName, cryptDataB64);
    }

    public String convertEncrypt(String srcAliasName, ModeEnum srcMode, PaddingEnum srcPadding, byte[] srcIV, String destAliasName, ModeEnum destMode, PaddingEnum destPadding, byte[] destIV, String cryptDataB64) throws KeyException {
        return this.convertEncrypt(srcAliasName, srcAliasName, srcMode, srcPadding, srcIV, destAliasName, destMode, destPadding, destIV, cryptDataB64);
    }

    @Deprecated
    public String convertEncrypt(String aliasName, String srcAliasName, String destAliasName, String cryptDataB64) throws KeyException {
        AlgEnum srcAlg = CryptUtil.getAlgByAliasName(srcAliasName);
        AlgEnum destAlg = CryptUtil.getAlgByAliasName(destAliasName);
        return this.convertEncrypt(aliasName, srcAliasName, AKSConstant.DEFAULT_MODE, CryptUtil.getPaddingByAlg(srcAlg), null, destAliasName, AKSConstant.DEFAULT_MODE, CryptUtil.getPaddingByAlg(destAlg), null, cryptDataB64);
    }

    @Deprecated
    public String convertEncrypt(String aliasName, String srcAliasName, ModeEnum srcMode, PaddingEnum srcPadding, byte[] srcIV, String destAliasName, ModeEnum destMode, PaddingEnum destPadding, byte[] destIV, String cryptDataB64) throws KeyException {
        String convertCryptDataB64;
        Preconditions.validate(aliasName, srcAliasName, destAliasName, cryptDataB64);
        Preconditions.checkIsBase64Data(cryptDataB64);
        Preconditions.validate(srcAliasName, srcMode, srcPadding, srcIV);
        Preconditions.validate(destAliasName, destMode, destPadding, destIV);
        this.checkPermission();
        try {
            if (PaddingEnum.PADDING_PKCS1 == srcPadding || PaddingEnum.PADDING_PKCS1 == destPadding) {
                throw new KeyException(AksExceptionEnum.AKS_99_00056.getCode(), AksExceptionEnum.AKS_99_00056.getDesc());
            }
            convertCryptDataB64 = this.cryptoDisService.convertEncrypt(this.getTokenAndApiVersion(), this.appID, aliasName, srcAliasName, srcMode, srcPadding, srcIV, destAliasName, destMode, destPadding, destIV, cryptDataB64);
        }
        catch (KeyException e) {
            throw e;
        }
        catch (Throwable t) {
            LOGGER.error("An exception occured when convertDecrypt failed.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_00055.getCode(), AksExceptionEnum.AKS_99_00055.getDesc());
        }
        return convertCryptDataB64;
    }

    public List<String> decryptoAKSWebData(String certAliasName, String aksWebData) throws KeyException {
        return this.decryptoAKSWebData(certAliasName, aksWebData, null, null);
    }

    public List<String> decryptoAKSWebData(String certAliasName, String aksWebData, String shaKeyB64) throws KeyException {
        return this.decryptoAKSWebData(certAliasName, aksWebData, shaKeyB64, null);
    }

    public List<String> decryptoAKSWebData(String certAliasName, String aksWebData, String shaKeyB64, String charsetName) throws KeyException {
        ArrayList<String> resultList;
        block22: {
            Preconditions.validate(certAliasName, aksWebData);
            Preconditions.checkCertAliasName(certAliasName);
            this.checkPermission();
            resultList = new ArrayList<String>();
            byte[] result = null;
            MonitorMessage monitorMessage = new MonitorMessage();
            try {
                block23: {
                    monitorMessage.head(MY_NAME, "decryptoAKSWebData", this.appID, certAliasName, this.lengthOf(aksWebData));
                    monitorMessage.tail(200, null, null);
                    JSON.JSONObject jsonobj = (JSON.JSONObject)JSON.parse(aksWebData);
                    String data = jsonobj.getString("data");
                    String key = jsonobj.getString("key");
                    String version = jsonobj.getString("version");
                    if ("2".equals(version)) {
                        shaKeyB64 = jsonobj.getString("shakey");
                    }
                    Preconditions.validate(shaKeyB64);
                    Preconditions.checkIsBase64Data(data);
                    Preconditions.checkIsBase64Data(key);
                    Preconditions.checkIsBase64Data(shaKeyB64);
                    if (this.isRSAOffLine(certAliasName, shaKeyB64)) {
                        result = AKSNativeCryptoService.decryptWithAsym(certAliasName, key, AlgEnum.ALG_AES256, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null, data);
                        resultList.add("success");
                        resultList.add(new String(result));
                        break block22;
                    }
                    try {
                        if (this.isOnLine()) {
                            result = this.cryptoDisService.decryptoAKSWebData(this.getTokenAndApiVersion(), this.appID, "rsa_04_001", data, key, shaKeyB64, AlgEnum.ALG_AES256, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null, "");
                        } else {
                            List<String> privateKey = this.cryptoDisService.getRSAPrivateKey(this.getTokenAndApiVersion(), this.appID, "rsa_04_001", shaKeyB64);
                            LOGGER.debug("decryptoAKSWebData.....getRSAPrivateKey result:" + (privateKey == null ? "null" : Integer.valueOf(privateKey.size())));
                            if (privateKey != null && privateKey.size() == 2) {
                                String sessionkey = privateKey.get(0);
                                String keypair = privateKey.get(1);
                                byte[] keyBytes = AKSNativeCryptoService.crypto(false, "rsa_04_001", ModeEnum.MODE_ECB, PaddingEnum.PADDING_NOPADDING, null, DatatypeConverter.parseBase64Binary(sessionkey));
                                byte[] keypairBytes = AKSNativeCryptoService.crypto(false, AlgEnum.ALG_AES256, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, keyBytes, null, DatatypeConverter.parseBase64Binary(keypair));
                                byte[] aesKey = AKSNativeCryptoService.privateKeyDecrypt(keypairBytes, DatatypeConverter.parseBase64Binary(key));
                                result = AKSNativeCryptoService.crypto(false, AlgEnum.ALG_AES256, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, aesKey, null, DatatypeConverter.parseBase64Binary(data));
                            }
                        }
                    }
                    catch (KeyException e) {
                        if (AKSConstant.errorcodes.contains(e.getCode())) {
                            LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u89e3\u5bc6AKS\u52a0\u5bc6web\u6570\u636e. KeyException:{}", (Object)e.getMessage());
                            this.setOffLineStatus();
                            try {
                                List<String> privateKey = this.cryptoDisService.getRSAPrivateKey(this.getTokenAndApiVersion(), this.appID, "rsa_04_001", shaKeyB64);
                                if (privateKey != null && privateKey.size() == 2) {
                                    String sessionkey = privateKey.get(0);
                                    String keypair = privateKey.get(1);
                                    byte[] keyBytes = AKSNativeCryptoService.crypto(false, "rsa_04_001", ModeEnum.MODE_ECB, PaddingEnum.PADDING_NOPADDING, null, DatatypeConverter.parseBase64Binary(sessionkey));
                                    byte[] keypairBytes = AKSNativeCryptoService.crypto(false, AlgEnum.ALG_AES256, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, keyBytes, null, DatatypeConverter.parseBase64Binary(keypair));
                                    byte[] aesKey = AKSNativeCryptoService.privateKeyDecrypt(keypairBytes, DatatypeConverter.parseBase64Binary(key));
                                    result = AKSNativeCryptoService.crypto(false, AlgEnum.ALG_AES256, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, aesKey, null, DatatypeConverter.parseBase64Binary(data));
                                }
                                LOGGER.warn("AKS\u8f6c\u964d\u7ea7\u79bb\u7ebf\u5904\u7406 ... \u89e3\u5bc6AKS\u52a0\u5bc6web\u6570\u636e.");
                            }
                            catch (Exception e2) {
                                LOGGER.warn("AKS\u8f6c\u964d\u7ea7\u79bb\u7ebf\u5904\u7406 ... \u89e3\u5bc6AKS\u52a0\u5bc6web\u6570\u636e. Exception:{}", (Object)e2.getMessage());
                            }
                        }
                        throw e;
                    }
                    catch (Throwable t) {
                        if (!this.isRpcException(t)) break block23;
                        LOGGER.warn("AKS\u8f6c\u964d\u7ea7\u79bb\u7ebf\u5904\u7406 ... \u89e3\u5bc6AKS\u52a0\u5bc6web\u6570\u636e. RpcException:{}", (Object)t.getMessage());
                    }
                }
                if (result == null || result.length == 0) {
                    String nativePubKey = this.aksNativeGetPublicKeyN(certAliasName);
                    resultList.add("fail");
                    resultList.add(nativePubKey);
                    monitorMessage.setExceptionMessage("fail");
                } else {
                    resultList.add("success");
                    if (charsetName == null) {
                        resultList.add(new String(result));
                    } else {
                        resultList.add(new String(result, charsetName));
                    }
                }
            }
            catch (JsonSyntaxException e1) {
                monitorMessage.tail(500, ((Object)((Object)e1)).getClass().getName(), e1.getMessage());
                LOGGER.error("An exception occured when decryptoAKSWebData failed.", (Throwable)e1);
                throw new KeyException(AksExceptionEnum.AKS_99_00057.getCode(), AksExceptionEnum.AKS_99_00057.getDesc() + (Object)((Object)e1) + e1.getMessage());
            }
            catch (Exception e) {
                monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
                LOGGER.error("An exception occured when decryptoAKSWebData failed.", (Throwable)e);
                throw new KeyException(AksExceptionEnum.AKS_99_00058.getCode(), AksExceptionEnum.AKS_99_00058.getDesc() + e + e.getMessage());
            }
            finally {
                this.report(monitorMessage);
            }
        }
        return resultList;
    }

    public String[] parseAksWebData(String aksWebData) {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            if (aksWebData != null) {
                monitorMessage.head(MY_NAME, "parseAksWebData", this.appID, null, this.lengthOf(aksWebData));
                monitorMessage.tail(200, null, null);
                if (aksWebData.contains("#")) {
                    String[] dataArray = aksWebData.split("#");
                    if (dataArray.length == 3) {
                        String aliasName = dataArray[0];
                        String pwd = dataArray[1];
                        String encPin = dataArray[2];
                        byte[] zpk = AKSNativeCryptoService.crypto(false, aliasName, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null, DatatypeConverter.parseBase64Binary(pwd));
                        byte[] pinByte = AKSNativeCryptoService.crypto(false, AlgEnum.ALG_SM4, ModeEnum.MODE_ECB, PaddingEnum.PADDING_NOPADDING, zpk, null, ByteUtil.hexStringToBytes(encPin));
                        String pin = ByteUtil.binaryToHexString(pinByte).replaceAll("F", "");
                        String sourcePwd = this.digestPrivate(DigestAlgEnum.ALG_MD5, pin.getBytes());
                        String[] stringArray = new String[]{aksWebData, sourcePwd};
                        return stringArray;
                    }
                    String[] stringArray = null;
                    return stringArray;
                }
                String[] dataArray = aksWebData.split("_");
                return dataArray;
            }
            String[] dataArray = null;
            return dataArray;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public List<String> encryptoAKSWebData(String certAliasName, String aksWebData, byte[] data) throws KeyException {
        return this.encryptoAKSWebData(certAliasName, aksWebData, null, data);
    }

    public List<String> encryptoAKSWebData(String certAliasName, String aksWebData, String shaKeyB64, byte[] data) throws KeyException {
        Preconditions.validate(certAliasName, aksWebData);
        Preconditions.checkCertAliasName(certAliasName);
        ArrayList<String> resultList = new ArrayList<String>();
        this.checkPermission();
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            block23: {
                monitorMessage.head(MY_NAME, "encryptoAKSWebData", this.appID, certAliasName, data.length);
                monitorMessage.tail(200, null, null);
                JSON.JSONObject jsonobj = (JSON.JSONObject)JSON.parse(aksWebData);
                String key = jsonobj.getString("key");
                String version = jsonobj.getString("version");
                if ("2".equals(version)) {
                    shaKeyB64 = jsonobj.getString("shakey");
                }
                Preconditions.validate(shaKeyB64);
                Preconditions.checkIsBase64Data(key);
                Preconditions.checkIsBase64Data(shaKeyB64);
                try {
                    if (this.isRSAOffLine(certAliasName, shaKeyB64)) {
                        byte[] keyBytes = AKSNativeCryptoService.privateKeyDecrypt(certAliasName, DatatypeConverter.parseBase64Binary(key));
                        byte[] encData = AKSNativeCryptoService.crypto(true, AlgEnum.ALG_AES256, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, keyBytes, null, data);
                        resultList.add("success");
                        resultList.add(DatatypeConverter.printBase64Binary(encData));
                    } else if (this.isOnLine()) {
                        byte[] encData = this.cryptoDisService.encryptoAKSWebData(this.getTokenAndApiVersion(), this.appID, "rsa_04_001", key, shaKeyB64, AlgEnum.ALG_AES256, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null, "", data);
                        if (encData != null && encData.length > 0) {
                            resultList.add("success");
                            resultList.add(DatatypeConverter.printBase64Binary(encData));
                        } else {
                            LOGGER.warn("AKS\u8f6c\u964d\u7ea7\u79bb\u7ebf\u5904\u7406 ... \u52a0\u5bc6AKS\u4fdd\u62a4web\u6570\u636e. shaKeyB64 not available:{}", (Object)shaKeyB64);
                        }
                    } else {
                        List<String> privateKey = this.cryptoDisService.getRSAPrivateKey(this.getTokenAndApiVersion(), this.appID, "rsa_04_001", shaKeyB64);
                        if (privateKey != null && privateKey.size() == 2) {
                            String sessionkey = privateKey.get(0);
                            String keypair = privateKey.get(1);
                            byte[] sessionBytes = AKSNativeCryptoService.crypto(false, "rsa_04_001", ModeEnum.MODE_ECB, PaddingEnum.PADDING_NOPADDING, null, DatatypeConverter.parseBase64Binary(sessionkey));
                            byte[] keypairBytes = AKSNativeCryptoService.crypto(false, AlgEnum.ALG_AES256, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, sessionBytes, null, DatatypeConverter.parseBase64Binary(keypair));
                            byte[] keyBytes = AKSNativeCryptoService.privateKeyDecrypt(keypairBytes, DatatypeConverter.parseBase64Binary(key));
                            byte[] encData = AKSNativeCryptoService.crypto(true, AlgEnum.ALG_AES256, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, keyBytes, null, data);
                            resultList.add("success");
                            resultList.add(DatatypeConverter.printBase64Binary(encData));
                        } else {
                            LOGGER.warn("encryptoAKSWebData.....getRSAPrivateKey error shaKeyB64:{} result:{}", (Object)shaKeyB64, privateKey == null ? "null" : Integer.valueOf(privateKey.size()));
                        }
                    }
                }
                catch (KeyException e) {
                    if (AKSConstant.errorcodes.contains(e.getCode())) {
                        LOGGER.warn("AKS\u8f6c\u964d\u7ea7\u79bb\u7ebf\u5904\u7406 ... \u52a0\u5bc6AKS\u4fdd\u62a4web\u6570\u636e. KeyException:{}", (Object)e.getMessage());
                        this.setOffLineStatus();
                        try {
                            List<String> privateKey = this.cryptoDisService.getRSAPrivateKey(this.getTokenAndApiVersion(), this.appID, "rsa_04_001", shaKeyB64);
                            if (privateKey != null && privateKey.size() == 2) {
                                String sessionkey = privateKey.get(0);
                                String keypair = privateKey.get(1);
                                byte[] sessionBytes = AKSNativeCryptoService.crypto(false, "rsa_04_001", ModeEnum.MODE_ECB, PaddingEnum.PADDING_NOPADDING, null, DatatypeConverter.parseBase64Binary(sessionkey));
                                byte[] keypairBytes = AKSNativeCryptoService.crypto(false, AlgEnum.ALG_AES256, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, sessionBytes, null, DatatypeConverter.parseBase64Binary(keypair));
                                byte[] keyBytes = AKSNativeCryptoService.privateKeyDecrypt(keypairBytes, DatatypeConverter.parseBase64Binary(key));
                                byte[] encData = AKSNativeCryptoService.crypto(true, AlgEnum.ALG_AES256, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, keyBytes, null, data);
                                resultList.add("success");
                                resultList.add(DatatypeConverter.printBase64Binary(encData));
                            }
                            LOGGER.warn("encryptoAKSWebData.....getRSAPrivateKey error shaKeyB64:{} result:{}", (Object)shaKeyB64, privateKey == null ? "null" : Integer.valueOf(privateKey.size()));
                        }
                        catch (KeyException e1) {
                            LOGGER.warn("AKS\u8f6c\u964d\u7ea7\u79bb\u7ebf\u5904\u7406 ... \u52a0\u5bc6AKS\u4fdd\u62a4web\u6570\u636e. Exception:{}", (Object)e1.getMessage());
                        }
                    }
                    throw e;
                }
                catch (Throwable t) {
                    if (!this.isRpcException(t)) break block23;
                    LOGGER.warn("AKS\u8f6c\u964d\u7ea7\u79bb\u7ebf\u5904\u7406 ... \u52a0\u5bc6AKS\u4fdd\u62a4web\u6570\u636e. RpcException:{}", (Object)t.getMessage());
                }
            }
            if (resultList.size() == 0) {
                String nativePubKey = this.aksNativeGetPublicKeyN(certAliasName);
                resultList.add("fail");
                resultList.add(nativePubKey);
                monitorMessage.setExceptionMessage("fail");
            }
        }
        catch (JsonSyntaxException e1) {
            monitorMessage.tail(500, ((Object)((Object)e1)).getClass().getName(), e1.getMessage());
            LOGGER.error("An exception occured when encryptoAKSWebData failed.", (Throwable)e1);
            throw new KeyException(AksExceptionEnum.AKS_99_00060.getCode(), AksExceptionEnum.AKS_99_00060.getDesc() + (Object)((Object)e1) + e1.getMessage());
        }
        catch (Exception e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            LOGGER.error("An exception occured when encryptoAKSWebData failed.", (Throwable)e);
            throw new KeyException(AksExceptionEnum.AKS_99_00061.getCode(), AksExceptionEnum.AKS_99_00061.getDesc() + e + e.getMessage());
        }
        finally {
            this.report(monitorMessage);
        }
        return resultList;
    }

    public String getSMPublicKeyByAlias(String certAliasName) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "getSMPublicKeyByAlias", this.appID, certAliasName, 0);
            monitorMessage.tail(200, null, null);
            Preconditions.checkAliasName(certAliasName, AlgEnum.ALG_SM2);
            CertCache cache = CacheUtil.getInstance().getCertCache(this.appID, certAliasName);
            String cert = this.getCert(certAliasName);
            if (cert == null) {
                throw new KeyException(AksExceptionEnum.AKS_99_00089.getCode(), AksExceptionEnum.AKS_99_00089.getDesc() + " alliasName: " + certAliasName);
            }
            String string = PKIHelper.getPubKeyStringForSM2(certAliasName, cert.getBytes());
            return string;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public String[] decryptoAKSWebDataForSM(String certAliasName, String aksWebData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "decryptoAKSWebDataForSM", this.appID, certAliasName, this.lengthOf(aksWebData));
            monitorMessage.tail(200, null, null);
            Preconditions.validate(certAliasName, aksWebData);
            Preconditions.checkAliasName(certAliasName, AlgEnum.ALG_SM2);
            Preconditions.checkIsBase64Data(aksWebData);
            this.checkPermission();
            byte[][] data = PKIHelper.parseSMWebData(aksWebData);
            byte[] key = this.privateDecryptBytes(certAliasName, data[3]);
            byte[] plain = this.crypto(false, AlgEnum.ALG_SM4, ModeEnum.MODE_CBC, PaddingEnum.PADDING_PKCS5, key, data[1], data[2]);
            String[] stringArray = new String[]{new String(plain), DatatypeConverter.printBase64Binary(key)};
            return stringArray;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public String encryptoAKSWebDataForSM(String certAliasName, String keyb64, byte[] srcData) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "encryptoAKSWebDataForSM", this.appID, certAliasName, srcData.length);
            monitorMessage.tail(200, null, null);
            Preconditions.validate(certAliasName, keyb64);
            Preconditions.validate(new byte[][]{srcData});
            Preconditions.checkAliasName(certAliasName, AlgEnum.ALG_SM2);
            Preconditions.checkIsBase64Data(keyb64);
            this.checkPermission();
            byte[] key = DatatypeConverter.parseBase64Binary(keyb64);
            byte[] iv = new byte[16];
            SecureRandom random = new SecureRandom();
            random.nextBytes(iv);
            byte[] result = this.crypto(true, AlgEnum.ALG_SM4, ModeEnum.MODE_CBC, PaddingEnum.PADDING_PKCS5, key, iv, srcData);
            String string = DatatypeConverter.printBase64Binary(ByteUtil.joinBytes({1, 19, 0}, iv, result));
            return string;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    private byte[] crypto(boolean isEncrypt, AlgEnum alg, ModeEnum mode, PaddingEnum padding, byte[] key, byte[] iv, byte[] Data) throws KeyException {
        try {
            if (this.isOnLine() && Data.length / 3 * 4 < 9984) {
                return this.cryptoDisService.crypto(isEncrypt, alg, mode, padding, key, iv, Data);
            }
        }
        catch (KeyException k) {
            if (!AKSConstant.errorcodes.contains(k.getCode())) {
                throw k;
            }
            LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u5bf9\u79f0\u52a0\u89e3\u5bc6. KeyException:{}", (Object)k.getMessage());
            this.setOffLineStatus();
        }
        catch (Throwable t) {
            if (this.isRpcException(t)) {
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... \u5bf9\u79f0\u52a0\u89e3\u5bc6. RpcException:{}", (Object)t.getMessage());
                this.setOffLineStatus();
            }
            LOGGER.error("An exception occured when crypto failed.", t);
            if (isEncrypt) {
                throw new KeyException(AksExceptionEnum.AKS_99_00014.getCode(), AksExceptionEnum.AKS_99_00014.getDesc() + t + t.getMessage());
            }
            throw new KeyException(AksExceptionEnum.AKS_99_00015.getCode(), AksExceptionEnum.AKS_99_00015.getDesc() + t + t.getMessage());
        }
        return AKSNativeCryptoService.crypto(isEncrypt, alg, mode, padding, key, iv, Data);
    }

    public boolean compareCiphertext(String aliasName, String aliasName1, String ciphertext1, String aliasName2, String ciphertext2) throws KeyException {
        return this.compareCiphertext(aliasName, aliasName1, AKSConstant.DEFAULT_MODE, CryptUtil.getPaddingByAliasName(aliasName1), null, ciphertext1, aliasName2, AKSConstant.DEFAULT_MODE, CryptUtil.getPaddingByAliasName(aliasName2), null, ciphertext2);
    }

    public boolean compareCiphertext(String aliasName, String aliasName1, ModeEnum mode1, PaddingEnum padding1, byte[] iv1, String ciphertext1, String aliasName2, ModeEnum mode2, PaddingEnum padding2, byte[] iv2, String ciphertext2) throws KeyException {
        Preconditions.validate(aliasName, aliasName1, ciphertext1, aliasName2, ciphertext2);
        Preconditions.checkIsBase64Data(ciphertext1, ciphertext2);
        Preconditions.validate(aliasName1, mode1, padding1, iv1);
        Preconditions.validate(aliasName2, mode2, padding2, iv2);
        this.checkPermission();
        try {
            if (PaddingEnum.PADDING_PKCS1 == padding1 || PaddingEnum.PADDING_PKCS1 == padding2) {
                throw new KeyException(AksExceptionEnum.AKS_99_00063.getCode(), AksExceptionEnum.AKS_99_00063.getDesc());
            }
            return this.cryptoDisService.compareCiphertext(this.getTokenAndApiVersion(), this.appID, aliasName, aliasName1, mode1, padding1, iv1, ciphertext1, aliasName2, mode2, padding2, iv2, ciphertext2);
        }
        catch (KeyException e) {
            throw e;
        }
        catch (Throwable t) {
            LOGGER.error("An exception occured when compareCiphertext failed.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_00062.getCode(), AksExceptionEnum.AKS_99_00062.getDesc() + t + t.getMessage());
        }
    }

    @Deprecated
    public String decryptForKeyBoard(String aksPWData, boolean isCheckOTP) throws KeyException {
        String[] data = KeyboardHelper.parseForKeyboard(aksPWData);
        if (data[0] == null || data[0].length() == 0) {
            return data[1];
        }
        Preconditions.checkIsBase64Data(data[1]);
        this.checkPermission();
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "decryptForKeyBoard", this.appID, null, this.lengthOf(aksPWData));
            monitorMessage.tail(200, null, null);
            String string = new String(ByteUtil.hexStringToBytes(AKSNativeCryptoService.checkPWDForKeyboard(isCheckOTP, data[0], data[1])));
            return string;
        }
        catch (Exception e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            LOGGER.error("\u89e3\u5bc6\u5b89\u5168\u952e\u76d8 decryptForKeyBoard \u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new KeyException(AksExceptionEnum.AKS_99_00065.getCode(), AksExceptionEnum.AKS_99_00065.getDesc() + e + e.getMessage());
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public String decryptForGeneralKeyBoard(String aksPWData, boolean isCheckOTP) throws KeyException {
        String[] data = KeyboardHelper.parseForGeneralKeyboard(aksPWData);
        if (data[0] == null || data[0].length() == 0) {
            return data[1];
        }
        this.checkPermission();
        Preconditions.checkIsBase64Data(data[1]);
        try {
            if (this.isOnLine()) {
                return new String(this.cryptoDisService.checkForGeneralKeyboard(this.getTokenAndApiVersion(), this.appID, data[0], data[1], data[2], isCheckOTP));
            }
        }
        catch (KeyException k) {
            if (!AKSConstant.errorcodes.contains(k.getCode())) {
                throw new KeyException(AksExceptionEnum.AKS_99_00065.getCode(), AksExceptionEnum.AKS_99_00065.getDesc() + "KeyException:" + k.getMessage());
            }
            LOGGER.warn("\u89e3\u5bc6\u5b89\u5168\u952e\u76d8(\u539f\u751f&H5)\u6570\u636e \u964d\u7ea7\u5904\u7406 ... KeyException:{}", (Object)k.getMessage());
            this.setOffLineStatus();
        }
        catch (Throwable t) {
            if (this.isRpcException(t)) {
                LOGGER.warn("\u89e3\u5bc6\u5b89\u5168\u952e\u76d8(\u539f\u751f&H5)\u6570\u636e \u964d\u7ea7\u5904\u7406. RpcException:{}", (Object)t.getMessage());
                this.setOffLineStatus();
            }
            LOGGER.error("An exception occured when decryptForGeneralKeyBoard failed.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_00065.getCode(), AksExceptionEnum.AKS_99_00065.getDesc() + t + t.getMessage());
        }
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "decryptForGeneralKeyBoard", this.appID, null, this.lengthOf(aksPWData));
            monitorMessage.tail(200, null, null);
            String alias = data[0];
            String content = data[1];
            if ("JS".equals(data[2])) {
                byte[] plain;
                if ("APB_12_001".equals(alias)) {
                    byte[] envData = DatatypeConverter.parseBase64Binary(content);
                    byte[] encKey = ByteUtil.copy(envData, 0, 256);
                    byte[] encData = ByteUtil.copy(envData, 256, envData.length - 256);
                    byte[] aesKey = AKSNativeCryptoService.privateKeyDecrypt(alias, encKey);
                    plain = AKSNativeCryptoService.crypto(false, AlgEnum.ALG_AES256, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, aesKey, null, encData);
                } else {
                    byte[][] keyData = PKIHelper.parseSMKeyboardData(content);
                    byte[] key = this.privateDecryptBytes(alias, keyData[2]);
                    plain = this.crypto(false, AlgEnum.ALG_SM4, ModeEnum.MODE_CBC, PaddingEnum.PADDING_PKCS5, key, keyData[0], keyData[1]);
                }
                String string = new String(AKSNativeCryptoService.checkOTP(isCheckOTP, plain));
                return string;
            }
            String string = new String(ByteUtil.hexStringToBytes(AKSNativeCryptoService.checkPWDForKeyboard(isCheckOTP, data[0], data[1])));
            return string;
        }
        catch (Exception e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            LOGGER.error("\u89e3\u5bc6\u5b89\u5168\u952e\u76d8(\u539f\u751f&H5) decryptForKeyBoard \u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new KeyException(AksExceptionEnum.AKS_99_00065.getCode(), AksExceptionEnum.AKS_99_00065.getDesc() + e + e.getMessage());
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public Map<String, Boolean> antiCheatForSdk(String dataString) {
        Preconditions.validate(dataString);
        this.checkPermission();
        try {
            if (this.isOnLine()) {
                return this.cryptoDisService.antiCheatForSdk(this.getTokenAndApiVersion(), this.appID, dataString);
            }
        }
        catch (KeyException k) {
            if (!AKSConstant.errorcodes.contains(k.getCode())) {
                throw new KeyException(AksExceptionEnum.AKS_99_00066.getCode(), AksExceptionEnum.AKS_99_00066.getDesc() + "KeyException:" + k.getMessage());
            }
            LOGGER.warn("\u5b89\u5168SDK\u53cd\u4f5c\u5f0a\u9a8c\u8bc1 \u964d\u7ea7\u5904\u7406 ... KeyException:{}", (Object)k.getMessage());
            this.setOffLineStatus();
        }
        catch (Throwable t) {
            if (this.isRpcException(t)) {
                LOGGER.warn("\u5b89\u5168SDK\u53cd\u4f5c\u5f0a\u9a8c\u8bc1 \u964d\u7ea7\u5904\u7406. RpcException:{}", (Object)t.getMessage());
                this.setOffLineStatus();
            }
            LOGGER.error("An exception occured when captchaForSdk failed.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_00066.getCode(), AksExceptionEnum.AKS_99_00066.getDesc() + t + t.getMessage());
        }
        return this.offLineAntiCheatForSdk(dataString);
    }

    private Map<String, Boolean> offLineAntiCheatForSdk(String dataString) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "offLineAntiCheatForSdk", this.appID, "APB_12_001", this.lengthOf(dataString));
            monitorMessage.tail(200, null, null);
            Map<String, Boolean> map = AKSNativeCryptoService.antiCheatForSdkJni(dataString);
            return map;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public String getSoftTokenSeed(String tokenInfo) throws KeyException {
        Preconditions.validate(tokenInfo);
        return this.cryptoDisService.getSoftTokenSeed(this.getTokenAndApiVersion(), this.appID, tokenInfo);
    }

    public boolean deleteSoftTokenSeedForAdmin(String userPin) throws KeyException {
        Preconditions.validate(userPin);
        String deleteSeed = this.cryptoDisService.deleteSoftTokenSeed(this.getTokenAndApiVersion(), this.appID, userPin);
        return Boolean.parseBoolean(deleteSeed);
    }

    public boolean deleteSoftTokenSeed(String tokenInfo) throws KeyException {
        Preconditions.validate(tokenInfo);
        String deleteSeed = this.cryptoDisService.deleteSoftTokenSeed(this.getTokenAndApiVersion(), this.appID, tokenInfo);
        return Boolean.parseBoolean(deleteSeed);
    }

    public boolean checkSoftToken(String transferInfo, String softToken) throws KeyException {
        Preconditions.validate(transferInfo, softToken);
        Preconditions.checkIsBase64Data(softToken);
        return Boolean.parseBoolean(this.cryptoDisService.checkSoftToken(this.getTokenAndApiVersion(), this.appID, transferInfo, softToken));
    }

    public boolean checkSoftTokenOTP(String userPin, String softTokenOTP) throws KeyException {
        Preconditions.validate(userPin, softTokenOTP);
        return Boolean.parseBoolean(this.cryptoDisService.checkSoftTokenOTP(this.getTokenAndApiVersion(), this.appID, userPin, softTokenOTP));
    }

    public String initPasswordForE2E(String envelope, String[] policies) throws KeyException {
        Preconditions.validate(envelope);
        Preconditions.checkIsBase64Data(envelope);
        return this.cryptoDisService.initPasswordForE2E(this.getTokenAndApiVersion(), this.appID, envelope, policies);
    }

    public boolean validatePasswordForE2E(String envelope, String credential) throws KeyException {
        Preconditions.validate(envelope, credential);
        Preconditions.checkIsBase64Data(envelope);
        return "0".equals(this.cryptoDisService.validatePasswordForE2E(this.getTokenAndApiVersion(), this.appID, envelope, credential));
    }

    public String updatePasswordForE2E(String credential, String envelopeVal, String envelopeNew, String[] policies) throws KeyException {
        Preconditions.validate(credential, envelopeVal, envelopeNew);
        Preconditions.checkIsBase64Data(envelopeVal, envelopeNew);
        return this.cryptoDisService.updatePasswordForE2E(this.getTokenAndApiVersion(), this.appID, credential, envelopeVal, envelopeNew, policies);
    }

    public String encryptWYPwdForGeneralKeyboard(String encPW, String salt, boolean isCheckOTP) throws KeyException {
        Preconditions.validate(encPW, salt);
        if (salt.length() < 16) {
            throw new KeyException(AksExceptionEnum.AKS_99_00008.getCode(), AksExceptionEnum.AKS_99_00008.getDesc() + "salt.length = " + salt.length());
        }
        this.checkPermission();
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            String[] data;
            monitorMessage.head(MY_NAME, "encryptWYPwdForGeneralKeyboard", this.appID, null, null);
            monitorMessage.tail(200, null, null);
            try {
                data = KeyboardHelper.parseForGeneralKeyboard(encPW);
            }
            catch (KeyException e) {
                LOGGER.warn("AKS\u79fb\u52a8\u7aef\u5b89\u5168\u952e\u76d8(\u539f\u751f&H5) \u751f\u6210\u7f51\u94f6\u5bc6\u7801(\u94b1\u5305\u5bc6\u7801)\u5931\u8d25. ", (Throwable)e);
                throw new KeyException(AksExceptionEnum.AKS_99_99999.getCode(), AksExceptionEnum.AKS_99_99999.getDesc() + e + e.getMessage());
            }
            if (data.length == 4) {
                String aliasName = data[0];
                String pwd = data[1];
                String encPin = data[2];
                byte[] zpk = AKSNativeCryptoService.crypto(false, aliasName, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null, DatatypeConverter.parseBase64Binary(pwd));
                byte[] pinByte = AKSNativeCryptoService.crypto(false, AlgEnum.ALG_SM4, ModeEnum.MODE_ECB, PaddingEnum.PADDING_NOPADDING, zpk, null, ByteUtil.hexStringToBytes(encPin));
                String pin = ByteUtil.binaryToHexString(pinByte).replaceAll("F", "");
                String string = this.digestPrivate(DigestAlgEnum.ALG_MD5, (pin + salt).getBytes()).toUpperCase();
                return string;
            }
            String alias = data[0];
            String content = data[1];
            if (data[0] == null || data[0].length() == 0) {
                String encPin = this.digestPrivate(DigestAlgEnum.ALG_MD5, (content + salt).getBytes()).toUpperCase();
                return encPin;
            }
            Preconditions.checkIsBase64Data(content);
            if ("JS".equals(data[2])) {
                byte[] plain;
                if ("APB_12_001".equals(alias)) {
                    byte[] envData = DatatypeConverter.parseBase64Binary(content);
                    byte[] encKey = ByteUtil.copy(envData, 0, 256);
                    byte[] encData = ByteUtil.copy(envData, 256, envData.length - 256);
                    byte[] aesKey = AKSNativeCryptoService.privateKeyDecrypt(alias, encKey);
                    plain = AKSNativeCryptoService.crypto(false, AlgEnum.ALG_AES256, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, aesKey, null, encData);
                } else {
                    byte[][] keyData = PKIHelper.parseSMKeyboardData(content);
                    byte[] key = this.privateDecryptBytes(alias, keyData[2]);
                    plain = this.crypto(false, AlgEnum.ALG_SM4, ModeEnum.MODE_CBC, PaddingEnum.PADDING_PKCS5, key, keyData[0], keyData[1]);
                }
                byte[] pin = AKSNativeCryptoService.checkOTP(isCheckOTP, plain);
                String string = this.digestPrivate(DigestAlgEnum.ALG_MD5, ByteUtil.joinBytes(pin, salt.getBytes())).toUpperCase();
                return string;
            }
            byte[] pin = ByteUtil.hexStringToBytes(AKSNativeCryptoService.checkPWDForKeyboard(isCheckOTP, alias, content));
            String string = this.digestPrivate(DigestAlgEnum.ALG_MD5, ByteUtil.joinBytes(pin, salt.getBytes())).toUpperCase();
            return string;
        }
        catch (KeyException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            LOGGER.warn("AKS\u79fb\u52a8\u7aef\u5b89\u5168\u952e\u76d8(\u539f\u751f&H5) \u751f\u6210\u7f51\u94f6\u5bc6\u7801(\u94b1\u5305\u5bc6\u7801)\u5931\u8d25. Exception:" + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable t) {
            monitorMessage.tail(500, t.getClass().getName(), t.getMessage());
            LOGGER.error("AKS\u79fb\u52a8\u7aef\u5b89\u5168\u952e\u76d8(\u539f\u751f&H5) \u751f\u6210\u7f51\u94f6\u5bc6\u7801(\u94b1\u5305\u5bc6\u7801)\u5931\u8d25.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_99999.getCode(), AksExceptionEnum.AKS_99_99999.getDesc() + t + t.getMessage());
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public Map<String, Boolean> resetCheckForGeneralKeyboard(String encPW, boolean isCheckOTP, Map<String, String> cond) throws KeyException {
        Preconditions.validate(encPW);
        this.checkPermission();
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        if (cond == null || cond.isEmpty()) {
            return result;
        }
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            String string;
            String[] data;
            monitorMessage.head(MY_NAME, "resetCheckForGeneralKeyboard", this.appID, null, null);
            monitorMessage.tail(200, null, null);
            try {
                data = KeyboardHelper.parseForGeneralKeyboard(encPW);
            }
            catch (KeyException e) {
                LOGGER.warn("AKS\u79fb\u52a8\u7aef\u5b89\u5168\u952e\u76d8(\u539f\u751f&H5) \u91cd\u7f6e\u6821\u9a8c\u5931\u8d25. ", (Throwable)e);
                throw new KeyException(AksExceptionEnum.AKS_99_99999.getCode(), AksExceptionEnum.AKS_99_99999.getDesc() + e + e.getMessage());
            }
            if (data.length == 4) {
                String aliasName = data[0];
                String pwd = data[1];
                String encPin = data[2];
                byte[] zpk = AKSNativeCryptoService.crypto(false, aliasName, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null, DatatypeConverter.parseBase64Binary(pwd));
                byte[] pinByte = AKSNativeCryptoService.crypto(false, AlgEnum.ALG_SM4, ModeEnum.MODE_ECB, PaddingEnum.PADDING_NOPADDING, zpk, null, ByteUtil.hexStringToBytes(encPin));
                string = ByteUtil.binaryToHexString(pinByte).replaceAll("F", "");
            } else {
                String alias = data[0];
                String content = data[1];
                if (data[0] == null || data[0].length() == 0) {
                    string = content;
                } else {
                    Preconditions.checkIsBase64Data(content);
                    if ("JS".equals(data[2])) {
                        byte[] plain;
                        if ("APB_12_001".equals(alias)) {
                            byte[] envData = DatatypeConverter.parseBase64Binary(content);
                            byte[] encKey = ByteUtil.copy(envData, 0, 256);
                            byte[] encData = ByteUtil.copy(envData, 256, envData.length - 256);
                            byte[] aesKey = AKSNativeCryptoService.privateKeyDecrypt(alias, encKey);
                            plain = AKSNativeCryptoService.crypto(false, AlgEnum.ALG_AES256, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, aesKey, null, encData);
                        } else {
                            byte[][] keyData = PKIHelper.parseSMKeyboardData(content);
                            byte[] key = this.privateDecryptBytes(alias, keyData[2]);
                            plain = this.crypto(false, AlgEnum.ALG_SM4, ModeEnum.MODE_CBC, PaddingEnum.PADDING_PKCS5, key, keyData[0], keyData[1]);
                        }
                        string = new String(AKSNativeCryptoService.checkOTP(isCheckOTP, plain));
                    } else {
                        string = new String(ByteUtil.hexStringToBytes(AKSNativeCryptoService.checkPWDForKeyboard(isCheckOTP, alias, content)));
                    }
                }
            }
            for (String key : cond.keySet()) {
                if (string != null && !"".equals(string)) {
                    String value = cond.get(key);
                    if (value != null && !"".equals(value)) {
                        if (value.equals(string)) {
                            result.put(key, true);
                            continue;
                        }
                        try {
                            Pattern pattern = Pattern.compile(value);
                            if (pattern.matcher(string).matches()) {
                                result.put(key, true);
                                continue;
                            }
                            result.put(key, false);
                        }
                        catch (Exception e) {
                            result.put(key, false);
                        }
                        continue;
                    }
                    result.put(key, false);
                    continue;
                }
                result.put(key, false);
            }
            HashMap<String, Boolean> hashMap = result;
            return hashMap;
        }
        catch (KeyException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            LOGGER.warn("AKS\u79fb\u52a8\u7aef\u5b89\u5168\u952e\u76d8(\u539f\u751f&H5) \u91cd\u7f6e\u6821\u9a8c\u5931\u8d25. Exception:" + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable t) {
            monitorMessage.tail(500, t.getClass().getName(), t.getMessage());
            LOGGER.error("AKS\u79fb\u52a8\u7aef\u5b89\u5168\u952e\u76d8(\u539f\u751f&H5) \u91cd\u7f6e\u6821\u9a8c\u5931\u8d25.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_99999.getCode(), AksExceptionEnum.AKS_99_99999.getDesc() + t + t.getMessage());
        }
        finally {
            this.report(monitorMessage);
        }
    }

    @Deprecated
    public byte[] getPwd(String aliasName) throws KeyException {
        Preconditions.validate(this.appID, aliasName);
        byte[] pwd = this.cryptoDisService.getPwd(this.getTokenAndApiVersion(), this.appID, aliasName);
        return this.crypto(false, AlgEnum.ALG_AES, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, DatatypeConverter.parseHexBinary(this.getToken()), null, pwd);
    }

    @Deprecated
    public byte[] p1_sign_old(String certAliasName, byte[] srcData) throws KeyException {
        byte[] result;
        Preconditions.validate(certAliasName);
        Preconditions.validate(new byte[][]{srcData});
        Preconditions.checkCertAliasName(certAliasName);
        this.checkPermission();
        byte[] data = null;
        try {
            MessageDigest md = MessageDigest.getInstance(DigestAlgEnum.ALG_SHA256.getCode());
            byte[] shaData = md.digest(srcData);
            data = ByteUtil.joinBytes(AKSConstant.HASH_PREFIX_SHA256, shaData);
            result = this.isOnLine() ? this.cryptoDisService.private_encrypt(this.getTokenAndApiVersion(), this.appID, certAliasName, data) : this.offLinePrivateKeyEncrypt(certAliasName, data);
        }
        catch (KeyException k) {
            if (AKSConstant.errorcodes.contains(k.getCode())) {
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... P1\u7b7e\u540d. KeyException:{}", (Object)k.getMessage());
                result = this.offLinePrivateKeyEncrypt(certAliasName, data);
            }
            throw k;
        }
        catch (Throwable t) {
            if (this.isRpcException(t)) {
                LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... P1\u7b7e\u540d. RpcException:{}", (Object)t.getMessage());
                result = this.offLinePrivateKeyEncrypt(certAliasName, data);
            }
            LOGGER.error("An exception occured when p1_sign failed.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_00020.getCode(), AksExceptionEnum.AKS_99_00020.getDesc() + t + t.getMessage());
        }
        return result;
    }

    private byte[] offLinePrivateKeyEncrypt(String aliasName, byte[] srcData) throws KeyException {
        this.setOffLineStatus();
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "offLinePrivateKeyEncrypt", this.appID, aliasName, srcData.length);
            monitorMessage.tail(200, null, null);
            byte[] byArray = AKSNativeCryptoService.privateKeyEncrypt(aliasName, srcData);
            return byArray;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    @Deprecated
    public boolean p1_verify_old(String certAliasName, byte[] publicKey_Cert, byte[] srcData, byte[] p1Data) throws KeyException {
        Preconditions.validate(certAliasName);
        Preconditions.validate(srcData, p1Data);
        Preconditions.checkCertAliasName(certAliasName);
        AlgEnum _alg = CryptUtil.getAlgByAliasName(certAliasName);
        Preconditions.checkEncryptedData(_alg, p1Data);
        this.checkPermission();
        try {
            byte[] deData;
            AKSCertInfo certInfo;
            if (null != publicKey_Cert && publicKey_Cert.length > 0 && null != (certInfo = this.getCertInfo(publicKey_Cert)) && certInfo.getCertResidualTime() < 0L) {
                LOGGER.error("cert has expired, {}", (Object)certInfo.getCertResidualTime());
                throw new KeyException(AksExceptionEnum.AKS_99_00032.getCode(), AksExceptionEnum.AKS_99_00032.getDesc());
            }
            if (128 != p1Data.length && 256 != p1Data.length && 512 != p1Data.length) {
                LOGGER.error("p1_verify_old\u9a8c\u7b7e\u6570\u636e\u7684\u957f\u5ea6\u9519\u8bef {}", (Object)p1Data.length);
                throw new KeyException(AksExceptionEnum.AKS_99_00021.getCode(), AksExceptionEnum.AKS_99_00021.getDesc() + p1Data.length);
            }
            try {
                deData = this.isOnLine() ? this.cryptoDisService.public_decrypt(this.getTokenAndApiVersion(), this.appID, certAliasName, publicKey_Cert, p1Data) : this.offLinePublicKeyDecrypt(certAliasName, publicKey_Cert, p1Data);
            }
            catch (KeyException k) {
                if (AKSConstant.errorcodes.contains(k.getCode())) {
                    LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... P1\u9a8c\u7b7e. KeyException:{}", (Object)k.getMessage());
                    deData = this.offLinePublicKeyDecrypt(certAliasName, publicKey_Cert, p1Data);
                }
                throw k;
            }
            catch (Throwable t) {
                if (this.isRpcException(t)) {
                    LOGGER.warn("AKS\u8f6c\u88ab\u52a8\u79bb\u7ebf\u5904\u7406 ... P1\u9a8c\u7b7e. RpcException:{}", (Object)t.getMessage());
                    deData = this.offLinePublicKeyDecrypt(certAliasName, publicKey_Cert, p1Data);
                }
                LOGGER.error("An exception occured when p1_verify failed.", t);
                throw new KeyException(AksExceptionEnum.AKS_99_00030.getCode(), AksExceptionEnum.AKS_99_00030.getDesc());
            }
            String alg = DigestAlgEnum.ALG_SHA256.getCode();
            int algPrefixLength = AKSConstant.HASH_PREFIX_SHA256_STANDARD.length;
            byte[] prefix = ByteUtil.copy(deData, 0, algPrefixLength);
            if (!Arrays.equals(prefix, AKSConstant.HASH_PREFIX_SHA256_STANDARD) && !Arrays.equals(prefix = ByteUtil.copy(deData, 0, algPrefixLength = AKSConstant.HASH_PREFIX_SHA256.length), AKSConstant.HASH_PREFIX_SHA256)) {
                alg = DigestAlgEnum.ALG_SHA1.getCode();
                algPrefixLength = AKSConstant.HASH_PREFIX_SHA1.length;
                prefix = ByteUtil.copy(deData, 0, algPrefixLength);
                if (!Arrays.equals(prefix, AKSConstant.HASH_PREFIX_SHA1)) {
                    alg = DigestAlgEnum.ALG_MD5.getCode();
                    algPrefixLength = AKSConstant.HASH_PREFIX_MD5.length;
                    prefix = ByteUtil.copy(deData, 0, algPrefixLength);
                    if (!Arrays.equals(prefix, AKSConstant.HASH_PREFIX_MD5)) {
                        LOGGER.error("p1_verify\u9a8c\u7b7e\u9519\u8bef\uff0c\u4e0d\u652f\u6301\u7684Hash\u7c7b\u578b ");
                        throw new KeyException(AksExceptionEnum.AKS_99_00022.getCode(), AksExceptionEnum.AKS_99_00022.getDesc());
                    }
                }
            }
            MessageDigest md = MessageDigest.getInstance(alg);
            byte[] shaData = md.digest(srcData);
            byte[] retData = ByteUtil.copy(deData, algPrefixLength, deData.length - algPrefixLength);
            boolean result = Arrays.equals(shaData, retData);
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyException(AksExceptionEnum.AKS_99_00026.getCode(), AksExceptionEnum.AKS_99_00026.getDesc(), e);
        }
    }

    private byte[] offLinePublicKeyDecrypt(String aliasName, byte[] cert, byte[] srcData) throws KeyException {
        this.setOffLineStatus();
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "offLinePublicKeyDecrypt", this.appID, aliasName, srcData.length);
            monitorMessage.tail(200, null, null);
            byte[] byArray = AKSNativeCryptoService.publicKeyDecrypt(aliasName, cert, srcData);
            return byArray;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    @Deprecated
    public EncryptPWResponse encryptUserPwdForSHA1_24(String SHA1_24) throws KeyException {
        Preconditions.validate(SHA1_24);
        Preconditions.checkIsBase64Data(SHA1_24);
        this.checkPermission();
        EncryptPWResponse response = new EncryptPWResponse();
        try {
            byte[] salt = new byte[32];
            SecureRandom random = new SecureRandom();
            random.nextBytes(salt);
            byte[] enSalt = AKSNativeCryptoService.crypto(true, "rsa_04_001", ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null, salt);
            byte[] keys = this.digestByte(DigestAlgEnum.ALG_SHA256, ByteUtil.joinBytes(SHA1_24.getBytes(), salt));
            byte[] pw = AKSNativeCryptoService.crypto(true, "rsa_04_001", ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null, keys);
            response.setSuccess(true);
            response.setCryptPW(DatatypeConverter.printBase64Binary(pw));
            response.setCryptSalt(DatatypeConverter.printBase64Binary(enSalt));
        }
        catch (Exception e) {
            LOGGER.error("\u7528\u6237\u5bc6\u7801\u52a0\u5bc6(\u7528\u4e8e\u5bc6\u7801\u6ce8\u518c\u6216\u91cd\u7f6e\u670d\u52a1) encryptUserPwdForSHA1_24  \u5931\u8d25\uff1a{}", (Object)e.getMessage());
            response.setSuccess(false);
        }
        return response;
    }

    @Deprecated
    public EncryptPWResponse verifyUserPwdForSHA1_24(String SHA1_24, String dbPW, String dbSalt) throws KeyException {
        Preconditions.validate(SHA1_24, dbPW, dbSalt);
        Preconditions.checkIsBase64Data(SHA1_24, dbSalt);
        this.checkPermission();
        try {
            byte[] salt = AKSNativeCryptoService.crypto(false, "rsa_04_001", ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null, DatatypeConverter.parseBase64Binary(dbSalt));
            byte[] keys = this.digestByte(DigestAlgEnum.ALG_SHA256, ByteUtil.joinBytes(SHA1_24.getBytes(), salt));
            byte[] pw = AKSNativeCryptoService.crypto(true, "rsa_04_001", ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null, keys);
            return this.checkPWResponse(DatatypeConverter.printBase64Binary(pw), dbPW, null);
        }
        catch (Exception e) {
            LOGGER.error("\u7528\u6237\u5bc6\u7801\u9a8c\u8bc1verifyUserPwdForSHA1_24 \u5931\u8d25 \uff1a{}", (Object)e.getMessage());
            return this.checkPWResponse("", dbPW, null);
        }
    }

    @Deprecated
    public EncryptPWResponse encryptUserPwdForSHA1_JS(String certAliasName, String cryptoPwdB64, String shaKeyB64) throws KeyException {
        Preconditions.validate(certAliasName, cryptoPwdB64);
        this.checkPermission();
        EncryptPWResponse response = new EncryptPWResponse();
        try {
            String SHA1 = null;
            if (cryptoPwdB64.startsWith("{")) {
                JSON.JSONObject jsonobj = (JSON.JSONObject)JSON.parse(cryptoPwdB64);
                cryptoPwdB64 = jsonobj.getString("data");
                String version = jsonobj.getString("version");
                if ("2".equals(version)) {
                    shaKeyB64 = jsonobj.getString("shakey");
                }
            }
            Preconditions.validate(shaKeyB64);
            Preconditions.checkIsBase64Data(shaKeyB64);
            if (this.isRSAOffLine(certAliasName, shaKeyB64)) {
                byte[] result = AKSNativeCryptoService.privateKeyDecrypt(certAliasName, DatatypeConverter.parseBase64Binary(cryptoPwdB64));
                SHA1 = this.digestPrivate(DigestAlgEnum.ALG_SHA1, result);
            } else {
                List<String> privateKey = this.cryptoDisService.getRSAPrivateKey(this.getTokenAndApiVersion(), this.appID, "rsa_04_001", shaKeyB64);
                if (privateKey != null && privateKey.size() == 2) {
                    String sessionkey = privateKey.get(0);
                    String keypair = privateKey.get(1);
                    byte[] keyBytes = AKSNativeCryptoService.crypto(false, "rsa_04_001", ModeEnum.MODE_ECB, PaddingEnum.PADDING_NOPADDING, null, DatatypeConverter.parseBase64Binary(sessionkey));
                    byte[] keypairBytes = AKSNativeCryptoService.crypto(false, AlgEnum.ALG_AES256, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, keyBytes, null, DatatypeConverter.parseBase64Binary(keypair));
                    byte[] result = AKSNativeCryptoService.privateKeyDecrypt(keypairBytes, DatatypeConverter.parseBase64Binary(cryptoPwdB64));
                    SHA1 = this.digestPrivate(DigestAlgEnum.ALG_SHA1, result);
                }
            }
            if (SHA1 != null) {
                String SHA1_24 = DatatypeConverter.printBase64Binary(ByteUtil.hexStringToBytes(SHA1)).substring(0, 24);
                byte[] salt = new byte[32];
                SecureRandom random = new SecureRandom();
                random.nextBytes(salt);
                byte[] enSalt = AKSNativeCryptoService.crypto(true, "rsa_04_001", ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null, salt);
                byte[] keys = this.digestByte(DigestAlgEnum.ALG_SHA256, ByteUtil.joinBytes(SHA1_24.getBytes(), salt));
                byte[] pw = AKSNativeCryptoService.crypto(true, "rsa_04_001", ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null, keys);
                response.setSuccess(true);
                response.setCryptPW(DatatypeConverter.printBase64Binary(pw));
                response.setCryptSalt(DatatypeConverter.printBase64Binary(enSalt));
                response.setSha1(DatatypeConverter.printBase64Binary(ByteUtil.hexStringToBytes(SHA1)));
            } else {
                response.setSuccess(false);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u7528\u6237\u5bc6\u7801\u52a0\u5bc6(\u7528\u4e8e\u5bc6\u7801\u6ce8\u518c\u6216\u91cd\u7f6e\u670d\u52a1)encryptUserPwdForSHA1_JS \u5931\u8d25 \uff1a{}", (Object)e.getMessage());
            response.setSuccess(false);
        }
        return response;
    }

    @Deprecated
    public EncryptPWResponse verifyUserPwdForSHA1_JS(String certAliasName, String cryptoPwdB64, String shaKeyB64, String dbPW, String dbSalt) throws KeyException {
        Preconditions.validate(certAliasName, cryptoPwdB64, dbPW, dbSalt);
        this.checkPermission();
        try {
            String SHA1 = null;
            if (cryptoPwdB64.startsWith("{")) {
                JSON.JSONObject jsonobj = (JSON.JSONObject)JSON.parse(cryptoPwdB64);
                cryptoPwdB64 = jsonobj.getString("data");
                String version = jsonobj.getString("version");
                if ("2".equals(version)) {
                    shaKeyB64 = jsonobj.getString("shakey");
                }
            }
            Preconditions.validate(shaKeyB64);
            Preconditions.checkIsBase64Data(shaKeyB64, dbSalt);
            if (this.isRSAOffLine(certAliasName, shaKeyB64)) {
                byte[] result = AKSNativeCryptoService.privateKeyDecrypt(certAliasName, DatatypeConverter.parseBase64Binary(cryptoPwdB64));
                SHA1 = this.digestPrivate(DigestAlgEnum.ALG_SHA1, result);
            } else {
                List<String> privateKey = this.cryptoDisService.getRSAPrivateKey(this.getTokenAndApiVersion(), this.appID, "rsa_04_001", shaKeyB64);
                if (privateKey != null && privateKey.size() == 2) {
                    String sessionkey = privateKey.get(0);
                    String keypair = privateKey.get(1);
                    byte[] keyBytes = AKSNativeCryptoService.crypto(false, "rsa_04_001", ModeEnum.MODE_ECB, PaddingEnum.PADDING_NOPADDING, null, DatatypeConverter.parseBase64Binary(sessionkey));
                    byte[] keypairBytes = AKSNativeCryptoService.crypto(false, AlgEnum.ALG_AES256, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, keyBytes, null, DatatypeConverter.parseBase64Binary(keypair));
                    byte[] result = AKSNativeCryptoService.privateKeyDecrypt(keypairBytes, DatatypeConverter.parseBase64Binary(cryptoPwdB64));
                    SHA1 = this.digestPrivate(DigestAlgEnum.ALG_SHA1, result);
                }
            }
            if (SHA1 != null) {
                String SHA1_24 = DatatypeConverter.printBase64Binary(ByteUtil.hexStringToBytes(SHA1)).substring(0, 24);
                byte[] salt = AKSNativeCryptoService.crypto(false, "rsa_04_001", ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null, DatatypeConverter.parseBase64Binary(dbSalt));
                byte[] keys = this.digestByte(DigestAlgEnum.ALG_SHA256, ByteUtil.joinBytes(SHA1_24.getBytes(), salt));
                byte[] pw = AKSNativeCryptoService.crypto(true, "rsa_04_001", ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null, keys);
                return this.checkPWResponse(DatatypeConverter.printBase64Binary(pw), dbPW, null);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u7528\u6237\u5bc6\u7801\u9a8c\u8bc1 verifyUserPwdForSHA1_JS \u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        return this.checkPWResponse("", dbPW, null);
    }

    @Deprecated
    public EncryptPWResponse encryptUserPwdForSHA1_KeyBoard(String aksPWData, boolean isCheckOTP) throws KeyException {
        Preconditions.validate(aksPWData);
        this.checkPermission();
        EncryptPWResponse response = new EncryptPWResponse();
        try {
            String SHA1;
            if (aksPWData.length() <= 4) {
                LOGGER.warn("\u7528\u6237\u5bc6\u7801\u52a0\u5bc6(\u7528\u4e8e\u5bc6\u7801\u6ce8\u518c\u6216\u91cd\u7f6e\u670d\u52a1) encryptUserPwdForSHA1_KeyBoard \u5931\u8d25. aksPWData : {}", (Object)aksPWData);
                response.setSuccess(false);
                return response;
            }
            String index = aksPWData.substring(0, 4);
            String content = aksPWData.substring(4);
            if (index.charAt(0) == '1') {
                String alias;
                if (index.charAt(1) == '1') {
                    alias = "APB_13_001";
                } else if (index.charAt(1) == '0') {
                    alias = "APB_12_001";
                } else {
                    LOGGER.warn("\u7528\u6237\u5bc6\u7801\u52a0\u5bc6(\u7528\u4e8e\u5bc6\u7801\u6ce8\u518c\u6216\u91cd\u7f6e\u670d\u52a1) encryptUserPwdForSHA1_KeyBoard \u5931\u8d25. index : {}", (Object)index);
                    response.setSuccess(false);
                    return response;
                }
                SHA1 = this.digestPrivate(DigestAlgEnum.ALG_SHA1, ByteUtil.hexStringToBytes(AKSNativeCryptoService.checkPWDForKeyboard(isCheckOTP, alias, content)));
            } else if (index.charAt(0) == '0') {
                SHA1 = this.digestPrivate(DigestAlgEnum.ALG_SHA1, content.getBytes());
            } else {
                LOGGER.warn("\u7528\u6237\u5bc6\u7801\u52a0\u5bc6(\u7528\u4e8e\u5bc6\u7801\u6ce8\u518c\u6216\u91cd\u7f6e\u670d\u52a1) encryptUserPwdForSHA1_KeyBoard \u5931\u8d25. index : {}", (Object)index);
                response.setSuccess(false);
                return response;
            }
            if (SHA1 != null) {
                String SHA1_24 = DatatypeConverter.printBase64Binary(ByteUtil.hexStringToBytes(SHA1)).substring(0, 24);
                byte[] salt = new byte[32];
                SecureRandom random = new SecureRandom();
                random.nextBytes(salt);
                byte[] enSalt = AKSNativeCryptoService.crypto(true, "rsa_04_001", ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null, salt);
                byte[] keys = this.digestByte(DigestAlgEnum.ALG_SHA256, ByteUtil.joinBytes(SHA1_24.getBytes(), salt));
                byte[] pw = AKSNativeCryptoService.crypto(true, "rsa_04_001", ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null, keys);
                response.setSuccess(true);
                response.setCryptPW(DatatypeConverter.printBase64Binary(pw));
                response.setCryptSalt(DatatypeConverter.printBase64Binary(enSalt));
                response.setSha1(DatatypeConverter.printBase64Binary(ByteUtil.hexStringToBytes(SHA1)));
            } else {
                response.setSuccess(false);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u7528\u6237\u5bc6\u7801\u52a0\u5bc6(\u7528\u4e8e\u5bc6\u7801\u6ce8\u518c\u6216\u91cd\u7f6e\u670d\u52a1) encryptUserPwdForSHA1_KeyBoard \u5931\u8d25\uff1a{}", (Object)e.getMessage());
            response.setSuccess(false);
        }
        return response;
    }

    @Deprecated
    public EncryptPWResponse verifyUserPwdForSHA1_KeyBoard(String aksPWData, boolean isCheckOTP, String dbPW, String dbSalt) throws KeyException {
        Preconditions.validate(aksPWData, dbPW, dbSalt);
        this.checkPermission();
        try {
            String SHA1;
            if (aksPWData.length() <= 4) {
                LOGGER.warn("\u7528\u6237\u5bc6\u7801\u9a8c\u8bc1 verifyUserPwdForSHA1_KeyBoard \u5931\u8d25. aksPWData : {}", (Object)aksPWData);
                return this.checkPWResponse("", dbPW, null);
            }
            String index = aksPWData.substring(0, 4);
            String content = aksPWData.substring(4);
            if (index.charAt(0) == '1') {
                String alias;
                if (index.charAt(1) == '1') {
                    alias = "APB_13_001";
                } else if (index.charAt(1) == '0') {
                    alias = "APB_12_001";
                } else {
                    LOGGER.warn("\u7528\u6237\u5bc6\u7801\u9a8c\u8bc1 verifyUserPwdForSHA1_KeyBoard \u5931\u8d25. index : {}", (Object)index);
                    return this.checkPWResponse("", dbPW, null);
                }
                SHA1 = this.digestPrivate(DigestAlgEnum.ALG_SHA1, ByteUtil.hexStringToBytes(AKSNativeCryptoService.checkPWDForKeyboard(isCheckOTP, alias, content)));
            } else if (index.charAt(0) == '0') {
                SHA1 = this.digestPrivate(DigestAlgEnum.ALG_SHA1, content.getBytes());
            } else {
                LOGGER.warn("\u7528\u6237\u5bc6\u7801\u9a8c\u8bc1 verifyUserPwdForSHA1_KeyBoard \u5931\u8d25. index : {}", (Object)index);
                return this.checkPWResponse("", dbPW, null);
            }
            if (SHA1 != null) {
                String SHA1_24 = DatatypeConverter.printBase64Binary(ByteUtil.hexStringToBytes(SHA1)).substring(0, 24);
                byte[] salt = AKSNativeCryptoService.crypto(false, "rsa_04_001", ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null, DatatypeConverter.parseBase64Binary(dbSalt));
                byte[] keys = this.digestByte(DigestAlgEnum.ALG_SHA256, ByteUtil.joinBytes(SHA1_24.getBytes(), salt));
                byte[] pw = AKSNativeCryptoService.crypto(true, "rsa_04_001", ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null, keys);
                return this.checkPWResponse(DatatypeConverter.printBase64Binary(pw), dbPW, null);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u7528\u6237\u5bc6\u7801\u9a8c\u8bc1 verifyUserPwdForSHA1_KeyBoard \u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        return this.checkPWResponse("", dbPW, null);
    }

    public String setPayStatus(final String walletId, final String paycodeStatus) throws KeyException {
        Preconditions.validate(walletId, paycodeStatus);
        Preconditions.checkWalletIdLength(walletId.length());
        Preconditions.checkStatusCode(paycodeStatus);
        return new Paymark(){

            @Override
            public String doPay() throws KeyException {
                PayCode payCode = DeviceCryptoService.this.createPayCode(walletId);
                payCode.setPaycodeStatus(paycodeStatus);
                return DeviceCryptoService.this.cryptoDisService.setPayStatus(payCode);
            }
        }.run(this.getToken());
    }

    public String getPayStatus(final String walletId) throws KeyException {
        Preconditions.validate(walletId);
        Preconditions.checkWalletIdLength(walletId.length());
        return new Paymark(){

            @Override
            public String doPay() throws KeyException {
                PayCode payCode = DeviceCryptoService.this.createPayCode(walletId);
                return DeviceCryptoService.this.cryptoDisService.getPayStatus(payCode);
            }
        }.run(this.getToken());
    }

    public String createUserSeed(final String walletId) throws KeyException {
        Preconditions.validate(walletId);
        Preconditions.checkWalletIdLength(walletId.length());
        return new Paymark(){

            @Override
            public String doPay() throws KeyException {
                PayCode payCode = DeviceCryptoService.this.createPayCode(walletId);
                return DeviceCryptoService.this.cryptoDisService.createUserSeed(payCode);
            }
        }.run(this.getToken());
    }

    public String checkQRcode(final String otpcode) throws KeyException {
        Preconditions.validate(otpcode);
        Preconditions.checkOtpcode(otpcode);
        return new Paymark(){

            @Override
            public String doPay() throws KeyException {
                PayCode payCode = DeviceCryptoService.this.createPayCode("");
                payCode.setOptcode(otpcode);
                return DeviceCryptoService.this.cryptoDisService.checkQRcode(payCode);
            }
        }.run(this.getToken());
    }

    public String decryptUserID(final String otpcode) throws KeyException {
        Preconditions.validate(otpcode);
        Preconditions.checkOtpcode(otpcode);
        return new Paymark(){

            @Override
            public String doPay() throws KeyException {
                PayCode payCode = DeviceCryptoService.this.createPayCode("");
                payCode.setOptcode(otpcode);
                return DeviceCryptoService.this.cryptoDisService.decryptUserID(payCode);
            }
        }.run(this.getToken());
    }

    public String getPaymentcode(final String walletId, final String paycodetype, final String isUpdateSeed) throws KeyException {
        Preconditions.validate(walletId, paycodetype, isUpdateSeed);
        Preconditions.checkWalletIdLength(walletId.length());
        Preconditions.checkStatusCode(paycodetype, isUpdateSeed);
        return new Paymark(){

            @Override
            public String doPay() throws KeyException {
                PayCode payCode = DeviceCryptoService.this.createPayCode(walletId);
                payCode.setPaycodeType(paycodetype);
                payCode.setUpdateSeed(isUpdateSeed);
                return DeviceCryptoService.this.cryptoDisService.getQRcode(payCode);
            }
        }.run(this.getToken());
    }

    public String getPaymentcode(final String walletId, final PayCodeEnum payCode) {
        Preconditions.validate(walletId);
        try {
            return new Paymark(){

                @Override
                public String doPay() throws KeyException {
                    PayCode pc = DeviceCryptoService.this.createPayCode(walletId);
                    pc.setPaycodeType(payCode.getType());
                    return DeviceCryptoService.this.cryptoDisService.getPaymentcode(pc);
                }
            }.run(this.getToken());
        }
        catch (KeyException e) {
            throw e;
        }
        catch (Throwable e) {
            LOGGER.error("An exception occured when getPaymentcode failed.", e);
            throw new KeyException(AksExceptionEnum.AKS_99_00064.getCode(), AksExceptionEnum.AKS_99_00064.getDesc());
        }
    }

    private PayCode createPayCode(String walletId) throws KeyException {
        PayCode payCode = new PayCode();
        payCode.setWalletId(walletId);
        payCode.setAppID(this.appID);
        payCode.setToken(this.getToken());
        payCode.setApiVersion(this.getApiVersion());
        return payCode;
    }

    public List<String> createUserSeedByJDPin(String jdPin) throws KeyException {
        return this.createUserSeed(PayCodeTypeEnum.PayCode_JDPIN, jdPin);
    }

    public List<String> createUserSeed(PayCodeTypeEnum payCodeType, String user_id) throws KeyException {
        Preconditions.validate(user_id);
        if (this.getToken() == null || this.getToken().isEmpty()) {
            LOGGER.warn("Do pay business has exception when token is null...");
            throw new KeyException(AksExceptionEnum.AKS_99_00003.getCode(), AksExceptionEnum.AKS_99_00003.getDesc());
        }
        PayCode payCode = this.createPayCode("");
        payCode.setJDPin(DatatypeConverter.printBase64Binary(user_id.getBytes()));
        payCode.setType(payCodeType.getPayCodeType());
        return this.cryptoDisService.createUserSeedByJDPin(payCode);
    }

    public String deleteUserSeedByJDPin(String jdPin) throws KeyException {
        return this.deleteUserSeed(PayCodeTypeEnum.PayCode_JDPIN, jdPin);
    }

    public String deleteUserSeed(final PayCodeTypeEnum payCodeType, final String user_id) throws KeyException {
        Preconditions.validate(user_id);
        return new Paymark(){

            @Override
            public String doPay() throws KeyException {
                PayCode payCode = DeviceCryptoService.this.createPayCode("");
                payCode.setJDPin(DatatypeConverter.printBase64Binary(user_id.getBytes()));
                payCode.setType(payCodeType.getPayCodeType());
                return DeviceCryptoService.this.cryptoDisService.deleteSeedByJDPin(payCode);
            }
        }.run(this.getToken());
    }

    public List<String> checkPaymentcode(final String paymentcode) throws KeyException {
        Preconditions.validate(paymentcode);
        Preconditions.checkOtpcode(paymentcode);
        ArrayList<String> result = new ArrayList<String>();
        String jdPinAndType = new Paymark(){

            @Override
            public String doPay() throws KeyException {
                PayCode payCode = DeviceCryptoService.this.createPayCode("");
                payCode.setOptcode(paymentcode);
                return DeviceCryptoService.this.cryptoDisService.checkPaymentcode(payCode);
            }
        }.run(this.getToken());
        if (jdPinAndType == null || "".equals(jdPinAndType)) {
            return result;
        }
        String type = jdPinAndType.substring(0, 1);
        result.add(type);
        if ("1".equals(type)) {
            result.add(new String(DatatypeConverter.parseBase64Binary(new String(DatatypeConverter.parseBase64Binary(jdPinAndType.substring(1))))));
        } else {
            result.add(new String(DatatypeConverter.parseBase64Binary(jdPinAndType.substring(1))));
        }
        return result;
    }

    public String getSeedByPayCode(String aliasName, RadixEnum radix, String tweak_FK, String paycode, String encFK, byte[] tweak) throws KeyException {
        Preconditions.validate(aliasName, paycode, encFK);
        Preconditions.checkStringIsNumber(paycode);
        if (paycode.length() != 19) {
            throw new KeyException(AksExceptionEnum.AKS_99_00008.getCode(), AksExceptionEnum.AKS_99_00008.getDesc() + "paycode.length() != 19");
        }
        if (tweak_FK != null && tweak_FK.length() != 0) {
            Preconditions.checkIsBase64Data(tweak_FK);
        }
        Preconditions.checkFF1DataType(radix, encFK);
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "getSeedByPayCode", this.appID, aliasName, null);
            monitorMessage.tail(200, null, null);
            byte[] seeds = AKSNativeCryptoService.getSeedByPayCodeUnipay(aliasName, radix, tweak_FK, paycode.getBytes(), encFK.getBytes(), tweak);
            String string = seeds != null ? new String(seeds) : null;
            return string;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public String checkPayCode(String aliasName, RadixEnum radix, String tweak_FK, String paycode, int rate, byte[] verifyPin, byte[] sk, String encFK, byte[] tweak, long t) throws KeyException {
        Preconditions.validate(aliasName, paycode, encFK);
        Preconditions.checkStringIsNumber(paycode);
        if (paycode.length() != 19) {
            throw new KeyException(AksExceptionEnum.AKS_99_00008.getCode(), AksExceptionEnum.AKS_99_00008.getDesc() + "paycode.length() != 19");
        }
        if (tweak_FK != null && tweak_FK.length() != 0) {
            Preconditions.checkIsBase64Data(tweak_FK);
        }
        Preconditions.checkFF1DataType(radix, encFK);
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "checkPayCode", this.appID, aliasName, null);
            monitorMessage.tail(200, null, null);
            byte[] seeds = AKSNativeCryptoService.checkPayCode(aliasName, radix, tweak_FK, paycode.getBytes(), rate, verifyPin, sk, encFK.getBytes(), tweak, t);
            String string = seeds != null ? new String(seeds) : null;
            return string;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public void putPayCodeInfo(String payCodeInfo) throws KeyException {
        List jsonPayCode;
        Preconditions.validate(payCodeInfo);
        try {
            JSON.JSONObject json = (JSON.JSONObject)JSON.parse(payCodeInfo);
            jsonPayCode = (List)json.get("otp");
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("payCodeInfo\u4e0d\u662fjson\u6570\u636e");
            throw new KeyException(AksExceptionEnum.AKS_99_00001.getCode(), AksExceptionEnum.AKS_99_00001.getDesc() + " payCodeInfo is " + payCodeInfo);
        }
        catch (Exception e) {
            LOGGER.error("payCodeInfo\u4e0d\u662fjson\u6570\u636e");
            throw new KeyException(AksExceptionEnum.AKS_99_00001.getCode(), AksExceptionEnum.AKS_99_00001.getDesc() + " payCodeInfo is " + payCodeInfo);
        }
        for (Object o : jsonPayCode) {
            Map obj = (Map)o;
            String id = (String)obj.get("id");
            String paycode = (String)obj.get("paycode");
            String user_id = (String)obj.get("user_id");
            Preconditions.validate(id, paycode, user_id);
            if (paycode.length() != 18 || user_id.length() != 18) {
                LOGGER.error("paycode or user_id\u7684\u957f\u5ea6\u4e0d\u7b49\u4e0e18");
                throw new KeyException(AksExceptionEnum.AKS_99_00001.getCode(), AksExceptionEnum.AKS_99_00001.getDesc());
            }
            this.cryptoDisService.pubPayCodeInfo(this.getTokenAndApiVersion(), this.appID, DatatypeConverter.printBase64Binary(id.getBytes()), paycode, user_id);
        }
    }

    private byte[] decryptWBoxData(String aliasName, byte[] input) throws KeyException {
        Preconditions.validate(aliasName);
        if (null == input || input.length <= 64) {
            throw new KeyException(AksExceptionEnum.AKS_99_00008.getCode(), AksExceptionEnum.AKS_99_00008.getDesc() + "input.length <= 64");
        }
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "decryptWBoxData", this.appID, aliasName, input.length);
            monitorMessage.tail(200, null, null);
            ByteBuffer wrap = ByteBuffer.wrap(input);
            byte[] enkey = new byte[32];
            byte[] enrk = new byte[32];
            byte[] endata = new byte[input.length - enkey.length - enrk.length];
            wrap.get(enkey).get(enrk).get(endata);
            byte[] key = AKSNativeCryptoService.crypto(false, aliasName, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null, enkey);
            byte[] rk = AKSNativeCryptoService.crypto(false, AlgEnum.ALG_SM4, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, key, null, enrk);
            byte[] byArray = AKSNativeCryptoService.crypto(false, AlgEnum.ALG_SM4, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, rk, null, endata);
            return byArray;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public byte[] decryptWBoxData(String input) throws KeyException {
        Preconditions.validate(input);
        Preconditions.checkIsBase64Data(input);
        return this.decryptWBoxData("SIG_04_001", DatatypeConverter.parseBase64Binary(input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean appVerify(String input, Map<String, String> packageData) {
        boolean v = false;
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "appVerify", this.appID, null, this.lengthOf(input));
            monitorMessage.tail(200, null, null);
            byte[] envData = DatatypeConverter.parseBase64Binary(input);
            byte[] encKey = ByteUtil.copy(envData, 0, 256);
            byte[] encData = ByteUtil.copy(envData, 256, envData.length - 256);
            byte[] keyBytess = AKSNativeCryptoService.privateKeyDecrypt("APB_12_001", encKey);
            byte[] data = AKSNativeCryptoService.crypto(false, AlgEnum.ALG_AES, ModeEnum.MODE_CBC, PaddingEnum.PADDING_PKCS7, keyBytess, AKSConstant.default_iv, encData);
            String message = new String(data);
            Object[] tokens = message.split("\\|");
            if (tokens.length >= 2) {
                LOGGER.debug("tokens: {}", (Object)Arrays.toString(tokens));
                Object name = tokens[0];
                Object h1 = tokens[1];
                Object h2 = "";
                if (tokens.length >= 3) {
                    h2 = tokens[2];
                }
                if (packageData.containsKey(name) && ((String)h1).equalsIgnoreCase(packageData.get(name))) {
                    v = ((String)h2).length() <= 0 || ((String)h2).equalsIgnoreCase(packageData.get(name));
                }
            }
        }
        catch (Exception e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            LOGGER.error("An exception occured when appVerify failed.", (Throwable)e);
        }
        finally {
            this.report(monitorMessage);
        }
        return v;
    }

    public void encryptFile(String aliasName, String srcFilePath, String destFilePath) throws KeyException {
        this.encryptFile(aliasName, srcFilePath, destFilePath, AlgEnum.ALG_SM4, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null);
    }

    public void encryptFile(String aliasName, String srcFilePath, String destFilePath, AlgEnum algEnum, ModeEnum modeEnum, PaddingEnum paddingEnum, byte[] iv) throws KeyException {
        this.cryptoFile(true, aliasName, srcFilePath, destFilePath, algEnum, modeEnum, paddingEnum, iv);
    }

    public void decryptFile(String aliasName, String srcFilePath, String destFilePath) throws KeyException {
        this.decryptFile(aliasName, srcFilePath, destFilePath, AlgEnum.ALG_SM4, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null);
    }

    public void decryptFile(String aliasName, String srcFilePath, String destFilePath, AlgEnum algEnum, ModeEnum modeEnum, PaddingEnum paddingEnum, byte[] iv) throws KeyException {
        this.cryptoFile(false, aliasName, srcFilePath, destFilePath, algEnum, modeEnum, paddingEnum, iv);
    }

    private void cryptoFile(boolean isEncrypt, String aliasName, String srcFilePath, String destFilePath, AlgEnum algEnum, ModeEnum modeEnum, PaddingEnum paddingEnum, byte[] iv) throws KeyException {
        if (srcFilePath == null || destFilePath == null || algEnum == null || modeEnum == null || paddingEnum == null) {
            throw new KeyException(AksExceptionEnum.AKS_99_00001.getCode(), AksExceptionEnum.AKS_99_00001.getDesc());
        }
        if (!("AES128".equals(algEnum.getCode()) || "AES192".equals(algEnum.getCode()) || "AES256".equals(algEnum.getCode()) || "SM4".equals(algEnum.getCode()))) {
            throw new KeyException(AksExceptionEnum.AKS_99_00082.getCode(), AksExceptionEnum.AKS_99_00082.getDesc());
        }
        if ("NoPadding".equals(paddingEnum.getCode())) {
            throw new KeyException(AksExceptionEnum.AKS_99_00083.getCode(), AksExceptionEnum.AKS_99_00083.getDesc());
        }
        File srcFile = new File(srcFilePath);
        File destFile = new File(destFilePath);
        if (!srcFile.exists() || !srcFile.canRead()) {
            throw new KeyException(AksExceptionEnum.AKS_99_00078.getCode(), AksExceptionEnum.AKS_99_00078.getDesc() + "srcFilePath = " + srcFilePath);
        }
        if (!destFile.exists()) {
            try {
                destFile.createNewFile();
            }
            catch (IOException e) {
                throw new KeyException(AksExceptionEnum.AKS_99_00079.getCode(), AksExceptionEnum.AKS_99_00079.getDesc() + "destFilePath = " + destFilePath);
            }
        }
        if (!destFile.canWrite()) {
            throw new KeyException(AksExceptionEnum.AKS_99_00079.getCode(), AksExceptionEnum.AKS_99_00079.getDesc() + "destFilePath = " + destFilePath);
        }
        Preconditions.checkAliasName(aliasName);
        this.checkPermission();
        OutputStream out = null;
        CipherInputStream cis = null;
        try {
            int length;
            Cipher cipher = PKIHelper.getCipherBC(algEnum, modeEnum, paddingEnum);
            FileInputStream is = new FileInputStream(srcFile);
            out = new FileOutputStream(destFile);
            if (isEncrypt) {
                java.security.Key fileKey = CryptUtil.generateKey(algEnum, CryptUtil.getKeyLength(algEnum));
                byte[] fileKeyEncrypt = this.encryptByVersion(aliasName, AKSConstant.DEFAULT_MODE_VERSION, CryptUtil.getPaddingByAliasName(aliasName), fileKey.getEncoded());
                out.write(fileKeyEncrypt);
                if (ModeEnum.MODE_CBC.equals((Object)modeEnum)) {
                    IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
                    cipher.init(1, fileKey, ivParameterSpec);
                } else {
                    cipher.init(1, fileKey);
                }
            } else {
                byte[] enkey = new byte[21 + CryptUtil.getEncryptedDataLength(aliasName, CryptUtil.getPaddingByAliasName(aliasName), CryptUtil.getKeyLength(algEnum))];
                int n = ((InputStream)is).read(enkey, 0, enkey.length);
                if (n < enkey.length) {
                    throw new KeyException(AksExceptionEnum.AKS_99_00080.getCode(), AksExceptionEnum.AKS_99_00080.getDesc());
                }
                byte[] key = this.decryptByVersion(aliasName, AKSConstant.DEFAULT_MODE, CryptUtil.getPaddingByAliasName(aliasName), null, enkey);
                SecretKeySpec fileKey = new SecretKeySpec(key, CryptUtil.getAlgorithmString(algEnum));
                if (ModeEnum.MODE_CBC.equals((Object)modeEnum)) {
                    IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
                    cipher.init(2, (java.security.Key)fileKey, ivParameterSpec);
                } else {
                    cipher.init(2, fileKey);
                }
            }
            byte[] buffer = new byte[0xA00000];
            cis = new CipherInputStream(is, cipher);
            while ((length = cis.read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
        }
        catch (Exception e) {
            LOGGER.error("An exception occurred when cryptoFile failed.", (Throwable)e);
            throw new KeyException(AksExceptionEnum.AKS_99_00081.getCode(), AksExceptionEnum.AKS_99_00081.getDesc() + e + e.getMessage());
        }
        finally {
            if (cis != null) {
                try {
                    cis.close();
                }
                catch (IOException e) {
                    cis = null;
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    out = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String antiRush(String domain, String uri, String uid, String userIp, String signData, String signature, String nonce, int periodOfValidity, int interval) {
        block9: {
            Preconditions.validate(domain, uri, signData, signature, nonce);
            this.checkPermission();
            MonitorMessage monitorMessage = new MonitorMessage();
            try {
                monitorMessage.head(MY_NAME, "antiRush", this.appID, null, signData.getBytes().length);
                String result = this.cryptoDisService.antiRush(this.getTokenAndApiVersion(), this.appID, domain, uri, uid, userIp, signData, signature, nonce, periodOfValidity, interval);
                monitorMessage.tail(200, null, result);
                String string = result;
                return string;
            }
            catch (KeyException k) {
                monitorMessage.tail(500, k.getClass().getName(), k.getMessage());
                if (!AKSConstant.errorcodes.contains(k.getCode())) {
                    throw new KeyException(AksExceptionEnum.AKS_99_00085.getCode(), AksExceptionEnum.AKS_99_00085.getDesc() + "KeyException:" + k.getMessage());
                }
                LOGGER.warn("\u6d3b\u52a8\u9632\u5237 \u964d\u7ea7\u5904\u7406 ... KeyException:{}", (Object)k.getMessage());
            }
            catch (Throwable t) {
                monitorMessage.tail(500, t.getClass().getName(), t.getMessage());
                if (this.isRpcException(t)) {
                    LOGGER.warn("\u6d3b\u52a8\u9632\u5237 \u964d\u7ea7\u5904\u7406. RpcException:{}", (Object)t.getMessage());
                    break block9;
                }
                LOGGER.error("An exception occured when antiRush failed.", t);
                throw new KeyException(AksExceptionEnum.AKS_99_00085.getCode(), AksExceptionEnum.AKS_99_00085.getDesc() + t + t.getMessage());
            }
            finally {
                this.report(monitorMessage);
            }
        }
        return null;
    }

    public String indexingWordByFPE(String srcData) {
        Preconditions.validate(srcData);
        this.checkPermission();
        StringBuilder stringBuilder = new StringBuilder();
        long handle = (Long)this.indexHandle.get(this.appID);
        if (handle <= 0L) {
            throw new KeyException(AksExceptionEnum.AKS_99_00088.getCode(), AksExceptionEnum.AKS_99_00088.getDesc());
        }
        int size = -1;
        byte[] round = new byte[]{};
        for (int i = 0; i < srcData.length(); ++i) {
            String roundString;
            byte[] chars = srcData.substring(i, i + 1).getBytes(Charset.forName("UTF-8"));
            if (chars.length != 1 && chars.length != 3) {
                if (round.length != 0) {
                    roundString = new String(AKSNativeCryptoService.ciphertextIndex(handle, round, size), Charset.forName("UTF-8"));
                    stringBuilder.append(roundString);
                    size = -1;
                    round = new byte[]{};
                }
                stringBuilder.append(new String(chars, Charset.forName("UTF-8")));
                continue;
            }
            if (size < 0) {
                size = chars.length;
                round = chars;
                continue;
            }
            if (size == chars.length) {
                round = ByteUtil.joinBytes(round, chars);
                continue;
            }
            roundString = new String(AKSNativeCryptoService.ciphertextIndex(handle, round, size), Charset.forName("UTF-8"));
            stringBuilder.append(roundString);
            size = chars.length;
            round = chars;
        }
        if (round.length != 0) {
            String roundString = new String(AKSNativeCryptoService.ciphertextIndex(handle, round, size), Charset.forName("UTF-8"));
            stringBuilder.append(roundString);
        }
        return stringBuilder.toString();
    }

    public String antiRush2Key(String certAliasName) throws KeyException {
        String key = this.getSMPublicKeyByAlias(certAliasName);
        return DatatypeConverter.printHexBinary(DatatypeConverter.parseBase64Binary(key.substring(12))).toLowerCase();
    }

    public String antiRush2JS(String certAliasName, String version, String name) throws KeyException {
        Preconditions.validate(certAliasName);
        Preconditions.checkCertAliasName(certAliasName);
        this.checkPermission();
        try {
            return this.cryptoDisService.antiRush2JS(this.getTokenAndApiVersion(), this.appID, certAliasName, version, name);
        }
        catch (KeyException k) {
            if (!AKSConstant.errorcodes.contains(k.getCode())) {
                throw new KeyException(AksExceptionEnum.AKS_99_00085.getCode(), AksExceptionEnum.AKS_99_00085.getDesc() + "KeyException:" + k.getMessage());
            }
            LOGGER.warn("\u6d3b\u52a8\u9632\u52372 \u964d\u7ea7\u5904\u7406 ... KeyException:{}", (Object)k.getMessage());
        }
        catch (Throwable t) {
            if (this.isRpcException(t)) {
                LOGGER.warn("\u6d3b\u52a8\u9632\u52372 \u964d\u7ea7\u5904\u7406. RpcException:{}", (Object)t.getMessage());
            }
            LOGGER.error("An exception occured when antiRush2 failed.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_00085.getCode(), AksExceptionEnum.AKS_99_00085.getDesc() + t + t.getMessage());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String antiRush2(String domain, String uri, String uid, String userIp, String signData, String signature, String nonce, int periodOfValidity, int interval) {
        block9: {
            Preconditions.validate(domain, uri, signData, signature, nonce);
            this.checkPermission();
            MonitorMessage monitorMessage = new MonitorMessage();
            try {
                monitorMessage.head(MY_NAME, "antiRush2", this.appID, null, signData.getBytes().length);
                String result = this.cryptoDisService.antiRush2(this.getTokenAndApiVersion(), this.appID, domain, uri, uid, userIp, signData, signature, nonce, periodOfValidity, interval);
                monitorMessage.tail(200, null, result);
                String string = result;
                return string;
            }
            catch (KeyException k) {
                monitorMessage.tail(500, k.getClass().getName(), k.getMessage());
                if (!AKSConstant.errorcodes.contains(k.getCode())) {
                    throw new KeyException(AksExceptionEnum.AKS_99_00085.getCode(), AksExceptionEnum.AKS_99_00085.getDesc() + "KeyException:" + k.getMessage());
                }
                LOGGER.warn("\u6d3b\u52a8\u9632\u52372 \u964d\u7ea7\u5904\u7406 ... KeyException:{}", (Object)k.getMessage());
            }
            catch (Throwable t) {
                monitorMessage.tail(500, t.getClass().getName(), t.getMessage());
                if (this.isRpcException(t)) {
                    LOGGER.warn("\u6d3b\u52a8\u9632\u52372 \u964d\u7ea7\u5904\u7406. RpcException:{}", (Object)t.getMessage());
                    break block9;
                }
                LOGGER.error("An exception occured when antiRush2 failed.", t);
                throw new KeyException(AksExceptionEnum.AKS_99_00085.getCode(), AksExceptionEnum.AKS_99_00085.getDesc() + t + t.getMessage());
            }
            finally {
                this.report(monitorMessage);
            }
        }
        return null;
    }

    public String getKeyAliasFromCipherText(String ciphertext) {
        Preconditions.validate(ciphertext);
        Preconditions.checkIsBase64Data(ciphertext);
        try {
            if (this.isOnLine()) {
                return this.cryptoDisService.getKeyAliasFromCipherText(this.getTokenAndApiVersion(), this.appID, ciphertext);
            }
        }
        catch (KeyException k) {
            if (!AKSConstant.errorcodes.contains(k.getCode())) {
                throw k;
            }
            LOGGER.warn("\u83b7\u53d6\u5bc6\u6587\u6570\u636e\u52a0\u5bc6\u7684\u79d8\u94a5\u522b\u540d \u964d\u7ea7\u5904\u7406 ... KeyException:{}", (Object)k.getMessage());
            this.setOffLineStatus();
        }
        catch (Throwable t) {
            if (this.isRpcException(t)) {
                LOGGER.warn("\u83b7\u53d6\u5bc6\u6587\u6570\u636e\u52a0\u5bc6\u7684\u79d8\u94a5\u522b\u540d \u964d\u7ea7\u5904\u7406. RpcException:{}", (Object)t.getMessage());
                this.setOffLineStatus();
            }
            LOGGER.error("An exception occured when getKeyAliasFromCipherText failed.", t);
            throw new KeyException(AksExceptionEnum.AKS_99_00091.getCode(), AksExceptionEnum.AKS_99_00091.getDesc() + t + t.getMessage());
        }
        return AKSNativeCryptoService.ciphertextKeyAlias(ciphertext);
    }

    public EncryptPWResponse resetUserPwdForSM(String certAliasName, String aksWebData) {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "resetUserPwdForSM", this.appID, certAliasName, this.lengthOf(aksWebData));
            monitorMessage.tail(200, null, null);
            EncryptPWResponse response = new EncryptPWResponse();
            Preconditions.validate(certAliasName, aksWebData);
            Preconditions.checkAliasName(certAliasName, AlgEnum.ALG_SM2);
            Preconditions.checkIsBase64Data(aksWebData);
            this.checkPermission();
            byte[][] data = PKIHelper.parseSMWebData(aksWebData);
            byte[] key = this.privateDecryptBytes(certAliasName, data[3]);
            byte[] plain = this.crypto(false, AlgEnum.ALG_SM4, ModeEnum.MODE_CBC, PaddingEnum.PADDING_PKCS5, key, data[1], data[2]);
            byte[] salt = new byte[32];
            SecureRandom random = new SecureRandom();
            random.nextBytes(salt);
            String enSalt = DatatypeConverter.printBase64Binary(this.encryptBytesByVersion("rsa_05_001", AKSConstant.DEFAULT_MODE_VERSION, CryptUtil.getPaddingByAliasName("rsa_05_001"), salt));
            byte[] keys = this.digestByte(DigestAlgEnum.ALG_SM3, ByteUtil.joinBytes(plain, salt));
            String pw = DatatypeConverter.printBase64Binary(this.encryptBytesByVersion("rsa_05_001", AKSConstant.DEFAULT_MODE_VERSION, CryptUtil.getPaddingByAliasName("rsa_05_001"), keys));
            response.setSuccess(true);
            response.setCryptPW(pw);
            response.setCryptSalt(enSalt);
            EncryptPWResponse encryptPWResponse = response;
            return encryptPWResponse;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    public EncryptPWResponse verifyUserPwdForSM(String certAliasName, String aksWebData, String dbPW, String cryptSalt) throws KeyException {
        MonitorMessage monitorMessage = new MonitorMessage();
        try {
            monitorMessage.head(MY_NAME, "verifyUserPwdForSM", this.appID, certAliasName, this.lengthOf(aksWebData));
            monitorMessage.tail(200, null, null);
            EncryptPWResponse response = new EncryptPWResponse();
            Preconditions.validate(certAliasName, aksWebData, dbPW, cryptSalt);
            Preconditions.checkAliasName(certAliasName, AlgEnum.ALG_SM2);
            Preconditions.checkIsBase64Data(aksWebData, dbPW, cryptSalt);
            this.checkPermission();
            byte[][] data = PKIHelper.parseSMWebData(aksWebData);
            byte[] key = this.privateDecryptBytes(certAliasName, data[3]);
            byte[] plain = this.crypto(false, AlgEnum.ALG_SM4, ModeEnum.MODE_CBC, PaddingEnum.PADDING_PKCS5, key, data[1], data[2]);
            if (this.getKeyAliasFromCipherText(cryptSalt) == null) {
                EncryptPWResponse encryptPWResponse = this.verifyUserPwdForHistory(plain, dbPW, cryptSalt);
                return encryptPWResponse;
            }
            byte[] salt = this.decryptBytesByVersion("rsa_05_001", DatatypeConverter.parseBase64Binary(cryptSalt));
            byte[] pw = this.decryptBytesByVersion("rsa_05_001", DatatypeConverter.parseBase64Binary(dbPW));
            byte[] keys = this.digestByte(DigestAlgEnum.ALG_SM3, ByteUtil.joinBytes(plain, salt));
            response.setSuccess(true);
            response.setLogin(Arrays.equals(pw, keys));
            response.setCryptPW(dbPW);
            EncryptPWResponse encryptPWResponse = response;
            return encryptPWResponse;
        }
        catch (RuntimeException e) {
            monitorMessage.tail(500, e.getClass().getName(), e.getMessage());
            throw e;
        }
        finally {
            this.report(monitorMessage);
        }
    }

    private EncryptPWResponse verifyUserPwdForHistory(byte[] plain, String dbPW, String dbSalt) {
        byte[] SHA1 = this.digestByte(DigestAlgEnum.ALG_SHA1, plain);
        String SHA1_24 = DatatypeConverter.printBase64Binary(SHA1).substring(0, 24);
        byte[] salt = AKSNativeCryptoService.crypto(false, "rsa_04_001", ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null, DatatypeConverter.parseBase64Binary(dbSalt));
        byte[] keys = this.digestByte(DigestAlgEnum.ALG_SHA256, ByteUtil.joinBytes(SHA1_24.getBytes(), salt));
        byte[] pw = AKSNativeCryptoService.crypto(true, "rsa_04_001", ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null, keys);
        return this.checkPWResponse(DatatypeConverter.printBase64Binary(pw), dbPW, null);
    }
}

