/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server.model;

import com.wangyin.key.server.exception.KeyException;
import com.wangyin.key.server.util.ByteUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SecureChannel
implements Serializable {
    private static final long serialVersionUID = -3553549719248084392L;
    private String[] keys = new String[]{"errorcode", "data", "sessioninfo"};
    private Map<String, byte[]> params = new HashMap<String, byte[]>();

    public Map<String, byte[]> addParam(byte[][] values) throws KeyException {
        for (int i = 0; i < values.length; ++i) {
            byte[] value = values[i];
            if (i == 0) {
                int errorCode = ByteUtil.byteToInt(value);
                if (errorCode != 0 && errorCode != 1001 && errorCode != 1005) {
                    String code = String.valueOf(errorCode);
                    String msg = new String(values[1]);
                    throw new KeyException("AKS99" + code, msg);
                }
                this.addParam(this.keys[i], String.valueOf(errorCode).getBytes());
                continue;
            }
            this.addParam(this.keys[i], value);
        }
        return this.params;
    }

    public void addParam(String key, byte[] value) {
        this.params.put(key, value);
    }

    public Map<String, byte[]> getParams() {
        return this.params;
    }

    public long getCurrentTime() {
        return System.currentTimeMillis() / 1000L;
    }
}

