/*
 * Decompiled with CFR 0.152.
 */
package com.jd.jr.aks.security;

import com.jd.jr.aks.security.PropertiesLoader;
import com.jd.jr.aks.security.crypto.Decryption;
import com.jd.jr.aks.security.exception.DecryptException;
import com.jd.jr.aks.security.exception.FailFastException;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.env.PropertySource;

public class SecurityPropertySourceWrapper<S>
extends PropertySource<S> {
    private final PropertySource<S> source;
    private final Decryption cipher;
    private final ConcurrentHashMap<String, String> cache = new ConcurrentHashMap();

    public SecurityPropertySourceWrapper(PropertySource<S> source, Decryption cipher) {
        super(source.getName(), source.getSource());
        this.source = source;
        this.cipher = cipher;
    }

    public Object getProperty(String name) {
        if (this.cache.containsKey(name)) {
            return this.cache.get(name);
        }
        Object value = this.source.getProperty(name);
        if (value instanceof String) {
            try {
                value = PropertiesLoader.decrypt(name, (String)value, this.cipher);
            }
            catch (DecryptException e) {
                throw new FailFastException(e);
            }
            this.cache.put(name, (String)value);
        }
        return value;
    }
}

