/*
 * Decompiled with CFR 0.152.
 */
package com.jd.jr.aks.security.configuration;

import com.jd.jr.aks.security.SecurityEnumerablePropertySourceWrapper;
import com.jd.jr.aks.security.SecurityMapPropertySourceWrapper;
import com.jd.jr.aks.security.SecurityPropertySourceMethodInterceptor;
import com.jd.jr.aks.security.SecurityPropertySourceWrapper;
import com.jd.jr.aks.security.SecuritySystemEnvironmentPropertySourceWrapper;
import com.jd.jr.aks.security.SecutiryPropertySource;
import com.jd.jr.aks.security.configuration.EnvMode;
import com.jd.jr.aks.security.crypto.CipherFactory;
import com.jd.jr.aks.security.crypto.Decryption;
import java.util.Arrays;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.SystemEnvironmentPropertySource;
import org.springframework.core.type.AnnotationMetadata;

public class EnableSecurityPropertiesConfiguration
implements ImportBeanDefinitionRegistrar,
EnvironmentAware,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)EnableSecurityPropertiesConfiguration.class.getName());
    private final HashSet<String> MUST_PROXY = new HashSet<String>(Arrays.asList("org.springframework.boot.context.config.ConfigFileApplicationListener$ConfigurationPropertySources", "org.springframework.boot.context.properties.source.ConfigurationPropertySourcesPropertySource"));

    public void setEnvironment(Environment environment) {
        if (!(environment instanceof ConfigurableEnvironment)) {
            return;
        }
        ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
        String mode = env.getProperty("aks.config.security.mode");
        if ("false".equalsIgnoreCase(mode)) {
            LOGGER.warn("[AKS CONFIG SECURITY:1.2.3] Please set mode=\"off\" if you need (with double quote) because of YAML mapping off to false. See also org.yaml.snakeyaml.resolver.Resolver#BOOL.");
        }
        EnvMode.set(mode);
        String prefix = env.getProperty("aks.config.security.prefix");
        EnvMode.prefix(prefix);
        String suffix = env.getProperty("aks.config.security.suffix");
        EnvMode.suffix(suffix);
        Decryption cipher = CipherFactory.getInstance();
        if (EnvMode.get() == EnvMode.OFF) {
            return;
        }
        MutablePropertySources propSources = env.getPropertySources();
        for (PropertySource source : propSources) {
            if (this.MUST_PROXY.contains(source.getClass().getName())) {
                propSources.replace(source.getName(), this.proxy(source, cipher));
                continue;
            }
            propSources.replace(source.getName(), this.wrap(source, cipher));
        }
    }

    private <S> PropertySource<?> wrap(PropertySource<S> source, Decryption cipher) {
        if (source instanceof SystemEnvironmentPropertySource) {
            return new SecuritySystemEnvironmentPropertySourceWrapper((SystemEnvironmentPropertySource)source, cipher);
        }
        if (source instanceof MapPropertySource) {
            return new SecurityMapPropertySourceWrapper((MapPropertySource)source, cipher);
        }
        if (source instanceof EnumerablePropertySource) {
            return new SecurityEnumerablePropertySourceWrapper((EnumerablePropertySource)source, cipher);
        }
        return new SecurityPropertySourceWrapper<S>(source, cipher);
    }

    private <S> PropertySource<S> proxy(PropertySource<S> source, Decryption cipher) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTargetClass(source.getClass());
        proxyFactory.setProxyTargetClass(true);
        proxyFactory.addInterface(SecutiryPropertySource.class);
        proxyFactory.setTarget(source);
        proxyFactory.addAdvice(new SecurityPropertySourceMethodInterceptor<S>(source, cipher));
        return (PropertySource)proxyFactory.getProxy();
    }

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry beanDefinitionRegistry) {
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

