package com.cnooc.expert.external.file.api;

import com.cnooc.expert.external.common.model.response.ApiBaseResult;
import com.cnooc.expert.external.file.model.request.GeneratorDownloadInfoApiReq;
import com.cnooc.expert.external.file.model.request.GeneratorUploadInfoApiReq;
import com.cnooc.expert.external.file.model.response.DownLoadInfoApiResp;
import com.cnooc.expert.external.file.model.response.GeneratorUploadInfoApiResp;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.Part;
import retrofit2.http.PartMap;
import retrofit2.http.Url;

import java.util.List;
import java.util.Map;

public interface FileServiceApi {

    @POST("/api/file/generatorUploadInfo")
    Call<ApiBaseResult<GeneratorUploadInfoApiResp>> generatorUploadInfoApi(@Body GeneratorUploadInfoApiReq req);

    @Multipart
    @POST
    Call<ResponseBody> uploadFile(@Url String url, @PartMap Map<String, RequestBody> params, @Part MultipartBody.Part file);

    @POST("/api/file/generatorDownloadInfo")
    Call<ApiBaseResult<List<DownLoadInfoApiResp>>> generatorDownloadInfoApi(@Body GeneratorDownloadInfoApiReq req);

}
