package com.cnooc.expert.external.pingbiao.api;

import com.cnooc.expert.external.common.model.response.ApiBaseResult;
import com.cnooc.expert.external.pingbiao.model.request.SignOptimizeReq;
import com.cnooc.expert.external.pingbiao.model.response.FaceDynResp;
import com.cnooc.expert.external.pingbiao.model.response.IdentifyFaceDynResp;
import com.cnooc.expert.external.pingbiao.model.response.SignValidityPeriodResp;
import com.cnooc.expert.external.pingbiao.model.response.WhitelistStatusResp;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.HeaderMap;
import retrofit2.http.POST;

import java.util.Map;

public interface PingBiaoServiceApi {

    //查询证书预授权有效期
    @POST("/api/saas-pingbiao/sign/optimize/getSignValidityPeriod")
    Call<ApiBaseResult<SignValidityPeriodResp>> getSignValidityPeriod(@HeaderMap Map<String, Object> headers, @Body SignOptimizeReq req);

    //查询内部用户白名单
    @POST("/api/saas-pingbiao/sign/optimize/queryInsideSignUser")
    Call<ApiBaseResult<WhitelistStatusResp>> queryInsideSignUser(@HeaderMap Map<String, Object> headers, @Body SignOptimizeReq req);

    //查询外部用户白名单状态
    @POST("/api/saas-pingbiao/sign/optimize/queryOutsidePerson")
    Call<ApiBaseResult<WhitelistStatusResp>> queryOutsidePerson(@HeaderMap Map<String, Object> headers, @Body SignOptimizeReq req);

    //创建外部用户白名单状态
    @POST("/api/saas-pingbiao/sign/optimize/createOutsidePerson")
    Call<ApiBaseResult<WhitelistStatusResp>> createOutsidePerson(@HeaderMap Map<String, Object> headers, @Body SignOptimizeReq req);

    //人脸识别-动态
    @POST("/api/saas-pingbiao/sign/optimize/getFaceDyn")
    Call<ApiBaseResult<FaceDynResp>> getFaceDyn(@HeaderMap Map<String, Object> headers, @Body SignOptimizeReq req);

    //获取动态人脸识别核验结果
    @POST("/api/saas-pingbiao/sign/optimize/identifyFaceDyn")
    Call<ApiBaseResult<IdentifyFaceDynResp>> identifyFaceDyn(@HeaderMap Map<String, Object> headers, @Body SignOptimizeReq req);

    //场景证书授权人发送授权码
    @POST("/api/saas-pingbiao/sign/optimize/sendSceneCode")
    Call<ApiBaseResult<WhitelistStatusResp>> sendSceneCode(@HeaderMap Map<String, Object> headers, @Body SignOptimizeReq req);

    //验证场景证书授权码
    @POST("/api/saas-pingbiao/sign/optimize/validSceneCode")
    Call<ApiBaseResult<WhitelistStatusResp>> validSceneCode(@HeaderMap Map<String, Object> headers, @Body SignOptimizeReq req);

}
