/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server;

import com.wangyin.key.server.CryptoDistanceService;
import com.wangyin.key.server.CryptoServiceBase;
import com.wangyin.key.server.exception.AuthException;
import com.wangyin.key.server.exception.KeyException;
import com.wangyin.key.server.jni.AKSNativeCryptoService;
import com.wangyin.key.server.model.AlgEnum;
import com.wangyin.key.server.model.ModeEnum;
import com.wangyin.key.server.model.PaddingEnum;
import com.wangyin.key.server.util.AKSConstant;
import com.wangyin.key.server.util.CryptUtil;
import com.wangyin.key.server.util.Preconditions;
import com.wangyin.key.server.util.StatusUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class UserCryptoService
extends CryptoServiceBase {
    private static Map<String, String> nameSession = new ConcurrentHashMap<String, String>();
    private CryptoDistanceService cryptoDisService;

    @Override
    public CryptoDistanceService getCryptoDisService() {
        return this.cryptoDisService;
    }

    public void setCryptoDisService(CryptoDistanceService cryptoDisService) {
        this.cryptoDisService = cryptoDisService;
    }

    public String login(String userName, String passWord) throws AuthException {
        Preconditions.validate(userName, passWord);
        String token = this.cryptoDisService.login(userName, passWord);
        this.token_keyAlias = this.createTokenKeyAlias(token);
        nameSession.put(token, userName);
        return token;
    }

    public void logout(String token) throws AuthException {
        Preconditions.checkToken(token);
        this.cryptoDisService.logout(token);
    }

    public byte[] getPwd(String token, String aliasName) throws KeyException {
        Preconditions.checkToken(token);
        Preconditions.checkPasswordAliasName(aliasName);
        String userName = nameSession.get(token);
        byte[] pwd = this.cryptoDisService.getPwd(this.getToken(token), userName, aliasName);
        AKSNativeCryptoService.put_token(this.token_keyAlias, token);
        return AKSNativeCryptoService.crypto(this.token_keyAlias, ModeEnum.MODE_ECB, PaddingEnum.PADDING_PKCS7, null, pwd);
    }

    public byte[] encrypt(String token, String aliasName, byte[] srcData) throws KeyException {
        AlgEnum alg = CryptUtil.getAlgByAliasName(aliasName);
        return this.encrypt(this.getToken(token), aliasName, AKSConstant.DEFAULT_MODE, CryptUtil.getPaddingByAlg(alg), null, srcData);
    }

    public byte[] encrypt(String token, String aliasName, ModeEnum mode, PaddingEnum padding, byte[] iv, byte[] srcData) throws KeyException {
        Preconditions.checkToken(token);
        Preconditions.validate(aliasName);
        Preconditions.validate(new byte[][]{srcData});
        Preconditions.validate(aliasName, mode, padding, iv);
        String userName = nameSession.get(token);
        return this.cryptoDisService.encrypt(this.getToken(token), userName, aliasName, mode, padding, iv, srcData);
    }

    public byte[] decrypt(String token, String aliasName, byte[] envData) throws KeyException {
        AlgEnum alg = CryptUtil.getAlgByAliasName(aliasName);
        return this.decrypt(this.getToken(token), aliasName, AKSConstant.DEFAULT_MODE, CryptUtil.getPaddingByAlg(alg), null, envData);
    }

    public byte[] decrypt(String token, String aliasName, ModeEnum mode, PaddingEnum padding, byte[] iv, byte[] envData) throws KeyException {
        Preconditions.checkToken(token);
        Preconditions.validate(aliasName);
        Preconditions.validate(new byte[][]{envData});
        Preconditions.validate(aliasName, mode, padding, iv);
        AlgEnum alg = CryptUtil.getAlgByAliasName(aliasName);
        Preconditions.checkEncryptedData(alg, envData);
        String userName = nameSession.get(token);
        return this.cryptoDisService.decrypt(this.getToken(token), userName, aliasName, mode, padding, iv, envData);
    }

    private String getToken(String token) {
        return token + "|" + StatusUtil.getApiVersion();
    }
}

