/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server.hsm;

import com.wangyin.key.server.exception.BaseException;
import com.wangyin.key.server.hsm.IDataHandler;
import com.wangyin.key.server.jni.AKSNativeCryptoService;
import com.wangyin.key.server.model.CertCache;
import com.wangyin.key.server.model.Key;
import com.wangyin.key.server.model.Session;
import com.wangyin.key.server.model.UserEnum;
import java.util.ArrayList;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChipsDataHandler
extends IDataHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChipsDataHandler.class);
    private static String appId = null;
    private static String sysId = "first-sys";
    private static String chipsZkAddress = null;
    private static String chipsAddress = null;
    private static int chipsTimeout = 5000;
    private static int family = 1;
    private List<String> chipsSystems = null;

    public ChipsDataHandler(String zkAddress, int timeout, String appid) throws BaseException {
        appId = appid;
        chipsZkAddress = zkAddress;
        chipsTimeout = timeout;
        this.getChipsIPs();
        this.connectAndShakehands();
    }

    public ChipsDataHandler(String zkAddress, int timeout, String appid, String sysid, int intFamily) throws BaseException {
        appId = appid;
        chipsZkAddress = zkAddress;
        chipsTimeout = timeout;
        sysId = sysid;
        family = intFamily;
        this.getChipsIPs();
        this.connectAndShakehands();
    }

    private void getChipsIPs() throws BaseException {
        try {
            CuratorFramework client = CuratorFrameworkFactory.newClient((String)chipsZkAddress, (int)chipsTimeout, (int)chipsTimeout, (RetryPolicy)new RetryNTimes(3, 5000));
            client.start();
            this.chipsSystems = (List)client.getChildren().forPath("/AKS/aks-chips/system");
            client.close();
        }
        catch (Exception e) {
            throw new BaseException("hsm_error", " connect to zk has error! ");
        }
        if (this.chipsSystems == null || this.chipsSystems.size() == 0) {
            LOGGER.error("get chips server ip from zk has error!");
            throw new BaseException("chips", "get chips server ip from zk has error!");
        }
    }

    private void connectAndShakehands() throws BaseException {
        StringBuilder addr = new StringBuilder();
        for (int i = 0; i < this.chipsSystems.size(); ++i) {
            String ip_port = this.chipsSystems.get(i).replace("_", ":");
            if (!ip_port.contains(":")) {
                ip_port = this.chipsSystems.get(i) + ":20004";
            }
            addr.append(ip_port);
            if (i >= this.chipsSystems.size() - 1) continue;
            addr.append("|");
        }
        chipsAddress = addr.toString();
    }

    @Override
    public Session initSession(Session session) throws BaseException {
        try {
            ArrayList<String> aliasList = new ArrayList<String>();
            String token = AKSNativeCryptoService.loginChips(appId, chipsAddress, sysId, chipsTimeout, family, aliasList);
            session.setOptName(appId);
            session.setOptPwd("");
            session.setToken(token);
            session.setUserType(UserEnum.DEV_CRYPTO);
            session.setStatus("Y");
            ArrayList<Key> keys = new ArrayList<Key>();
            for (String alias : aliasList) {
                Key key = new Key();
                key.setAlias(alias);
                key.setUseType(0);
                key.setToken(token);
                keys.add(key);
            }
            session.setAliases(keys);
            session.setServerVersion("offline");
        }
        catch (Exception e) {
            LOGGER.error("initSession has error!", (Throwable)e);
            throw new BaseException("chips", "initSession has error!" + e.getMessage());
        }
        return session;
    }

    @Override
    public void getKeysR6(Session session, List<String> aliasList, List<CertCache> certs) throws BaseException {
        try {
            AKSNativeCryptoService.getAndPutKeysByChips(session.getOptName(), aliasList, certs);
        }
        catch (Exception e) {
            LOGGER.error("handleR6 has error!", (Throwable)e);
            throw new BaseException("chips", "handleR6 has error!" + e.getMessage());
        }
    }
}

