/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server.monitor2;

import com.wangyin.key.server.util.JSON;
import com.wangyin.key.server.util.Nets;
import com.wangyin.key.server.util.StatusUtil;
import java.io.Serializable;

public class MonitorMessage
implements Serializable {
    public static final String IP = Nets.getIp("aks-selfservice-access.jdpay.local");
    private String exception;
    private String date;
    private Long cost;
    private Long startTimestamp;
    private String ip;
    private String apiVersion;
    private String aliasName;
    private String nativeMessage;
    private Integer paramDataLength;
    private String exceptionMessage;
    private Long endTimestamp;
    private String methodName;
    private String className;
    private String appId;
    private Short status;
    private Long startNano;
    private Long endNano;

    public String getException() {
        return this.exception;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public Long getCost() {
        return this.cost;
    }

    public void setCost(Long cost) {
        this.cost = cost;
    }

    public Long getStartTimestamp() {
        return this.startTimestamp;
    }

    public void setStartTimestamp(Long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public void setAliasName(String aliasName) {
        this.aliasName = aliasName;
    }

    public String getNativeMessage() {
        return this.nativeMessage;
    }

    public void setNativeMessage(String nativeMessage) {
        this.nativeMessage = nativeMessage;
    }

    public Integer getParamDataLength() {
        return this.paramDataLength;
    }

    public void setParamDataLength(Integer paramDataLength) {
        this.paramDataLength = paramDataLength;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    public Long getEndTimestamp() {
        return this.endTimestamp;
    }

    public void setEndTimestamp(Long endTimestamp) {
        this.endTimestamp = endTimestamp;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = this.methodName == null || methodName.length() > 2048 ? methodName : this.methodName + "-" + methodName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public Short getStatus() {
        return this.status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    public Long getStartNano() {
        return this.startNano;
    }

    public void setStartNano(Long startNano) {
        this.startNano = startNano;
    }

    public Long getEndNano() {
        return this.endNano;
    }

    public void setEndNano(Long endNano) {
        this.endNano = endNano;
    }

    public MonitorMessage head(String className, String methodName, String appId, String aliasName, Integer paramDataLength) {
        if (!StatusUtil.getInstance().isMonitor(appId)) {
            return this;
        }
        this.setClassName(className);
        this.setMethodName(methodName);
        this.setAppId(appId);
        this.setAliasName(aliasName);
        this.setParamDataLength(paramDataLength);
        this.setStartTimestamp(System.currentTimeMillis());
        this.setStartNano(System.nanoTime());
        this.setIp(IP);
        this.setApiVersion(StatusUtil.getApiVersion());
        return this;
    }

    public MonitorMessage tail(int status, String exception, String exceptionMessage) {
        if (!StatusUtil.getInstance().isMonitor(this.appId)) {
            return this;
        }
        this.setStatus((short)status);
        this.setException(exception);
        this.setExceptionMessage(exceptionMessage);
        return this;
    }

    public MonitorMessage beforeSend() {
        Long end;
        if (!StatusUtil.getInstance().isMonitor(this.appId)) {
            return this;
        }
        this.setEndNano(System.nanoTime());
        this.setEndTimestamp(System.currentTimeMillis());
        Long start = this.getStartNano();
        if (start != null && (end = this.getEndNano()) != null) {
            this.setCost(end - start);
        }
        this.setStartNano(null);
        this.setEndNano(null);
        return this;
    }

    public String toString() {
        return "MonitorMessage{exception='" + this.exception + '\'' + ", date='" + this.date + '\'' + ", cost=" + this.cost + ", startTimestamp=" + this.startTimestamp + ", ip='" + this.ip + '\'' + ", apiVersion='" + this.apiVersion + '\'' + ", aliasName='" + this.aliasName + '\'' + ", nativeMessage='" + this.nativeMessage + '\'' + ", paramDataLength=" + this.paramDataLength + ", exceptionMessage='" + this.exceptionMessage + '\'' + ", endTimestamp=" + this.endTimestamp + ", methodName='" + this.methodName + '\'' + ", className='" + this.className + '\'' + ", appId='" + this.appId + '\'' + ", status=" + this.status + '}';
    }

    public String toJson() {
        return JSON.toJSONString(this);
    }
}

