/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server.pdf;

public class FileTypeVerify {
    public static final String PNG = "89504E47";
    public static final String PDF = "255044462D312E";

    public static String byteToHexString(byte[] srcBytes) {
        if (srcBytes == null || srcBytes.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : srcBytes) {
            int v = b & 0xFF;
            String hexV = Integer.toHexString(v);
            if (hexV.length() < 2) {
                sb.append(0);
            }
            sb.append(hexV);
        }
        return sb.toString();
    }

    public static String getFlieType(byte[] fileContent) {
        String type = FileTypeVerify.byteToHexString(fileContent);
        if (type == null) {
            return null;
        }
        if ((type = type.toUpperCase()).contains(PNG)) {
            return "png";
        }
        if (type.contains(PDF)) {
            return "pdf";
        }
        return null;
    }

    public static boolean isFileType(byte[] fileContent, String type) {
        if (fileContent == null || fileContent.length == 0) {
            return false;
        }
        if (type == null || type.length() == 0) {
            return false;
        }
        String fileType = FileTypeVerify.getFlieType(fileContent);
        if (fileType == null) {
            return false;
        }
        return fileType.equals(type);
    }
}

