/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server.pdf;

import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.codec.Base64;
import com.itextpdf.text.pdf.security.BouncyCastleDigest;
import com.itextpdf.text.pdf.security.DigestAlgorithms;
import com.itextpdf.text.pdf.security.TSAClient;
import com.itextpdf.text.pdf.security.TSAInfoBouncyCastle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cmp.PKIFailureInfo;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSAClientImpl
implements TSAClient {
    public static final int DEFAULTTOKENSIZE = 4096;
    public static final String DEFAULTHASHALGORITHM = "SHA-256";
    private static final Logger LOGGER = LoggerFactory.getLogger(TSAClientImpl.class);
    protected String tsaURL;
    protected String tsaUsername;
    protected String tsaPassword;
    protected TSAInfoBouncyCastle tsaInfo;
    protected int tokenSizeEstimate;
    protected String digestAlgorithm;

    public TSAClientImpl(String url) {
        this(url, null, null, 4096, DEFAULTHASHALGORITHM);
    }

    public TSAClientImpl(String url, String username, String password) {
        this(url, username, password, 4096, DEFAULTHASHALGORITHM);
    }

    public TSAClientImpl(String url, String username, String password, int tokSzEstimate, String digestAlgorithm) {
        this.tsaURL = url;
        this.tsaUsername = username;
        this.tsaPassword = password;
        this.tokenSizeEstimate = tokSzEstimate;
        this.digestAlgorithm = digestAlgorithm;
    }

    public void setTSAInfo(TSAInfoBouncyCastle tsaInfo) {
        this.tsaInfo = tsaInfo;
    }

    public int getTokenSizeEstimate() {
        return this.tokenSizeEstimate;
    }

    public MessageDigest getMessageDigest() throws GeneralSecurityException {
        return new BouncyCastleDigest().getMessageDigest(this.digestAlgorithm);
    }

    public byte[] getTimeStampToken(byte[] imprint) throws IOException, TSPException {
        int value;
        byte[] respBytes = null;
        TimeStampRequestGenerator tsqGenerator = new TimeStampRequestGenerator();
        tsqGenerator.setCertReq(true);
        BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
        TimeStampRequest request = tsqGenerator.generate(new ASN1ObjectIdentifier(DigestAlgorithms.getAllowedDigests((String)this.digestAlgorithm)), imprint, nonce);
        byte[] requestBytes = request.getEncoded();
        respBytes = this.getTSAResponse(requestBytes);
        if (respBytes == null) {
            return null;
        }
        System.out.println("TimeStampResponse is " + Base64.encodeBytes((byte[])respBytes));
        TimeStampResponse response = new TimeStampResponse(respBytes);
        response.validate(request);
        PKIFailureInfo failure = response.getFailInfo();
        int n = value = failure == null ? 0 : failure.intValue();
        if (value != 0) {
            throw new IOException(MessageLocalization.getComposedMessage((String)"invalid.tsa.1.response.code.2", (Object[])new Object[]{this.tsaURL, String.valueOf(value)}));
        }
        TimeStampToken tsToken = response.getTimeStampToken();
        if (tsToken == null) {
            throw new IOException(MessageLocalization.getComposedMessage((String)"tsa.1.failed.to.return.time.stamp.token.2", (Object[])new Object[]{this.tsaURL, response.getStatusString()}));
        }
        TimeStampTokenInfo tsTokenInfo = tsToken.getTimeStampInfo();
        byte[] encoded = tsToken.getEncoded();
        LOGGER.info("Timestamp generated: {}", (Object)tsTokenInfo.getGenTime());
        if (this.tsaInfo != null) {
            this.tsaInfo.inspectTimeStampTokenInfo(tsTokenInfo);
        }
        this.tokenSizeEstimate = encoded.length + 32;
        return encoded;
    }

    protected byte[] getTSAResponse(byte[] requestBytes) throws IOException {
        int retry = 2;
        for (int i = 0; i <= retry; ++i) {
            try {
                return this.tsaRequest(requestBytes);
            }
            catch (Exception e) {
                LOGGER.warn("{} getTSAResponse error: {}, retry time = {}", new Object[]{this.tsaURL, e.getMessage(), i});
                continue;
            }
        }
        LOGGER.warn("AKS signed pdf service timestamp request fail.");
        return null;
    }

    private byte[] tsaRequest(byte[] requestBytes) throws IOException {
        URLConnection tsaConnection;
        URL url = new URL(this.tsaURL);
        try {
            tsaConnection = url.openConnection();
        }
        catch (IOException ioe) {
            throw new IOException(MessageLocalization.getComposedMessage((String)"failed.to.get.tsa.response.from.1", (Object[])new Object[]{this.tsaURL}));
        }
        tsaConnection.setDoInput(true);
        tsaConnection.setDoOutput(true);
        tsaConnection.setUseCaches(false);
        tsaConnection.setRequestProperty("Content-Type", "application/timestamp-query");
        tsaConnection.setRequestProperty("Content-Transfer-Encoding", "binary");
        if (this.tsaUsername != null && !this.tsaUsername.equals("")) {
            String userPassword = this.tsaUsername + ":" + this.tsaPassword;
            tsaConnection.setRequestProperty("Authorization", "Basic " + Base64.encodeBytes((byte[])userPassword.getBytes(), (int)8));
        }
        OutputStream out = tsaConnection.getOutputStream();
        out.write(requestBytes);
        out.close();
        InputStream inp = tsaConnection.getInputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        while ((bytesRead = inp.read(buffer, 0, buffer.length)) >= 0) {
            baos.write(buffer, 0, bytesRead);
        }
        byte[] respBytes = baos.toByteArray();
        String encoding = tsaConnection.getContentEncoding();
        if (encoding != null && encoding.equalsIgnoreCase("base64")) {
            respBytes = Base64.decode((String)new String(respBytes));
        }
        return respBytes;
    }
}

