/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server.thread;

import com.wangyin.key.server.DeviceCryptoService;
import com.wangyin.key.server.model.AksRet;
import com.wangyin.key.server.model.CipherOptEnum;
import com.wangyin.key.server.model.ModeEnum;
import com.wangyin.key.server.model.PaddingEnum;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CipherExecutorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CipherExecutorService.class);
    private static volatile CipherExecutorService instance = null;
    private ExecutorService executorService;

    private CipherExecutorService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CipherExecutorService getInstance() {
        if (instance != null) return instance;
        Class<CipherExecutorService> clazz = CipherExecutorService.class;
        synchronized (CipherExecutorService.class) {
            if (instance != null) return instance;
            instance = new CipherExecutorService();
            instance.initCipherThreadPool();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void initCipherThreadPool() {
        this.executorService = new ThreadPoolExecutor(10, 10, 5L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
    }

    public List<AksRet> execute(DeviceCryptoService deviceCryptoService, CipherOptEnum cipherOpt, String aliasName, ModeEnum mode, PaddingEnum padding, byte[] iv, List<byte[]> datas) {
        if (datas == null || datas.isEmpty()) {
            return null;
        }
        AksRet[] aksRets = new AksRet[datas.size()];
        CountDownLatch counter = new CountDownLatch(datas.size());
        for (int index = 0; index < datas.size(); ++index) {
            CipherRunnable runnable = new CipherRunnable(deviceCryptoService, cipherOpt, aliasName, mode, padding, iv, datas.get(index), index, aksRets, counter);
            this.executorService.execute(runnable);
        }
        try {
            counter.await();
        }
        catch (InterruptedException e) {
            LOGGER.error("CipherExecutorService execute sleep exception.", (Throwable)e);
        }
        return Arrays.asList(aksRets);
    }

    private static class CipherRunnable
    implements Runnable {
        private DeviceCryptoService cryptoService;
        private CipherOptEnum cipherOpt;
        private String aliasName;
        private ModeEnum mode;
        private PaddingEnum padding;
        private byte[] iv;
        private byte[] data;
        private int index;
        private AksRet[] aksRets;
        private CountDownLatch counter;

        public CipherRunnable(DeviceCryptoService deviceCryptoService, CipherOptEnum cipherOpt, String aliasName, ModeEnum mode, PaddingEnum padding, byte[] iv, byte[] data, int index, AksRet[] aksRets, CountDownLatch counter) {
            this.cryptoService = deviceCryptoService;
            this.cipherOpt = cipherOpt;
            this.aliasName = aliasName;
            this.mode = mode;
            this.padding = padding;
            this.iv = iv;
            this.data = data;
            this.index = index;
            this.aksRets = aksRets;
            this.counter = counter;
        }

        @Override
        public void run() {
            try {
                byte[] result = this.cipherOpt == CipherOptEnum.ENCRYPT ? this.cryptoService.encrypt(this.aliasName, this.mode, this.padding, this.iv, this.data) : this.cryptoService.decrypt(this.aliasName, this.mode, this.padding, this.iv, this.data);
                String code = result == null ? "fail" : "success";
                this.aksRets[this.index] = new AksRet(code, result);
            }
            catch (Throwable e) {
                LOGGER.error("CipherRunnable exception.", e);
                this.aksRets[this.index] = new AksRet("fail", e.getMessage().getBytes());
            }
            this.counter.countDown();
        }
    }
}

