/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server.util;

public final class DatatypeConverter {
    private static volatile DatatypeConverterImpl theConverter;

    private DatatypeConverter() {
    }

    private static synchronized void initConverter() {
        theConverter = new DatatypeConverterImpl();
    }

    public static byte[] parseBase64Binary(String lexicalXSDBase64Binary) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseBase64Binary(lexicalXSDBase64Binary);
    }

    public static byte[] parseHexBinary(String lexicalXSDHexBinary) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.parseHexBinary(lexicalXSDHexBinary);
    }

    public static String printBase64Binary(byte[] val) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printBase64Binary(val);
    }

    public static String printHexBinary(byte[] val) {
        if (theConverter == null) {
            DatatypeConverter.initConverter();
        }
        return theConverter.printHexBinary(val);
    }

    private static final class DatatypeConverterImpl {
        private static final byte[] decodeMap = DatatypeConverterImpl.initDecodeMap();
        private static final char[] encodeMap = DatatypeConverterImpl.initEncodeMap();
        private static final char[] hexCode = "0123456789ABCDEF".toCharArray();

        private DatatypeConverterImpl() {
        }

        public byte[] parseBase64Binary(String lexicalXSDBase64Binary) {
            return DatatypeConverterImpl._parseBase64Binary(lexicalXSDBase64Binary);
        }

        private static byte[] _parseBase64Binary(String text) {
            int bufLen = DatatypeConverterImpl.guessLength(text);
            byte[] out = new byte[bufLen];
            int o = 0;
            int len = text.length();
            byte[] quadruplet = new byte[4];
            int q = 0;
            for (int i = 0; i < len; ++i) {
                char ch = text.charAt(i);
                byte v = decodeMap[ch];
                if (v != -1) {
                    quadruplet[q++] = v;
                }
                if (q != 4) continue;
                out[o++] = (byte)(quadruplet[0] << 2 | quadruplet[1] >> 4);
                if (quadruplet[2] != 127) {
                    out[o++] = (byte)(quadruplet[1] << 4 | quadruplet[2] >> 2);
                }
                if (quadruplet[3] != 127) {
                    out[o++] = (byte)(quadruplet[2] << 6 | quadruplet[3]);
                }
                q = 0;
            }
            if (bufLen == o) {
                return out;
            }
            byte[] nb = new byte[o];
            System.arraycopy(out, 0, nb, 0, o);
            return nb;
        }

        public String printBase64Binary(byte[] val) {
            return DatatypeConverterImpl._printBase64Binary(val);
        }

        private static String _printBase64Binary(byte[] input) {
            return DatatypeConverterImpl._printBase64Binary(input, 0, input.length);
        }

        private static String _printBase64Binary(byte[] input, int offset, int len) {
            char[] buf = new char[(len + 2) / 3 * 4];
            int ptr = DatatypeConverterImpl._printBase64Binary(input, offset, len, buf, 0);
            assert (ptr == buf.length);
            return new String(buf);
        }

        private static int _printBase64Binary(byte[] input, int offset, int len, char[] buf, int ptr) {
            int remaining = len;
            int i = offset;
            while (remaining >= 3) {
                buf[ptr++] = DatatypeConverterImpl.encode(input[i] >> 2);
                buf[ptr++] = DatatypeConverterImpl.encode((input[i] & 3) << 4 | input[i + 1] >> 4 & 0xF);
                buf[ptr++] = DatatypeConverterImpl.encode((input[i + 1] & 0xF) << 2 | input[i + 2] >> 6 & 3);
                buf[ptr++] = DatatypeConverterImpl.encode(input[i + 2] & 0x3F);
                remaining -= 3;
                i += 3;
            }
            if (remaining == 1) {
                buf[ptr++] = DatatypeConverterImpl.encode(input[i] >> 2);
                buf[ptr++] = DatatypeConverterImpl.encode((input[i] & 3) << 4);
                buf[ptr++] = 61;
                buf[ptr++] = 61;
            }
            if (remaining == 2) {
                buf[ptr++] = DatatypeConverterImpl.encode(input[i] >> 2);
                buf[ptr++] = DatatypeConverterImpl.encode((input[i] & 3) << 4 | input[i + 1] >> 4 & 0xF);
                buf[ptr++] = DatatypeConverterImpl.encode((input[i + 1] & 0xF) << 2);
                buf[ptr++] = 61;
            }
            return ptr;
        }

        public byte[] parseHexBinary(String s) {
            int len = s.length();
            if (len % 2 != 0) {
                throw new IllegalArgumentException("hexBinary needs to be even-length: " + s);
            }
            byte[] out = new byte[len / 2];
            for (int i = 0; i < len; i += 2) {
                int h = DatatypeConverterImpl.hexToBin(s.charAt(i));
                int l = DatatypeConverterImpl.hexToBin(s.charAt(i + 1));
                if (h == -1 || l == -1) {
                    throw new IllegalArgumentException("contains illegal character for hexBinary: " + s);
                }
                out[i / 2] = (byte)(h * 16 + l);
            }
            return out;
        }

        public String printHexBinary(byte[] data) {
            StringBuilder r = new StringBuilder(data.length * 2);
            for (byte b : data) {
                r.append(hexCode[b >> 4 & 0xF]);
                r.append(hexCode[b & 0xF]);
            }
            return r.toString();
        }

        private static byte[] initDecodeMap() {
            int i;
            byte[] map = new byte[128];
            for (i = 0; i < 128; ++i) {
                map[i] = -1;
            }
            for (i = 65; i <= 90; ++i) {
                map[i] = (byte)(i - 65);
            }
            for (i = 97; i <= 122; ++i) {
                map[i] = (byte)(i - 97 + 26);
            }
            for (i = 48; i <= 57; ++i) {
                map[i] = (byte)(i - 48 + 52);
            }
            map[43] = 62;
            map[47] = 63;
            map[61] = 127;
            return map;
        }

        private static char[] initEncodeMap() {
            int i;
            char[] map = new char[64];
            for (i = 0; i < 26; ++i) {
                map[i] = (char)(65 + i);
            }
            for (i = 26; i < 52; ++i) {
                map[i] = (char)(97 + (i - 26));
            }
            for (i = 52; i < 62; ++i) {
                map[i] = (char)(48 + (i - 52));
            }
            map[62] = 43;
            map[63] = 47;
            return map;
        }

        private static int guessLength(String text) {
            int padSize;
            int j;
            int len = text.length();
            for (j = len - 1; j >= 0; --j) {
                byte code = decodeMap[text.charAt(j)];
                if (code == 127) continue;
                if (code != -1) break;
                return text.length() / 4 * 3;
            }
            return (padSize = len - ++j) > 2 ? text.length() / 4 * 3 : text.length() / 4 * 3 - padSize;
        }

        private static int hexToBin(char ch) {
            if ('0' <= ch && ch <= '9') {
                return ch - 48;
            }
            if ('A' <= ch && ch <= 'F') {
                return ch - 65 + 10;
            }
            return 'a' <= ch && ch <= 'f' ? ch - 97 + 10 : -1;
        }

        private static char encode(int i) {
            return encodeMap[i & 0x3F];
        }

        private static byte encodeByte(int i) {
            return (byte)encodeMap[i & 0x3F];
        }
    }
}

