/*
 * Decompiled with CFR 0.152.
 */
package com.wangyin.key.server.util;

import com.wangyin.key.server.exception.BaseException;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class StringUtil {
    private static final byte[] BASE64_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 62, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};

    public static String i2String(int length) {
        String value = String.valueOf(length);
        if (length / 1000 != 0) {
            return value;
        }
        if (length / 100 != 0) {
            return "0" + value;
        }
        if (length / 10 != 0) {
            return "00" + value;
        }
        return "000" + value;
    }

    public static String i2String(int value, int length) {
        String result = String.valueOf(value);
        StringBuilder sb = new StringBuilder();
        int count = length - result.length();
        for (int i = 0; i < count; ++i) {
            sb.append("0");
        }
        sb.append(result);
        return sb.toString();
    }

    public static String l2HexString(long value, int length) {
        String result = String.format("%X", value);
        StringBuilder sb = new StringBuilder();
        int count = length - result.length();
        for (int i = 0; i < count; ++i) {
            sb.append("0");
        }
        sb.append(result);
        return sb.toString();
    }

    public static String i2TString(int length) {
        String value = String.valueOf(length);
        if (value.length() == 2) {
            return value;
        }
        return "0" + value;
    }

    public static List<String> string2List(String str) throws Exception {
        int length;
        ArrayList<String> list = new ArrayList<String>();
        for (int index = 0; index != str.length(); index += length) {
            length = Integer.parseInt(str.substring(index, index + 4));
            String temp = str.substring(index += 4, index + length);
            list.add(temp);
        }
        return list;
    }

    public static String[] string2Array(String str2) throws BaseException {
        if (null == str2 || str2.isEmpty()) {
            return new String[]{"0", ""};
        }
        int index = 0;
        int len = 0;
        String totalsize = "";
        String result = "";
        try {
            totalsize = str2.substring(index, index + 4);
            len = Integer.parseInt(totalsize);
            totalsize = str2.substring(index += 4, index + len);
            result = str2.substring(index + len);
        }
        catch (IndexOutOfBoundsException e) {
            totalsize = "0";
            result = "";
        }
        catch (NumberFormatException e1) {
            totalsize = "0";
            result = "";
        }
        return new String[]{totalsize, result};
    }

    public static char[] i2Char(int length) {
        char[] cc = new char[4];
        int i = length / 16581375;
        int j = (length - 16581375 * i) / 65025;
        int k = (length - 16581375 * i - 65025 * j) / 255;
        int l = length - 16581375 * i - 65025 * j - 255 * k;
        cc[0] = (char)i;
        cc[1] = (char)j;
        cc[2] = (char)k;
        cc[3] = (char)l;
        return cc;
    }

    public static String threadID2String() {
        String msgIndex = "";
        msgIndex = StringUtil.i2String((int)Thread.currentThread().getId(), 6);
        return msgIndex;
    }

    public static String getPid() {
        String runtimeMXBeanName = ManagementFactory.getRuntimeMXBean().getName();
        return runtimeMXBeanName.split("@")[0];
    }

    private static boolean isWhiteSpace(byte byteToCheck) {
        return byteToCheck == 9 || byteToCheck == 10 || byteToCheck == 13 || byteToCheck == 32;
    }

    private static boolean isBase64(byte octet) {
        return octet == 61 || octet >= 0 && octet < BASE64_TABLE.length && BASE64_TABLE[octet] != -1;
    }

    public static boolean isBase64(String str) {
        return StringUtil.isBase64(str.getBytes(Charset.forName("UTF-8")));
    }

    public static boolean isBase64(byte[] str) {
        for (byte b : str) {
            if (StringUtil.isBase64(b) || StringUtil.isWhiteSpace(b)) continue;
            return false;
        }
        return true;
    }
}

