/*
 * Decompiled with CFR 0.152.
 */
package com.jd.jr.aks.security.crypto.aks;

import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ReferenceConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.jd.jr.aks.security.crypto.Decryption;
import com.jd.jr.aks.security.crypto.aks.AksConfig;
import com.jd.jr.aks.security.exception.DecryptException;
import com.jd.jr.aks.security.exception.FailFastException;
import com.jd.jr.aks.security.monitor.MonitorMessageBuilder;
import com.jd.jr.aks.security.utils.Reflector;
import com.jd.jsf.gd.config.ConsumerConfig;
import com.wangyin.key.server.CryptoDistanceService;
import com.wangyin.key.server.DeviceCryptoService;
import com.wangyin.key.server.IBaseCryptoService;
import com.wangyin.key.server.JSFCryptoDistanceService;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAksCipher
implements Decryption {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AbstractAksCipher.class.getName());
    private AksConfig config;
    private DeviceCryptoService jsf;
    private DeviceCryptoService dubbo;

    void init() {
        this.config = this.config();
        if (this.config.loadWithJSF()) {
            this.loadJSF1();
            if (this.jsf != null) {
                return;
            }
        }
        if (this.config.loadWithDubbo()) {
            int version = this.checkDubboVersion();
            if ((version & 2) != 0) {
                this.loadApacheDubbo();
                if (this.dubbo != null) {
                    return;
                }
            }
            if ((version & 1) != 0) {
                this.loadAlibabaDubbo();
                if (this.dubbo != null) {
                    return;
                }
            }
            if (version == 0) {
                LOGGER.warn("[AKS CONFIG SECURITY:1.2.3] \u672a\u53d1\u73b0\u53ef\u7528\u7684dubbo\u4f9d\u8d56\uff0cAKS\u5c06\u5ffd\u7565dubbo\u521d\u59cb\u5316.");
            }
        }
        if (this.jsf == null && this.dubbo == null) {
            LOGGER.error("[AKS CONFIG SECURITY:1.2.3] AKS \u521d\u59cb\u5316\u5931\u8d25.");
            FailFastException fe = new FailFastException("[AKS CONFIG SECURITY:1.2.3] AKS \u521d\u59cb\u5316\u5931\u8d25.");
            new MonitorMessageBuilder().className(this.getClass().getSimpleName()).methodName("init").exception(fe).send();
            throw fe;
        }
    }

    private void loadAlibabaDubbo() {
        try {
            LOGGER.info("[AKS CONFIG SECURITY:1.2.3] AKS alibaba dubbo\u5f00\u59cb\u8fdb\u884c\u521d\u59cb\u5316.");
            ApplicationConfig application = new ApplicationConfig();
            application.setName(this.config.getDubboName());
            RegistryConfig registry = new RegistryConfig();
            registry.setAddress(this.config.getDubboAddress());
            ReferenceConfig reference = new ReferenceConfig();
            reference.setApplication(application);
            reference.setRegistry(registry);
            reference.setInterface(CryptoDistanceService.class);
            reference.setCheck(Boolean.valueOf(false));
            CryptoDistanceService service = (CryptoDistanceService)reference.get();
            DeviceCryptoService deviceCryptoService = new DeviceCryptoService();
            deviceCryptoService.setCryptoDisService((IBaseCryptoService)service);
            deviceCryptoService.setAppId(this.config.getAksAppId());
            try {
                deviceCryptoService.setHeartbeatInterval(118);
            }
            catch (Throwable t) {
                LOGGER.warn("[AKS CONFIG SECURITY:1.2.3] \u8f83\u4f4e\u7684AKS API\u7248\u672c\uff0c\u4e0d\u652f\u6301\u8bbe\u7f6e\u5fc3\u8df3\u95f4\u9694\uff0c\u5efa\u8bae\u5347\u7ea7AKS API\u4e3a\u6700\u65b0\u7248\u672c.");
            }
            deviceCryptoService.init();
            this.dubbo = deviceCryptoService;
            LOGGER.info("[AKS CONFIG SECURITY:1.2.3] AKS alibaba dubbo\u521d\u59cb\u5316\u5b8c\u6210.");
            new MonitorMessageBuilder().className(this.getClass().getSimpleName()).methodName("init").send();
            LOGGER.info("[AKS CONFIG SECURITY:1.2.3] AKS \u521d\u59cb\u5316\u6210\u529f.");
        }
        catch (Throwable e) {
            LOGGER.error("[AKS CONFIG SECURITY:1.2.3] AKS alibaba dubbo\u521d\u59cb\u5316\u5931\u8d25.", e);
        }
    }

    private void loadApacheDubbo() {
        try {
            LOGGER.info("[AKS CONFIG SECURITY:1.2.3] AKS apache dubbo\u5f00\u59cb\u8fdb\u884c\u521d\u59cb\u5316.");
            Reflector application = Reflector.of("org.apache.dubbo.config.ApplicationConfig").c().t(new Class[0]).p(new Object[0]);
            application.m("setName").t(String.class).p(this.config.getDubboName());
            Reflector registry = Reflector.of("org.apache.dubbo.config.RegistryConfig").c().t(new Class[0]).p(new Object[0]);
            registry.m("setAddress").t(String.class).p(this.config.getDubboAddress());
            Reflector reference = Reflector.of("org.apache.dubbo.config.ReferenceConfig").c().t(new Class[0]).p(new Object[0]);
            reference.m("setApplication").t(Class.forName("org.apache.dubbo.config.ApplicationConfig")).p(application.getInstance());
            reference.m("setRegistry").t(Class.forName("org.apache.dubbo.config.RegistryConfig")).p(registry.getInstance());
            reference.m("setInterface").t(Class.class).p(CryptoDistanceService.class);
            reference.m("setCheck").t(Boolean.class).p(false);
            CryptoDistanceService service = (CryptoDistanceService)reference.m("get").t(new Class[0]).p(new Object[0]);
            DeviceCryptoService deviceCryptoService = new DeviceCryptoService();
            deviceCryptoService.setCryptoDisService((IBaseCryptoService)service);
            deviceCryptoService.setAppId(this.config.getAksAppId());
            try {
                deviceCryptoService.setHeartbeatInterval(118);
            }
            catch (Throwable t) {
                LOGGER.warn("[AKS CONFIG SECURITY:1.2.3] \u8f83\u4f4e\u7684AKS API\u7248\u672c\uff0c\u4e0d\u652f\u6301\u8bbe\u7f6e\u5fc3\u8df3\u95f4\u9694\uff0c\u5efa\u8bae\u5347\u7ea7AKS API\u4e3a\u6700\u65b0\u7248\u672c.");
            }
            deviceCryptoService.init();
            this.dubbo = deviceCryptoService;
            LOGGER.info("[AKS CONFIG SECURITY:1.2.3] AKS apache dubbo\u521d\u59cb\u5316\u5b8c\u6210.");
            new MonitorMessageBuilder().className(this.getClass().getSimpleName()).methodName("init").send();
            LOGGER.info("[AKS CONFIG SECURITY:1.2.3] AKS \u521d\u59cb\u5316\u6210\u529f.");
        }
        catch (Throwable e) {
            LOGGER.error("[AKS CONFIG SECURITY:1.2.3] AKS apache dubbo\u521d\u59cb\u5316\u5931\u8d25.", e);
        }
    }

    private void loadJSF1() {
        try {
            LOGGER.info("[AKS CONFIG SECURITY:1.2.3] AKS Jsf\u5f00\u59cb\u8fdb\u884c\u521d\u59cb\u5316.");
            ConsumerConfig consumerConfig = new ConsumerConfig();
            consumerConfig.setInterfaceId(this.config.getJsfInterfaceId());
            consumerConfig.setAlias(this.config.getJsfAlias());
            consumerConfig.setProtocol(this.config.getJsfProtocol());
            consumerConfig.setUrl(this.config.getJsfConsumerUrl());
            consumerConfig.setRegister(false);
            consumerConfig.setSubscribe(false);
            consumerConfig.setHeartbeat(0);
            JSFCryptoDistanceService service = (JSFCryptoDistanceService)consumerConfig.refer();
            DeviceCryptoService deviceCryptoService = new DeviceCryptoService();
            deviceCryptoService.setCryptoDisService((IBaseCryptoService)service);
            deviceCryptoService.setAppId(this.config.getAksAppId());
            try {
                deviceCryptoService.setHeartbeatInterval(118);
            }
            catch (Throwable t) {
                LOGGER.warn("[AKS CONFIG SECURITY:1.2.3] \u8f83\u4f4e\u7684AKS API\u7248\u672c\uff0c\u4e0d\u652f\u6301\u8bbe\u7f6e\u5fc3\u8df3\u95f4\u9694\uff0c\u5efa\u8bae\u5347\u7ea7AKS API\u4e3a\u6700\u65b0\u7248\u672c.");
            }
            deviceCryptoService.init();
            this.jsf = deviceCryptoService;
            LOGGER.info("[AKS CONFIG SECURITY:1.2.3] AKS Jsf\u521d\u59cb\u5316\u5b8c\u6210.");
            new MonitorMessageBuilder().className(this.getClass().getSimpleName()).methodName("init").send();
            LOGGER.info("[AKS CONFIG SECURITY:1.2.3] AKS \u521d\u59cb\u5316\u6210\u529f.");
        }
        catch (Throwable ex) {
            LOGGER.warn("[AKS CONFIG SECURITY:1.2.3] AKS Jsf\u521d\u59cb\u5316\u5931\u8d25.", ex);
        }
    }

    abstract AksConfig config();

    @Override
    public String decrypt(String ciphertext) throws DecryptException {
        try {
            DeviceCryptoService service = this.jsf != null ? this.jsf : this.dubbo;
            String aliasName = this.config.getAksAliasName();
            byte[] bytes = service.decryptString(aliasName, ciphertext);
            return new String(bytes, "UTF-8");
        }
        catch (Exception e) {
            throw new DecryptException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AksConfig tryLoadConfig() {
        InputStream stream = null;
        try {
            AksConfig aksConfig;
            PropertyDescriptor[] descriptors;
            stream = AbstractAksCipher.class.getClassLoader().getResourceAsStream("important.properties");
            if (stream == null) {
                AksConfig aksConfig2 = null;
                return aksConfig2;
            }
            Properties props = new Properties();
            props.load(stream);
            AksConfig config = new AksConfig();
            BeanInfo beanInfo = Introspector.getBeanInfo(AksConfig.class);
            for (PropertyDescriptor property : descriptors = beanInfo.getPropertyDescriptors()) {
                String name = property.getName();
                Method method = property.getWriteMethod();
                if ("class".equals(name) || name == null || method == null || !props.containsKey(name = "aks.config.security." + name)) continue;
                method.invoke((Object)config, props.getProperty(name));
            }
            if (config.emptyConfig()) {
                aksConfig = null;
                return aksConfig;
            }
            aksConfig = config;
            return aksConfig;
        }
        catch (Exception e) {
            AksConfig aksConfig = null;
            return aksConfig;
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                stream = null;
            }
        }
    }

    private int checkDubboVersion() {
        int version = 0;
        try {
            try {
                Class<?> clazz = Class.forName("org.apache.dubbo.common.Version");
                version |= 2;
                String v = (String)Reflector.from(clazz).m("getVersion").t(new Class[0]).p(new Object[0]);
                if ("2.7.0".compareToIgnoreCase(v) > 0) {
                    version |= 1;
                }
            }
            catch (ClassNotFoundException e) {
                try {
                    Class<?> clazz = Class.forName("com.alibaba.dubbo.common.Version");
                    String v = (String)Reflector.from(clazz).m("getVersion").t(new Class[0]).p(new Object[0]);
                    if ("2.7.0".compareToIgnoreCase(v) > 0) {
                        version |= 1;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        catch (Throwable t) {
            LOGGER.warn("[AKS CONFIG SECURITY:1.2.3] " + t.getMessage(), t);
        }
        return version;
    }
}

