/*
 * Decompiled with CFR 0.152.
 */
package com.jd.jr.aks.security.monitor;

import com.jd.jr.aks.security.utils.JSON;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public abstract class HttpClient {
    public static String get(String url, Map<String, String> headers) {
        try {
            return HttpClient.connect(url, HttpMethodEnum.GET, headers, null, null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T get(String url, Map<String, String> headers, Class<T> clazz) {
        try {
            String result = HttpClient.connect(url, HttpMethodEnum.GET, headers, null, null);
            return JSON.parseObject(result, clazz);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String post(String url, Map<String, String> headers, Map<String, String> params, String payload) {
        try {
            return HttpClient.connect(url, HttpMethodEnum.POST, headers, params, payload);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T post(String url, Map<String, String> headers, Map<String, String> params, String payload, Class<T> clazz) {
        try {
            String result = HttpClient.connect(url, HttpMethodEnum.POST, headers, params, payload);
            return JSON.parseObject(result, clazz);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String connect(String url, HttpMethodEnum method, Map<String, String> headers, Map<String, String> params, String payload) throws Exception {
        String line;
        URL $url = new URL(HttpClient.joinParams(url, params));
        HttpURLConnection conn = (HttpURLConnection)$url.openConnection();
        conn.setRequestMethod(method.name());
        conn.setConnectTimeout(1000);
        conn.setReadTimeout(1000);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (payload != null) {
            OutputStream out = conn.getOutputStream();
            out.write(payload.getBytes("UTF-8"));
            out.close();
        }
        StringBuilder sb = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = in.readLine()) != null) {
            sb.append(line);
        }
        in.close();
        return sb.toString();
    }

    private static String joinParams(String url, Map<String, String> params) {
        StringBuilder sb = url != null && url.contains("?") ? new StringBuilder("&") : new StringBuilder("?");
        if (params == null || params.isEmpty()) {
            return url;
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        return sb.substring(0, sb.length() - 1);
    }

    static enum HttpMethodEnum {
        GET,
        HEAD,
        POST,
        PUT,
        DELETE,
        CONNECT,
        OPTIONS,
        TRACE,
        PATCH;

    }
}

