/*
 * Decompiled with CFR 0.152.
 */
package com.jd.jr.aks.security.monitor;

import com.jd.jr.aks.security.configuration.EnvMode;
import com.jd.jr.aks.security.monitor.FMQClient;
import com.jd.jr.aks.security.monitor.MonitorMessage;
import com.jd.jr.aks.security.utils.Nets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class MonitorMessageBuilder {
    private static FMQClient client;
    private final MonitorMessage msg = new MonitorMessage();

    public static void initClient() {
        client = FMQClientHolder.instance;
    }

    public MonitorMessageBuilder className(String className) {
        this.msg.setClassName(className);
        return this;
    }

    public MonitorMessageBuilder methodName(String methodName) {
        this.msg.setMethodName(methodName);
        return this;
    }

    public MonitorMessageBuilder key(String key) {
        this.msg.setKey(key);
        return this;
    }

    public MonitorMessageBuilder exception(Exception exception) {
        int trace = 5;
        this.msg.setException(exception.getClass().getName());
        this.msg.setExceptionMessage(exception.getMessage());
        Object[] stackTraces = exception.getStackTrace();
        if (stackTraces.length < trace) {
            this.msg.setExceptionTrace(Arrays.toString(stackTraces));
        } else {
            Object[] newStackTraces = new StackTraceElement[trace];
            System.arraycopy(stackTraces, 0, newStackTraces, 0, trace);
            this.msg.setExceptionTrace(Arrays.toString(newStackTraces));
        }
        return this;
    }

    public MonitorMessage build() {
        return this.msg;
    }

    public void send() {
        try {
            this.msg.setDate(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
            this.msg.setTimestamp(System.currentTimeMillis());
            this.msg.setMode(EnvMode.get().name());
            this.msg.setPrefix(EnvMode.prefix());
            this.msg.setSuffix(EnvMode.suffix());
            this.msg.setIp(Nets.getIp(client.getProxy()));
            if (this.msg.getException() == null) {
                this.msg.setStatus((short)200);
            } else {
                this.msg.setStatus((short)500);
            }
            client.produce(this.msg.toJson());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class FMQClientHolder {
        private static final FMQClient instance = new FMQClient();

        private FMQClientHolder() {
        }
    }
}

