package com.cnooc.expert.controller.portal;

import com.cnooc.expert.common.response.ApiResult;
import com.cnooc.expert.controller.common.AbstractBaseController;
import com.cnooc.expert.controller.portal.model.request.AgentNumReq;
import com.cnooc.expert.controller.portal.model.request.AgentPageReq;
import com.cnooc.expert.controller.portal.model.request.MessagePageReq;
import com.cnooc.expert.external.common.model.response.ApiBasePageResp;
import com.cnooc.expert.external.portal.model.response.AgentNumGetApiResp;
import com.cnooc.expert.external.portal.model.response.AgentNumPageApiResp;
import com.cnooc.expert.external.portal.model.response.MessageNumGetApiResp;
import com.cnooc.expert.external.portal.model.response.MessageNumPageApiResp;
import com.cnooc.expert.service.portal.PortalService;
import com.fasterxml.jackson.core.JsonProcessingException;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@AllArgsConstructor
@RestController
@RequestMapping("/portal")
public class PortalController extends AbstractBaseController {

    private final PortalService portalService;

    // *** 业务待办 ***

    /**
     * 已办待办数量
     *
     * @return
     */
    @PostMapping("/agent/num")
    public ApiResult<AgentNumGetApiResp> agentNum(AgentNumReq req) {
        AgentNumGetApiResp apiResp = portalService.getAgentNum(req);
        return ApiResult.successWithResult(apiResp);
    }

    /**
     * 已办待办分页列表
     *
     * @return
     */
    @PostMapping("/agent/page")
    public ApiResult<ApiBasePageResp<AgentNumPageApiResp>> agentPage(@RequestBody @Validated AgentPageReq req) {
        ApiBasePageResp<AgentNumPageApiResp> apiResp = portalService.pageAgentNum(req);
        return ApiResult.successWithResult(apiResp);
    }

    // *** 我的消息 ***

    /**
     * 已读未读数量查询
     *
     * @return
     */
    @PostMapping("/message/num")
    public ApiResult<MessageNumGetApiResp> messageNum() {
        MessageNumGetApiResp apiResp = portalService.getMessageNum(null);
        return ApiResult.successWithResult(apiResp);
    }

    /**
     * 消息列表查询
     *
     * @param req
     * @return
     */
    @PostMapping("/message/page")
    public ApiResult<ApiBasePageResp<MessageNumPageApiResp>> messagePage(@RequestBody @Validated MessagePageReq req) {
        ApiBasePageResp<MessageNumPageApiResp> apiResp = portalService.pageMessageNum(req);
        return ApiResult.successWithResult(apiResp);
    }

}
