package com.cnooc.expert.external.expert.api;

import com.cnooc.expert.controller.expert.model.request.ExpertInfoUpdateApiReq;
import com.cnooc.expert.external.common.model.response.ApiBasePageResp;
import com.cnooc.expert.external.common.model.response.ApiBaseResult;
import com.cnooc.expert.external.expert.model.request.ApproveNodeGetApiReq;
import com.cnooc.expert.external.expert.model.request.CityTreeApiReq;
import com.cnooc.expert.external.expert.model.request.CommonFuJianListApiReq;
import com.cnooc.expert.external.expert.model.request.CommonJiTuanErJiDanWeiListApiReq;
import com.cnooc.expert.external.expert.model.request.CommonNofilterEnumGetApiReq;
import com.cnooc.expert.external.expert.model.request.DictByParentListApiReq;
import com.cnooc.expert.external.expert.model.request.DongJieGetApiReq;
import com.cnooc.expert.external.expert.model.request.DongJieZhuanYePageApiReq;
import com.cnooc.expert.external.expert.model.request.ExamPaperSubmitApiReq;
import com.cnooc.expert.external.expert.model.request.ExamQuestionListApiReq;
import com.cnooc.expert.external.expert.model.request.ExamQuestionXiaoTiListApiReq;
import com.cnooc.expert.external.expert.model.request.ExamRecordSaveApiReq;
import com.cnooc.expert.external.expert.model.request.ExpertInfoGetApiReq;
import com.cnooc.expert.external.expert.model.request.FirstCategoryExpertApplyApiReq;
import com.cnooc.expert.external.expert.model.request.GeRenXiuJiaApplyApiReq;
import com.cnooc.expert.external.expert.model.request.GeRenXiuJiaPageApiReq;
import com.cnooc.expert.external.expert.model.request.XiuGaiJiLuSqByTypeQueryApiReq;
import com.cnooc.expert.external.expert.model.response.GeRenXiuJiaZhuXiaoTimeUpdateApiResp;
import com.cnooc.expert.external.expert.model.request.JinJiQingJiaApplyApiReq;
import com.cnooc.expert.external.expert.model.request.JinJiQingJiaPageApiReq;
import com.cnooc.expert.external.expert.model.request.TainLessonProgressUpdateApiReq;
import com.cnooc.expert.external.expert.model.request.TempExamPaperGetApiReq;
import com.cnooc.expert.external.expert.model.request.TrainCourseGetApiReq;
import com.cnooc.expert.external.expert.model.request.TrainCourseLessonGetApiReq;
import com.cnooc.expert.external.expert.model.request.TrainCourseLessonPageApiReq;
import com.cnooc.expert.external.expert.model.request.TrainExamPageApiReq;
import com.cnooc.expert.external.expert.model.request.ViolationAuditRecordListApiReq;
import com.cnooc.expert.external.expert.model.request.ViolationExpertGetApiReq;
import com.cnooc.expert.external.expert.model.request.ViolationExpertPageApiReq;
import com.cnooc.expert.external.expert.model.request.XiangMuInfoByChouQuNumGetApiReq;
import com.cnooc.expert.external.expert.model.request.ZhuanJiaInfoGetByBusinessIdApiReq;
import com.cnooc.expert.external.expert.model.request.ZhuanJiaPingBiaoXiangMuRenWuPageApiReq;
import com.cnooc.expert.external.expert.model.response.ApproveNodeGetApiResp;
import com.cnooc.expert.external.expert.model.response.CityTreeApiResp;
import com.cnooc.expert.external.expert.model.response.CommonFuJianListApiResp;
import com.cnooc.expert.external.expert.model.response.CommonJiTuanErJiDanWeiListApiResp;
import com.cnooc.expert.external.expert.model.response.CommonNofilterEnumGetApiResp;
import com.cnooc.expert.external.expert.model.response.DictByParentListApiResp;
import com.cnooc.expert.external.expert.model.response.DongJieGetApiResp;
import com.cnooc.expert.external.expert.model.response.DongJieZhuanYePageApiResp;
import com.cnooc.expert.external.expert.model.response.ExamPaperSubmitApiResp;
import com.cnooc.expert.external.expert.model.response.ExamQuestionListApiResp;
import com.cnooc.expert.external.expert.model.response.ExamQuestionXiaoTiListApiResp;
import com.cnooc.expert.external.expert.model.response.ExamRecordSaveApiResp;
import com.cnooc.expert.external.expert.model.response.ExpertInfoGetApiResp;
import com.cnooc.expert.external.expert.model.response.FirstCategoryExpertApplyApiResp;
import com.cnooc.expert.external.expert.model.response.GeRenXiuJiaApplyApiResp;
import com.cnooc.expert.external.expert.model.response.GeRenXiuJiaPageApiResp;
import com.cnooc.expert.external.expert.model.response.JinJiQingJiaApplyApiResp;
import com.cnooc.expert.external.expert.model.response.JinJiQingJiaPageApiResp;
import com.cnooc.expert.external.expert.model.response.TainLessonProgressUpdateApiResp;
import com.cnooc.expert.external.expert.model.response.TempExamPaperGetApiResp;
import com.cnooc.expert.external.expert.model.response.TrainCourseGetApiResp;
import com.cnooc.expert.external.expert.model.response.TrainCourseLessonGetApiResp;
import com.cnooc.expert.external.expert.model.response.TrainCourseLessonPageApiResp;
import com.cnooc.expert.external.expert.model.response.TrainCoursePageApiReq;
import com.cnooc.expert.external.expert.model.response.TrainCoursePageApiResp;
import com.cnooc.expert.external.expert.model.response.TrainExamPageApiResp;
import com.cnooc.expert.external.expert.model.response.ViolationAuditRecordListApiResp;
import com.cnooc.expert.external.expert.model.response.ViolationExpertGetApiResp;
import com.cnooc.expert.external.expert.model.response.ViolationExpertPageApiResp;
import com.cnooc.expert.external.expert.model.response.XiangMuInfoByChouQuNumGetApiResp;
import com.cnooc.expert.external.expert.model.response.XiuGaiJiLuSqByTypeQueryApiResp;
import com.cnooc.expert.external.expert.model.response.ZhuanJiaInfoGetByBusinessIdApiResp;
import com.cnooc.expert.external.expert.model.response.ZhuanJiaPingBiaoXiangMuRenWuPageApiResp;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.HeaderMap;
import retrofit2.http.POST;
import retrofit2.http.Query;

import java.util.List;
import java.util.Map;

public interface ExpertServiceApi {

    @POST("/api/saas-expert/mini/expertManage/approve/getBusinessId")
    Call<ApiBaseResult<String>> getBusinessIdApi(@HeaderMap Map<String, Object> headers);

    // 获取审批的节点
    @POST("/api/saas-expert/mini/expertManage/approve/getApproveNode")
    Call<ApiBaseResult<List<ApproveNodeGetApiResp>>> getApproveNodeApi(@HeaderMap Map<String, Object> headers, @Body ApproveNodeGetApiReq req);

    @POST("/api/saas-expert/mini/zjfw/zggrxxgl/queryZhuanJiaInfoByBusinessId")
    Call<ApiBaseResult<ZhuanJiaInfoGetByBusinessIdApiResp>> getZhuanJiaInfoByBusinessIdApi(@HeaderMap Map<String, Object> headers, @Body ZhuanJiaInfoGetByBusinessIdApiReq req);

    @POST("/api/saas-expert/mini/zjfw/zggrxxgl/queryInfoForEdit")
    Call<ApiBaseResult<ExpertInfoGetApiResp>> getExpertInfo(@HeaderMap Map<String, Object> headers, @Body ExpertInfoGetApiReq req);

    @POST("/api/saas-expert/mini/saas-expert/zjfw/zggrxxgl/updateAllInfo?type=1")
    Call<ApiBaseResult<ExpertInfoGetApiResp>> updateExpertInfoApi(@HeaderMap Map<String, Object> headers, @Body ExpertInfoUpdateApiReq req);

    @POST("/api/saas-expert/mini/zjfw/zggrxxgl/firstCategoryExpertApply")
    Call<ApiBaseResult<FirstCategoryExpertApplyApiResp>> applyFirstCategoryExpertApi(@HeaderMap Map<String, Object> headers, @Body FirstCategoryExpertApplyApiReq req);

    /* 字典、枚举 */
    @POST("/api/saas-expert/mini/common/nofilter/getEnum")
    Call<ApiBaseResult<List<CommonNofilterEnumGetApiResp>>> getCommonNofilterEnumApi(@HeaderMap Map<String, Object> headers, @Body CommonNofilterEnumGetApiReq req);

    @POST("/api/saas-expert/mini/common/nofilter/getSystemTime")
    Call<ApiBaseResult<Long>> getCommonNofilterSystemTimeApi(@HeaderMap Map<String, Object> headers);

    /* 字典、枚举 */
    @POST("/api/saas-expert/mini/common/listJiTuanErJiDanWei")
    Call<ApiBaseResult<List<CommonJiTuanErJiDanWeiListApiResp>>> listCommonJiTuanErJiDanWeiApi(@HeaderMap Map<String, Object> headers, @Body CommonJiTuanErJiDanWeiListApiReq req);

    // 3职称 4职业资格信息 11 语种 12 熟练程度
    @POST("/api/saas-expert/mini/zjcq/ChouQuShenQing/queryDictByParent")
    Call<ApiBaseResult<List<DictByParentListApiResp>>> listDictByParentApi(@HeaderMap Map<String, Object> headers, @Body DictByParentListApiReq req);

    // 5学历   6学位
    @POST("/api/saas-expert/mini/xitongguanli/queryDictsByParentGuid")
    Call<ApiBaseResult<List<DictByParentListApiResp>>> listDictByParentGuidApi(@HeaderMap Map<String, Object> headers, @Body DictByParentListApiReq req);

    // 省市县树
    @POST("/api/saas-expert/mini/zjcq/ChouQuShenQing/queryCityTreeContainPartArea")
    Call<ApiBaseResult<List<CityTreeApiResp>>> cityTreeApi(@HeaderMap Map<String, Object> headers, @Body CityTreeApiReq req);

    // 根据抽取码获取项目信息
    @POST("/api/saas-expert/mini/zjcq/quailfication/queryInfoByChouQuNum")
    Call<ApiBaseResult<XiangMuInfoByChouQuNumGetApiResp>> xiangMuInfoByChouQuNumGetApi(@HeaderMap Map<String, Object> headers, @Body XiangMuInfoByChouQuNumGetApiReq req);

    // 专家评标项目分页
    @POST("/api/mini/saas-expert/zjfw/zggrxxgl/queryZhuanJiaPingBiaoXiangMuRenWuList")
    Call<ApiBaseResult<ApiBasePageResp<ZhuanJiaPingBiaoXiangMuRenWuPageApiResp>>> pageZhuanJiaPingBiaoXiangMuRenWuApi(@HeaderMap Map<String, Object> headers, @Body ZhuanJiaPingBiaoXiangMuRenWuPageApiReq req);

    // 根据事项类型查询专家修改记录
    @POST("/api/mini/saas-expert/zjfw/zggrxxgl/queryZhuanJiaPingBiaoXiangMuRenWuList")
    Call<ApiBaseResult<XiuGaiJiLuSqByTypeQueryApiResp>> queryXiuGaiJiLuSqByTypeApi(@HeaderMap Map<String, Object> headers, @Body XiuGaiJiLuSqByTypeQueryApiReq req);

    /* 请假、休假 */

    // 请假分页
    @POST("/api/saas-expert/mini/zjfw/zggrxxgl/queryJinJiQingJiaPagination")
    Call<ApiBaseResult<ApiBasePageResp<JinJiQingJiaPageApiResp>>> pageJinJiQingJiaApi(@HeaderMap Map<String, Object> headers, @Body JinJiQingJiaPageApiReq req);

    // 紧急请假申请
    @POST("/api/saas-expert/mini/zjgl/crkgl/saveSystemJinJiQingJia")
    Call<ApiBaseResult<JinJiQingJiaApplyApiResp>> applyJinJiQingJiaApi(@HeaderMap Map<String, Object> headers, @Body JinJiQingJiaApplyApiReq req);

    // 个人休假分页
    @POST("/api/saas-expert/mini/zjfw/zggrxxgl/queryZhuanJiaQingJia")
    Call<ApiBaseResult<ApiBasePageResp<GeRenXiuJiaPageApiResp>>> pageGeRenXiuJiaApi(@HeaderMap Map<String, Object> headers, @Body GeRenXiuJiaPageApiReq req);

    // 个人休假申请
    @POST("/api/saas-expert/mini/zjfw/zggrxxgl/saveZhuanJiaQingJia")
    Call<ApiBaseResult<GeRenXiuJiaApplyApiResp>> applyGeRenXiuJiaApi(@HeaderMap Map<String, Object> headers, @Body GeRenXiuJiaApplyApiReq req);

    // 个人休假更新注销时间
    @POST("/api/saas-expert/mini/zjfw/zggrxxgl/updateZhuXiaoTime")
    Call<ApiBaseResult<GeRenXiuJiaZhuXiaoTimeUpdateApiResp>> updateGeRenXiuJiaZhuXiaoTimeApi(@HeaderMap Map<String, Object> headers, @Query("guid") String qingJiaGuid);


    /* 违规、冻结 */

    // 专家违规分页
    @POST("/api/saas-expert/mini/zjgl/zjwg/pageViolationExpert")
    Call<ApiBaseResult<ApiBasePageResp<ViolationExpertPageApiResp>>> pageViolationExpertApi(@HeaderMap Map<String, Object> headers, @Body ViolationExpertPageApiReq req);

    // 专家违规详情
    @POST("/api/saas-expert/mini/zjgl/zjwg/queryZhuanJiaWeiGuiRecordById")
    Call<ApiBaseResult<ViolationExpertGetApiResp>> getViolationExpertApi(@HeaderMap Map<String, Object> headers, @Body ViolationExpertGetApiReq req);

    // 专家违规处理记录
    @POST("/api/saas-expert/mini/zjgl/zjwg/getAuditRecordList")
    Call<ApiBaseResult<List<ViolationAuditRecordListApiResp>>> listViolationAuditRecordApi(@HeaderMap Map<String, Object> headers, @Body ViolationAuditRecordListApiReq req);

    // 专家冻结分页
    @POST("/api/saas-expert/mini/zjgl/zhuanJiaPingBiaoZhuanYe/queryDongJieZhuanYeList")
    Call<ApiBaseResult<ApiBasePageResp<DongJieZhuanYePageApiResp>>> pageDongJieZhuanYeApi(@HeaderMap Map<String, Object> headers, @Body DongJieZhuanYePageApiReq req);

    // 专家冻结详情
    @POST("/api/saas-expert/mini/zjgl/zhuanJiaPingBiaoZhuanYe/queryZhuanYeChangeRecordList")
    Call<ApiBaseResult<DongJieGetApiResp>> getDongJieApi(@HeaderMap Map<String, Object> headers, @Body DongJieGetApiReq req);

    /* 培训、考试 */

    // 培训课程分页
    @POST("/api/saas-expert/mini/train/expert/pageExpertCourseProgress")
    Call<ApiBaseResult<ApiBasePageResp<TrainCoursePageApiResp>>> pageTrainCourseApi(@HeaderMap Map<String, Object> headers, @Body TrainCoursePageApiReq req);

    // 培训课程详情
    @POST("/api/saas-expert/mini/train/expert/queryTrainCourse")
    Call<ApiBaseResult<TrainCourseGetApiResp>> getTrainCourseApi(@HeaderMap Map<String, Object> headers, @Body TrainCourseGetApiReq req);

    // 培训课程的课节分页
    @POST("/api/saas-expert/mini/train/expert/pageExpertStudyLesson")
    Call<ApiBaseResult<ApiBasePageResp<TrainCourseLessonPageApiResp>>> pageTrainCourseLessonApi(@HeaderMap Map<String, Object> headers, @Body TrainCourseLessonPageApiReq req);


    @POST("/api/saas-expert/saas-expert/mini/train/expert/queryTrainLesson")
    Call<ApiBaseResult<TrainCourseLessonGetApiResp>> getTrainCourseLessonApi(@HeaderMap Map<String, Object> headers, @Body TrainCourseLessonGetApiReq req);

    // 培训课程附件列表
    @POST("/api/saas-expert/mini/common/queryFuJianList")
    Call<ApiBaseResult<List<CommonFuJianListApiResp>>> listCommonFuJianApi(@HeaderMap Map<String, Object> headers, @Body CommonFuJianListApiReq req);

    // 更新培训课节学习进度
    @POST("/api/saas-expert/mini/train/expert/updateTrainLessonProgress")
    Call<ApiBaseResult<TainLessonProgressUpdateApiResp>> updateTainLessonProgressApi(@HeaderMap Map<String, Object> headers, @Body TainLessonProgressUpdateApiReq req);

    // 课后考试列表
    @POST("/api/saas-expert/mini/train/exam/pageExpertLessonExamRecord")
    Call<ApiBaseResult<ApiBasePageResp<TrainExamPageApiResp>>> pageTrainExamApi(@HeaderMap Map<String, Object> headers, @Body TrainExamPageApiReq req);

    // 考试试卷信息
    @POST("/api/saas-expert/mini/train/exam/queryTempExamPaper")
    Call<ApiBaseResult<TempExamPaperGetApiResp>> getTempExamPaperApi(@HeaderMap Map<String, Object> headers, @Body TempExamPaperGetApiReq req);

    // 保存考试记录
    @POST("/api/saas-expert/mini/train/exam/saveExpertExamRecord")
    Call<ApiBaseResult<ExamRecordSaveApiResp>> saveExamRecordApi(@HeaderMap Map<String, Object> headers, @Body ExamRecordSaveApiReq req);

    // 考试试题列表
    @POST("/api/saas-expert/mini/train/exam/listExamMainQuestion")
    Call<ApiBaseResult<List<ExamQuestionListApiResp>>> listExamQuestionApi(@HeaderMap Map<String, Object> headers, @Body ExamQuestionListApiReq req);

    // 考试试题小题列表
    @POST("/api/saas-expert/mini/zjfw/PXXX/queryXiaoTiList")
    Call<ApiBaseResult<List<ExamQuestionXiaoTiListApiResp>>> listExamQuestionXiaoTiApi(@HeaderMap Map<String, Object> headers, @Body ExamQuestionXiaoTiListApiReq req);

    @POST("/api/saas-expert/mini/train/exam/submitExamResult")
    Call<ApiBaseResult<ExamPaperSubmitApiResp>> submitExamPaperApi(@HeaderMap Map<String, Object> headers, @Body ExamPaperSubmitApiReq req);
}
