package com.cnooc.expert.external.portal.api;

import com.cnooc.expert.external.common.model.response.ApiBasePageResp;
import com.cnooc.expert.external.common.model.response.ApiBaseResult;
import com.cnooc.expert.external.portal.model.request.AgentNumGetApiReq;
import com.cnooc.expert.external.portal.model.request.AgentNumPageApiReq;
import com.cnooc.expert.external.portal.model.request.MessageNumGetApiReq;
import com.cnooc.expert.external.portal.model.request.MessageNumPageApiReq;
import com.cnooc.expert.external.portal.model.response.AgentNumGetApiResp;
import com.cnooc.expert.external.portal.model.response.AgentNumPageApiResp;
import com.cnooc.expert.external.portal.model.response.MessageNumGetApiResp;
import com.cnooc.expert.external.portal.model.response.MessageNumPageApiResp;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.HeaderMap;
import retrofit2.http.POST;

import java.util.Map;

public interface PortalServiceApi {

    @POST("/api/mini/specialist/business/agent/expert/num")
    Call<ApiBaseResult<AgentNumGetApiResp>> agentNumGetApi(@HeaderMap Map<String, Object> headers, @Body AgentNumGetApiReq req);

    @POST("/api/mini/specialist/business/agent/expert/selectByPage")
    Call<ApiBaseResult<ApiBasePageResp<AgentNumPageApiResp>>> agentNumPageApi(@HeaderMap Map<String, Object> headers, @Body AgentNumPageApiReq req);

    @POST("/api/mini/specialist/v1/business/message/selectMessage")
    Call<ApiBaseResult<MessageNumGetApiResp>> messageNumGetApi(@HeaderMap Map<String, Object> headers, @Body MessageNumGetApiReq req);

    @POST("/api/mini/specialist/v1/business/message/selectPageByExpert")
    Call<ApiBaseResult<ApiBasePageResp<MessageNumPageApiResp>>> messageNumPageApi(@HeaderMap Map<String, Object> headers, @Body MessageNumPageApiReq req);

}
