package com.cnooc.expert.external.workflow.model.request;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ApprovePathSettingSaveOrUpdateApiReq {

    // 业务类型编码
    @NotBlank(message = "事项类型 不能为空")
    private String businessTypeCode;

    // 业务id
    @NotBlank(message = "业务id 不能为空")
    private String businessId;

    // 选择模板id
    @NotBlank(message = "选择模板id 不能为空")
    private String defId;

    // 模板名称
    private String defName;

    // 模板路径信息
    private String defPathInfo;

    // 配置来源
    @NotNull(message = "配置来源 不能为空")
    private Integer engineType;

    // 意见
    private String opinion;

    // 文件id
    private Long pathId;

    /**
     * 需返回以下格式的json字符串
     * [
     *     {
     *         "nodeId": "aaa",
     *         "users": [
     *             {
     *                 "account": "zhangsan"
     *             },
     *             {
     *                 "account": "lisi"
     *             }
     *         ]
     *     },
     *     {
     *         "nodeId": "bbb",
     *         "users": [
     *             {
     *                 "account": "wangwu"
     *             }
     *         ]
     *     }
     * ]
     */
    // 审批模板中每个审批节点中审批人的对应关系的json字符串
    private String controlApproveUser;

    // 申请备注中的附件
    private String fileId;

    // 申请备注
    private String suggestMsg;

    // ----------限上岗配置-----------

    // 限上岗配置标识
    private String receiveSettingCode;

    // 限上岗配置名称
    private String receiveSettingName;

    // 上级单位名称
    private String upSubjectName;

    // 上级单位id
    private String upSubjectId;

    // 是否向上级单位报批
    private Boolean needUpApproval;

    // 不报批理由code
    private String noNeedUpApprovalCode;

    // 不报批理由内容
    private String noNeedUpApprovalInfo;

    // 签署意见
    private String signingComments;

    // 限上岗审批人员,前端直接传账号，多个以|进行拼接
    private String proUserArray;

    // 主体id
    private Long subjectId;

    // 主体名称
    private String subjectName;
}
