package com.cnooc.expert.external.workflow.model.response;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ApprovePathSettingByConditionGetApiResp {

    // 模板id
    private String defId;

    // 模板名称
    private String defName;

    // 意见
    private String opinion;

    // 文件id
    private Long pathId;

    // 是否使用Ifream嵌入第三方模板
    private Boolean useIfream;

    // 配置来源
    private Short engineType;

    // ifream嵌入url
    private String ifreamUrl;

    // 步骤信息
    private List<JingDongProcDefPathVO> templatePaths;

    // 审批备注下的附件id
    private String fileId;

    // 申请备注
    private String suggestMsg;

    // 限上岗配置标识
    private String receiveSettingCode;

    // 限上岗配置名称
    private String receiveSettingName;

    // 上级单位名称
    private String upSubjectName;

    // 上级单位id
    private String upSubjectId;

    // 是否向上级单位报批
    private Boolean needUpApproval;

    // 签署意见
    private String signingComments;

    // 不报批理由code
    private String noNeedUpApprovalCode;

    // 不报批理由内容
    private String noNeedUpApprovalInfo;

    // 大采购反显模板数据
    private ProcDefInfoVO procDefInfoVO;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class JingDongProcDefPathVO {

        // 节点id
        private String nodeId;

        // 审批步骤
        private String nodeName;

        // 审批人名称,该节点存在多个审批人时，以|拼接
        private String approvePersonName;

        // 账号，一个节点存在多个用户审批，一个用户对应一个account。多个以|来进行拼接
        private List<AccountSubjectNameEmailVO> accountList;

        // 所属单位,该节点存在多个审批人时，以|拼接
        private String subjectName;

        // 邮箱,该节点存在多个审批人时，以|拼接
        private String email;

    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class AccountSubjectNameEmailVO {

        // 账号
        private String account;

        // 候选人名称
        private String name;

        // 候选人所属主体名称
        private String subjectName;

        // 邮箱
        private String email;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class ProcDefInfoVO {

        // 业务类型名称
        private String businessTypeName;

        // 是否最新的版本
        private Boolean newestVersion;

        // 定义方式
        private Short definitionWay;

        // 版本
        private Integer version;

        // 发布的定义id
        private String deployDefId;

        // bpmn方式的流程定义
        private BpmnDeployInfoVO bpmnDeployInfoVO;

        // 树型流程定义
        private TreeDeployInfoVO treeDeployInfoVO;

        // 简单方式的流程定义
        private SimpleDeployInfoVO simpleDeployInfoVO;

        /**
         * 节点的配置
         * 暂时只有任务节点的配置
         */
        // 任务节点配置 暂时只有任务节点的配置
        private List<NodeConfigDTO> nodeConfigs;

        // 启用状态
        private Boolean off;

        // 主体id
        private String subjectId;

        // 租户id
        private String tenantId;

        // 创建人id
        private String creatorId;

        // 创建人名称
        private String creatorName;

        // 发布时间
        private String deployTime;

        // 创建时间
        private String createAt;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class SimpleDeployInfoVO {

        // 简单方式条件的配置信息
        private List<SimpleNodeDTO> nodes;

    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class SimpleNodeDTO {

        // id信息
        private String id;

        // 名称
        private String name;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class NodeConfigDTO {

        // 任务节点唯一标识
        private String key;

        // 任务名称
        private String name;

        // 节点类型 1: 普通 2：会签
        private Integer nodeType;
        /**
         * 或签：单任务
         * 会签：多任务 （并行（任务组并行））
         * 依次审批：多任务（串行（任务组串行））
         */
        // 通过方式 1: 或签 2：会签 3：依次审批
        private Integer byWay;

        // 通过标准 1：百分比，2：绝对票数
        private Integer passedStandardPrefix;

        // 通过标准输入项：整数
        private Long passedStandardVal;

        // 提醒配置 1：系统消息 2：短信
        private List<Integer> reminderConfiguration;

        // 是否允许加签
        private Boolean allowAddSign;

        // 是否允许转审
        private Boolean allowTransfer;

        // 是否开启催办
        private Boolean startUrging;

        // 表单配置
        private String formVariableCode;

        // 是否允许发起人修改审批人
        private Boolean allowStartChangeParty;

        // 是否允许发起人修改抄送人
        private Boolean alloInitiatorToModify;

        // 是否拆分审批人组
        private Boolean allowSplitParty;

        // 节点抄送人
        private List<ParticipantDTO> ccParticipant;

        // 审批人配置信息
        private List<ParticipantGroupDTO> participantGroups;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class ParticipantDTO {

        // id
        private String id;

        // 名称
        private String name;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class ParticipantGroupDTO {

        // 参与者类型：person-人员、orgHead-部门负责人、role-角色、trendsOrgHead-动态部门负责人、personVariable-人员变量
        private String type;

        /**
         * 是否需要 协助(秘书协助等)
         */
        // 是否需要 协助(秘书协助等)
        private Boolean needAssist;

        // 分组名称
        private String groupName;

        // 审批人
        private List<ParticipantApproveDTO> participants;

    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class ParticipantApproveDTO {

        /**
         * 审批人分 用户 ， 角色 ， 部门等。。id 和 name 存对应的id和名称
         */
        // id
        private String id;

        // 名称
        private String name;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class TreeDeployInfoVO {

        // 树节点
        private List<TreeNodeDTO> treeNodes;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class TreeNodeDTO {

        // 任务节点唯一标识
        private String key;

        // 任务名称
        private String name;

        // 节点类型 1：条件节点 2：审批人节点
        private Short type;

        // 条件节点信息
        // 流程条件
        private TreeConditionDTO conditionNode;

        // 审批人节点信息
        private TreeNodeParticipantDTO nodeConfigDTO;

        // 子节点
        private List<TreeNodeDTO> subTreeNode;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class TreeNodeParticipantDTO {
        /**
         * 或签：单任务
         * 会签：多任务 （并行（任务组并行））
         * 依次审批：多任务（串行（任务组串行））
         */
        // 通过方式 1: 或签 2：会签 3：依次审批
        private Integer byWay;

        // 节点类型 1: 普通 2：会签
        private Integer nodeType;

        // 通过标准 1：百分比，2：绝对票数
        private Integer passedStandardPrefix;

        // 通过标准输入项：整数
        private Long passedStandardVal;

        // 提醒配置 1：系统消息 2：短信
        private List<Integer> reminderConfiguration;

        // 是否允许加签
        private Boolean allowAddSign;

        // 是否允许转审
        private Boolean allowTransfer;

        // 是否开启催办
        private Boolean startUrging;

        // 表单配置
        private String formVariableCode;

        // 是否允许发起人修改审批人
        private Boolean allowStartChangeParty;

        // 是否允许发起人修改抄送人
        private Boolean alloInitiatorToModify;

        // 是否拆分审批人组
        private Boolean allowSplitParty;

        // 节点抄送人
        private List<ParticipantDTO> ccParticipant;

        // 审批人配置信息
        private List<ParticipantGroupDTO> participantGroups;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class TreeConditionDTO {

        // 是否默认路径
        private Boolean defaultSeq;

        // 审批条件
        private FlowConditionGroupDTO matchCondition;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class FlowConditionGroupDTO {

        // 条件连接类型
        private String conditionConnectType;

        // 条件连接类型名称
        private String conditionConnectName;

        // 流程条件
        private List<FlowConditionDTO> flowConditions;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class BpmnDeployInfoVO {

        // 前端绘制的bpmn的xml信息
        private String bpmnXml;

        // 条件的配置信息
        private List<ConditionDTO> bpmnConditions;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class ConditionDTO {

        // 连线的id
        private String flowSequenceId;

        // 连线的名称
        private String flowSequenceName;

        // 是否默认路径
        private Boolean defaultSeq;

        // 审批条件
        private FlowConditionGroupDTO matchCondition;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class FlowConditionDTO {

        // 变量key值
        private String varKey;

        // 变量名称
        private String varName;

        // 变量 扩展倍数； 如： 概算价
        private Double variableExpansionMultiple;

        // 操作key值
        private String opKey;

        // 操作名称
        private String opType;

        // 值key
        private String key;

        // 值名称
        private String value;
    }

}
