package com.cnooc.expert.external.workflow.model.response;

import lombok.Data;

import java.util.List;

@Data
public class ProcDefPageApiResp {

    // id
    private String id;

    // 业务类型编码
    private String businessTypeCode;

    // 模板id
    private String defId;

    // 模板名称
    private String defName;

    // ifream嵌入url
    private String ifreamUrl;

    // 模板步骤
    private String defPath;

    // 步骤信息
    private List<ProcDefPath> templatePaths;

    // 是否需要审批
    private Boolean needApprove;

    // 配置来源
    private Short engineType;

    @Data
    public static class ProcDefPath {

        // 节点id
        private String nodeId;

        // 审批步骤
        private String nodeName;

        // 审批人名称,该节点存在多个审批人时，以|拼接
        private String approvePersonName;

        // 账号，一个节点存在多个用户审批，一个用户对应一个account。多个以|来进行拼接
        private List<AccountSubjectNameEmailVO> accountList;

        // 所属单位,该节点存在多个审批人时，以|拼接
        private String subjectName;

        // 邮箱,该节点存在多个审批人时，以|拼接
        private String email;
    }

    @Data
    public static class AccountSubjectNameEmailVO {

        // 账号
        private String account;

        // 候选人名称
        private String name;

        // 候选人所属主体名称
        private String subjectName;

        // 邮箱
        private String email;
    }

}
