package com.cnooc.expert.service.file;

import com.cnooc.expert.external.common.model.response.ApiBaseResult;
import com.cnooc.expert.external.file.model.response.DownLoadInfoApiResp;
import com.cnooc.expert.external.file.sevice.FileServiceClient;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.List;

@AllArgsConstructor
@Service
public class FileService {

    private final FileServiceClient fileServiceClient;

    public List<DownLoadInfoApiResp> downloadInfo(String pathId) {
        ApiBaseResult<List<DownLoadInfoApiResp>> apiResp = fileServiceClient.generatorDownloadInfo(pathId);

        return apiResp.getData();
    }

    public List<DownLoadInfoApiResp> putObject(MultipartFile multFile, int fileType) throws IOException {
        List<DownLoadInfoApiResp> apiResp = fileServiceClient.putObject(multFile, fileType);

        return apiResp;
    }
}
