package com.cnooc.expert.service.portal;

import com.cnooc.expert.controller.portal.model.request.AgentNumReq;
import com.cnooc.expert.controller.portal.model.request.AgentPageReq;
import com.cnooc.expert.controller.portal.model.request.MessageNumReq;
import com.cnooc.expert.controller.portal.model.request.MessagePageReq;
import com.cnooc.expert.external.common.model.response.ApiBasePageResp;
import com.cnooc.expert.external.common.model.response.ApiBaseResult;
import com.cnooc.expert.external.portal.model.request.AgentNumGetApiReq;
import com.cnooc.expert.external.portal.model.request.AgentNumPageApiReq;
import com.cnooc.expert.external.portal.model.request.MessageNumGetApiReq;
import com.cnooc.expert.external.portal.model.request.MessageNumPageApiReq;
import com.cnooc.expert.external.portal.model.response.AgentNumGetApiResp;
import com.cnooc.expert.external.portal.model.response.AgentNumPageApiResp;
import com.cnooc.expert.external.portal.model.response.MessageNumGetApiResp;
import com.cnooc.expert.external.portal.model.response.MessageNumPageApiResp;
import com.cnooc.expert.external.portal.service.PortalServiceClient;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

@AllArgsConstructor
@Service
public class PortalService {

    private final PortalServiceClient portalServiceClient;

    private String getCurUserAccount() {
        return "ex_zhanglh15";
    }

    public AgentNumGetApiResp getAgentNum(AgentNumReq req) {

        AgentNumGetApiReq apiReq = AgentNumGetApiReq.builder()
                .account(this.getCurUserAccount())
                .title(req.getTitle())
                .build();
        ApiBaseResult<AgentNumGetApiResp> apiResp = portalServiceClient.getAgentNumApi(apiReq);

        return apiResp.getData();
    }

    public ApiBasePageResp<AgentNumPageApiResp> pageAgentNum(AgentPageReq req) {

        AgentNumPageApiReq apiReq = AgentNumPageApiReq.builder()
                .pageNum(req.getPageNo())
                .pageSize(req.getPageSize())
                .account(this.getCurUserAccount())
                .status(req.getStatus())
                .title(req.getTitle())
                .build();
        ApiBaseResult<ApiBasePageResp<AgentNumPageApiResp>> apiResp = portalServiceClient.pageAgentNumApi(apiReq);

        return apiResp.getData();
    }

    public MessageNumGetApiResp getMessageNum(MessageNumReq req) {
        MessageNumGetApiReq apiReq = MessageNumGetApiReq.builder()
                .receivers(this.getCurUserAccount())
                .build();
        ApiBaseResult<MessageNumGetApiResp> apiResp = portalServiceClient.getMessageNumApi(apiReq);
        return apiResp.getData();
    }

    public ApiBasePageResp<MessageNumPageApiResp> pageMessageNum(MessagePageReq req) {

        MessageNumPageApiReq apiReq = MessageNumPageApiReq.builder()
                .pageNum(req.getPageNo())
                .pageSize(req.getPageSize())
                .receivers(this.getCurUserAccount())
                .status(req.getStatus())
                .build();
        ApiBaseResult<ApiBasePageResp<MessageNumPageApiResp>> apiResp = portalServiceClient.pageMessageNumApi(apiReq);
        return apiResp.getData();
    }

}
