package com.cnooc.expert.service.subject;

import com.cnooc.expert.controller.subject.model.request.CompanyPageReq;
import com.cnooc.expert.external.common.model.response.ApiBasePageResp;
import com.cnooc.expert.external.common.model.response.ApiBaseResult;
import com.cnooc.expert.external.subject.model.request.PlatformCompanyPageApiReq;
import com.cnooc.expert.external.subject.model.response.PlatformCompanyPageApiResp;
import com.cnooc.expert.external.subject.service.SubjectServiceClient;
import com.cnooc.expert.service.UserInfoUtils;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

@Service
@AllArgsConstructor
public class SubjectService {

    private SubjectServiceClient subjectServiceClient;

    public ApiBasePageResp<PlatformCompanyPageApiResp> pageCompany(CompanyPageReq req) {
        PlatformCompanyPageApiReq apiReq = PlatformCompanyPageApiReq.builder()
                .pageNum(req.getPageNo())
                .pageSize(req.getPageSize())
                .businessType(req.getBusinessType())
                .tenantId(UserInfoUtils.TENANT_ID)
                .subjectName(req.getSubjectName())
                .creditCode(req.getCreditCode())
                .build();
        ApiBaseResult<ApiBasePageResp<PlatformCompanyPageApiResp>> apiResp = subjectServiceClient.pagePlatformCompanyApi(apiReq);


        return apiResp.getData();
    }
}
