package com.cnooc.expert.service.workflow;

import com.cnooc.expert.common.response.BasePageResp;
import com.cnooc.expert.controller.workflow.model.request.ApprovePathSettingByConditionGetReq;
import com.cnooc.expert.controller.workflow.model.request.ApprovePathSettingPageReq;
import com.cnooc.expert.controller.workflow.model.response.ApprovePathSettingByConditionGetResp;
import com.cnooc.expert.controller.workflow.model.response.ApprovePathSettingPageResp;
import com.cnooc.expert.controller.workflow.model.response.InstCalculateResp;
import com.cnooc.expert.controller.workflow.model.response.InstStartResp;
import com.cnooc.expert.controller.workflow.model.response.ReceiveSettingByConditionFindResp;
import com.cnooc.expert.external.workflow.model.request.ApprovePathSettingByConditionGetApiReq;
import com.cnooc.expert.external.workflow.model.request.ApprovePathSettingSaveOrUpdateApiReq;
import com.cnooc.expert.external.workflow.model.request.InstCalculateApiReq;
import com.cnooc.expert.external.workflow.model.request.InstExistedQueryApiReq;
import com.cnooc.expert.external.workflow.model.request.InstRevokeApiReq;
import com.cnooc.expert.external.workflow.model.request.InstStartApiReq;
import com.cnooc.expert.external.workflow.model.request.StageDetailShowApiReq;
import com.cnooc.expert.external.workflow.model.response.StageDetailShowApiResp;
import com.cnooc.expert.external.workflow.model.response.model.ApprovalExecutionRecordVO;
import com.cnooc.expert.external.workflow.model.response.model.ApprovalRecordVO;
import com.cnooc.expert.external.workflow.model.response.model.ApprovalTaskRecordVO;
import com.cnooc.expert.external.workflow.model.response.model.SingleDetailVO;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;

@AllArgsConstructor
@Service
public class WorkflowMockService {

    public InstStartResp startInst(InstStartApiReq req) {
        return InstStartResp.builder()
                .id(1763815035205L)
                .build();
    }

    public Boolean revokeInst(InstRevokeApiReq req) {
        return Boolean.TRUE;
    }

    public BasePageResp<ApprovePathSettingPageResp> pageApprovePathSetting(ApprovePathSettingPageReq req) {

        List<ApprovePathSettingPageResp.ApprovePathAccount> accountList = Lists.newArrayList(
                ApprovePathSettingPageResp.ApprovePathAccount.builder()
                        .account("ex_liujh27")
                        .name("刘俊")
                        .subjectName("中国海洋石油集团有限公司")
                        .email("ex_liujh27@cnooc.com.cn")
                        .build()
        );

        List<ApprovePathSettingPageResp.ApprovePath> templatePaths = Lists.newArrayList(
                ApprovePathSettingPageResp.ApprovePath.builder()
                        .nodeId("node246ec7f3c7571dd631a93f34fa8aeb4b")
                        .nodeName("一级")
                        .approvePersonName("刘俊")
                        .subjectName("中国海洋石油集团有限公司")
                        .email("ex_liujh27@cnooc.com.cn")
                        .accountList(accountList)
                        .build()
        );

        List<ApprovePathSettingPageResp> data = Lists.newArrayList(
                ApprovePathSettingPageResp.builder()
                        .defId("e2dbccf455ec448b8a8284dc2c6c3b04")
                        .defName("中移深化-专家审批")
                        .defPath("1")
                        .opinion(null)
                        .pathId(null)
                        .useIfream(true)
                        .engineType(1)
                        .ifreamUrl("https://flow.t-bid.cnooc.com.cn/deta/scene-talk/approvalFlowChart.html?templateId=e2dbccf455ec448b8a8284dc2c6c3b04&approveId=")
                        .fileId(null)
                        .suggestMsg("1111")
                        .receiveSettingCode(null)
                        .receiveSettingName(null)
                        .upSubjectName(null)
                        .upSubjectId(null)
                        .needUpApproval(null)
                        .signingComments(null)
                        .noNeedUpApprovalCode(null)
                        .noNeedUpApprovalInfo(null)
                        .templatePaths(templatePaths)
                        .build()
        );

        return BasePageResp.<ApprovePathSettingPageResp>builder()
                .current(1)
                .pages(1)
                .total(1)
                .data(data)
                .build();
    }

    public InstCalculateResp calculateInst(InstCalculateApiReq req) {
        List<InstCalculateResp.ApproveSettingVO> approveSettingVOList = Lists.newArrayList(
                InstCalculateResp.ApproveSettingVO.builder()
                        .id("1441098359454003215")
                        .tenantId("892422091105296385")
                        .subjectId("1171522650397351936")
                        .businessTypeCode("FirstCategoryExpertApply-innerApprove")
                        .procDefId("9ee2dc6e983f438391df1b1dc747089b")
                        .procDefName("审批-ZY")
                        .needApprove(true)
                        .priority(1)
                        .needUpApproval(false)
                        .sponsorCanChooseUpApproval(false)
                        .engineType(1)
                        .build()
        );

        return InstCalculateResp.builder()
                .needApprove(true)
                .ifJumpProcess(true)
                .ifApprovePathSetting(true)
                .approveSettingVOList(approveSettingVOList)
                .build();
    }

    public void saveOrUpdateApprovePathSetting(ApprovePathSettingSaveOrUpdateApiReq req) {
        // do nothing
    }

    public ApprovePathSettingByConditionGetResp getApprovePathSettingByCondition(ApprovePathSettingByConditionGetApiReq req) {


        List<ApprovePathSettingByConditionGetResp.AccountSubjectNameEmailVO> accountList = Lists.newArrayList(
                ApprovePathSettingByConditionGetResp.AccountSubjectNameEmailVO.builder()
                        .account("ex_wangzhd3")
                        .name("王振东")
                        .subjectName("中国海洋石油集团有限公司")
                        .email("ex_wangzhd3@cnooc.com.cn")
                        .build()
        );


        List<ApprovePathSettingByConditionGetResp.JingDongProcDefPathVO> templatePaths = Lists.newArrayList(
                ApprovePathSettingByConditionGetResp.JingDongProcDefPathVO.builder()
                        .nodeId("node6932532bee54c574d8697eddef71659f")
                        .nodeName("1")
                        .approvePersonName("王振东")
                        .subjectName("中国海洋石油集团有限公司")
                        .email("ex_wangzhd3@cnooc.com.cn")
                        .accountList(accountList)
                        .build()
        );

        ApprovePathSettingByConditionGetResp result = ApprovePathSettingByConditionGetResp.builder()
                .defId("9ee2dc6e983f438391df1b1dc747089b")
                .defName("审批-ZY")
                .opinion(null)
                .pathId(null)
                .useIfream(true)
                .engineType(1)
                .ifreamUrl("https:flow.t-bid.cnooc.com.cn/deta/scene-talk/approvalFlowChart.html?templateId=9ee2dc6e983f438391df1b1dc747089b&approveId=")
                .fileId(null)
                .fileId(null)
                .suggestMsg(null)
                .receiveSettingCode(null)
                .receiveSettingName(null)
                .upSubjectName(null)
                .upSubjectId(null)
                .needUpApproval(null)
                .signingComments(null)
                .noNeedUpApprovalCode(null)
                .noNeedUpApprovalInfo(null)
                .procDefInfoVO(null)
                .templatePaths(null)
                .templatePaths(templatePaths)
                .build();

        return result;
    }

    public List<ReceiveSettingByConditionFindResp> findReceiveSettingByCondition(ApprovePathSettingByConditionGetReq req) {
        return Collections.emptyList();
    }

    public Boolean queryInstExisted(InstExistedQueryApiReq req) {
        return Boolean.TRUE;
    }

    public List<StageDetailShowApiResp> showStageDetail(StageDetailShowApiReq req) {

        List<ApprovalTaskRecordVO> taskRecordVOList = Lists.newArrayList(
                ApprovalTaskRecordVO.builder()
                        .tenantId("892422091105296385")
                        .instId("1407379834176692224")
                        .executionId("1407379834180886529")
                        .taskId("node2831f49a2484a0dd77b58cccb2696079")
                        .taskName("一级审批")
                        .job("默认岗")
                        .approveId(null)
                        .approveName("杨斌")
                        .approveCropName("中国海洋石油集团有限公司")
                        .endAt("1755587159884")
                        .opinion("同意。")
                        .pathId(null)
                        .taskStatus(null)
                        .operate("同意")
                        .sourceType(1)
                        .fileInfo(Collections.emptyList())
                        .build()
        );
        ApprovalExecutionRecordVO executionRecordVO = ApprovalExecutionRecordVO.builder()
                .tenantId("892422091105296385")
                .instId("1407379834176692224")
                .executionId("1407379834180886529")
                .starterId("1369611720561750016")
                .starterName("物装中心十七")
                .createAt("1755587100321")
                .endAt("1755587160232")
                .pathId(null)
                .opinion(null)
                .reasonForEnding("审批结束")
                .build();
        List<ApprovalRecordVO> approvalRecordVOList = Lists.newArrayList(
                ApprovalRecordVO.builder()
                        .executionRecordVO(executionRecordVO)
                        .taskRecordVOList(taskRecordVOList)
                        .build()
        );

        List<SingleDetailVO> singleDetailVOList = Lists.newArrayList(
                SingleDetailVO.builder()
                .subjectId("1171522650451877889")
                .subjectName("中化建国际招标有限责任公司")
                .engineType(1)
                .useIfream(true)
                .ifreamUrl("https://flow.m-bid.cnooc.com.cn/deta/scene-talk/approvalFlowChart.html?templateId=70873f3faf714e939d4659cba405c358&approveId=listd3d8c5a0-d1e3-44a9-81f6-9c5fac329356284b")
                .approvalProcessVO(null)
                .approvalRecordVOList(approvalRecordVOList)
                .build()
);
        return Lists.newArrayList(
                StageDetailShowApiResp.builder()
                        .busTypeCode("expertModifyApply-innerApprove")
                        .singleDetailVOList(singleDetailVOList)
                        .build()
        );
    }
}
