package com.cnooc.expert.system.entity.vo;

import lombok.*;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

/**
 * 接收登录的form表单数据
 * @Author: FuHongZhang
 * @CreateTime: 2025-09-18  15:11
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class LoginVO {

    private String phoneNumber;

    private String phoneCode;

    private String idNumber;

    private String password;

    @Max(value = 2, message = "登录类型只能是1，手机验证码登录 2.身份证密码登录")
    @Min(value = 1)
    private Integer loginType;

    @Max(value = 2, message = "短信模版类型只能是1，登录时候发送验证码的短信模版 2.修改密码时候发送验证码的短信模版")
    @Min(value = 1)
    private Integer smsTemplateType;

    //图形验证码的key
    private String key;

    //图片验证码
    private String captcha;

    


}
