package com.cnooc.expert.common.exception;

public interface GlobalErrorCodeConstants {

    ErrorCode SUCCESS = new ErrorCode(100200, "操作成功");

    // ========== 系统级别错误 (1000-1999) ==========
    ErrorCode BAD_REQUEST = new ErrorCode(1001, "请求参数不正确");
    ErrorCode UNAUTHORIZED = new ErrorCode(1002, "账号未登录");
    ErrorCode FORBIDDEN = new ErrorCode(1003, "没有该操作权限");
    ErrorCode NOT_FOUND = new ErrorCode(1004, "请求未找到");
    ErrorCode METHOD_NOT_ALLOWED = new ErrorCode(1005, "请求方法不正确");
    ErrorCode LOCKED = new ErrorCode(1006, "请求失败，请稍后重试");
    ErrorCode TOO_MANY_REQUESTS = new ErrorCode(1007, "请求过于频繁，请稍后重试");
    ErrorCode INTERNAL_SERVER_ERROR = new ErrorCode(1008, "系统异常");
    ErrorCode NOT_IMPLEMENTED = new ErrorCode(1009, "功能未实现/未开启");
    ErrorCode ERROR_CONFIGURATION = new ErrorCode(1010, "错误的配置项");
    ErrorCode CAPTCHA_EXPIRED = new ErrorCode(1011, "验证码错误");
    ErrorCode CODE_REDIS_KEY = new ErrorCode(1011, "验证码已过期");
    ErrorCode SYSTEM_ERROR = new ErrorCode(1012, "系统内部异常");

    // ========== 用户认证相关错误 (2000-2999) ==========
    ErrorCode LOGIN_EXPIRED = new ErrorCode(2001, "请先登录");
    ErrorCode USER_NOT_EXISTS = new ErrorCode(2002, "用户不存在");
    ErrorCode PASSWORD_ERROR = new ErrorCode(2003, "密码错误");
    ErrorCode USER_DISABLED = new ErrorCode(2004, "用户已被禁用");

    // ========== 参数校验错误 (3000-3999) ==========
    ErrorCode PARAM_REQUIRED = new ErrorCode(3001, "必填字段不能为空");
    ErrorCode PARAM_FORMAT_ERROR = new ErrorCode(3002, "参数格式不正确");
    ErrorCode PARAM_RANGE_ERROR = new ErrorCode(3003, "参数超出范围");

    // ========== 业务逻辑错误 (4000-4999) ==========
    ErrorCode OPERATION_TOO_FREQUENT = new ErrorCode(4001, "操作太频繁，请稍后再试");
    ErrorCode DATA_ALREADY_EXISTS = new ErrorCode(4002, "数据已存在");
    ErrorCode DATA_NOT_EXISTS = new ErrorCode(4003, "数据不存在");
    ErrorCode BUSINESS_FAILED = new ErrorCode(4004, "业务处理失败");

    // ========== 数据访问错误 (5000-5999) ==========
    ErrorCode DATABASE_CONNECTION_ERROR = new ErrorCode(5001, "数据库连接失败");
    ErrorCode QUERY_DATA_ERROR = new ErrorCode(5002, "查询数据出错");
    ErrorCode INSERT_DATA_ERROR = new ErrorCode(5003, "插入数据出错");
    ErrorCode UPDATE_DATA_ERROR = new ErrorCode(5004, "更新数据出错");
    ErrorCode DELETE_DATA_ERROR = new ErrorCode(5005, "删除数据出错");

}
