package com.cnooc.expert.controller.expert;

import com.cnooc.expert.common.response.ApiResult;
import com.cnooc.expert.common.response.BasePageResp;
import com.cnooc.expert.controller.expert.model.request.CompanyPageReq;
import com.cnooc.expert.controller.expert.model.request.DictNofilterListReq;
import com.cnooc.expert.controller.expert.model.response.DictListItemResp;
import com.cnooc.expert.controller.expert.model.response.NofilterListItemResp;
import com.cnooc.expert.controller.expert.model.response.SecondaryUnitListItemResp;
import com.cnooc.expert.service.ExpertService;
import com.fasterxml.jackson.core.JsonProcessingException;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@AllArgsConstructor
@RestController
@RequestMapping("/expert")
public class ExpertController {

    private final ExpertService expertService;

    @GetMapping("/get")
    public String expertGet() throws JsonProcessingException {
        return expertService.getExpertDetail(1);
    }

    // *** 数据字典 ***

    /**
     * 民族查询列表
     *
     * @param req
     * @return
     */
    @PostMapping("/nofilter/list")
    public ApiResult<List<NofilterListItemResp>> dictNofilterList(@RequestBody @Validated DictNofilterListReq req) {
        return ApiResult.successWithResult(expertService.listDictNofilter(req));
    }

    /**
     * 集团二级单位列表
     *
     * @return
     */
    @PostMapping("/secondary-unit/list")
    public ApiResult<List<SecondaryUnitListItemResp>> secondaryUnitList() {
        return ApiResult.successWithResult(expertService.listSecondaryUnit());
    }

    /**
     * 职称列表
     *
     * @return
     */
    @PostMapping("/dict/guid4/list")
    public ApiResult<List<DictListItemResp>> dictGuiud4List() {
        return ApiResult.successWithResult(expertService.listDict4());
    }

    /**
     * 学历列表
     *
     * @return
     */
    @PostMapping("/dict/guid5/list")
    public ApiResult<List<DictListItemResp>> dictGuiud5List() {
        return ApiResult.successWithResult(expertService.listDict5());
    }


    /**
     * 学位列表
     *
     * @return
     */
    @PostMapping("/dict/guid6/list")
    public ApiResult<List<DictListItemResp>> dictGuiud6List() {
        return ApiResult.successWithResult(expertService.listDict6());
    }

    /**
     * 公司列表
     *
     * @return
     */
    @PostMapping("/company/page")
    public ApiResult<BasePageResp<Object>> companyPage(@RequestBody @Validated CompanyPageReq req) {
        return ApiResult.successWithResult(expertService.pageCompany(req));
    }

    /**
     * 专家个人信息
     *
     * @return
     */
    @PostMapping("/info")
    public ApiResult<ExpertInfoGetResp> ExpertInfoGet(@RequestBody @Validated CompanyPageReq req) {
        return ApiResult.successWithResult(expertService.getExpertInfo(req));
    }


}
