package com.cnooc.expert.common.response;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

@Setter
@Getter
public class ApiResult<T> implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 响应码
     */
    private String code;

    /**
     * 响应消息
     */
    private String message;

    /**
     * 响应数据
     */
    private T data;


    public ApiResult(String code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    /**
     * 成功返回结果
     */
    public static <T> ApiResult<T> successWithData(T data) {
        return new ApiResult<>("200", "操作成功", data);
    }

    /**
     * 成功返回结果
     */
    public static <T> ApiResult<T> success() {
        return new ApiResult<>("200", "操作成功", null);
    }

    public static <T> ApiResult<T> success(String message) {
        return new ApiResult<>("200", message, null);
    }

    /**
     * 失败返回结果
     */
    public static <T> ApiResult<T> error(String message) {
        return new ApiResult<>("500", message, null);
    }

    /**
     * 失败返回结果
     */
    public static <T> ApiResult<T> error(String code, String message) {
        return new ApiResult<>(code, message, null);
    }

    // Getters and Setters

}
