package com.cnooc.expert.controller.person;

import com.cnooc.expert.common.response.ApiResult;
import com.cnooc.expert.controller.person.model.request.PersonGetReq;
import com.cnooc.expert.service.PersonService;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@AllArgsConstructor
@RestController
@RequestMapping("/person")
public class PersonController {

    private final PersonService personService;

    @GetMapping("/get")
    // public ApiResult<String> personGet(@RequestBody @Validated PersonGetReq req) {
    public ApiResult<String> personGet() {
        return ApiResult.successWithData(personService.getExpertDetail(1));
    }

}
