package com.cnooc.expert.service;

import com.cnooc.expert.controller.person.model.request.PersonGetReq;
import com.cnooc.expert.external.expert.model.response.ExpertInfoGetResp;
import com.cnooc.expert.external.expert.service.ExpertService;
import lombok.AllArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@AllArgsConstructor
@Service
public class PersonService {

    private final ExpertService expertService;

    public String getExpertDetail(int id) {

        ExpertInfoGetResp expertInfo = expertService.getExpertInfo(id);
        return StringUtils.defaultIfBlank(expertInfo.getInfo().getSeed(), "") ;
    }
}
