package com.cnooc.expertmanageminiapp.common.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

/**
 * 公用的工具类
 * @author zhengkai
 *
 *  @date 2015年5月25日 上午11:34:35
 */
public class CommonUtil {

	public static final Long SO_FAR_TINE = new Long(-1L);

	/**
	 * 时间转换成字符串(采用 yyyy-MM-dd HH:mm:ss)
	 * @param longtime
	 * @return
	 * @author zhengkai
	 * @date 2015年5月9日 下午2:43:28F
	 */
	public static String longTimeToString(Long longtime){
		if (SO_FAR_TINE.equals(longtime)) {
			return "至今";
		}
		if(longtime!=null){
			Date dt=(new Date(longtime));
			SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			return sdf.format(dt);
		}
		return "";
	}
	
	public static String LongTimeToStringOnDay(Long longtime){
		if (SO_FAR_TINE.equals(longtime)) {
			return "至今";
		}
		if(longtime!=null){
			Date dt=(new Date(longtime));
			SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd");
			return sdf.format(dt);
		}
		return "";
	}
	
	/**
	 * 时间转换成字符串
	 * @param longtime
	 * @param formatter
	 * @return
	 * @author zhengkai
	 * @date 2015年5月9日 下午2:43:28
	 */
	public static String LongTimeToString(Long longtime,String formatter){
		if (SO_FAR_TINE.equals(longtime)) {
			return "至今";
		}
		if(longtime!=null){
			Date dt=(new Date(longtime));
			SimpleDateFormat sdf=new SimpleDateFormat(formatter);
			return sdf.format(dt);
		}
		return "";
	}

	/**
	 * 字符串值是否相同
	 * <p>
	 *     注意：只比较视觉值  即null = '' = '  '
	 * </p>
	 *
	 * @param str1
	 * @param str2
	 * @return
	 */
	public static boolean stringValSame(String str1, String str2){
		str1 = Objects.toString(str1, "").trim();
		str2 = Objects.toString(str2, "").trim();
		return str1.equals(str2);
	}


	/**
	 * 二开 - Boolean类型转成字符串展示
     *
	 * @param val
	 * @return true->是；false->否
	 */
	public static String convertBool2Str(Boolean val){
		if (Objects.isNull(val)) {
			return "";
		}
		return Boolean.TRUE.equals(val) ? "是" : "否";
	}
}
