package com.cnooc.expertmanageminiapp.common.utils;

import com.cnooc.expertmanageminiapp.common.constant.TokenConstants;
import io.jsonwebtoken.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;

/**
 * JWT工具类，用于生成、解析和验证token
 * @author FuHongZhang
 */
public class JwtUtils {
    // 密钥，实际项目中应放在配置文件中
    private static final String SECRET_KEY = TokenConstants.SECRET;
    
    // Token过期时间，这里设置为24小时
    private static final long EXPIRATION_TIME = 24 * 60 * 60 * 1000;


    /**
     * 生成token
     * @return token字符串
     */
    public static String createToken(Integer userId , String uuidKey) {
        Map<String, Object> claims = new HashMap<>();
        claims.put(TokenConstants.UUID_KEY,uuidKey);
        claims.put(TokenConstants.USER_ID,userId);
        // 生成token
        return Jwts.builder()
                .setClaims(claims)
                .signWith(SignatureAlgorithm.HS256, SECRET_KEY)
                .compact();
    }

    /**
     * 从token中获取用于拼接缓存的key uuid_key 和用户 user_id
     */
    public static  Map<String, String> getTokenInfo(String token) {
        Claims claims = extractAllClaims(token);
        Map<String, String> userInfo = new HashMap<>();
        userInfo.put(TokenConstants.UUID_KEY, (String) claims.get(TokenConstants.UUID_KEY));
        userInfo.put(TokenConstants.USER_ID, (String) claims.get(TokenConstants.USER_ID));
        return userInfo;
    }


    /**
     *
     * @param token
     * @return
     */
    private static Claims extractAllClaims(String token) {
        return Jwts.parser().setSigningKey(SECRET_KEY).parseClaimsJws(token).getBody();
    }

    /**
     * 校验token是否过期
     * @param token
     * @return
     */
    public static boolean isTokenExpired(String token) {
        //1.解析token中的key进行拼接，完了查询缓存是否存在
        return false;
    }
}
