package com.cnooc.expertmanageminiapp.common.utils;

import com.cnooc.expertmanageminiapp.common.exception.BusinessException;
import com.cnooc.expertmanageminiapp.common.exception.enums.ErrorCode;
import com.cnooc.expertmanageminiapp.common.exception.enums.GlobalErrorCodeConstants;

import java.util.Collection;

/**
 * @Author: FuHongZhang
 * @CreateTime: 2025-09-18  16:11
 */
public class ValidUtils {

    /**
     * 校验字符串是否为空
     * @param text 待校验的字符串
     * @param message 异常信息
     */
    public static void isText(String text, String message) {
        if (text == null || text.trim().isEmpty()) {
            throw new BusinessException(GlobalErrorCodeConstants.PARAM_FORMAT_ERROR.getCode(),message);
        }
    }

    /**
     * 校验对象是否为null
     * @param obj 待校验的对象
     * @param message 异常信息
     */
    public static void isNotNull(Object obj, String message) {
        if (obj == null) {
            throw new BusinessException(GlobalErrorCodeConstants.PARAM_FORMAT_ERROR.getCode(),message);
        }
    }

    /**
     * 自定义错误码及错误信息
     * @param obj
     * @param errorCode
     */
    public static void isNotNull(Object obj, ErrorCode errorCode) {
        if (obj == null) {
            throw new BusinessException(errorCode.getCode(), errorCode.getMsg());
        }
    }

    /**
     * 校验集合是否为空
     * @param collection 待校验的集合
     * @param message 异常信息
     */
    public static void isNullList(Collection<?> collection, String message) {
        if (collection == null || collection.isEmpty()) {
            throw new BusinessException(GlobalErrorCodeConstants.PARAM_FORMAT_ERROR.getCode(),message);
        }
    }

    /**
     * 校验表达式是否为true
     * @param expression 待校验的布尔表达式
     * @param message 异常信息
     */
    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new BusinessException(GlobalErrorCodeConstants.PARAM_FORMAT_ERROR.getCode(),message);
        }
    }

    /**
     * 校验表达式是否为true
     * @param expression
     * @param errorCode
     */
    public static void isTrue(boolean expression, ErrorCode errorCode) {
        if (!expression) {
            throw new BusinessException(errorCode.getCode(), errorCode.getMsg());
        }
    }

    /**
     * 校验表达式是否为false
     * @param expression 待校验的布尔表达式
     * @param message 异常信息
     */
    public static void isFalse(boolean expression, String message) {
        if (expression) {
            throw new BusinessException(GlobalErrorCodeConstants.PARAM_FORMAT_ERROR.getCode(),message);
        }
    }


}
