package com.cnooc.expertmanageminiapp.manage.controller;

import com.cnooc.expertmanageminiapp.common.response.Result;
import com.cnooc.expertmanageminiapp.manage.entity.pojo.ZhuanJiaInfo;
import com.cnooc.expertmanageminiapp.manage.service.PersonInfoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 个人信息
 * @author: FuHongZhang
 * @date 2025-10-23 15:52
 */
@Slf4j
@RestController
@RequestMapping("/person")
public class PersonInfoController {

    @Autowired
    private PersonInfoService personInfoService;


    /**
     * 获取专家个人信息
     * @return Result<String> 统一返回操作码及信息
     */
    @GetMapping("/getExpertInfo")
    public Result<ZhuanJiaInfo> getPersonInfo() {
        return personInfoService.getExpertPersonInfo();
    }

    /**
     * 获取专家词典信息
     */
    @GetMapping("/getExpertSysDictByParent")
    public Result<String> getExpertSysDictByParent() {
        return null;
    }

    @GetMapping("/getDictsByParentGuid")
    public Result<String> getDictsByParentGuid() {
        return null;
    }

    /**
     * 获取枚举信息
     * @param name 枚举名称
     * @return Result<String> 统一返回操作码及信息
     */
    @GetMapping("/getEnum")
    public Result<String> getEnum(@RequestParam("name") String name) {
        return null;
    }

    /**
     * 修改个人信息
     * @return Result<String> 统一返回操作码及信息
     */
    @PostMapping("/updatePersonInfo")
    public Result<String> updatePersonInfo() {
        return null;
    }


    /**
     * 专家申请记录查看
     * @return Result<List<String>> 统一返回操作码及信息
     */
    @GetMapping("/getApplyList")
    public Result<List<String>> getApplyLogListInfo() {
        return null;
    }

    /**
     * 专家退库申请
     * @return Result<String> 统一返回操作码及信息
     */
    @PostMapping("/exitBankApply")
    public Result<String> exitBankApply() {
        return null;
    }

    /**
     * 专家续期申请
     * @return Result<String> 统一返回操作码及信息
     */
    @PostMapping("/renewalApply")
    public Result<String> renewalApply() {
        return null;
    }







}
