package com.cnooc.expertmanageminiapp.manage.controller;

import cn.hutool.json.JSONObject;
import com.cnooc.expertmanageminiapp.common.response.Result;
import com.cnooc.expertmanageminiapp.manage.service.PortalService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 小程序首页门户
 * @author: FuHongZhang
 * @date 2025-10-23 11:13
 */
@Slf4j
@RestController
@RequestMapping("/portal")
public class PortalController {

    @Autowired
    private PortalService portalService;

    /**
     * 获取首页信息
     * @return Result<String> 统一返回操作码及信息
     */
    @GetMapping("/getPortalInfo")
    public Result<JSONObject> getPortalInfo() {

        return Result.success();
    }


    /**
     * 获取业务待办信息
     * @return Result<String> 统一返回操作码及信息
     */
    @GetMapping("/getAgendaList")
    public Result<JSONObject> getBusinessAgendaInfo() {
        // todo 获取当前登录人信息（后续考虑是否要把当前登录人id存入token）
        return Result.success();
    }


    /**
     * 获取我的消息
     * @return Result<String> 统一返回操作码及信息
     */
    @GetMapping("/getMyMessagesList")
    public Result<JSONObject> getMyMessagesInfo() {
        // todo 获取当前登录人信息（后续考虑是否要把当前登录人id存入token）
        return Result.success();
    }


}
